; dman04b/asm - kjw/bci - Log Diskettes
;
;	created 08/16/83	- kjw/bci
;	revised 09/01/83	- kjw/bci
;
;	add record to file
;
ADDREC	LD	HL,SAVEM	;'saving'
	CALL	$DOLINE		;display
	LD	IX,@DATA	;data pointer
;
;	check if any deleted files
;
	SET	7,(IX+108)	;set logging deleted file
	LD	B,(IX+64)	;get file link start
	LD	H,(IX+65)
	LD	L,(IX+66)
	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	Z,ADDIT0	;go if no deleted
;
;	read deleted record to get next link
;
	LD	(IX+96),B	;save as current file#
	LD	(IX+97),H
	LD	(IX+98),L
	CALL	GETREC		;read record BHL
	RET	NZ		;go on error
	LD	B,(IY+5)	;get forward delete link
	LD	H,(IY+6)
	LD	L,(IY+7)	;BHL = next deleted
	LD	(IX+64),B	;update new delete start
	LD	(IX+65),H
	LD	(IX+66),L
	LD	A,B		;check if last
	AND	H
	AND	L
	INC	A		;last deleted record?
	JR	NZ,ADDREC0	;go if not last
	LD	(IX+67),B	;deleted link end
	LD	(IX+68),H
	LD	(IX+69),L
ADDREC0	CALL	UPDAT0		;update buffer
	JR	ADDIT1		;continue
;
;	add new file to end
;
ADDIT0	RES	7,(IX+108)	;set new file
	LD	B,(IX+76)	;get next free file
	LD	H,(IX+77)
	LD	L,(IX+78)
	CALL	$INC24		;add to rel 0
	LD	(IX+96),B	;set current file#
	LD	(IX+97),H
	LD	(IX+98),L
;
;	locate address into index table
;
ADDIT1	CALL	MAKECHR		;make character offset
	LD	H,INDF<-8	;HL =>
	LD	(IX+106),H	;save pointer
	LD	(IX+107),L
	PUSH	HL		;pass to IY
	POP	IY		;IY => new data
	LD	B,(IY+0)	;get first record pointer
	LD	H,(IY+1)
	LD	L,(IY+2)
	LD	A,B		;check for nil
	AND	H
	AND	L
	INC	A		;any records?
	JR	NZ,ADDIT5	;go if some there
;
;	set first and only record into link
;
	LD	B,(IX+96)	;get current file #
	LD	H,(IX+97)
	LD	L,(IX+98)
	LD	(IY+0),B	;update pointers
	LD	(IY+1),H
	LD	(IY+2),L
	LD	(IY+3),B
	LD	(IY+4),H
	LD	(IY+5),L
	LD	(IY+6),'-'	;reset log
	LD	(IY+7),'-'	;set no last record
	CALL	UPDATF		;set buff needs update
	JP	ADDIT6		;continue, link done!
;
;	must locate correct link into file
;
ADDIT5	CALL	GETREC		;read record
	RET	NZ		;go if error
;
;	check if current record is < record just read
;
	CALL	CMPREC		;compare records
	JR	C,LINKB		;yes, link backward
;
;	fetch next forward link
;
	LD	B,(IY+5)	;get MSB forward link
	LD	H,(IY+6)	;get NSB
	LD	L,(IY+7)	;get LSB
;
;	check for last record in link
;
	LD	A,B		;get data
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,ADDIT5	;continue if not
;
;	last sector in chain, add record to end
;
	LD	B,(IX+96)	;get current file #
	LD	H,(IX+97)
	LD	L,(IX+98)
	LD	(IY+5),B	;update forward link
	LD	(IY+6),H
	LD	(IY+7),L
	LD	B,(IX+35)	;get current file #
	LD	H,(IX+36)
	LD	L,(IX+37)
	LD	IY,CBUFF	;install back link
	LD	(IY+8),B	;set back link
	LD	(IY+9),H
	LD	(IY+10),L
	SET	4,(IX+47)	;set buff needs update
;
;	set current record to last in chain
;
	LD	D,(IX+106)	;get INDF table pointer
	LD	E,(IX+107)
	PUSH	DE		;pass to IY
	POP	IY		;IY => INDF links
	LD	B,(IX+96)	;get current #
	LD	H,(IX+97)
	LD	L,(IX+98)
	LD	(IY+3),B	;set link as last record
	LD	(IY+4),H
	LD	(IY+5),L
	LD	(IY+7),'>'	;set back link available
	CALL	UPDATF		;set buff needs update
	JP	ADDIT6		;continue
;
;	insert link into middle of file
;
LINKB	LD	B,(IY+8)	;get backward link
	LD	H,(IY+9)
	LD	L,(IY+10)
	PUSH	IY		;save pointer
	LD	IY,CBUFF	;compressed record
	LD	(IY+8),B	;set as new backward link
	LD	(IY+9),H
	LD	(IY+10),L
	LD	B,(IX+35)	;get current file #
	LD	H,(IX+36)
	LD	L,(IX+37)
	LD	(IY+5),B	;set as forward link
	LD	(IY+6),H
	LD	(IY+7),L
	POP	IY		;IY => current record
	LD	B,(IX+96)	;get current file#
	LD	H,(IX+97)
	LD	L,(IX+98)
	LD	(IY+8),B	;set as new back link
	LD	(IY+9),H
	LD	(IY+10),L
	SET	4,(IX+47)	;set buff needs update
	LD	IY,CBUFF	;compressed buffer
	LD	B,(IY+8)	;get back link
	LD	H,(IY+9)
	LD	L,(IY+10)
;
;	check if new first record in link
;
	LD	A,B		;check for first record
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,LINKB2	;not first, update F link
;
;	current record is new first record in chain
;
	LD	B,(IX+96)	;get current record #
	LD	H,(IX+97)
	LD	L,(IX+98)
	LD	D,(IX+106)	;get INDF pointer
	LD	E,(IX+107)
	PUSH	DE		;pass to IY
	POP	IY		;IY => INDF
	LD	(IY+0),B	;set as new first record
	LD	(IY+1),H
	LD	(IY+2),L
	LD	(IY+6),'<'	;set forward linked
	CALL	UPDATF		;buffer needs update
	JR	ADDIT6		;continue
;
;	update forward link in new prior record
;
LINKB2	CALL	GETREC		;read record
	RET	NZ		;go if error
	LD	B,(IX+96)	;get current record
	LD	H,(IX+97)
	LD	L,(IX+98)
	LD	(IY+5),B	;set as new forward link
	LD	(IY+6),H
	LD	(IY+7),L
	SET	4,(IX+47)	;set buffer update
;
;	linkages established, add new record to file
;
;	read data sector before data update
;
ADDIT6	LD	B,(IX+96)	;get current file #
	LD	H,(IX+97)
	LD	L,(IX+98)
	CALL	GETREC		;read record
	JR	Z,ADDIT7	;go if OK
	CP	1CH		;EOF error?
	JR	Z,ADDIT7A	;go if yes
	CP	1DH		;EOF error?
	RET	NZ		;nope, go!
;
;	check if new record being used
;
ADDIT7A	BIT	7,(IX+108)	;yes?
	RET	NZ		;yes, return in error!
	LD	C,A		;save error code
	LD	A,(IX+102)	;relative byte
	AND	3		;must be first record
	LD	A,C		;restore error code
	RET	NZ		;error!
;
;	new first record in sector, clear buffer
;
	LD	HL,(@IOBUFF)	;I/O buffer
	LD	BC,0<8+0FFH	;length + fill
	CALL	$CLEAR		;clear sector buffer
;
;	move data to I/O buffer
;
ADDIT7	PUSH	IY		;pass file start to DE
	POP	DE		;DE => I/O buffer posit
	LD	HL,CBUFF	;compressed record
	LD	BC,64		;record length
	BIT	6,(IX+10)	;expanded?
	JR	NZ,$+4		;go if yes
	LD	C,32		;compressed length
	LDIR			;move to buffer
;
;	write I/O buffer to file
;
	SET	5,(IX+47)	;set no data
	RES	4,(IX+47)	;set no update
	LD	BC,@DATA+41	;relative sector
	LD	DE,(@FCB)	;file block
	CALL	$POSN		;position to record
	JR	Z,ADDIT9	;go if OK
	CP	1CH		;end of file?
	JR	Z,ADDIT8A	;go if yes
	CP	1DH		;past file?
	RET	NZ		;nope, real error
;
;	update new EOF sector
;
ADDIT8A	LD	B,(IX+41)	;get relative sector
	LD	H,(IX+42)
	LD	L,(IX+43)
	LD	(IX+60),B	;update EOF sector
	LD	(IX+61),H
	LD	(IX+62),L
;
ADDIT9	CALL	$WRITE		;write sector
	RET	NZ		;go if error
;
;	update file count
;
	LD	B,(IX+73)	;get # files used
	LD	H,(IX+74)
	LD	L,(IX+75)
	CALL	$INC24		;+1
	LD	(IX+73),B	;update
	LD	(IX+74),H
	LD	(IX+75),L
;
;	check if next file record needs update
;
	BIT	7,(IX+108)	;using deleted record?
	JR	NZ,ADDIT10	;go if yes
;
;	update next file address at end
;
	LD	B,(IX+76)	;update next file
	LD	H,(IX+77)
	LD	L,(IX+78)
	CALL	$INC24		;bump count
	LD	(IX+76),B	;update
	LD	(IX+77),H
	LD	(IX+78),L
;
ADDIT10	CALL	UPDAT0		;flag buffer updated
	CALL	$SHOWF		;display new data
	XOR	A		;set NO error
	RET			;done!
;
	PAGE
;
;	load current record into buffer
;
GETREC	LD	(IX+35),B	;save current file#
	LD	(IX+36),H
	LD	(IX+37),L
;
;	compute sector/byte offset
;
GETREC0	CALL	$DEC24		;adjust 0 relative
	BIT	6,(IX+10)	;expanded records?
	JR	NZ,GETRECE	;go if yes
;
;	compute byte offset compressed
;
	LD	C,8		;entries/sector compress
	CALL	$DIVID		;BHL = sector, A=byte off
	RRCA			;align remainder bits
	RRCA
	RRCA
	AND	0E0H		;A = byte offset
	JR	GETRECC		;continue
;
;	compute expanded byte offset
;
GETRECE	LD	C,4		;entries / sector
	CALL	$DIVID		;divide BHL / C
	RRCA			;align remainder
	RRCA
	AND	0C0H		;high two bits
;
GETRECC	LD	(IX+102),A	;save byte offset
	LD	C,(IX+70)	;start sector files
	LD	D,(IX+71)
	LD	E,(IX+72)
	CALL	$ADD24		;BHL = sector
	CALL	READIT		;read record
	PUSH	AF		;save status
	LD	IY,(@IOBUFF)	;start I/O buffer
	LD	C,(IX+102)	;get byte offset
	LD	B,0		;BC = offset
	ADD	IY,BC		;IY => file record
	POP	AF		;restore status
	RET			;done!
;
;	compare record CREC with (IY)
;
CMPREC	PUSH	IX		;save
	PUSH	IY		;save
	LD	IX,CBUFF	;current compressed buff
	LD	BC,11		;name offset compressed
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;compressed?
	JR	Z,CMPREC0	;yes, go!
	LD	C,16		;offset expanded
CMPREC0	ADD	IX,BC		;add source
	ADD	IY,BC		;add dest
	LD	B,9		;compare 9 bytes
;
CMPREC1	LD	A,(IX)		;get data
	CP	(IY)		;compare
	JR	NZ,CMPREC2	;go if not equal
	INC	IX		;bump pointers
	INC	IY
	DJNZ	CMPREC1		;go for count
;
;	5 more bits left to check
;
	LD	A,(IY)		;get data
	AND	0F8H		;5 bits only
	LD	C,A		;save
	LD	A,(IX)		;get data
	AND	0F8H		;5 bits only
	CP	C		;compare
;
CMPREC2	POP	IY		;unstack
	POP	IX
	RET			;return with flags
;
;	move buffer from expanded to compressed buffer
;
PACK	LD	HL,EBUFF	;expanded buffer
	LD	DE,CBUFF	;compressed buffer
	LD	BC,11		;11 bytes already set
	LDIR			;move 'em
;
;	check if expanded/compressed
;
	LD	A,(@FLAG1)	;system flag
	BIT	6,A		;expanded?
	JR	NZ,PACKE	;yes, go!
;
;	pack compressed
;
PACKC	LD	HL,EBUFF+21	;name here
	LD	B,17		;bytes to move
	CALL	MBITS		;move the bits in
	LD	IX,EBUFF+74	;start flags
	LD	B,12		;12 flags to go
	CALL	MBITS0		;move flags
;
;	align last data byte to high order bits
;
PACKD	SLA	E		;align bits
	DEC	D		;less bit counter
	JR	NZ,PACKD	;go for count
	LD	(IY+0),E	;update last data byte
	RET			;done
;
;	move telephone
;
PACKE	LD	B,5		;10 digit total
PACK1	LD	A,(HL)		;get data
	CALL	PACKR		;adjust char
	RLCA			;align digits
	RLCA
	RLCA
	RLCA
	AND	0F0H		;4 bits only
	LD	C,A		;save it
	INC	HL		;bump pointer
	LD	A,(HL)		;get data
	CALL	PACKR		;adjust char
	OR	C		;combine
	LD	(DE),A		;to buffer
	INC	HL		;bump source
	INC	DE		;bump dest
	DJNZ	PACK1		;go for 10 digits
;
	LD	B,53		;53 bytes to move
	CALL	MBITS		;move bits
;
;	move flag data
;
	LD	B,12		;12 flags
	JR	MBITS0		;move flags
;
;	compute digit for packed record
;
PACKR	CP	'*'		;nil?
	JR	Z,PACKRR	;yes, reset
	SUB	'0'		;remove ascii
	JR	C,PACKRR	;go if not digit
	CP	10		;0-9?
	RET	C		;yes, go!
PACKRR	XOR	A		;return 0 digit
	RET			;done!
;
;	move BC bits from (HL) => (DE)
;
MBITS	PUSH	HL		;pass to IX
	POP	IX
	PUSH	DE		;pass to IY
	POP	IY		;IX=>source, IY=>dest
	LD	DE,8<8+0	;D=bits/byte, E=byte
	LD	L,7		;bits to move / byte
	JR	MBITS1		;continue
;
MBITS0	LD	L,1		;bits to move / byte
MBITS1	LD	A,(IX+0)	;get data
	ADD	A,A		;ignore bit 7
	INC	IX		;bump pointer
	PUSH	HL		;save bits to move
	CALL	MBITS2		;move 'em
	POP	HL		;restore bits/byte
	DJNZ	MBITS1		;go for byte count
	LD	(IY+0),E	;update last partial
	RET			;done!
;
MBITS2	ADD	A,A		;move bit to carry
	RL	E		;move to data byte
	DEC	D		;less bits/byte
	JR	NZ,MBITS3	;go if not full
	LD	(IY+0),E	;load data byte
	INC	IY		;bump dest
	LD	DE,8<8+0	;reset count/byte
;
MBITS3	DEC	L		;less bits to move
	JR	NZ,MBITS2	;go for count
	RET			;byte moved!
;
;	create index offset
;
MAKECHR	LD	A,(EBUFF+21)	;first byte filename
	CALL	$UCASE		;make upper case
	SUB	'A'		;remove ascii
	JR	C,MAKECH1	;go if out of range
	CP	26		;0-25?
	JR	C,MAKECH2	;go if OK
MAKECH1	LD	A,26		;set as last
MAKECH2	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	L,A		;pass LSB
	RET			;done!
;
