; dman04a/asm - kjw/bci - Log Diskettes
;
;	created 08/16/83	- kjw/bci
;	revised 09/24/83	- kjw/bci
;
;	system data useage
;
;	20-22	- current disk number
;	23-25	- relative sector disk name/date
;	26	- relative byte disk name/date
;	27-29	- relative sector index record
;	30	- relative byte index record
;	31	- directory cylinder
;	32	- directory sector
;	33	- directory byte
;	34	- current drive binary
;	35-37	- temp file positioning storage
;	38	- cylinder count
;	39	- disk type 7=R/F 6=DD 5=DS 4=5/8
;	40	- directory sector count
;	41-43	- current index sector loaded
;	44-46	- deleted disk linkage
;	47	- flags
;			7 = 1 = logging deleted disk
;			6 = 1 = continuous update mode
;			5 = 1 = buffer has data
;			4 = 1 = buffer needs update
;			3 = 1 = IND0 buffer loaded
;			2 = 1 = IND0 buffer needs update
;			1 = 1 = INDF buffer loaded
;			0 = 1 = INDF buffer needs update
;	96-98	- current file#
;	99-101	- file relative sector
;	102	- file relative byte
;	103-105	- current file # for linking
;	106-107	- INDF buffer pointer
;	108	- flags
;		  7 =
;		  6 - 1=buffer updated
;		  5 - 1=update, 0=log
;	109	- file byte offset
;	110	- file AND include byte
;	111	- file CMP include byte
;
;	text area
;
REMG1	DEFB	_STX
	DEFB	@VID,00
	DEFM	'Mount disk #'
REMG1A	DEFM	'....., and enter Drive Number: '
	DEFB	_ETX
;
REMG2	DEFM	'DiskMAN',80H,'## '
REMG2A	DEFM	'.....'
;
REMG3	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Disk Update Error - '
	DEFB	_EREOL
	DEFB	_ETX
;
CLS	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFB	_ETX
;
CLS1	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOL
	DEFB	_ETX
;
EDITMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'A(dd, C)ontinuous, E)dit, '
	DEFM	'N)ext, S)earch, Q)uit? '
	DEFB	_EREOL
	DEFB	_ETX
;
NAMMSG	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'Disk Name: '
	DEFB	_ETX
;
DATMSG	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'Disk Date: '
	DEFB	_ETX
;
ADDMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Filename: '
	DEFB	_EREOL
	DEFB	_ETX
;
ADDSVMG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'S(ave, E)dit, I)gnore, Q)uit? '
	DEFB	_EREOL
	DEFB	_ETX
;
EDITMSC	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOL
	DEFB	_ETX
;
DELMSG1	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Deleting File ...'
	DEFB	_EREOL
	DEFB	_ETX
;
NOTMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Index File Not Available - Use OPEN'
	DEFB	_ETX
;
FULMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Index File is FULL - Use CLOSE & INIT'
	DEFB	_ETX
;
PROMPT1	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'Drivespec? '
	DEFB	_ETX
;
HEADER	DEFM	'DiskMAN'
	DEFB	80H
	DEFM	'## '
;
ALRMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Disk Already Logged as #'
ALRMSG1	DEFM	'..... - Use UPDATE'
	DEFB	_ETX
;
INVMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Invalid Command Parameter - Use HELP'
	DEFB	_ETX
;
BADDNM	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Invalid Disk Header - Use LOG'
	DEFB	_ETX
;
BADDMG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Invalid Disk Number - '
	DEFM	'Possibly Belongs To Another Index File'
	DEFB	_ETX
;
INVDSKM	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'Invalid Disk Number'
	DEFB	_ETX
;
DNUMG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Cannot Identify, Disk Number? '
	DEFB	_EREOF
	DEFB	_ETX
;
MISMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Missing Information - Use HELP'
	DEFB	_ETX
;
LOGMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Disk Log Error - '
	DEFB	_ETX
;
ADDEMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFB	_EREOF
	DEFM	'Disk Add Error - '
	DEFB	_ETX
;
KEYMSG	DEFM	'Key <ENTER> to continue:'
	DEFB	_ETX
;
NAMDAT	DEFM	'................'
;
PROMPT2	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'Index Needs Updating, Attempt? '
	DEFB	_ETX
;
OKMSG0	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFB	_ETX
;
SAVEQ	DEFB	_STX
	DEFB	@VID,000
	DEFM	'A(dd, E)dit, I)gnore, Q)uit? '
	DEFB	_EREOL
	DEFB	_ETX
;
SEARMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Searching ...'
	DEFB	_EREOL
	DEFB	_ETX
;
SAVEM	DEFB	_STX
	DEFB	@VID,00
	DEFM	'Saving ...'
	DEFB	_EREOL
	DEFB	_ETX
;
UPMSG	DEFB	_STX
	DEFB	@VID,00
	DEFM	'Updating ...'
	DEFB	_EREOL
	DEFB	_ETX
;
OKMSG	DEFB	_STX
	DEFB	@VID+4,000
	DEFM	'***************************************'
	DEFB	_CR
	DEFM	'****   Be Sure To Label Diskette   ****'
	DEFB	_CR
	DEFM	'***************************************'
	DEFB	_ETX
;
OKMSGUU	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFM	'* Diskette Removed *'
	DEFB	_ETX
;
OKMSGU	DEFB	_STX
	DEFB	@VID+1,000
	DEFM	'* Diskette Updated *'
	DEFB	_ETX
;
SMSG	DEFB	_STX
	DEFB	@VID+2,000
	DEFM	':'
SMSG0	DEFM	'. - #'
SMSG1	DEFM	'..... - '
SMSG2	DEFM	'........ - '
SMSG3	DEFM	'........ - '
SMSG4	DEFM	'.../'
SMSG5	DEFM	'.D/'
SMSG6	DEFM	'.S/'
SMSG7	DEFM	'."/'
SMSG8	DEFM	'. - '
SMSG9	DEFM	'.....k'
	DEFB	_EREOL
	DEFB	_ETX
;
SCNERR	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Search Error - '
	DEFB	_EREOL
	DEFB	_ETX
;
SCNKEY	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Key <ENTER> to resume:'
	DEFB	_EREOL
	DEFB	_ETX
;
SCNFIN	DEFB	_STX
	DEFB	@VID+1,000
SCNFIN1	DEFM	'........ Matching Filenames In Index'
	DEFB	_EREOL
	DEFB	_ETX
;
SRMSG	DEFB	_STX
	DEFB	@VID+1,000
	DEFM	'Disk#'
SRMSG1	DEFM	'..... '
SRMSG2	DEFM	'........ '
SRMSG3	DEFM	'........ / File#'
SRMSG4	DEFM	'........ '
SRMSG5	DEFM	'....... '
SRMSG6	DEFM	'../../..'
	DEFB	_EREOL
	DEFB	_STX
	DEFB	@VID,000
	DEFM	'N(ext, D)elete, Q)uit? '
	DEFB	_EREOL
	DEFB	_ETX
;
CKUPMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Deleting Extraneous Files ...'
	DEFB	_EREOL
	DEFB	_ETX
;
CLRFMSG	DEFB	_STX
	DEFB	@VID,000
	DEFM	'Clearing Update Flags ...'
	DEFB	_EREOL
	DEFB	_ETX
;
REMPMT	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOF
	DEFM	'Delete Disk Number? '
	DEFB	_ETX
;
DELAMSG	DEFB	_STX
	DEFB	@VID+0,000
	DEFM	'Deleting All Files ...'
	DEFB	_EREOF
;
FILEMSK	DEFB	_STX
	DEFB	08,00
	DEFM	'Name   :'
	DEFB	_STX
	DEFB	08,020
	DEFM	':'
	DEFB	_STX
	DEFB	08,035
	DEFM	'Date :  /  /  :'
;
	DEFB	_STX
	DEFB	09,000
	DEFM	'Version:     :'
	DEFB	_STX
	DEFB	09,035
	DEFM	'Flags:       :'
	DEFB	_STX
	DEFB	@VID,000
	DEFB	_ETX
;
FILEMSE	DEFB	_STX
	DEFB	10,000
	DEFM	'Author :'
	DEFB	_STX
	DEFB	10,018
	DEFM	':'
	DEFB	_STX
	DEFB	10,035
	DEFM	'Index: :'
;
	DEFB	_STX
	DEFB	11,000
	DEFM	'Company:'
	DEFB	_STX
	DEFB	11,020
	DEFM	':'
	DEFB	_STX
	DEFB	11,035
	DEFM	'Group:'
	DEFB	_STX
	DEFB	11,049
	DEFM	':'
;
	DEFB	_STX
	DEFB	12,000
	DEFM	'Phone  :(   )    -    :'
	DEFB	_STX
	DEFB	12,035
	DEFM	'Class:      :'
;
	DEFB	_STX
	DEFB	@VID,000
	DEFB	_ETX
;
FLAGM	DEFB	_STX
FLAGM1	DEFB	@VID
FLAGM2	DEFB	000
FLAGM3	DEFM	'..- -'
FLAGM4	DEFM	'........'
	DEFB	_ETX
;
;	display command table
;
;	+0/1	video address data lsb/msb
;	+2	field length
;	+3	data offset
;	+4/5	display driver address
;
TABLETC	DEFW	@COLS*8+8+@VIDEO
	DEFB	12
	DEFB	21
	DEFW	DVRN		;name
	DEFW	EDIT1
;
	DEFW	@COLS*9+8+@VIDEO
	DEFB	5
	DEFB	33
	DEFW	DVR1		;version
	DEFW	EDIT1
;
	DEFW	@COLS*8+41+@VIDEO
	DEFB	3
	DEFB	0
	DEFW	DVR3		;date
	DEFW	0000H
;
	DEFW	@COLS*9+41+@VIDEO
	DEFB	6
	DEFB	0
	DEFW	DVR4		;system flags
	DEFW	0000H
;
	DEFW	@COLS*13+3+@VIDEO
	DEFB	1
	DEFB	74
	DEFW	DVR2		;flag1
	DEFW	EDIT2
;
	DEFW	@COLS*13+19+@VIDEO
	DEFB	1
	DEFB	75
	DEFW	DVR2		;flag2
	DEFW	EDIT2
;
	DEFW	@COLS*13+35+@VIDEO
	DEFB	1
	DEFB	76
	DEFW	DVR2		;flag3
	DEFW	EDIT2
;
	DEFW	@COLS*13+51+@VIDEO
	DEFB	1
	DEFB	77
	DEFW	DVR2		;flag4
	DEFW	EDIT2
;
	DEFW	@COLS*14+3+@VIDEO
	DEFB	1
	DEFB	78
	DEFW	DVR2		;flag5
	DEFW	EDIT2
;
	DEFW	@COLS*14+19+@VIDEO
	DEFB	1
	DEFB	79
	DEFW	DVR2		;flag6
	DEFW	EDIT2
;
	DEFW	@COLS*14+35+@VIDEO
	DEFB	1
	DEFB	80
	DEFW	DVR2		;flag7
	DEFW	EDIT2
;
	DEFW	@COLS*14+51+@VIDEO
	DEFB	1
	DEFB	81
	DEFW	DVR2		;flag8
	DEFW	EDIT2
;
	DEFW	@COLS*15+3+@VIDEO
	DEFB	1
	DEFB	82
	DEFW	DVR2		;flag9
	DEFW	EDIT2
;
	DEFW	@COLS*15+19+@VIDEO
	DEFB	1
	DEFB	83
	DEFW	DVR2		;flag10
	DEFW	EDIT2
;
	DEFW	@COLS*15+35+@VIDEO
	DEFB	1
	DEFB	84
	DEFW	DVR2		;flag11
	DEFW	EDIT2
;
	DEFW	@COLS*15+51+@VIDEO
	DEFB	1
	DEFB	85
	DEFW	DVR2		;flag12
	DEFW	EDIT2
;
	DEFW	0000H		;terminator
;
TABLETE	DEFW	@COLS*8+8+@VIDEO
	DEFB	12
	DEFB	21
	DEFW	DVRN		;name
	DEFW	EDIT1
;
	DEFW	@COLS*9+8+@VIDEO
	DEFB	5
	DEFB	33
	DEFW	DVR1		;version
	DEFW	EDIT1
;
	DEFW	@COLS*10+8+@VIDEO
	DEFB	10
	DEFB	38
	DEFW	DVR1		;author
	DEFW	EDIT1
;
	DEFW	@COLS*11+8+@VIDEO
	DEFB	12
	DEFB	48
	DEFW	DVR1		;company
	DEFW	EDIT1
;
	DEFW	@COLS*12+8+@VIDEO
	DEFB	10
	DEFB	11
	DEFW	DVR0		;phone
	DEFW	EDIT0
;
	DEFW	@COLS*8+41+@VIDEO
	DEFB	3
	DEFB	0
	DEFW	DVR3		;date
	DEFW	0000H
;
	DEFW	@COLS*9+41+@VIDEO
	DEFB	6
	DEFB	0
	DEFW	DVR4		;system flags
	DEFW	0000H
;
	DEFW	@COLS*10+41+@VIDEO
	DEFB	1
	DEFB	0
	DEFW	DVR5		;index
	DEFW	EDIT5
;
	DEFW	@COLS*11+41+@VIDEO
	DEFB	8
	DEFB	60
	DEFW	DVR1		;group
	DEFW	EDIT1
;
	DEFW	@COLS*12+41+@VIDEO
	DEFB	6
	DEFB	68
	DEFW	DVR1		;class
	DEFW	EDIT1
;
	DEFW	@COLS*13+3+@VIDEO
	DEFB	1
	DEFB	74
	DEFW	DVR2		;flag1
	DEFW	EDIT2
;
	DEFW	@COLS*13+19+@VIDEO
	DEFB	1
	DEFB	75
	DEFW	DVR2		;flag2
	DEFW	EDIT2
;
	DEFW	@COLS*13+35+@VIDEO
	DEFB	1
	DEFB	76
	DEFW	DVR2		;flag3
	DEFW	EDIT2
;
	DEFW	@COLS*13+51+@VIDEO
	DEFB	1
	DEFB	77
	DEFW	DVR2		;flag4
	DEFW	EDIT2
;
	DEFW	@COLS*14+3+@VIDEO
	DEFB	1
	DEFB	78
	DEFW	DVR2		;flag5
	DEFW	EDIT2
;
	DEFW	@COLS*14+19+@VIDEO
	DEFB	1
	DEFB	79
	DEFW	DVR2		;flag6
	DEFW	EDIT2
;
	DEFW	@COLS*14+35+@VIDEO
	DEFB	1
	DEFB	80
	DEFW	DVR2		;flag7
	DEFW	EDIT2
;
	DEFW	@COLS*14+51+@VIDEO
	DEFB	1
	DEFB	81
	DEFW	DVR2		;flag8
	DEFW	EDIT2
;
	DEFW	@COLS*15+3+@VIDEO
	DEFB	1
	DEFB	82
	DEFW	DVR2		;flag9
	DEFW	EDIT2
;
	DEFW	@COLS*15+19+@VIDEO
	DEFB	1
	DEFB	83
	DEFW	DVR2		;flag10
	DEFW	EDIT2
;
	DEFW	@COLS*15+35+@VIDEO
	DEFB	1
	DEFB	84
	DEFW	DVR2		;flag11
	DEFW	EDIT2
;
	DEFW	@COLS*15+51+@VIDEO
	DEFB	1
	DEFB	85
	DEFW	DVR2		;flag12
	DEFW	EDIT2
;
	DEFW	0000H		;terminator
;
;	editor vector table
;	up,down,left,right,s-up,s-down,s-left,s-right
;
TABLETV	DEFB	-1,-1,-1,-1,-1,-1,-1,-1	;name
	DEFB	8,16,8,56,8,144,8,8	;version
	DEFB	8,24,16,56,8,144,16,56	;author
	DEFB	16,32,56,64,8,144,24,64	;company
	DEFB	24,80,64,72,8,144,32,72	;phone
	DEFB	-1,-1,-1,-1,-1,-1,-1,-1	;date
	DEFB	-1,-1,-1,-1,-1,-1,-1,-1	;sys flags
	DEFB	56,64,16,24,56,168,16,56 ;index
	DEFB	56,72,24,32,56,168,24,64 ;group
	DEFB	64,104,32,80,56,168,32,72 ;class
;
	DEFB	32,112,72,88,8,144,80,104	;flag1
	DEFB	32,120,80,96,8,152,80,104	;flag2
	DEFB	72,128,88,104,56,160,80,104	;flag3
	DEFB	72,136,96,112,56,168,80,104	;flag4
	DEFB	80,144,104,120,8,144,112,136	;flag5
	DEFB	88,152,112,128,8,152,112,136	;flag6
	DEFB	96,160,120,136,56,160,112,136	;flag7
	DEFB	104,168,128,144,56,168,112,136	;flag8
	DEFB	112,144,136,152,8,144,144,168	;flag9
	DEFB	120,152,144,160,8,152,144,168	;flag10
	DEFB	128,160,152,168,56,160,144,168	;flag11
	DEFB	136,168,160,8,56,168,144,168	;flag12
	DEFW	0000H				;term
;
;	compressed records vector table
;
TABLETW	DEFB	-1,-1,-1,-1,-1,-1,-1,-1		;name
	DEFB	8,32,8,8,8,96,8,8		;version
	DEFB	-1,-1,-1,-1,-1,-1,-1,-1		;date
	DEFB	-1,-1,-1,-1,-1,-1,-1,-1		;sys flag
;
	DEFB	8,64,32,40,8,96,32,56		;flag 1
	DEFB	8,72,32,48,8,104,32,56		;flag 2
	DEFB	8,80,40,56,8,112,32,56		;flag 3
	DEFB	8,88,48,64,8,120,32,56		;flag 4
;
	DEFB	32,96,56,72,8,96,64,88		;flag 5
	DEFB	40,104,64,80,8,104,64,88	;flag 6
	DEFB	48,112,72,88,8,112,64,88	;flag 7
	DEFB	56,120,80,96,8,120,64,88	;flag 8
;
	DEFB	64,96,88,104,8,96,96,120	;flag 9
	DEFB	72,104,96,112,8,104,96,120	;flag 10
	DEFB	80,112,104,120,8,112,96,120	;flag 11
	DEFB	88,120,112,8,8,120,96,120	;flag 12
	DEFW	0000H				;term
;
;	editing command lookup table
;
EDITTBL	EQU	$
;
	DEFB	_UP
	DEFW	ADVU
	DEFB	_DOWN
	DEFW	ADVD
	DEFB	_LEFT
	DEFW	ADVL
	DEFB	_RIGHT
	DEFW	ADVR
	DEFB	_SUP
	DEFW	ADVSU
	DEFB	_SDOWN
	DEFW	ADVSD
	DEFB	_SLEFT
	DEFW	ADVSL
	DEFB	_SRIGHT
	DEFW	ADVSR
	DEFB	_ETBL
;
