; dman04/asm - kjw/bci - LOG/UPDATE/ADD/REMOVE
;
;	created 08/16/83	- kjw/bci
;	revised 09/24/83	- kjw/bci
;
ENTRY	LD	IX,@DATA	;data block
	LD	(IX+108),0	;clear flags
	LD	(IX+114),0	;clear exact flag
	LD	(IX+125),0	;clear FORCE flag
	DEC	A		;command 1 LOG?
	JR	Z,DOLOG		;yes, go!
	DEC	A		;command 2 UPDATE?
	JR	Z,DOUPD		;yes, go!
	DEC	A		;command 3 ADD?
	JR	Z,DOADD		;go if yes
	DEC	A		;command 4 REMOVE?
	JP	NZ,$CMD		;invalid, go!
	SET	6,(IX+114)	;set REMOVE feature
	JR	DOLOG		;continue
;
DOADD	SET	0,(IX+108)	;set ADD mode
	JR	DOLOG		;continue
;
DOUPD	SET	5,(IX+108)	;set UPDATE mode
;
DOLOG	LD	(COMMAND),HL	;save command pointer
;
;	check if file is open
;
	LD	(IX+47),0	;reset flags
	LD	(IX+110),11011000B	;file AND
	LD	(IX+111),00010000B	;file CMP
	BIT	7,(IX+10)	;index available?
	JR	NZ,START	;go if OK
	LD	HL,NOTMSG	;'file not open'
	JR	ERREX		;error exit
;
MISSING	LD	HL,MISMSG	;'missing information'
	JR	ERREX		;continue
INVALID	LD	HL,INVMSG	;'invalid command'
ERREX	CALL	$DOLINE		;display
GOCMD	LD	A,0<4+1		;command interpreter
	JP	$OVRLAY		;back to it
;
;	check for any deleted disk records
;
START	BIT	5,(IX+108)	;UPDATE?
	JP	NZ,UPDAT1	;yes, go!
	BIT	6,(IX+114)	;REMOVE?
	JP	NZ,REMOVE	;go if yes
;
	SET	7,(IX+47)	;set deleted disk link
	LD	B,(IX+54)	;get deleted disk link
	LD	H,(IX+55)
	LD	L,(IX+56)
	LD	A,B		;check if any link
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,CONT1	;no, BHL = rec #
;
;	no deleted disks, check if room to add one
;
	RES	7,(IX+47)	;set new disk
	LD	C,(IX+48)	;get max # diskettes
	LD	D,(IX+49)
	LD	E,(IX+50)
	LD	B,(IX+51)	;get # diskettes used
	LD	H,(IX+52)
	LD	L,(IX+53)
	CALL	$CMP24		;BHL = CDE?
	JR	NZ,CONT0	;yes, room to add it
;
;	diskette index full!
;
	LD	HL,FULMSG	;'index full'
	JP	ERREX		;error exit
;
;	store current disk #
;
CONT0	CALL	$INC24		;BHL = curr disk #
CONT1	LD	(IX+20),B	;save curr disk #
	LD	(IX+21),H
	LD	(IX+22),L
;
;	check if any commands issued
;
UPDAT1	LD	HL,$		;get command pointer
COMMAND	EQU	$-2
CKDAT	CALL	$POSHL		;any input?
	JR	NZ,HAVDAT	;yes, go!
	BIT	0,(IX+108)	;ADD mode?
	JR	Z,ASK1		;go if not
;
ASKN	LD	HL,NAMMSG	;'name?
	CALL	$DOLINE		;prompt
	LD	B,8		;max length
	CALL	$KBLINE		;get input
	JP	C,$CMD		;abort on break
	JR	Z,ASKN		;go if nil
	LD	DE,NAMDAT	;store here
	CALL	PUTIT		;move it here
;
ASKD	LD	HL,DATMSG	;'date?
	CALL	$DOLINE		;prompt
	LD	B,8		;max length
	CALL	$KBLINE		;get input
	JP	C,$CMD		;abort on break
	JR	Z,ASKD		;go if nil
	LD	DE,NAMDAT+8	;store here
	CALL	PUTIT		;move here
	LD	(IX+34),'X'-'0'	;dummy drive #
	JP	UPDAT4		;continue
;
;	prompt user for input
;
ASK1	LD	HL,PROMPT1	;'drivespec'
	CALL	$DOLINE		;display prompt
	LD	B,32		;max input
	CALL	$KBLINE		;get keyboard input
	JP	C,$CMD		;abort on BREAK
	JR	CKDAT		;check if anything
;
;	evaluate user input
;
HAVDAT	LD	IX,@DATA	;reset pointer
	BIT	0,(IX+108)	;ADD mode?
	JP	NZ,INVALID	;yes, no commands!
;
	LD	IY,MASK		;mask work byte
	LD	(IY+0),0	;reset flags
	LD	A,(HL)		;get input char
	CP	':'		;drive #?
	JR	Z,HAVDAT2	;go if drive #
	CP	'-'		;minus partspec?
	JR	NZ,HAVD1	;go if not
	SET	6,(IY+0)	;set reverse mask
	INC	HL		;bump past
HAVD1	LD	B,1		;command #
	CALL	$WILD		;check if wild param
	JP	NZ,INVALID	;invalid command
	SET	7,(IY+0)	;set have mask
	CALL	$POSHL		;any more input?
	JP	Z,MISSING	;missing information
	LD	A,(HL)		;check for drive #
	CP	':'		;match?
	JP	NZ,INVALID	;go if not
HAVDAT2	INC	HL		;bump past
	LD	A,(HL)		;get drive #
	SUB	'0'		;valid?
	JP	C,INVALID	;nope, go!
	CP	8		;0-7?
	JP	NC,INVALID	;go if not
	LD	(IX+34),A	;save drive #
	INC	HL		;bump pointer
	CALL	$POSHL		;any more input?
	JR	Z,HAVDAT4	;go if not
	CP	'('		;open paren?
	JR	NZ,HAVDAT3+1	;go if not
;
HAVDAT3	INC	HL		;bump pointer
	CALL	$POSHL		;position to input
	JR	Z,HAVDAT4	;go if no more
	CP	')'		;terminator?
	JR	Z,HAVDAT4	;yes, go!
	CP	_REMARK		;terminator?
	JR	Z,HAVDAT4	;go if yes
	CALL	$UCASE		;make upper case
	CP	'F'		;force log?
	JR	Z,HAVDATF	;go if yes
	CP	'C'		;non-stop update mode?
	JR	Z,HAVDATC	;yes, go!
	CP	'I'		;invisible files?
	JR	Z,HAVDATI	;yes, go!
	CP	'M'		;mod only?
	JR	Z,HAVDATM	;yes, go!
	CP	'N'		;no name update/log check
	JR	Z,HAVDATN	;yes, go!
	CP	'E'		;exact update?
	JR	Z,HAVDATE	;yes, go!
	CP	'R'		;replace name/date?
	JR	Z,HAVDATR	;go if yes
	CP	'S'		;system files?
	JP	NZ,INVALID	;go if not
HAVDATS	RES	6,(IX+110)	;allow sys files
	JR	HAVDAT3		;continue
HAVDATI	RES	3,(IX+110)	;allow inv files
	JR	HAVDAT3		;continue
HAVDATC	SET	6,(IX+47)	;set no prompt on update
	JR	HAVDAT3		;continue
HAVDATN	SET	3,(IX+108)	;set no name update
	JR	HAVDAT3		;continue
HAVDATR	SET	0,(IX+114)	;set REPLACE mode
	JR	HAVDAT3		;continue
HAVDATM	LD	A,(MASK)	;get mask
	SET	5,A		;set MOD
	LD	(MASK),A	;update
	JR	HAVDAT3		;continue
HAVDATE	BIT	5,(IX+108)	;UPDATE?
	JP	Z,INVALID	;nope, invalid command!
	SET	7,(IX+114)	;set EXACT mode
	JR	HAVDAT3		;continue
HAVDATF	BIT	5,(IX+108)	;log?
	JP	NZ,INVALID	;UPDATE, invalid param
	SET	7,(IX+125)	;set flag
	JR	HAVDAT3		;continue
;
;	check if drive mounted/ready/readable
;
HAVDAT4	LD	C,(IX+34)	;get drive #
	CALL	$CKDRV		;drive ready?
	JR	NZ,ERROR0	;nope, go!
;
;	read GAT table to check if disk is logged
;
	LD	DE,0<8+0	;set cyl/sector
	LD	HL,DIRBUFF	;directory buffer
	CALL	$RDDIR		;read directory
	JR	NZ,ERROR0	;go if disk error
	LD	IX,@DATA	;data storage
	LD	(IX+31),D	;save dir cylinder
	LD	(IX+32),E	;save dir sector
	RES	1,(IX+114)	;set current format
;
;	check if disk logged by previous version!
;
	LD	HL,DIRBUFF+0D0H	;previously put here!
	LD	DE,HEADER	;header message
	LD	B,11		;length
	CALL	$COMPAR		;match?
	JR	NZ,NOTOLD	;not an old disk!
;
;	logging/updating an old disk, adjust data
;
	SET	1,(IX+114)	;set old format
	LD	HL,DIRBUFF+0D0H	;is here
	LD	DE,DIRBUFF+0F0H	;should be here
	LD	BC,16		;length
	LDIR			;save it
;
NOTOLD	LD	HL,DIRBUFF+0F0H	;offset to name/date
	LD	DE,HEADER	;header message
	LD	B,11		;11 chars in header
	CALL	$COMPAR		;match?
	JR	NZ,CONT2	;go if not
	BIT	5,(IX+108)	;update?
	JP	NZ,UPDAT2	;yes, go!
	BIT	7,(IX+125)	;FORCE log param?
	JR	NZ,CONT2	;go if yes
;
;	diskette already logged!
;
	LD	HL,DIRBUFF+0F0H+11	;start of number
	LD	DE,ALRMSG1	;text to load
	LD	BC,5		;number length
	LDIR			;move to message
	LD	HL,ALRMSG	;'already logged'
	JP	ERREX		;continue and exit
;
;	error handler
;
ERROR0	LD	DE,LOGMSG	;'log error'
	CALL	$DOERR		;display error message
	JP	GOCMD		;back to interpreter
;
ERRORX	LD	DE,ADDEMSG	;'add error'
	JR	ERROR+3		;continue
ERROR	LD	DE,LOGMSG	;'log error'
	CALL	$DOERR		;display message/error
	LD	HL,KEYMSG	;'key to continue'
	CALL	$DOLINE		;display
	CALL	$ENKEY		;wait for enter key
	JP	ABORT		;check for updating
;
;	save disk name/date and log disk directory
;
CONT2	BIT	5,(IX+108)	;update mode?
	LD	HL,BADDNM	;'invalid disk, use LOG
	JR	Z,CONT2A	;continue if LOG
	BIT	3,(IX+108)	;no name verify?
	JP	Z,ERREX		;yes verify, abort!
;
;	no disk number on disk, prompt user for it
;
ASDNM	LD	HL,DNUMG	;'invalid, disk #?'
	CALL	$DOLINE		;display
	LD	B,5		;5 chars max disk#
	CALL	$KBLINE		;get keys from user
	JP	C,$CMD		;abort on BREAK
	JR	Z,ASDNM		;wait on enter
	CALL	VALDISK		;valid disk #
	JP	NZ,ERREX	;go if invalid #
	LD	(IX+20),B	;update disk#
	LD	(IX+21),H
	LD	(IX+22),L
	SET	2,(IX+108)	;set logged
	JR	UPDAT2		;else continue
;
;	save disk name/date and strip control codes
;
CONT2A	LD	HL,DIRBUFF+0D0H	;start name/date
	LD	DE,NAMDAT	;store it here
	LD	B,16		;length
;
CONT3	LD	A,(HL)		;get a byte
	AND	7FH		;remove high bit
	CP	' '		;displayable?
	JR	NC,$+4		;go if yes
	LD	A,'.'		;remove control codes!
	LD	(DE),A		;load data
	INC	HL		;bump source
	INC	DE		;bump dest
	DJNZ	CONT3		;go for length
;
;	check if current auto command exceeds 16 chars
;
	LD	HL,DIRBUFF+0E0H	;start auto command
	LD	B,16		;max allowed length
	LD	A,_CR		;search char
CKAUTO	CP	(HL)		;terminator?
	JR	Z,AUTOOK	;go if found
	INC	HL		;bump pointer
	DJNZ	CKAUTO		;go till found
	LD	(DIRBUFF+0E0H),A	;reset auto!
;
AUTOOK	LD	DE,DIRBUFF+0F0H	;log disk here
	LD	HL,HEADER	;header message
	LD	BC,11		;header length
	LDIR			;move to GAT
	PUSH	DE		;pass pointer to IX
	POP	IX		;IX => remainder
	LD	IY,@DATA	;start data block
	LD	B,(IY+20)	;get curr disk #
	LD	H,(IY+21)
	LD	L,(IY+22)
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;convert to ascii
;
;	load disk type parameters and display
;
UPDAT2	LD	IY,@DATA	;reset pointer
	LD	C,(IY+34)	;get drive #
	CALL	$DSIZE		;fetch drive params
	LD	(IY+38),L	;cylinder count
	LD	(IY+39),B	;disk flags
	LD	(IY+40),E	;directory sector count
	BIT	5,(IY+108)	;update?
	JR	NZ,UPDAT3	;yes, continue!
;
;	write updated GAT to directory
;
	BIT	3,(IY+108)	;ignore disk update?
	JR	NZ,UPDAT4	;continue if yes
	LD	D,(IY+31)	;cyl directory
	LD	E,(IY+32)	;sec directory
	LD	C,(IY+34)	;get drive #
	LD	HL,DIRBUFF	;I/O buffer
	CALL	$WRDIR		;write directory
	JP	NZ,ERROR	;go on disk error
	JR	UPDAT4		;continue
;
;	fetch disk # from diskette
;
UPDAT3	LD	IX,@DATA	;reset pointer
	BIT	3,(IX+108)	;no disk log update?
	JR	Z,UPDAT33	;go if yes
	BIT	2,(IX+108)	;number found?
	JR	NZ,UPDAT4	;go if yes!
;
UPDAT33	LD	HL,DIRBUFF+0F0H+11 ;offset to disk #
	LD	A,_CR		;terminate input
	LD	(DIRBUFF+100H),A ;end of input
	CALL	$POSHL		;position to first char
	JR	Z,NOTGDSK	;go if no number!
	CALL	VALDISK		;valid disk #?
	JR	Z,UPDAT3A	;go if OK
;
NOTGDSK	LD	HL,BADDMG	;'bad disk number'
	JP	ERREX		;exit in error
;
UPDAT3A	LD	(IX+20),B	;save current disk #
	LD	(IX+21),H
	LD	(IX+22),L
;
;	log disk name/date into index file
;
UPDAT4	LD	IX,@DATA	;start data
	LD	B,(IX+20)	;get curr disk #
	LD	H,(IX+21)
	LD	L,(IX+22)
	CALL	$DEC24		;adjust 0 relative
	LD	C,16		;entries / sector
	CALL	$DIVID		;BHL = sector/A=rel offs
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	ADD	A,A		;*16
	LD	(IX+26),A	;rel byte name/date
	CALL	$INC24		;BHL = sector name/date
	LD	(IX+23),B	;save sector
	LD	(IX+24),H
	LD	(IX+25),L
;
;	compute relative sector disk index
;
	LD	B,(IX+20)	;get disk #
	LD	H,(IX+21)
	LD	L,(IX+22)
	CALL	$DEC24		;BHL = rel disk #
	LD	C,(IX+57)	;get start tables
	LD	D,(IX+58)
	LD	E,(IX+59)
	CALL	$ADD24		;BHL = BHL + CDE
	LD	(IX+27),B	;save sector disk index
	LD	(IX+28),H
	LD	(IX+29),L
;
;	load memory buffers for quick operation
;
	LD	HL,0		;init record #
	LD	B,H		;BHL = 000000
	CALL	READIT		;read the sector
	JP	NZ,ERROR	;go if disk error
	LD	DE,IND0		;index buffer 0
	LD	BC,100H		;buffer length
	LDIR			;save it
	SET	3,(IX+47)	;set buffer loaded
;
	BIT	5,(IX+108)	;update?
	JR	NZ,UPDAT5	;yes, go!
	BIT	6,(IX+114)	;remove?
	JR	NZ,UPDAT5	;go if yes, read sector
;
	LD	HL,INDF		;file index buffer
	LD	BC,0<8+0FFH	;length + nil fill data
	CALL	$CLEAR		;clear buffer
	XOR	A		;init defaults
	LD	(INDF+0FFH),A	;flags
	LD	(INDF+0FEH),A	;flags
	LD	(IX+38),A
	LD	(IX+39),A
	JR	UPDAT6		;continue
;
UPDAT5	LD	B,(IX+27)	;get index sector
	LD	H,(IX+28)
	LD	L,(IX+29)
	CALL	READIT		;read the sector
	JP	NZ,ERROR	;go on error
	LD	DE,INDF		;index buffer
	LD	BC,100H		;length
	LDIR			;save it
;
UPDAT6	SET	1,(IX+47)	;set buffer loaded
	SET	0,(IX+47)	;set INDF updated
	LD	HL,INDF+0F0H	;move in current date
	CALL	$DATE		;load it
	BIT	6,(IX+114)	;REMOVE calling?
	JP	NZ,REMUP6	;continue if yes
	BIT	7,(IX+114)	;exact mode?
	JR	Z,UPDAT7	;go if not
	CALL	CLRUPDF		;clear update flags
	JP	NZ,ERROR	;go on disk error
;
;	fetch disk size params and save into sector
;
UPDAT7	BIT	0,(IX+108)	;ADD?
	JR	Z,ADD1		;go if not
	LD	L,0		;zero cylinder count
	LD	B,L		;zero flags
	LD	DE,0		;get free space
	JR	ADD2		;continue
ADD1	LD	C,(IX+34)	;get drive #
	CALL	$DFREE		;get free space to DE
	PUSH	DE		;save free
	CALL	$DSIZE		;get drive params
	POP	DE		;restore free
;
ADD2	LD	A,L		;get cyl count
	LD	(INDF+0FFH),A	;save it
	LD	(IX+38),A
	LD	A,B		;get flags
	LD	(INDF+0FEH),A	;save it
	LD	(IX+39),A
	LD	(FREE),DE	;save free space
	LD	(INDF+0FCH),DE	;to buffer
;
;	log disk name/date into index
;
REMUP6	LD	B,(IX+23)	;get sector #
	LD	H,(IX+24)
	LD	L,(IX+25)
	CALL	READIT		;read it
	JP	NZ,ERROR	;go on disk error
;
	LD	E,(IX+26)	;byte name date
	LD	D,0		;DE = sector offset
	ADD	HL,DE		;HL => name/date
	BIT	6,(IX+114)	;remove?
	JR	NZ,REMUP7	;go if yes
	BIT	5,(IX+108)	;update?
	JR	Z,CONT2B	;continue if not
REMUP7	LD	DE,NAMDAT	;store here
	LD	BC,16		;name length
	LDIR			;move it
	BIT	6,(IX+114)	;remove?
	RET	NZ		;return if yes
	BIT	0,(IX+114)	;replace mode?
	JP	Z,CONT6		;nope, continue
	BIT	1,(IX+114)	;old format?
	JP	Z,CONT6		;nope, already correct
;
;	disk logged with old format, replace name/date
;
	LD	C,(IX+34)	;get drive #
	LD	D,(IX+31)	;get cylinder
	LD	E,0		;sector 0
	LD	HL,DIRBUFF	;directory buffer
	CALL	$RDDIR		;read directory
	JP	NZ,ERROR0	;go on error
	LD	HL,DIRBUFF+0D0H	;stored here
	LD	DE,DIRBUFF+0F0H	;should be here
	LD	BC,16		;length
	LDIR			;move it
	LD	(HL),_CR	;terminate auto command
	LD	HL,NAMDAT	;name/date stored here
	LD	DE,DIRBUFF+0D0H	;should be here
	LD	BC,16		;length
	LDIR			;put it back
	LD	C,(IX+34)	;get drive
	LD	D,(IX+31)	;cylinder
	LD	E,0		;sector
	LD	HL,DIRBUFF	;directory buffer
	CALL	$WRDIR		;write directory
	JP	NZ,ERROR0	;go on error
	JP	CONT6		;else continue
;
;	if a deleted disk record, save forward link
;
CONT2B	BIT	7,(IX+47)	;deleted disk usage?
	JR	Z,CONT4		;nope, continue
	PUSH	HL		;save pointer
	INC	HL		;HL => 3 byte next link
	LD	DE,@DATA+44	;disk link storage
	LD	BC,3		;3 bytes to move
	LDIR			;save 'em
	POP	HL		;restore pointer
;
;	save real disk name/date
;
CONT4	EX	DE,HL		;DE => dest
	LD	HL,NAMDAT	;stored here
	LD	BC,16		;text length
	LDIR			;move it
;
;	update index ID sector
;
	SET	4,(IX+47)	;set buff needs update
;
;	check if re-instating a deleted disk link
;
	BIT	7,(IX+47)	;deleted disk?
	JR	Z,CONT5		;nope, bump counter
;
;	update new pointer to next deleted disk
;
	LD	B,(IX+44)	;get deleted disk link
	LD	H,(IX+45)
	LD	L,(IX+46)	;BHL = next link in chain
	LD	(IX+54),B	;update next link
	LD	(IX+55),H
	LD	(IX+56),L
	JR	CONT6		;update data
;
;	set new disk count, new disk
;
CONT5	LD	B,(IX+20)	;get current disk
	LD	H,(IX+21)
	LD	L,(IX+22)	;BHL = current disk #
	LD	(IX+51),B	;update # disks used
	LD	(IX+52),H
	LD	(IX+53),L
;
;	write new data back to disk
;
CONT6	CALL	UPDAT0		;update data to disk/vid
	LD	HL,CLS		;clear video
	CALL	$DOLINE		;clear it
	CALL	$SHOWF		;display file data
	CALL	SHOW1		;display disk data
	CALL	WRITIT		;update I/O buffer
	JP	NZ,ERROR	;go on disk error
;
;	fetch file data from disk directory
;
	LD	HL,FILEMSK	;file header mask
	CALL	$DOLINE		;display mask
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;expanded mode?
	LD	HL,FILEMSE	;expanded data
	CALL	NZ,$DOLINE	;yes, display remainder
	CALL	FLAGNAM		;display flag names
	CALL	GETFILE		;get file data
	JP	NZ,ERROR	;go on disk error
	LD	IX,@DATA	;reset pointer
	BIT	7,(IX+114)	;exact mode?
	JP	Z,EXIT		;nope, done!
	CALL	CKUPDF		;check flags
	JP	NZ,ERROR	;go on disk error
	JP	EXIT		;else done!
;
;	data update
;
GETFILE	LD	IX,@DATA	;init data pointer
	BIT	0,(IX+108)	;adding?
	JP	NZ,GOADD	;yes, go!
;
;	set pointers for directory search
;
	LD	(IX+32),2	;current sector directory
	LD	(IX+33),0	;current byte directory
;
FILELP	LD	IX,@DATA	;data pointer
	LD	A,(IX+33)	;get byte directory
	OR	A		;need to read directory?
	JR	NZ,FILE1	;go if not
;
;	check if completed
;
	LD	A,(IX+32)	;get sector directory
	SUB	(IX+40)		;less directory sectors
	RET	Z		;completed!
;
;	read new directory sector
;
	LD	D,(IX+31)	;cylinder directory
	LD	E,(IX+32)	;sector directory
	LD	C,(IX+34)	;current drive
	LD	HL,DIRBUFF	;I/O buffer
	CALL	$RDDIR		;read sector
	RET	NZ		;go on disk error
;
FILE1	LD	H,DIRBUFF<-8	;msb buffer
	LD	A,(IX+33)	;byte directory
	LD	L,A		;HL => file
	ADD	A,20H		;offset to next
	LD	(IX+33),A	;update entry
	JR	NZ,FILE2	;continue if not at end
	INC	(IX+32)		;bump sector directory
;
FILE2	CALL	INCLUDE		;include this file?
	JR	NZ,FILE4	;nope, go next one
	CALL	MOVE		;move to EBUFF
;
	LD	IX,@DATA	;start data block
	BIT	5,(IX+108)	;update?
	JR	NZ,FILE3	;yes, go!
;
	CALL	EDITOR		;update new record
	RET	NZ		;go on error
	JR	FILE4		;continue
;
FILE3	CALL	UPDREC		;update record
	RET	NZ		;disk error!
;
;	advance to next file
;
FILE4	JR	FILELP		;continue
;
;	check if file is to be included in search
;	check and ignore BOOT/SYS and DIR/SYS
;
INCLUDE	LD	A,(IX+32)	;sector directory
	SUB	2		;2?
	JR	Z,INCCK		;yes, check byte 00
	DEC	A		;3?
	JR	NZ,INCCK1	;nope, continue
INCCK	LD	A,(IX+33)	;byte directory
	CP	20H		;at first entry?
	JR	NZ,INCCK1	;nope, continue
	OR	-1		;set NZ for ignore
	RET			;return to next
;
INCCK1	LD	A,(MASK)	;get flags
	BIT	5,A		;mod only?
	JR	Z,INCCK2	;go if not
	INC	HL		;bump to dir +1
	BIT	6,(HL)		;mod?
	DEC	HL		;adjust back
	JR	Z,INCLNO	;nope, go!
;
INCCK2	LD	A,(HL)		;get first char
	AND	(IX+110)	;file AND
	CP	(IX+111)	;file CMP
	RET	NZ		;NZ = ignore!
;
;	check if file compares to mask
;
	LD	A,0		;get flags
MASK	EQU	$-1
	AND	80H		;any mask?
	RET	Z		;nope, go!
	PUSH	HL		;save
	LD	BC,5		;offset to diskname
	ADD	HL,BC		;HL => name
	LD	B,2		;compare to wildmask
	CALL	$WILD		;match?
	POP	HL		;restore pointer
	LD	A,(MASK)	;re-fetch flags
	JR	NZ,CKNOTIN	;check if not param
	BIT	6,A		;reverse mask?
	JR	Z,INCLYES	;nope, include
INCLNO	OR	-1		;set NO match
	RET			;done
CKNOTIN	BIT	6,A		;reverse mask?
	JR	Z,INCLNO	;set NO match if not
INCLYES	XOR	A		;set MATCH
	RET			;done
;
;	update index sector relative 00000
;
UPDAT0	LD	HL,@DATA+48	;source data
	LD	DE,IND0+48	;dest data mem buff
	LD	BC,32		;data length
	LDIR			;move it
	SET	2,(IX+47)	;set buffer needs update
	XOR	A		;set NO error
	RET			;done!
;
UPDATF	SET	0,(IX+47)	;set buffer updated
	XOR	A		;set no error
	RET			;done!
;
;	read data sector with buffer memory
;
READIT	CALL	WRITIT		;update buffer
	RET	NZ		;go if error
;
;	check if requested buffer is currently loaded
;
	BIT	5,(IX+47)	;buffer has data?
	JR	Z,READIT1	;go if not!
	LD	C,(IX+41)	;get current sector
	LD	D,(IX+42)
	LD	E,(IX+43)
	CALL	$CMP24		;at current?
	JR	Z,READIT2	;go if yes
;
READIT1	LD	(IX+41),B	;set current sector
	LD	(IX+42),H
	LD	(IX+43),L
	RES	5,(IX+47)	;set no data in buffer
	LD	DE,(@FCB)	;file block
	LD	BC,@DATA+41	;sector number
	CALL	$POSN		;position to record
	RET	NZ		;go if error
	CALL	$READ		;read record
	RET	NZ		;go if error
READIT2	SET	5,(IX+47)	;set buffer loaded
	LD	HL,(@IOBUFF)	;start buffer
	XOR	A		;set NO error
	RET			;return OK
;
;	sector write with memory
;
WRITIT	BIT	5,(IX+47)	;data in buffer
	RET	Z		;nope, go!
	BIT	4,(IX+47)	;needs update?
	RET	Z		;nope, go!
;
	CALL	$SAVREG		;save registers
	LD	DE,(@FCB)	;file block
	LD	BC,@DATA+41	;relative sector #
	CALL	$POSN		;position to record
	RET	NZ		;go if error
	CALL	$WRITE		;write record
	RET	NZ		;go if error
	RES	4,(IX+47)	;set buffer OK
	XOR	A		;set NO error
	RET			;done!
;
;	error occured, check if buffers need update
;
ABORT	LD	IX,@DATA	;data block
	LD	A,(IX+47)	;get flags
;
;	check if any buffers need updating
;
	AND	00010101B	;any updating?
	JR	Z,EXIT		;nope, exit
;
;	error occured, check if attempt to update
;
CHECK	LD	HL,PROMPT2	;'attempt to update?'
	CALL	$DOLINE		;display
	CALL	$INKEY		;get user input
	JP	C,GODOS		;go on BREAK
	JR	Z,EXIT		;default on enter
	CALL	$UCASE		;make upper case
	CP	'N'		;no?
	JP	Z,GODOS		;nope, exit
	CP	'Y'		;yes?
	JR	NZ,CHECK	;neither, ask again
;
;	check if buffers need update
;
EXIT	LD	IX,@DATA	;start data block
;
;	check if any action taken
;
	LD	A,(IX+20)	;check if any disk number
	AND	(IX+21)
	AND	(IX+22)
	INC	A		;FFFFFF?
	JP	Z,$CMD		;yes, ignore close
;
;	any need updating?
;
	CALL	WRITIT		;update I/O buffer
	JP	NZ,ERROR	;go on error
;
EXIT1	BIT	3,(IX+47)	;IND0 buffer loaded?
	JR	Z,EXIT2		;nope, go!
	BIT	2,(IX+47)	;buffer needs update?
	JR	Z,EXIT2		;nope, go!
;
;	update IND0 buffer
;
	LD	HL,0		;load sector #
	LD	B,H		;BHL = 000000
	CALL	READIT		;read the sector
	JP	NZ,ERROR	;go on disk error
	EX	DE,HL		;DE => I/O buffer
	LD	HL,IND0		;point to buffer
	LD	BC,100H		;buffer length
	LDIR			;move it
	SET	4,(IX+47)	;set file updated
	CALL	WRITIT		;write the buffer
	JP	NZ,ERROR	;go on error
	RES	2,(IX+47)	;set updated
;
;	check if file pointer buffer needs update
;
EXIT2	BIT	1,(IX+47)	;INDF buffer loaded?
	JR	Z,GODOS		;nope, exit
	BIT	0,(IX+47)	;needs update?
	JR	Z,GODOS		;nope, exit
;
;	update index file pointer buffer
;
	LD	B,(IX+27)	;get record #
	LD	H,(IX+28)
	LD	L,(IX+29)
	CALL	READIT		;read the sector
	JP	NZ,ERROR	;go on disk error
	EX	DE,HL		;DE => I/O buffer
	LD	HL,INDF		;index file buffer
	LD	BC,100H		;buffer length
	LDIR			;move it
	SET	4,(IX+47)	;set buffer updated
	CALL	WRITIT		;write the sector
	JP	NZ,ERROR	;go on error
	RES	0,(IX+47)	;set updated
;
GODOS	BIT	6,(IX+114)	;REMOVE mode?
	JR	NZ,GODOS0	;go if yes
	LD	HL,OKMSG0	;'clear video'
	CALL	$DOLINE		;display
	CALL	SHOW1		;display disk type
	LD	IX,@DATA	;data pointer
	BIT	5,(IX+108)	;update?
	JR	NZ,GODOS1	;yes, go!
	LD	HL,OKMSG	;'file updated'
	CALL	$DOLINE		;display
	CALL	$ENKEY		;wait for enter key
	JP	GOCMD		;go command mode
GODOS0	LD	HL,OKMSGUU	;'file updated'
	CALL	$DOLINE		;display
	JP	GOCMD		;go command mode
GODOS1	LD	HL,OKMSGU	;'file updated'
	CALL	$DOLINE		;display
	JP	GOCMD		;go command mode
;
;	clear update flags for exact update
;
CLRUPDF	LD	HL,CLRFMSG	;'clearing update flags'
	CALL	$DOLINE		;display
	LD	HL,CLRFLG	;subroutine
	JR	CLRF		;go common
;
CKUPDF	LD	HL,CKUPMSG	;'deleting extra entries'
	CALL	$DOLINE		;display
	LD	HL,CKFLG	;subroutine
	JR	CLRF		;continue
;
DELALL	LD	HL,DELAMSG	;'deleting all files'
	CALL	$DOLINE		;display
	CALL	FLAGNAM		;display flag names
	CALL	SHOW1		;display disk type
	LD	HL,CKFLGK	;subroutine
;
CLRF	LD	(CLRCALL),HL	;pass sub vector
	XOR	A		;init pointer
;
CLRLP	LD	IX,@DATA	;reset pointer
	LD	(CLRPOS),A	;save position
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	L,A		;pass LSB
	LD	H,INDF<-8	;HL => current pointer
	LD	B,(HL)		;get MSB
	INC	HL		;bump
	LD	D,(HL)		;get nsb
	INC	HL		;bump
	LD	E,(HL)		;get lsb
	EX	DE,HL		;BHL = record #
;
CLRLP1	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;nil link FFFFFF?
	JR	Z,CLRNXT	;yes, go next link
	CALL	GETREC		;get record
	RET	NZ		;go on disk error
	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	CALL	$		;call subroutine for file
CLRCALL	EQU	$-2
	RET	NZ		;go on disk error
;
	JR	CLRLP1		;go next file
;
CLRNXT	LD	A,0		;get current position
CLRPOS	EQU	$-1
	INC	A		;bump to next
	CP	27		;0-26?
	JR	C,CLRLP		;go next link if yes
	XOR	A		;else set no error
	RET			;return files flagged
;
CLRFLG	RES	0,(IY+0)	;reset update flag
	SET	4,(IX+47)	;set buffer updated
	XOR	A		;set NO error
	RET			;done!
;
;	check if file flagged as updated
;
CKFLG	BIT	0,(IY+0)	;file updated?
	JR	Z,CKFLGK	;nope, delete file
	XOR	A		;else OK
	RET			;leave it here!
;
CKFLGK	CALL	$SAVREG		;must save BHL
	CALL	UNPACK		;unpack the record
	CALL	DISPLAY		;display file data
	LD	HL,INDF		;index buffer
	LD	DE,XBUFF	;extra buffer
	LD	BC,100H		;length
	LDIR			;save it
	LD	IX,@DATA	;reset data
	SET	1,(IX+108)	;set call from update
	RES	6,(IX+108)	;set buffer NOT updated
	CALL	DELEREC		;delete record
	RET	NZ		;go on error
	BIT	6,(IX+108)	;any buffer update?
	RET	Z		;nope, go!
	LD	HL,XBUFF	;extra buffer
	LD	DE,INDF		;index buffer
	LD	BC,100H		;length
	LDIR			;restore it
	SET	0,(IX+47)	;set buffer updated
	XOR	A		;set NO error
	RET			;return with status
;
REMOVE	LD	HL,(COMMAND)	;get input pointer
REMOV1	CALL	$POSHL		;any input?
	JR	NZ,REMOV2	;go if yes
	LD	HL,REMPMT	;'delete disk #?'
	CALL	$DOLINE		;display
	LD	B,20		;input length
	CALL	$KBLINE		;get key input
	JP	C,$CMD		;abort on BREAK
	JR	REMOV1		;check if any input
;
REMOV2	CP	'#'		;must be disk specifier
	JP	NZ,INVALID	;go if wrong
	INC	HL		;bump past
	CALL	VALDISK		;valid disk #
	JP	NZ,ERREX	;abort if error
	LD	(IX+20),B	;save disk #
	LD	(IX+21),H
	LD	(IX+22),L
	CALL	UPDAT4		;load index buffers
	CALL	DELALL		;delete all files
	JP	NZ,ERROR	;go on error
;
;	add disk to deleted disk link
;
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+23)	;get sector name/date
	LD	H,(IX+24)
	LD	L,(IX+25)
	CALL	READIT		;read the sector
	JP	NZ,ERROR	;go on error
	LD	E,(IX+26)	;get byte disk name/date
	LD	D,0		;DE = offset
	ADD	HL,DE		;HL => name
	LD	(HL),80H	;set as deleted
	INC	HL		;bump to next
	LD	B,(IX+54)	;get deleted disk link
	LD	D,(IX+55)
	LD	E,(IX+56)	;BDE = next deleted disk
	LD	(HL),B		;load msb
	INC	HL		;bump
	LD	(HL),D		;load nsb
	INC	HL		;bump
	LD	(HL),E		;load lsb
	SET	4,(IX+47)	;set buffer updated
	CALL	WRITIT		;write the buffer
	JP	NZ,ERROR	;go on disk error
	LD	B,(IX+20)	;get current disk #
	LD	H,(IX+21)
	LD	L,(IX+22)
	LD	(IX+54),B	;set as next deleted disk
	LD	(IX+55),H
	LD	(IX+56),L
	CALL	UPDAT0		;update IND0 buffer
	CALL	RESDIR		;reset directory
	JP	NZ,ERROR	;go on error
	JP	EXIT		;update buffers
;
;	reset diskette directory
;
RESDIR	LD	IX,@DATA	;reset pointer
	LD	B,(IX+20)	;get current disk #
	LD	H,(IX+21)
	LD	L,(IX+22)
	PUSH	BC		;save
	PUSH	HL
	LD	IX,REMG1A	;text to load number
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;to ascii
	POP	HL		;restore
	POP	BC
	LD	IX,REMG2A	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	LD	HL,CLS		;clear lower
	CALL	$DOLINE		;display
;
WAITMNT	LD	HL,REMG1	;'mount disk, key drive'
	CALL	$DOLINE		;display prompt
	CALL	$INKEY		;wait for one key
	JP	C,EXIT		;abort on BREAK
	SUB	'0'		;remove ascii
	JR	C,WAITMNT	;go if invalid
	CP	8		;0-7?
	JR	NC,WAITMNT	;wait if bad
;
	LD	C,A		;C = drive #
	CALL	$CKDRV		;check drive ready
	JR	NZ,MNTERR	;go if error
	LD	DE,0<8+0	;cyl/sect
	LD	HL,DIRBUFF	;buffer
	CALL	$RDDIR		;read directory
	JR	NZ,MNTERR	;go on error
;
;	load disk name/date, remove header
;
	PUSH	BC		;save drive
	PUSH	DE		;save cyl/sect
	LD	HL,NAMDAT	;name/date here
	LD	DE,DIRBUFF+0D0H	;goes here
	LD	BC,16		;length
	LDIR			;move it
	EX	DE,HL		;HL => auto
	LD	(HL),_CR	;terminate auto
	LD	D,H		;pass to DE
	LD	E,L
	INC	DE		;auto +1
	LD	BC,31		;length -1
	LDIR			;remove auto, header
	POP	DE		;restore cyl/sect
	POP	BC		;restore drive
	LD	HL,DIRBUFF	;buffer
	CALL	$WRDIR		;write directory
	RET	Z		;go on no error
;
MNTERR	LD	DE,REMG3	;'error'
	CALL	$DOERR		;display error
	JR	WAITMNT		;continue
;
*GET	DMAN04E			;remainder data
;
