; dman02/asm - kjw/bci - HELP
;
;	created 08/15/83	- kjw/bci
;	revised 09/24/83	- kjw/bci
;
ENTRY	PUSH	HL		;save command pointer
	LD	HL,CLSMSG	;clear screen message
	CALL	$DOLINE		;display
	POP	HL		;restore command pointer
;
;	check for any input
;
	CALL	$POSHL		;any input?
	JR	Z,SHOHELP	;nope, display summary
;
;	check if valid command issued
;
	EX	DE,HL		;DE => command
	LD	HL,LIBRY	;command library
	CALL	FIND		;valid command?
	JR	NZ,GOTLIB	;yes, display text
;
;	unrecognized command
;
	LD	HL,UNRMSG	;'unrecognized command'
	CALL	$DOLINE		;display text
;
;	display command summary
;
SHOHELP	LD	HL,AVAMSG	;'help available for:'
	CALL	$DOLINE		;display to video
;
;	display library command summary
;
	LD	A,3<4+1		;system command
	JP	$OVRLAY		;execute command
;
;	have valid command, display text
;
GOTLIB	DEC	A		;adjust 0 relative
	ADD	A,A		;*2
	LD	HL,LOOKUP	;text lookup table
	ADD	A,L		;add lsb offset
	LD	L,A		;update lsb
	JR	NC,$+3		;go if no overflow
	INC	H		;bump msb page crossing
;
;	fetch pointer to command mode
;
	LD	A,(HL)		;fetch lsb
	INC	HL		;bump table pointer
	LD	H,(HL)		;fetch msb
	LD	L,A		;HL => help message
	CALL	$DOLINE		;display message
	LD	A,0<4+1		;back to command mode
	JP	$OVRLAY		;go!
;
;	locate command word in lookup table
;
FIND	LD	B,0		;init position counter
FINDLP	INC	B		;bump command #
	LD	A,(HL)		;fetch table entry
	INC	HL		;bump pointer
	OR	A		;end list?
	JP	P,FINDLP+1	;locate first byte
	AND	7FH		;remove high bit
	RET	Z		;not found!
;
	PUSH	DE		;save string start
FINDLP1	CALL	$UCASE		;make upper case
	LD	C,A		;C = char
	LD	A,(DE)		;get input char
	CALL	$UCASE		;make upper case
	CP	C		;match?
	JR	NZ,FINDLP2	;go if not
	LD	A,(HL)		;get next char
	INC	DE		;bump input string
	INC	HL		;bump lookup table
	JR	FINDLP1		;continue
;
FINDLP2	POP	DE		;restore string pointer
	BIT	7,C		;end table entry?
	JR	Z,FINDLP	;nope, go next word
	CP	30H		;terminator/separator?
	JR	NC,FINDLP	;nope, continue
	LD	A,B		;get table posit
	OR	A		;set NZ for found
	RET			;return with command #
;
;	library command lookup table
;
LIBRY	DEFB	'A'+80H		;add
	DEFM	'dd'
	DEFB	'B'+80H		;buffers
	DEFM	'uffer'
	DEFB	'B'+80H		;browse
	DEFM	'rowse'
	DEFB	'C'+80H		;change
	DEFM	'hange'
	DEFB	'C'+80H		;check
	DEFM	'heck'
	DEFB	'C'+80H		;close
	DEFM	'lose'
	DEFB	'D'+80H		;dir
	DEFM	'ir'
	DEFB	'D'+80H		;dos
	DEFM	'os'
	DEFB	'E'+80H		;edit
	DEFM	'dit'
	DEFB	'E'+80H		;exit
	DEFM	'xit'
	DEFM	'F'+80H		;find
	DEFM	'ind'
	DEFM	'F'+80H		;flags
	DEFM	'lags'
	DEFB	'H'+80H		;help
	DEFM	'elp'
	DEFM	'I'+80H		;init
	DEFM	'nit'
	DEFB	'K'+80H		;kill
	DEFM	'ill'
	DEFB	'L'+80H		;lib
	DEFM	'ib'
	DEFB	'L'+80H		;log
	DEFM	'og'
	DEFB	'M'+80H		;mount
	DEFM	'ount'
	DEFB	'N'+80H		;name
	DEFM	'ame'
	DEFB	'N'+80H		;names
	DEFM	'ames'
	DEFB	'O'+80H		;open
	DEFM	'pen'
	DEFB	'Q'+80H		;quit
	DEFM	'uit'
	DEFB	'R'+80H		;remove
	DEFM	'emove'
	DEFB	'S'+80H		;screen
	DEFM	'creen'
	DEFB	'T'+80H		;test
	DEFM	'est'
	DEFB	'U'+80H		;unload
	DEFM	'nload'
	DEFB	'U'+80H		;update
	DEFM	'pdate'
	DEFM	'V'+80H		;version
	DEFM	'ersion'
	DEFB	80H		;terminator
;
;	text lookup table
;
LOOKUP	DEFW	@ADD
	DEFW	@BUFFRS
	DEFW	@BROWSE
	DEFW	@CHANGE
	DEFW	@CHECK
	DEFW	@CLOSE
	DEFW	@DIR
	DEFW	@DOS
	DEFW	@EDIT
	DEFW	@EXIT
	DEFW	@FIND
	DEFW	@FLAGS
	DEFW	@HELP
	DEFW	@INIT
	DEFW	@KILL
	DEFW	@LIB
	DEFW	@LOG
	DEFW	@MOUNT
	DEFW	@NAME
	DEFW	@NAME		;for names too
	DEFW	@OPEN
	DEFW	@QUIT
	DEFW	@REMOVE
	DEFW	@SCREEN
	DEFW	@TEST
	DEFW	@UNLOAD
	DEFW	@UPDATE
	DEFW	@VERSN
;
;	program text area
;
CLSMSG	DEFB	_STX		;set cursor
	DEFB	@VID+1,000	;row/column
	DEFB	_EREOF		;clear video
	DEFB	_ETX		;end text
;
UNRMSG	DEFM	'Unrecognized Command - Syntax: '
	DEFM	'HELP ',_LBR,'command',_RBR
	DEFB	_CR
	DEFB	_ETX
;
AVAMSG	DEFM	'Help Is Available For:'
	DEFB	_CR
	DEFB	_CR
	DEFB	_ETX
;
;	help command summary text
;
@ADD	DEFM	'ADD'
	DEFB	_CR
	DEFM	'Manually Add Titles',_SEP
	DEFM	'Disks to Index'
	DEFB	_CR
	DEFM	'Prompting Issued As Needed'
	DEFB	_CR
	DEFM	'Normally used for adding non-'
	DEFM	'opsystem-readable disks'
	DEFB	_CR
	DEFM	'and disks on protected media'
	DEFB	_ETX
;
@BUFFRS	DEFM	'BUFFER ',_LBR,'maxbuffs',_RBR
	DEFB	_CR
	DEFM	'Set',_SEP,'Display maximum number of '
	DEFM	'memory buffers to use'
	DEFB	_CR
	DEFM	'1-50 sets buffer count, 0 disables'
	DEFB	_ETX
;
@BROWSE	DEFM	'BROWSE ',_LBR,'#dn',_RBR
	DEFB	_CR
	DEFM	'Examine Index Listings by '
	DEFM	'Disk#',_SEP,'Index Links',_SEP
	DEFM	'File Threads'
	DEFB	_ETX
;
@CHANGE	DEFM	'CHANGE ',_LBR,'filespec',_RBR
	DEFM	_LBR,'(C,E,O,D=value)',_RBR
	DEFB	_CR
	DEFM	'Copies current index file to filespec '
	DEFB	_CR
	DEFM	'C = change to COMPRESSED file'
	DEFB	_CR
	DEFM	'E = change to EXPANDED file'
	DEFB	_CR
	DEFM	'O = OVERWRITE existing file'
	DEFB	_CR
	DEFM	'D = change file to new '
	DEFM	'maximum disk count'
	DEFB	_CR
	DEFM	'(cannot be less than current size)'
	DEFB	_CR
	DEFM	'At least one parameter '
	DEFM	'must be specified'
	DEFB	_ETX
;
@UNLOAD	EQU	$
@CLOSE	DEFM	'CLOSE'
	DEFB	_CR
	DEFM	'UNLOAD'
	DEFB	_CR
	DEFM	'Closes Out Current Index And '
	DEFM	'Updates File Pointers'
	DEFB	_ETX
;
@DIR	DEFM	'DIR ',_LBR,'-wildmask',_RBR
	DEFM	_LBR,'range',_RBR
	DEFM	_LBR,'(I,S,M,C,P=val,L=val,X,A,EA-D,'
	DEFM	'F=<>val)',_RBR
	DEFB	_CR
	DEFM	'Display File Data, or A',_SEP,'X '
	DEFM	'displays expanded data'
	DEFB	_CR
	DEFM	'Mask Wildcard Chars:  ? * !'
	DEFM	'  :(- indicates exclude)'
	DEFB	_CR
	DEFM	'range = #dn, #dn-, #-dn, #dn-dn ('
	DEFM	'EA-D indicate INDEX field)'
	DEFB	_CR
	DEFM	'I = include INVISIBLE files'
	DEFB	_CR
	DEFM	'S = include SYSTEM files'
	DEFB	_CR
	DEFM	'M = MODIFIED files only'
	DEFB	_CR
	DEFM	'C = CONTINUOUS mode (no pause)'
	DEFB	_CR
	DEFM	'P = PRINT output, '
	DEFM	'val=printed/page, L=val=lines/page'
	DEFB	_CR
	DEFM	'F = locate available free space'
	DEFB	_ETX
;
@TEST	EQU	$
@CHECK	DEFM	'CHECK ',_LBR,'range',_RBR
	DEFM	_LBR,'(F,B,D,R,P)',_RBR
	DEFB	_CR
	DEFM	'TEST ',_LBR,'range',_RBR
	DEFM	_LBR,'(F,B,D,R,P)',_RBR
	DEFB	_CR
	DEFM	'Verify Correct Links On Index Disk#'
	DEFB	_CR
	DEFM	'range = #dn, #dn-, #-dn, #dn-dn'
	DEFB	_CR
	DEFM	'Allowable Parameters:'
	DEFB	_CR
	DEFM	'F = search via FORWARD links'
	DEFB	_CR
	DEFM	'B = search via BACKWARD links'
	DEFB	_CR
	DEFM	'D = DISPLAY errors only, no prompting'
	DEFB	_CR
	DEFM	'R = continuous REPAIR, no prompting'
	DEFB	_CR
	DEFM	'P = dual error output to '
	DEFM	'video and printer'
	DEFB	_ETX
;
@DOS	DEFM	'DOS ',_LBR,'dos command line',_RBR
	DEFB	_CR
	DEFM	'Execute DOS System Command'
	DEFB	_ETX
;
@EDIT	DEFM	'EDIT ',_LBR,'-wildmask',_RBR
	DEFM	_LBR,'#dn',_RBR
	DEFM	_LBR,'(I,S,M,EA-D,F)',_RBR
	DEFB	_CR
	DEFM	'I = include INVISIBLE files'
	DEFB	_CR
	DEFM	'S = include SYSTEM files'
	DEFB	_CR
	DEFM	'M = MODIFIED files only'
	DEFB	_CR
	DEFM	'E = index A-D files only'
	DEFB	_CR
	DEFM	'F = allow entry of full search mask'
	DEFB	_ETX
;
@QUIT	EQU	$
@EXIT	DEFM	'EXIT'
	DEFB	_CR
	DEFM	'QUIT'
	DEFB	_CR
	DEFM	'Close Current Index Record and '
	DEFM	'Return to OpSystem'
	DEFB	_ETX
;
@FIND	DEFM	'FIND ',_LBR,'-wildmask',_RBR
	DEFM	_LBR,'#dn',_RBR
	DEFM	_LBR,'(I,S,EA-D,F,M,N)',_RBR
	DEFB	_CR
	DEFM	'I = include INVISIBLE files'
	DEFB	_CR
	DEFM	'S = include SYSTEM files'
	DEFB	_CR
	DEFM	'M = MODIFIED files only'
	DEFB	_CR
	DEFM	'N = nonstop display mode'
	DEFB	_CR
	DEFM	'E = index A-D files only'
	DEFB	_CR
	DEFM	'F = allow entry of full search mask'
	DEFB	_ETX
;
@FLAGS	DEFM	'FLAGS ',_LBR,'(E)',_RBR
	DEFB	_CR
	DEFM	'Display or EDIT 12 user Flag Names'
	DEFB	_ETX
;
@HELP	DEFB	'HELP ',_LBR,'libword',_RBR
	DEFB	_CR
	DEFM	'Displays Syntax',_SEP,'Summary for '
	DEFM	'Library Command'
	DEFB	_ETX
;
@INIT	DEFM	'INIT ',_LBR,'filespec',_RBR
	DEFM	_LBR,'(O,D=value,N,C',_SEP,'E)',_RBR
	DEFB	_CR
	DEFM	'Initialize index file at filespec'
	DEFB	_CR
	DEFM	'O = OVERWRITE file if pre-exists'
	DEFB	_CR
	DEFM	'D = maximum number of DISKS for file'
	DEFB	_CR
	DEFM	'N = NO prompt for disk space verify'
	DEFB	_CR
	DEFM	'C = create COMPRESSED file'
	DEFB	_CR
	DEFM	'E = create EXPANDED file'
	DEFB	_ETX
;
@KILL	DEFM	'KILL ',_LBR,'-wildmask',_RBR
	DEFM	_LBR,'#dn',_RBR
	DEFM	_LBR,'(I,S,M,EA-D,F,N)',_RBR
	DEFB	_CR
	DEFM	'I = include INVISIBLE files'
	DEFB	_CR
	DEFM	'S = include SYSTEM files'
	DEFB	_CR
	DEFM	'M = MODIFIED files only'
	DEFB	_CR
	DEFM	'E = index A-D files only'
	DEFB	_CR
	DEFM	'F = enter full data mask'
	DEFB	_CR
	DEFM	'N = continuous NONSTOP mode'
	DEFB	_ETX
;
@LIB	DEFM	'LIB'
	DEFB	_CR
	DEFM	'List System Library Command Summary'
	DEFB	_ETX
;
@LOG	DEFM	'LOG ',_LBR,'-wildmask',_RBR
	DEFM	_LBR,':dn',_RBR
	DEFM	_LBR,'(I,S,M,C,F,N)',_RBR
	DEFB	_CR
	DEFM	'Log Contents of Diskette Directory '
	DEFM	'Into Index File'
	DEFB	_CR
	DEFM	'Diskette Must Be OpSystem Readable '
	DEFM	'and Not Previously Logged'
	DEFB	_CR
	DEFM	'Allowable Parameters:'
	DEFB	_CR
	DEFM	'I = include INVISIBLE files'
	DEFB	_CR
	DEFM	'S = include SYSTEM files'
	DEFB	_CR
	DEFM	'M = MODIFIED files only'
	DEFB	_CR
	DEFM	'C = set CONTINUOUS (non-prompting mode)'
	DEFB	_CR
	DEFM	'N = no source disk name',_SEP,'date '
	DEFM	'directory update'
	DEFB	_CR
	DEFM	'F = FORCE previously logged disk '
	DEFM	'to re-log'
	DEFB	_ETX
;
@OPEN	EQU	$
@MOUNT	DEFM	'MOUNT ',_LBR,'filespec',_RBR
	DEFM	_LBR,':dr',_RBR
	DEFB	_CR
	DEFM	'OPEN ',_LBR,'filespec',_RBR
	DEFM	_LBR,':dr',_RBR
	DEFB	_CR
	DEFM	'Opens Specified Index File for Access'
	DEFB	_CR
	DEFM	'Only One Index File May Be Open '
	DEFM	'At A Time'
	DEFB	_ETX
;
@NAME	DEFM	'NAME ',_LBR,'range',_RBR
	DEFM	_LBR,'(T,F=<>val)',_RBR
	DEFB	_CR
	DEFM	'Display Disk(s) Number'
	DEFM	_SEP,'Name',_SEP,'Date'
	DEFB	_CR
	DEFM	'range = #dn, #dn-, #-dn, #dn-dn'
	DEFB	_CR
	DEFM	'T = optional display of disk TYPES'
	DEFB	_CR
	DEFM	'F = optional free space search'
	DEFB	_CR
	DEFM	'    operation can be = < >'
	DEFB	_CR
	DEFM	'    value input is free space '
	DEFM	'in kilobytes'
	DEFB	_ETX
;
@REMOVE	DEFM	'REMOVE ',_LBR,'disknumber',_RBR
	DEFB	_CR
	DEFM	'Deletes all files and disk name/date'
	DEFB	_CR
	DEFM	'Disk and File space de-allocated and'
	DEFB	_CR
	DEFM	'Made available for future files'
	DEFB	_ETX
;
@SCREEN	DEFM	'SCREEN'
	DEFB	_CR
	DEFM	'Re-Display Video and statistics'
	DEFB	_ETX
;
@UPDATE	DEFM	'UPDATE ',_LBR,'-wildmask',_RBR
	DEFM	_LBR,':dn',_RBR
	DEFM	_LBR,'(I,S,M,C,N,E)',_RBR
	DEFB	_CR
	DEFM	'Updates Contents Of '
	DEFM	'Previously Logged Disk'
	DEFB	_CR
	DEFM	'Allowable Parameters:'
	DEFB	_CR
	DEFM	'I = include INVISIBLE files'
	DEFB	_CR
	DEFM	'S = include SYSTEM files'
	DEFB	_CR
	DEFM	'M = MODIFIED files only'
	DEFB	_CR
	DEFM	'C = set CONTINUOUS (non-prompting mode)'
	DEFB	_CR
	DEFM	'N = allow update of non-marked disks'
	DEFB	_CR
	DEFM	'E = set EXACT mode to delete '
	DEFM	'extraneous files'
	DEFB	_ETX
;
@VERSN	DEFM	'VERSION'
	DEFB	_CR
	DEFM	'Displays Program Version Number'
	DEFB	_CR
	DEFM	'Assembly Date, and Number of Patches'
	DEFB	_ETX
;
_______	EQU	$
;
	END	ENTRY
