; diskmane/asm - kjw/bci - overlay handler
;
;	created 08/12/83	- kjw/bci
;	revised 08/12/83	- kjw/bci
;
	PAGE
;
;	$OVRLAY - overlay handler
;
;	ENTRY	A  =	command number/system number
;			7-4 = command number	0=load
;						1-15=exec
;			3-0 = system number	0=invalid
;						1-15=exec
;
;	EXIT	will exit to command mode if non existent
;		else will transfer control to module
;
OVRLAY	LD	SP,(@STACK)	;reset stack
	PUSH	HL		;save registers
	PUSH	DE
	PUSH	BC		;save registers
;
;	save current system command
;
	LD	HL,@CURCMD	;current command
	LD	(HL),A		;save command
	INC	HL		;bump pointer to sys #
;
;	check if requested overlay is loaded
;
	AND	0FH		;get sys #
	CP	(HL)		;already resident?
	LD	(HL),A		;update current overlay
	JR	Z,OVRLAY2	;go if resident
;
	CALL	OVRLAY5		;else load new file
	JP	NZ,SYSERR	;go if disk error!
	LD	(@SYSADD),DE	;save system entry point
;
;	system is loaded or resident, go to it!
;
OVRLAY2	POP	BC		;restore stack
	POP	DE
	LD	HL,(@SYSADD)	;get system entry point
	EX	(SP),HL		;get HL, leave vector
	LD	A,(@CURCMD)	;get system command
	RLCA			;align high bits to low
	RLCA
	RLCA
	RLCA
	AND	0FH		;low 4 bits = command #
	RET			;go overlay!
;
;	locate table entry for file
;
OVRLAY5	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	ADD	A,A		;*16
	ADD	A,12		;offset to data
	LD	E,A		;pass to E
	LD	D,0		;DE = table offset
	LD	HL,SYSTABL	;system I/O table
	ADD	HL,DE		;HL => entry
	LD	DE,@POSIT	;position storage
;
;	move relative sector to posit storage
;
	LD	BC,4		;move 4 bytes rel sector
	LDIR			;move 'em
	EX	DE,HL		;HL => posit storage
;
;	check for existing system
;
	DEC	HL		;relative byte
	LD	A,(HL)		;fetch it
	DEC	HL		;LSB sector
	AND	(HL)		;check
	DEC	HL		;NSB sector
	AND	(HL)		;check
	DEC	HL		;MSB sector
	AND	(HL)		;= FFFFFFFFH?
	INC	A		;yes?
	JP	Z,SYSNOT	;system not available
;
;	position to first sector and read it
;
	LD	DE,SYSFCB	;system FCB
	LD	B,H		;pass rel sector to BC
	LD	C,L		;BC => 3 byte rel sect
	CALL	POSNR		;position to file
	RET	NZ		;system error!
	CALL	READR		;read first record
	RET	NZ		;system error!
;
;	setup pointers to load sub-program
;
	LD	BC,(@POSIT+3)	;get byte offset
	LD	B,0		;BC = offset of first
	LD	HL,SYSBUFF	;system I/O buffer
	ADD	HL,BC		;HL => current byte
;
;	setup loop to load and execute overlay
;
OVRLAY0	CALL	OVRBYTE		;fetch byte
	DEC	A		;01 header code?
	JR	Z,OVRLAY1	;yes, go!
	DEC	A		;02 entry code?
	JR	Z,OVRADDR	;yes, go!
	JR	SYSFMT		;system format error!
;
;	load block
;
OVRLAY1	CALL	OVRADDR		;fetch address
	RET	NZ		;go if disk error
;
OVRLAY3	CALL	OVRBYTE		;fetch byte
	EX	DE,HL		;swap pointers
	XOR	'*'		;correct coding!
	LD	(HL),A		;load data
	CP	(HL)		;still there?
	INC	HL		;bump pointer
	EX	DE,HL		;swap back
	JR	NZ,SYSMEM	;memory error!
	DJNZ	OVRLAY3		;go for block length
	JR	OVRLAY0		;go next block
;
;	fetch 2 byte address + block length
;
OVRADDR	CALL	OVRBYTE		;fetch byte
	SUB	2		;less block length
	LD	B,A		;save length
	CALL	OVRBYTE		;fetch byte
	LD	E,A		;pass LSB
	CALL	OVRBYTE		;fetch byte
	LD	D,A		;pass MSB
	XOR	A		;set NO error
	RET			;done, return Z
;
;	fetch single byte from file
;
OVRBYTE	PUSH	DE		;save
	LD	E,(HL)		;get a byte
	INC	HL		;bump buffer
	INC	C		;bump offset
	JR	NZ,OVRBYOK	;go if OK
;
;	need to read new sector
;
	PUSH	DE		;save DE address
	LD	DE,SYSFCB	;system FCB
	CALL	READR		;read next sector
	POP	DE		;restore DE address
	LD	HL,SYSBUFF	;system I/O buffer
	JR	NZ,SYSERR	;go if disk error
;
OVRBYOK	XOR	A		;set NO error
	LD	A,E		;get data byte
	POP	DE		;restore DE address
	RET			;return OK
;
;	system overlay error vectors
;
SYSFMT	LD	HL,SYSFMTM	;'system file format err'
	JR	SYSDISP		;display error
;
SYSMEM	LD	HL,SYSMEMM	;'memory error'
	JR	SYSDISP		;display error
;
SYSINV	LD	HL,SYSINVM	;'invalid system command'
	JR	SYSDISP		;display error
;
SYSNOT	LD	HL,SYSNOTM	;'system not available'
;
;	display system error code
;
SYSDISP	XOR	A		;set NOT system error
;
SYSERR	LD	DE,SYSMSG	;'system overlay error'
	CALL	DOERR		;display error
;
	LD	HL,SYSMSG1	;'press enter to continue
	CALL	DOLINE		;display text
	CALL	ENKEY		;wait for enter key
;
	LD	A,(@CURCMD)	;get current command
	AND	0FH		;get system number
	DEC	A		;system 1?
	JP	Z,MISERR	;missing interpreter!
	JP	START		;re-enter command mode
;
;	system error text
;
SYSMSG	DEFB	_STX		;cursor header
	DEFB	@VID,00		;row/column cursor
	DEFB	_EREOF		;erase to end of frame
	DEFM	'System Overlay Error - '
	DEFB	_ETX
;
SYSFMTM	DEFM	'File Format Error'
	DEFB	_ETX
;
SYSMEMM	DEFM	'Memory Error'
	DEFB	_ETX
;
SYSINVM	DEFM	'Program Error'
	DEFB	_ETX
;
SYSNOTM	DEFM	'System Overlay Not Available'
	DEFB	_ETX
;
SYSMSG1	DEFB	_CR
	DEFM	'Press <ENTER> to resume command mode:'
	DEFB	_ETX
;
