; diskmanc/asm - kjw/bci - DOS Interfacing
;
;	created 08/11/83	- kjw/bci
;	revised 10/07/83	- kjw/bci
;
	PAGE
;
;	$KBCHAR - scan keyboard for character
;
;	ENTRY	none
;
;	EXIT	Z  =	no character available, A=0
;		NZ =	A = input character
;
KBCHAR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	PUSH	IY		;must save
	PUSH	DE		;must save
	CALL	@KBD		;scan keyboard
	POP	DE		;restore
	POP	IY		;restore
	OR	A		;set flags on result
	RET			;return with char/flags
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	DE		;must save
	LD	A,@KBD		;svc #
	RST	@SVC		;scan keyboard
	POP	DE		;restore
	JR	Z,$+3		;go if have key
	XOR	A		;else remove error code
	OR	A		;set flags on result
	RET			;return with key
	ENDIF
;
	PAGE
;
;	$ENKEY	- scan keyboard, wait for <ENTER> key
;
;	ENTRY	none
;
;	EXIT	<BREAK> pressed = Cy flag
;		<ENTER> pressed = NCy flag
;		Z  =	set
;
ENKEY	LD	A,CURENT	;enter key cursor
	CALL	INKEY0		;wait for key press
	RET	Z		;go if ENTER/BREAK
	JR	ENKEY		;else wait
;
	PAGE
;
;	$INKEY	- scan keyboard, wait for key press
;
;	ENTRY	none
;
;	EXIT	A  =	input key
;		Z  =	BREAK/ENTER pressed
;		Cy =	BREAK pressed
;
;	NOTE:	cursor flashes at current position
;		HL returns with current cursor offset
;
INKEY	LD	A,CURPAGE	;cursor character
;
;	special key editor entry, A  = cursor char
;
INKEY0	PUSH	AF		;save cursor
	CALL	CURADD		;locate cursor address
	POP	AF		;restore cursor
;
;	special key editor entry, HL = video address
;
INKEY1	LD	(CURCHR),A	;update cursor character
INKEYX	PUSH	BC		;save
	PUSH	DE		;save
	CALL	VIDON		;enable video memory
	LD	E,(HL)		;fetch current character
	CALL	VIDOFF		;disable video memory
	LD	D,'$'		;fetch cursor char
CURCHR	EQU	$-1
;
;	change cursor and initialize delay count
;
INKEY2	CALL	VIDON		;enable video memory
	LD	A,E		;fetch normal character
	CP	(HL)		;match with video?
	LD	A,D		;fetch cursor if on
	JR	Z,$+3		;go if char on video
	LD	A,E		;else reset character
	LD	(HL),A		;update video
	CALL	VIDOFF		;disable video
	LD	BC,FDELAY	;set delay factor
;
;	wait for keyboard key, dec flash count
;
INKEY3	CALL	KBCHAR		;scan keyboard
	JR	NZ,INKEY4	;go if we have a key
;
;	check if time for cursor change
;
	DEC	BC		;less flash count
	LD	A,B		;any more?
	OR	C		;BC = 0000?
	JR	NZ,INKEY3	;wait if not time
	JR	INKEY2		;else change cursor
;
;	have a key, restore original char to video
;
INKEY4	PUSH	AF		;save input char
	CALL	VIDON		;enable video memory
	LD	(HL),E		;restore video char
	CALL	VIDOFF		;disable video memory
	POP	AF		;restore input char
	POP	DE		;restore stack
	POP	BC
;
;	set flags on resulting key
;
	CP	_BREAK		;break key?
	SCF			;carry = yes
	RET	Z		;done if yes
	CP	_CR		;enter key?
	SCF			;set carry flag
	CCF			;reset carry flag
	RET			;Z = enter key, else not
;
	PAGE
;
;	$KBLINE	- fetch string from keyboard
;
;	ENTRY	B  =	max length to input
;
;	EXIT	HL =>	string input area
;		A  =	first input character
;		Z  =	no input, ENTER/BREAK only
;
KBLINE	LD	HL,KBBUFF	;keyboard buffer
	PUSH	BC		;save
	PUSH	HL		;save input string
;
;	clear out input area and add CR to string
;
	CALL	FILCLR		;load blanks
	LD	(HL),_CR	;terminate input
	INC	HL		;bump
	LD	(HL),_ETX	;for display
	POP	DE		;restore string start
	POP	BC		;restore length
KBLINE0	CALL	CURADD		;fetch cursor address
;
;	$KBLINE1 - alternate entry to KBLINE
;
;	ENTRY	DE =>	string text buffer
;		B  =	max input length
;		HL =>	video area containing data
;
KBLINE1	LD	A,CUREDIT	;cursor to edit
	LD	(CURCHR),A	;set cursor character
	LD	A,(KEYFLAG)	;get keyboard flag
	RES	1,A		;set NO keys
	LD	(KEYFLAG),A	;update
	LD	C,0		;init cursor location
;
KBLINE2	LD	A,CUREDIT	;editor cursor
	LD	(CURCHR),A	;update cursor
	CALL	INKEYX		;scan keyboard
	JP	Z,KBLINER	;exit on BREAK/ENTER
;
;	setup registers and check for special keys
;
KBLINE3	PUSH	AF		;save input key
	LD	A,CUREDIT	;editor cursor
	LD	(CURCHR),A	;update cursor
	POP	AF		;restore key
	PUSH	IY		;save
	PUSH	HL		;pass HL => IY
	POP	IY		;IY => video
	LD	HL,KBLINE4	;return vector
	PUSH	HL		;to stack
	LD	HL,KBLINET	;special key lookup table
	CALL	GOTABL		;any matching keys?
;
;	not a special key, check if valid keystroke
;
	CP	20H		;control key?
	RET	C		;yes, ignore it
	CP	80H		;non ascii/numeric?
	RET	NC		;yes, ignore it
	LD	HL,KEYFLAG	;keyboard flag
	SET	1,(HL)		;set KEY in buffer
	JR	KEYRCM		;add key to buffer
;
;	return vector for key use
;
KBLINE4	PUSH	IY		;pass video back to HL
	POP	HL		;HL => video
	POP	IY		;restore IY
	JR	KBLINE2		;continue next key
;
;	right arrow with erase of current key
;
KEYRDS	LD	A,' '		;load blank
	JR	KEYRCM		;continue
;
;	right arrow with maintain of current key
;
KEYRHT	LD	A,(DE)		;get current char
;
KEYRCM	CALL	KEYVID		;key to video/buffer
;
;	check if cursor can be moved right
;
MOVRHT	LD	A,B		;get maximum length
	DEC	A		;adjust 0 relative
	CP	C		;at max before end?
	RET	Z		;yes, can't add it
;
	INC	IY		;bump video
	INC	DE		;bump buffer
	INC	C		;bump current length
	OR	A		;clear carry flag
	RET			;done!
;
;	move cursor left with erase
;
KEYLDS	LD	A,' '		;load blank
	JR	KEYLCM		;continue
;
;	move cursor left with cursor preserve
;
KEYLEF	LD	A,(DE)		;get current character
;
KEYLCM	CALL	KEYVID		;key to video
;
MOVLFT	INC	C		;any length
	DEC	C		;C = 0?
	SCF			;carry = yes
	RET	Z		;yes, done!
;
	DEC	C		;length -1
	DEC	IY		;video -1
	DEC	DE		;buffer -1
	OR	A		;clear carry
	RET			;return done
;
;	key delete mode
;
KEYDEL	LD	HL,BUFLFT	;buffer left sub
	JR	KEYINDE		;go common
;
;	key insert mode
;
KEYINS	LD	HL,BUFRHT	;buffer right sub
;
KEYINDE	LD	A,B		;get max length
	DEC	A		;adjust 0 relative
	SUB	C		;less current length
	RET	Z		;at end, can't perform!
;
	LD	(KEYCAL1),HL	;pass subroutine
	LD	(KEYCAL2),HL	;need it twice
;
	PUSH	BC		;save count
	PUSH	DE		;save buffer
	LD	B,A		;save character
	CALL	VIDON		;enable video memory
	PUSH	IY		;pass video to HL
	POP	HL		;HL => video
	CALL	$-$		;shift data
KEYCAL1	EQU	$-2
	EX	DE,HL		;HL => buffer
	CALL	$-$		;shift data
KEYCAL2	EQU	$-2
	CALL	VIDOFF		;disable video
	POP	DE		;restore registers
	POP	BC		;restore
	RET			;done
;
;	move buffer right for insert
;
BUFRHT	PUSH	DE		;save needed
	PUSH	BC		;save length
;
	LD	C,B		;C = length
	LD	B,0		;BC = length
	ADD	HL,BC		;HL => end
	LD	D,H		;pass to DE
	LD	E,L		;DE => end
	DEC	HL		;HL => end -1
	LDDR			;shift data
	LD	A,' '		;load blank
	LD	(DE),A		;to current position
;
	POP	BC		;restore stack
	POP	DE		;restore
	RET			;shifted!
;
;	move buffer left for delete
;
BUFLFT	PUSH	BC		;save needed
	PUSH	DE		;save
;
	LD	C,B		;pass length
	LD	B,0		;BC = length
	LD	D,H		;pass start to DE
	LD	E,L		;DE/HL => start
	INC	HL		;HL => start +1
	LDIR			;move block
	LD	A,' '		;load blank
	LD	(DE),A		;blank to last char
;
	POP	DE		;restore stack
	POP	BC		;restore
	RET			;moved!
;
;	clear to end of frame
;
KEYESC	LD	A,B		;get max length
	SUB	C		;at max?
	RET	Z		;yes, nothing to clear!
;
	PUSH	BC		;save count
	PUSH	DE		;save buffer
	LD	B,A		;pass length
	LD	C,A		;need twice
	CALL	VIDON		;enable video
	PUSH	IY		;pass video to HL
	POP	HL		;HL => video
	CALL	FILCLR		;clear block
	EX	DE,HL		;HL => buffer
	LD	B,C		;reset length
	CALL	FILCLR		;clear block
	CALL	VIDOFF		;disable video
	POP	DE		;restore stack
	POP	BC		;restore
	RET			;done, cleared!
;
;	return vector for keyboard input
;
KBLINER	LD	HL,KBBUFF	;key buffer
	LD	A,0		;get system flag
KEYFLAG	EQU	$-1
	BIT	1,A		;any input?
	LD	A,(HL)		;return with first char
	RET			;return to caller
;
;	fill buffer block for length B @ (HL)
;
FILCLR	LD	(HL),' '	;load blank
	INC	HL		;bump buffer pointer
	DJNZ	FILCLR		;go for length B
	RET			;done!
;
;	load char in A into video and buffer
;
KEYVID	PUSH	BC		;save
	LD	B,A		;pass character
	CALL	VIDON		;enable video memory
	LD	A,B		;get character
	LD	(DE),A		;to buffer
	LD	(IY),A		;to video
	CALL	VIDOFF		;disable video
	POP	BC		;restore BC
	RET			;done!
;
;	keyboard response lookup table for $KBLINE
;
KBLINET	DEFB	_UP		;up arrow
	DEFW	KEYINS		;insert mode
	DEFB	_DOWN		;down arrow
	DEFW	KEYDEL		;delete mode
	DEFB	_LEFT		;left arrow
	DEFW	KEYLEF		;cursor left
	DEFB	_RIGHT		;right arrow
	DEFW	KEYRHT		;cursor right
	DEFB	_SLEFT		;shift left arrow
	DEFW	KEYLDS		;cursor left / erase
	DEFB	_SRIGHT		;shift right arrow
	DEFW	KEYRDS		;cursor right / erase
	DEFB	_CLEAR		;clear key
	DEFW	KEYESC		;erase to end of line
	DEFB	_ETBL		;end of table
;
	PAGE
;
;	enable/disable video memory
;
VIDON	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	RET			;no need
	ENDIF
;
	IF	LDOS4
	PUSH	IY		;save
	LD	A,@FLAGS	;SVC #
	RST	@SVC		;fetch flags
	LD	A,(IY+14)	;get mask
	AND	0FEH		;enable video
	LD	(IY+14),A	;update mask
	OUT	(84H),A		;select!
	POP	IY		;restore
	RET			;done
	ENDIF
;
	IF	LDOS2
	PUSH	IY		;save
	LD	A,@FLAGS	;SVC #
	RST	@SVC		;fetch flags
	LD	A,(IY+'M'-'A')	;get MFLAG$
	OR	80H		;enable video
	LD	(IY+'M'-'A'),A	;update flags
	OUT	(0FFH),A	;enable video
	POP	IY		;restore
	RET			;done
	ENDIF
;
VIDOFF	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	RET			;no need
	ENDIF
;
	IF	LDOS4
	PUSH	IY		;save
	LD	A,@FLAGS	;SVC #
	RST	@SVC		;fetch sys flags
	LD	A,(IY+14)	;get mask
	OR	1		;select
	LD	(IY+14),A	;update mask
	OUT	(84H),A		;de-select!
	POP	IY		;restore
	RET			;done!
	ENDIF
;
	IF	LDOS2
	PUSH	IY		;save
	LD	A,@FLAGS	;SVC #
	RST	@SVC		;fetch sys flags
	LD	A,(IY+'M'-'A')	;get mflag
	AND	7FH		;no video
	LD	(IY+'M'-'A'),A	;update flag
	OUT	(0FFH),A	;de-select!
	POP	IY		;restore
	RET			;done
	ENDIF
;
	PAGE
;
;	$DOCHAR	- character to display
;
;	ENTRY	A  =	character to display
;
;	EXIT	character displayed to video
;
DOCHAR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	PUSH	IY		;must save
	PUSH	DE		;must save
	CALL	@DSP		;display character
	POP	DE		;restore
	POP	IY		;restore
	RET			;done
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	DE		;save
	PUSH	BC		;need to use
	LD	C,A		;pass char
	LD	A,@DSP		;SVC #
	RST	@SVC		;display char
	LD	A,C		;restore char
	POP	BC		;unstack
	POP	DE
	RET			;done!
	ENDIF
;
	PAGE
;
;	$DOLINE	- display string to video
;
;	ENTRY	HL =>	display text
;
;	EXIT	HL =>	last char +1
;
;	NOTE:	special characters allowed
;		03H _ETX = end text and return
;		02H _STX = cursor ROW/COL follows
;
DOLINE	LD	A,(HL)		;fetch character
	INC	HL		;bump string
	CP	_ETX		;end of text?
	RET	Z		;yes, end!
	CP	_STX		;header marker?
	JR	Z,DOLINE1	;go if yes
	CALL	DOCHAR		;display character
	JR	DOLINE		;continue next char
;
;	fetch row/col and set cursor
;
DOLINE1	PUSH	BC		;save
	LD	B,(HL)		;get ROW
	INC	HL		;bump text pointer
	LD	C,(HL)		;get COLUMN
	INC	HL		;bump text pointer
	CALL	PUTCUR		;set cursor
	POP	BC		;restore BC
	JR	DOLINE		;continue
;
	PAGE
;
;	$PRCHAR	- send character to printer
;
;	ENTRY	A  =	character to print
;
;	EXIT	character delivered to printer
;
PRCHAR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	PUSH	IY		;must save
	PUSH	DE		;must save
	CALL	@PRT		;print character
	POP	DE		;restore
	POP	IY		;restore
	RET			;done
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	DE		;save from dos
	PUSH	BC		;save from us
	LD	C,A		;pass char
	LD	A,@PRT		;SVC #
	RST	@SVC		;print char
	LD	A,C		;restore char
	POP	BC		;restore
	POP	DE
	RET			;done
	ENDIF
;
	PAGE
;
;	$PRLINE	- display string to printer
;
;	ENTRY	HL =>	text to print
;
;	EXIT	HL =>	last char printed +1
;			text terminates with 03H _ETX
;
PRLINE	LD	A,(HL)		;get text char
	INC	HL		;bump pointer
	CP	_ETX		;end of text?
	RET	Z		;yes, done!
	CALL	PRCHAR		;else send character
	JR	PRLINE		;go next character
;
	PAGE
;
;	$PUTCUR	- load cursor with row/column
;
;	ENTRY	B  =	video row desired
;		C  =	video column desired
;
;	EXIT	cursor updated to new location
;
PUTCUR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	PUSH	HL		;save from math
	LD	L,B		;fetch row
	LD	H,0		;HL = row
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,HL		;*8
	ADD	HL,HL		;*16
	ADD	HL,HL		;*32
	ADD	HL,HL		;*64
	LD	A,L		;fetch LSB
	ADD	A,C		;add column
	LD	L,A		;HL = rows*64 + column
	LD	A,H		;fetch MSB
	ADD	A,@VIDEO<-8	;add msb video offset
	LD	H,A		;HL = new cursor address
	LD	(@CURSOR),HL	;update video cursor
	POP	HL		;restore HL
	RET			;done!
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	BC		;save 'em all
	PUSH	DE
	PUSH	HL
	LD	H,B		;pass row
	LD	L,C		;pass column
	LD	B,3		;dos command
	LD	A,@VDCTL	;SVC #
	RST	@SVC		;set cursor!
	POP	HL		;restore all
	POP	DE
	POP	BC
	RET			;done
	ENDIF
;
	PAGE
;
;	$CURADD	- fetch cursor address offset
;
;	ENTRY	none
;
;	EXIT	HL =>	current offset of cursor in video
;
CURADD	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	LD	HL,(@CURSOR)	;fetch cursor
	RET			;done
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	DE		;save
	PUSH	BC		;save
	LD	B,4		;dos command
	LD	A,@VDCTL	;SVC #
	RST	@SVC		;fetch cursor into HL
	PUSH	HL		;save row/col
	LD	L,H		;pass row
	LD	H,0		;init nsb
	LD	B,H		;init msb
	LD	C,@COLS		;# video columns
	CALL	MULT		;ABHL = BHL*A
	POP	BC		;C = column
	LD	B,A		;BC = column
	ADD	HL,BC		;HL = video offset
	LD	BC,@VIDEO	;start video memory
	ADD	HL,BC		;HL => current cursor
	POP	BC		;restore
	POP	DE
	RET			;done
	ENDIF
;
	PAGE
;
;	$MSIZE	- fetch high free memory address
;
;	ENTRY	HL =	0=get high, <>0=put high
;
;	EXIT	HL =	highest free address available
;
MSIZE	LD	A,H		;check if get/put
	OR	L		;HL = 0000?
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JR	Z,MSIZE1	;go if GET
	LD	(@HIGH$),HL	;else PUT
MSIZE1	LD	HL,(@HIGH$)	;fetch high memory
	RET			;done
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	BC		;save
	LD	B,0		;set HIGH$
	LD	A,@HIGH$	;SVC #
	RST	@SVC		;get/put high memory
	POP	BC		;restore
	RET			;done
	ENDIF
;
	PAGE
;
;	$DATE	- fetch system date
;
;	ENTRY	HL =>	8 byte buffer to hold string
;
;	EXIT	buffer loaded with format MM/DD/YY
;
DATE	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@DATE		;fetch system date
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	BC		;save from dos
	PUSH	DE
	LD	A,@DATE		;SVC#
	RST	@SVC		;load date$
	POP	DE		;restore
	POP	BC
	RET			;HL => date$
	ENDIF
;
	PAGE
;
;	$ERROR	- display system error code
;
;	ENTRY	A  =	dos error code
;
;	EXIT	error code displayed to video
;
ERROR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	OR	11000000B	;short msg + return
	JP	@ERROR		;display and return
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	BC		;save from dos
	OR	11000000B	;short msg + return
	LD	C,A		;pass error code
	LD	A,@ERROR	;SVC #
	RST	@SVC		;display message
	POP	BC		;restore
	RET			;done
	ENDIF
;
	PAGE
;
;	misc. dos file handling routines
;
;	$FSPEC	- extract filespec from string
;
;	ENTRY	HL =>	string to evaluate
;		DE =>	FCB to hold filename
;
;	EXIT	NZ =	invalid filespec characters
;		Z  =	filespec loaded
;		HL =>	terminating character
;		DE =>	filespec
;
FSPEC	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@FSPEC		;evaluate filespec
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@FSPEC	;evaluate filespec
	RST	@SVC		;execute
	RET			;return status
	ENDIF
;
	PAGE
;
;	$INIT	- open/create file
;
;	ENTRY	DE =>	filespec to open
;		HL =>	256 byte I/O buffer
;		B  =	logical record length
;		C  =	'R' or 'W' for read/write access
;
;	EXIT	Z  =	OK, A=0, file is open
;		NZ =	A = dos error code
;
INIT	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@INIT		;open/create file
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@INIT		;SVC #
	RST	@SVC		;open file
	RET			;return status
	ENDIF
;
	PAGE
;
;	$OPEN	- open existing file
;
;	ENTRY	DE =>	filespec to open
;		HL =>	256 byte I/O buffer
;		B  =	logical record length
;		C  =	'R' or 'W' for read/write access
;
OPEN	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@OPEN		;open existing file
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@OPEN		;SVC #
	RST	@SVC		;open file
	RET			;return status
	ENDIF
;
	PAGE
;
;	$REWIND	- rewind file to beginning
;
;	ENTRY	DE =>	FCB
;
;	EXIT	Z  =	OK, file rewound
;		NZ =	A = error code
REWIND	EQU	$
;
	PUSH	BC		;save
	LD	BC,ZEROES	;3 bytes of 00
	CALL	POSN		;position to first record
	POP	BC		;restore
	RET			;return with status
;
ZEROES	DEFB	0,0,0		;for file rewind
;
	PAGE
;
;	$POSN	- position file to logical record #
;
;	ENTRY	DE =>	open FCB
;		BC =>	3 byte requested record #
;
;	EXIT	Z  =	OK, file positioned
;		NZ =	A = dos error code
;
POSN	EQU	$
;
;	memory buffer control
;
	PUSH	BC		;save
	PUSH	DE		;save
	PUSH	HL		;save
	LD	D,B		;get address
	LD	E,C		;DE => current record
	LD	HL,BUFTBL+2	;start buffer table
	SET	6,(HL)		;set posit NOT valid
	INC	HL		;bump to +3
	EX	DE,HL		;HL=>curr rec, DE=>table
	LD	BC,3		;3 bytes
	LDIR
	POP	HL		;restore
	POP	DE		;restore
	POP	BC		;restore
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	LD	H,B		;pass pointer to HL
	LD	L,C		;HL => 3 byte record
	LD	A,(HL)		;get msb
	OR	A		;>65536?
	JR	NZ,OUTRNG	;yes, out of range
	INC	HL		;ignore MSB this dos
	LD	B,(HL)		;get NSB
	INC	HL		;bump pointer
	LD	C,(HL)		;get LSB
	CALL	@POSN		;position file
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	H,B		;pass pointer to HL
	LD	L,C		;HL => 3 byte record
	LD	A,(HL)		;get msb
	OR	A		;>65536?
	JR	NZ,OUTRNG	;yes, out of dos range!
	INC	HL		;ignore msb this dos
	LD	B,(HL)		;get nsb
	INC	HL		;bump pointer
	LD	C,(HL)		;get lsb
	LD	A,@POSN		;SVC#
	RST	@SVC		;position file
	ENDIF
;
	RET	NZ		;go if any error
	LD	A,(BUFTBL+2)	;get flags
	RES	6,A		;set NO error
	LD	(BUFTBL+2),A	;update flags
	XOR	A		;set NO error
	RET			;done!
;
POSNR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	LD	H,B		;pass pointer
	LD	L,C		;HL => record
	LD	A,(HL)		;get msb
	OR	A		;>65535?
	JR	NZ,OUTRNG	;yes, out of range!
	INC	HL		;ignore msb
	LD	B,(HL)		;get nsb
	INC	HL		;bump
	LD	C,(HL)		;get lsb
	JP	@POSN		;position file
OUTRNG	LD	A,1DH		;out of range
	OR	A		;set NZ
	RET			;done!
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	H,B		;pass pointer
	LD	L,C		;HL => record #
	LD	A,(HL)		;get msb
	OR	A		;>65535?
	JR	NZ,OUTRNG	;yes, out of dos range
	INC	HL		;ignore msb
	LD	B,(HL)		;get nsb
	INC	HL		;bump
	LD	C,(HL)		;get lsb
	LD	A,@POSN		;SVC#
	RST	@SVC		;position file
	RET			;return with status
OUTRNG	LD	A,1DH		;record out of range
	OR	A		;set NZ
	RET			;return in error
	ENDIF
;
	PAGE
;
;	$LEOF	- locate end of file
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, BHL = EOF sector
;		NZ =	A = error code
;
LEOF	EQU	$
;
	IF	LDOS1.OR.LDOS3
	CALL	@LOF		;get last record in BC
	LD	L,C		;pass to HL
	LD	H,B
	LD	B,0		;BHL = sector #
	RET			;done
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@LOF		;SVC #
	RST	@SVC		;get last record in BC
	LD	L,C		;pass to HL
	LD	H,B		;HL = record
	LD	B,0		;BHL = record #
	RET			;done
	ENDIF
;
	IF	MDOS1.OR.MDOS3
	PUSH	IX		;save
	PUSH	DE		;pass to IX
	POP	IX		;IX => FCB
	CALL	@LOF		;get last record in HL
	LD	B,0		;init msb
	POP	IX		;restore
	RET			;done
	ENDIF
;
	PAGE
;
;	$GET	- get char from device
;
;	ENTRY	DE =>	open FCB/DCB
;
;	EXIT	Z  =	OK, A=input char
;		NZ =	A=error code
;
GET	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@GET		;get character
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@GET		;get character
	RST	@SVC		;from dos
	RET			;return with A=char
	ENDIF
;
	PAGE
;
;	$PUT	- write character to device
;
;	ENTRY	DE =>	open FCB/DCB
;		A  =	character
;
;	EXIT	Z  =	OK
;		NZ =	A = error code
;
PUT	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@PUT		;write to device
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	PUSH	BC		;save from us
	LD	C,A		;pass char
	LD	A,@PUT		;SVC#
	RST	@SVC		;put char
	POP	BC		;restore BC
	RET			;return with status
	ENDIF
;
	PAGE
;
;	$READ	- read logical record #
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, I/O buffer loaded with record
;		NZ =	A = dos error code
;
READ	EQU	$
;
	PUSH	HL		;save
	CALL	CKBUFF		;check if in buffer
	JR	NZ,MSTREAD	;nope, must read it
	PUSH	DE		;save
	PUSH	BC		;save
	LD	DE,(@IOBUFF)	;I/O buffer
	LD	BC,100H		;buffer length
	LDIR			;fill I/O buffer
	POP	BC		;restore
	POP	DE
	POP	HL
	XOR	A		;set NO error
	RET			;done!
;
MSTREAD	POP	HL		;restore stack
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	CALL	@READ		;read record
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@READ		;SVC#
	RST	@SVC		;read the record
	ENDIF
;
	RET	NZ		;go on error
	JP	ADDBUFF		;else add to mem buffer
;
READR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@READ		;read record
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@READ		;SVC #
	RST	@SVC		;read record
	RET			;return with status
	ENDIF
;
	PAGE
;
;	$WRITE	- write logical record #
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, I/O buffer written to file
;		NZ =	A = dos error code
;
WRITE	EQU	$
;
	PUSH	HL		;save
	CALL	CKBUFF		;check if buffer loaded
	JR	NZ,JSTWRIT	;nope continue
;
	PUSH	DE		;save
	PUSH	BC		;save
	EX	DE,HL		;swap
	LD	HL,(@IOBUFF)	;start I/O buffers
	LD	BC,100H		;length
	LDIR			;update mem buffer
	POP	BC
	POP	DE
;
JSTWRIT	POP	HL		;restore
;
WRITER	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@WRITE		;write record
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@WRITE	;SVC #
	RST	@SVC		;write record
	RET			;return with status
	ENDIF
;
	PAGE
;
;	$CLOSE	- close file control block
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, file closed, DE => filespec
;		NZ =	A = dos error code
;
CLOSE	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@CLOSE		;close file for I/O
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@CLOSE	;SVC #
	RST	@SVC		;close file
	RET			;return with status
	ENDIF
;
	PAGE
;
;	$KILL	- delete file
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, file deleted, DE => filespec
;		NZ =	A = dos error code
;
KILL	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@KILL		;delete file
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@KILL		;SVC#
	RST	@SVC		;delete file
	RET			;return with status
	ENDIF
;
	PAGE
;
;	misc. direct disk I/O subroutines
;
;	$DSIZE	- fetch diskette type parameters
;
;	ENTRY	C  =	drive number
;
;	EXIT	B  =	misc. flags
;			7 = 1=rigid drive, 0=floppy
;			6 = 1=double density, 0=single
;			5 = 1=double sided, 0=single
;			4 = 1=8" drive, 0=5"
;			3-0 = unused
;		C  =	drive # (unchanged)
;		D  =	directory cylinder
;		E  =	# sectors in directory
;		HL =	cylinder count
;
DSIZE	EQU	$
;
	IF	LDOS1.OR.LDOS3
	PUSH	IY		;must save
	CALL	@GETDCT		;get drive data
	ENDIF
	IF	LDOS4.OR.LDOS2
	PUSH	IY
	LD	A,@GETDCT	;SVC #
	RST	@SVC		;fetch drive data
	ENDIF
;
	IF	LDOS1.OR.LDOS3.OR.LDOS4
	LD	D,(IY+9)	;fetch directory cylinder
;
	LD	A,(IY+7)	;get drive data
	AND	1FH		;highest # sector
	INC	A		;sector count
	BIT	3,(IY+3)	;rigid?
	JR	NZ,SKP0		;yes, ignore
	BIT	5,(IY+4)	;double sided?
	JR	Z,SKP0		;nope, ignore
	ADD	A,A		;double sector count
SKP0	CP	35		;34 max sectors in direct
	JR	C,$+4		;go if less
	LD	A,34		;else set maximum
	LD	E,A		;E = # sectors directory
;
	LD	L,(IY+6)	;get highest cylinder
	LD	H,0		;HL = highest cylinder
	INC	HL		;HL = cylinder count
	BIT	3,(IY+3)	;rigid drive?
	JR	Z,SKP0A		;go if not
	BIT	5,(IY+4)	;double count?
	JR	Z,SKP0A		;go if not
	ADD	HL,HL		;else double cylinder cnt
;
SKP0A	LD	B,0		;init flags
	BIT	3,(IY+3)	;rigid drive?
	JR	Z,$+4		;go if not
	SET	7,B		;else flag rigid drive
	BIT	6,(IY+3)	;double density?
	JR	Z,$+4		;go if not
	SET	6,B		;else set double flag
	BIT	7,B		;rigid drive?
	JR	NZ,$+10		;go if yes
	BIT	5,(IY+4)	;2 sides?
	JR	Z,$+4		;go if not
	SET	5,B		;else set double bit
	BIT	5,(IY+3)	;drive size?
	JR	Z,$+4		;go if 5"
	SET	4,B		;else set 8" bit
	POP	IY		;restore IY
	RET			;completed!
	ENDIF
;
	IF	MDOS1.OR.MDOS3
	LD	HL,@GETDCT	;DCT byte
	LD	B,0		;init flags
	BIT	4,(HL)		;double sided?
	JR	Z,$+4		;go if not
	SET	5,B		;set double
	BIT	7,(HL)		;double density?
	JR	Z,$+4		;go if not
	SET	6,B		;set double
	LD	A,10		;# sectors/cyl single den
	BIT	7,(HL)		;single?
	JR	Z,DSIZ0		;go if yes
	BIT	3,(HL)		;P density?
	JR	NZ,DSIZ0	;go if yes
	LD	A,18		;else 18 secs/cyl
DSIZ0	BIT	5,B		;double sided?
	JR	Z,$+3		;go if not
	ADD	A,A		;else double count
	CP	35		;less than 35?
	JR	C,$+4		;go if in range
	LD	A,34		;else maximum size
	LD	E,A		;# secs in dir
	LD	D,0		;dir cylinder unknown
	LD	HL,255		;set dummy cyl count
	XOR	A		;set OK
	RET			;done
	ENDIF
;
	PAGE
;
;	$DFREE - fetch disk free space to DE
;
DFREE	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.LDOS4.OR.LDOS2
	PUSH	BC		;save
	PUSH	HL		;save
	LD	HL,FREBUF	;free space buffer
	LD	B,4		;dos command
	CALL	GETFREE		;get free space
	LD	DE,18		;offset to free K
	ADD	HL,DE		;HL => free K
	LD	E,(HL)		;get lsb
	INC	HL		;bump
	LD	D,(HL)		;DE = free space
	POP	HL		;unstack
	POP	BC
	RET			;done
	ENDIF
;
	IF	LDOS1.OR.LDOS3
GETFREE	JP	@DODIR		;get dir info
	ENDIF
;
	IF	LDOS4.OR.LDOS2
GETFREE	LD	A,@DODIR	;SVC #
	RST	@SVC		;get dir info
	RET			;return with it
	ENDIF
;
	IF	MDOS1.OR.MDOS3
	LD	DE,0FFFFH	;cannot determine!
	RET			;return with it
	ENDIF
;
	PAGE
;
;	$GETDCT	- locate drive control table
;
;	ENTRY	C  =	drive #
;
;	EXIT	IY =>	DCT
;		BC =	DCT length
;
GETDCT	EQU	$
;
	IF	LDOS1.OR.LDOS3
	CALL	@GETDCT		;get code table
	LD	BC,10		;table length
	RET			;done
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@GETDCT	;get code table
	RST	@SVC		;from dos
	LD	BC,10		;table length
	RET			;done
	ENDIF
;
	PAGE
;
;	$CKDRV	- check if drive ready for I/O
;
;	ENTRY	C  =	drive # to check
;
;	EXIT	Z  =	OK, drive ready and mounted
;		NZ =	A = dos error code
;
CKDRV	EQU	$
;
	IF	LDOS1.OR.LDOS3
	CALL	@CKDRV		;check drive ready
	LD	A,0		;set no error
	RET	Z		;go if OK
	LD	A,8		;else modify error code
	RET			;return with it
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@CKDRV	;SVC #
	RST	@SVC		;check drive ready
	LD	A,0		;set no error
	RET	Z		;go if OK
	LD	A,8		;else modify error code
	RET			;return with status
	ENDIF
;
	IF	MDOS1.OR.MDOS3
	XOR	A		;not available
	RET			;set NO error
	ENDIF
;
	PAGE
;
;	$RDDIR	- read diskette directory
;
;	ENTRY	C  =	drive # to read
;		E  =	sector in directory to read
;		HL =>	256 byte I/O buffer
;
;	EXIT	Z  =	OK, I/O buffer loaded
;		NZ =	A = dos error code
;		D  =	actual directory cylinder
;
RDDIR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@RDSSEC		;read system sector
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@RDSSEC	;SVC #
	RST	@SVC		;read sector
	RET			;return with status
	ENDIF
;
	PAGE
;
;	$WRDIR	- write directory record
;
;	ENTRY	C  =	drive # to write to
;		D  =	directory cylinder
;		E  =	sector to write
;		HL =>	256 byte I/O buffer
;
;	EXIT	Z  =	OK, sector written
;		NZ =	A = dos error code
;
WRDIR	EQU	$
;
	IF	LDOS1.OR.LDOS3.OR.MDOS1.OR.MDOS3
	JP	@WRPROT		;write protected sector
	ENDIF
;
	IF	LDOS4.OR.LDOS2
	LD	A,@WRPROT	;SVC #
	RST	@SVC		;write sector
	RET			;return with status
	ENDIF
;
;	check if relative sector loaded
;
CKBUFF	PUSH	IY		;save
	LD	IY,BUFTBL	;buffer table
	BIT	7,(IY+2)	;available?
	JR	Z,CKBUFN	;nope, set not loaded
	LD	A,(IY+1)	;# used
	OR	A		;zero?
	JR	Z,CKBUFN	;yes, set not loaded
;
	PUSH	BC		;save
	PUSH	DE
	LD	B,(IY+3)	;get current posit
	LD	H,(IY+4)
	LD	L,(IY+5)
CKBUF1	EX	AF,AF'		;save count
	LD	C,(IY+6)	;get start entry
	LD	D,(IY+7)
	LD	E,(IY+8)
	CALL	$CMP24		;compare
	JR	Z,CKBUF2	;found, go!
	LD	DE,5		;offset to next
	ADD	IY,DE		;DE => next entry
	EX	AF,AF'		;get count
	DEC	A		;less this pass
	JR	NZ,CKBUF1	;go for count
	POP	DE		;restore
	POP	BC		;restore
;
CKBUFN	OR	-1		;set NOT found
	POP	IY		;restore
	RET			;done!
;
CKBUF2	LD	L,(IY+9)	;get buffer address
	LD	H,(IY+10)
	POP	DE		;restore
	POP	BC
;
CKBUFY	XOR	A		;set FOUND
	POP	IY		;restore
	RET			;done!
;
;	add to memory buffer
;
ADDBUFF	PUSH	IY		;save
	LD	IY,BUFTBL	;buffer table
	BIT	7,(IY+2)	;function available?
	JR	Z,ADDBUFR	;nope, return
	BIT	6,(IY+2)	;posit valid?
	JR	NZ,ADDBUFR	;nope, go!
	LD	A,(IY+0)	;get # available
	SUB	(IY+1)		;less # used
	LD	A,(IY+2)	;get flags
	JR	Z,ADDBUFE	;table full!
	INC	(IY+1)		;bump # used
;
ADDBUFE	CALL	MOVBUF		;move buffer
ADDBUFR	POP	IY		;restore
	XOR	A		;set NO error
	RET			;done!
;
;	move I/O buffer to memory buffer
;
MOVBUF	PUSH	BC		;save
	PUSH	DE
	PUSH	HL
	PUSH	IY
;
	LD	B,A		;save original byte
	AND	3FH		;get current posit
	LD	D,A		;= I/O buffer offset
	INC	A		;bump to next
	LD	HL,BUFTBL	;max count
	CP	(HL)		;test
	JR	C,$+3		;go if not
	XOR	A		;reset to start
	LD	C,A		;save next buffer
	LD	A,B		;get original
	AND	0C0H		;keep high 2 only
	OR	C		;+ next buffer
	LD	(IY+2),A	;update posit
;
;	update table entry
;
	PUSH	DE		;save offset
	LD	A,D		;get table offset
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,D		;*5
	LD	HL,BUFTBL+6	;offset first entry
	LD	E,A		;pass lsb offset
	LD	D,0		;DE = offset
	ADD	HL,DE		;HL => table data
	EX	DE,HL		;DE => table data
	LD	HL,BUFTBL+3	;current file posit
	LDI			;move 3 bytes
	LDI
	LDI
	PUSH	DE		;pass to IY
	POP	IY		;IY => current entry
	POP	DE		;restore offset
	LD	E,0		;DE = buffer offset
	LD	HL,BUFFS	;start of buffers
	ADD	HL,DE		;HL => buffer
	LD	(IY+0),L	;load lsb address
	LD	(IY+1),H	;load msb address
	EX	DE,HL		;DE => mem buffer
	LD	HL,(@IOBUFF)	;I/O buffer
	LD	BC,100H		;buffer length
	LDIR			;move it
;
	POP	IY		;unstack
	POP	HL
	POP	DE
	POP	BC
	RET			;done
;
FREBUF	DEFM	'.....................'
;
