; log/asm - disk logger for LDOS - kjw/bqsd - 04/83
;
; created 04/19/83 - kjw/bqsd
; revised 04/19/83 - kjw/bqsd
;
;	system equates
;
_ETX	EQU	03H		;end of text
_CR	EQU	0DH		;carriage return
;
_SEP1	EQU	' '		;command separator
_SEP2	EQU	','		;command separator
_TERM1	EQU	_CR		;command terminator
_TERM2	EQU	_ETX		;command terminator
_DIRERR	EQU	06H		;directory read error
;
;	dos equates
;
_DIR	EQU	9		;DCT dir offset
_CYLS	EQU	6		;DCT cylinders offset
_SECS	EQU	7		;DCT sectors offset
_FLAG1	EQU	3		;DCT flags #1
_FLAG2	EQU	4		;DCT flags #2
_FLAG3	EQU	8		;DCT flags #3
_DEN	EQU	6		;DCT density bit
_SID	EQU	5		;DCT sides bit
_CYLOFF	EQU	0CCH		;dir offset to cyl count
_CYLDSP	EQU	35		;dir cyl displacement
;
$CODE	EQU	5200H		;program code origin
$ROMID	EQU	0125H		;ROM ID address
$MOD3	EQU	'I'		;mod III identifier
;
@LOCDCT	EQU	478FH		;locate DCT block
@DREAD	EQU	4777H		;read data sector
@SREAD	EQU	4B45H		;read system sector
@ERROR	EQU	4409H		;display error message
@DIVE1	EQU	4B7BH		;divide mod I
@DIVE3	EQU	4B7AH		;divide mod III
@VDLINE	EQU	4467H		;display string to video
@KBLINE	EQU	0040H		;fetch input string
	ORG	$CODE
;
$ENTRY	PUSH	HL		;save input pointer
	LD	HL,$EXIT	;program exit vector
	EX	(SP),HL		;leave it, get HL back
PARSE	DEC	HL		;adjust for poshl
;
;	parse input command line
;
POSHL	INC	HL		;bump input pointer
	LD	A,(HL)		;fetch input char
	CP	_SEP1		;separator?
	JR	Z,POSHL		;ignore if yes
	CP	_SEP2		;separator?
	JR	Z,POSHL		;ignore if yes
	CP	_TERM1		;terminator?
	JP	Z,PROMPT	;yes, prompt for input
	CP	_TERM2		;terminator?
	JP	Z,PROMPT	;yes, prompt
;
;	must be drive number
;
	CP	':'		;drive indicator?
	JR	NZ,$+3		;go if not
	INC	HL		;else bump past colon
	LD	A,(HL)		;get drive #
	SUB	'0'		;remove ascii
	JP	C,INVAL		;invalid go!
	CP	8		;0-7?
	JP	NC,INVAL	;go if out of range
;
;	have drive #
;
	LD	C,A		;pass drive #
	CALL	@LOCDCT		;locate DCT address
;
;	read boot to locate directory
;
	LD	DE,0<8+0	;track 0, sector 0
	LD	HL,IOBUFF	;I/O buffer
	CALL	@DREAD		;read data sector
	RET	NZ		;go if any error
;
;	fetch 3'rd byte in sector to log dir cyl
;
	PUSH	HL		;save I/O buffer
	INC	HL		;+1
	INC	HL		;+2
	LD	A,(HL)		;get directory track
	POP	HL		;restore HL
;
;	assure that it could be a valid directory cyl #
;
	OR	A		;cyl zero?
	JP	Z,CANNOT	;cannot log!
	CP	200		;0-199?
	JP	NC,CANNOT	;cannot log!
;
;	update directory cylinder in DCT
;
	LD	(IY+_DIR),A	;load DCT
;
;	read first sector of directory for density/sides
;
	LD	D,A		;pass dir cylinder
	CALL	@DREAD		;read system sector
	JR	Z,DIROK		;go if no error
	CP	_DIRERR		;directory read?
	RET	NZ		;go if not
;
;	point to offset in dir for data / fetch cyl count
;
DIROK	LD	DE,_CYLOFF	;offset to cylinder count
	ADD	HL,DE		;HL => # cylinders
	LD	A,(HL)		;fetch cylinder count
	ADD	A,_CYLDSP	;adjust to physical cyls
	DEC	A		;highest number cylinder
	LD	(IY+_CYLS),A	;update DCT
;
;	fetch density/sides/grans*cyls
;
	INC	HL		;point to flags
	LD	A,(HL)		;fetch flags
;
;	check DENSITY
;
	RES	_DEN,(IY+_FLAG1) ;set SINGLE density
	BIT	_DEN,A		;double density?
	JR	Z,$+6		;go if single
	SET	_DEN,(IY+_FLAG1) ;set DOUBLE density
;
;	check SIDES
;
	RES	_SID,(IY+_FLAG2) ;set SINGLE sided
	BIT	_SID,A		;single sided?
	JR	Z,$+6		;go if single
	SET	_SID,(IY+_FLAG2) ;set DOUBLE sided
;
;	check GRANS/CYLINDER
;
	AND	00000111B	;low 3 bits only
	INC	A		;A = grans/cylinder
	LD	D,A		;pass value
	DEC	A		;adjust back
	RRCA			;align to high bits
	RRCA
	RRCA
	AND	11100000B	;keep high 3 only
	LD	B,A		;save it here
;
;	set SECTORS/GRAN
;
	LD	A,(IY+_SECS)	;get highest sector
	AND	00011111B	;low 5 bits only
	INC	A		;adjust to actual
	BIT	_SID,(IY+_FLAG2) ;2 sides
	JR	Z,$+3		;go if single
	ADD	A,A		;adjust to twice
	LD	E,A		;E = # secs / cylinder
	LD	A,D		;get grans / cylinder
	CALL	@DIVEA		;8 bit divide
	DEC	A		;adjust to 0 relative
	OR	B		;combine with g/t
	LD	(IY+_FLAG3),A	;update flags
;
;	completed, read sys sector to log it in
;
	LD	E,0		;sector zero
	CALL	@SREAD		;read system sector
	RET			;done, exit
;
;	program exit vector
;
$EXIT	OR	A		;check for errors
	RET	Z		;exit back to dos
	OR	11000000B	;return + short message
	CALL	@ERROR		;display error
	XOR	A		;now return Z
	RET			;done!
;
;	divide E/A
;
@DIVEA	PUSH	HL		;save it
	PUSH	AF		;save divide factor
	LD	A,($ROMID)	;read rom ID address
	CP	$MOD3		;mod III?
	LD	HL,@DIVE3	;vector mod III
	JR	Z,$+5		;go if yes
	LD	HL,@DIVE1	;vector mod I
	POP	AF		;restore AF
	EX	(SP),HL		;get HL, leave vector
	RET			;go vector!
;
;	prompt for user input
;
PROMPT	LD	HL,PTEXT	;prompt text
	CALL	@VDLINE		;display prompt
	LD	HL,IOBUFF	;use I/O buffer
	LD	B,3		;3 chars max
	CALL	@KBLINE		;get user input
	LD	A,0		;set no error
	RET	C		;abort on break
	JP	PARSE		;parse command
;
;	invalid command
;
INVAL	LD	HL,ITEXT	;invalid text
	CALL	@VDLINE		;display error
	XOR	A		;return no error
	RET			;done, exit to dos
;
;	cannot log disk
;
CANNOT	LD	HL,CTEXT	;cannot text
	CALL	@VDLINE		;display error
	XOR	A		;return no error
	RET			;done, exit dos
;
;	text block
;
PTEXT	DEFM	'*'		;prompt char
	DEFB	_ETX
;
ITEXT	DEFM	'Invalid Command'
	DEFB	_CR
	DEFB	_ETX
;
CTEXT	DEFM	'Cannot Log Disk'
	DEFB	_CR
	DEFB	_ETX
;
IOBUFF	EQU	$
;
	END	$ENTRY
