DATECO ;DATECOMP/ASM
 ;A date compression program for Z-80 based microcomputers.
 ;
 ;Written By: Darren R. Besler
 ;Date:       March 21, 1985
 ;
 ;This program/subroutine compresses a 6 byte ASCII date
 ;field into a 2 byte integer.  This program is a spin off
 ;of the BASIC program written by John Allison which was
 ;published in the March 9, 1985 issue of 'THE WINNIPEG
 ;MICRO-80 USERS GROUP NEWSLETTER'.
 ;
 ;The ptr to the date is passed in the HL register, and the
 ;compressed date is returned in the HL register. All other
 ;registers are preserved by this subroutine.  Very little
 ;error checking is done and NO error check should be
 ;assumed.
 ;
 ;The date format accepted is as follows: 'MMDDYY', where
 ;M,D, and Y are the ASCII representation of the digits in
 ;the date.
 ;
 ;The date is encoded as follows:
 ;                 YY    MM    DD
 ;              xxxxxxx xxxx xxxxx
 ;             @ <- 16 bits ->    @
 ;An eg.    March 19, 1985 ('031985') will result in the
 ;following word:
 ;          1010101001110011 = 0AA73H = 43537D
 ;This results in an unsigned integer. This could allow for
 ;a very quick sort on a date field along with the space
 ;reduction.
 ;
 	ORG	5200H
 ;
 DTCOMP	PUSH	AF	;Save registers on the stack
 	PUSH	BC
 	PUSH	IX
 	PUSH	HL	;Place ptr to date string into IX
 	POP	IX
 ;
 ;Get year field.
 YY	LD	A,(IX+04H) ;Get 1st character in the year
 	SUB	30H	;Make it an integer
 	CALL	MUL10	;Multiply by ten
 	LD	C,A	;Save in 'C' register
 	LD	A,(IX+05H) ;Get second character of date
 	SUB	30H	;and make into an integer
 	ADD	A,C	;add together
 	SLA	A	;Shift into position
 	LD	H,A	;Place year into 'H' register
 ;
 ;Get Month field.
 MM	LD	A,(IX+00H) ;Get 1st character of Month
 	SUB	30H	;Make it an integer
 	CALL	MUL10	;Multiply by ten
 	LD	C,A	;Save in 'C' register
 	LD	A,(IX+01H) ;Get 2nd char of month field
 	SUB	30H	;Change into an integer
 	ADD	A,C	;and add together
 	BIT	3,A	;Check if Month hi order bit set
 	JR	Z,HI0	;If not - ignore, else
 	SET	0,H	;Set Hi order bit of Month in 'H'
 HI0	RRCA		;Place 3 least significant bits
 	RRCA		;  into 3 hi order bits
 	RRCA
 	AND	0E0H	;Mask off 5 least sig bits
 	LD	L,A	;And place Month into 'L' reg
 ;
 ;Get Day field.
 DD	LD	A,(IX+02H) ;Get 1st char of day field
 	SUB	30H	;and make it into an integer
 	CALL	MUL10	;Multiply by 10
 	LD	C,A	;Save in 'C' register
 	LD	A,(IX+03H) ;Get 2nd char of day field
 	SUB	30H	;Make into an integer
 	ADD	A,C	;and add together
 	AND	1FH	;Mask off 3 most sig bits
 	OR	L	;Combine Month and Date
 	LD	L,A	;Place back into 'L' register
 ;
 ;The compressed date is now an integer in 'HL' registers
 	POP	IX	;Pop saved registers off the
 	POP	BC	;  stack and return
 	POP	AF
 	RET
 ;
 ;This is a subroutine to multiply a number (0-15) by 10.
 ;The number to be multiplied (the multiplicand) is passed
 ;in the 'A' register and the result is returned in the
 ;'A' register.
 MUL10	PUSH	BC	;Save 'BC' register
 	AND	0FH	;Make sure multiplicand is 0-15
 	SLA	A	;Multiply by 2 by shifting left
 	LD	C,A	;Save 2*multiplicand
 	SLA	A	;Multiply by 2 again
 	SLA	A	;Multiply by 2 again
 	ADD	A,C	;Add 2*multiplicand to product
 ;The final product is in the 'A' register now.
 	OR	A	;Set flags
 	POP	BC
 	RET
 ;
 	END	DTCOMP
