DSET3  ;**************************************************
 ;
 ;		DSET/CMD   MODEL III
 ;
 ;		by:  Allan J. Domuret
 ;
 ;	     Copyright (c)	Feb., 1982
 ;
 ;***************************************************
 ;
 ;
 ;Program to read & modify current PDRIVE settings.
 ;
 ;
 	ORG	5200H
 ;
 ;Check for DDSD/CMD active.
 ;
 START	LD	SP,STACK
 	LD	A,0C9H
 	LD	(4012H),A
 	LD	HL,(46EDH)	;DDSD Patch Adrs
 	LD	DE,46F2H	;DE = (46EDH)
 	XOR	A
 	SBC	HL,DE
 	JP	Z,ABORT		;No ADR installed
 ;
 	CALL	01C9H
 	LD	A,(42BFH)	;# Drives in system
 	LD	C,A		;Save
 ;
 ;Get input: DSET 0D,1S,2D,3D is rqd format.
 ; Four drives max.
 ;
 INPUT	LD	B,00		;Counter
 	LD	HL,4226H	;Input buff pointer
 	LD	A,(HL)		;HL=> DOS input buff
 	CP	0DH
 	JP	Z,SPRINT	;Screen print DCT
 	LD	IY,STORE	;Storage Buff
 	DEC	HL
 INLOOP	INC	HL
 	LD	A,(HL)
 	CP	20H
 	JR	Z,INCHL
 	CP	','		;Comma OK too
 	JR	Z,INCHL
 	CP	0DH		;Done
 ;
 KEEPON	JP	Z,MKCHNG	;Done, so make changes
 	JR	INLOOP		;Keep looking for eol
 INCHL	INC	HL
 	LD	A,(HL)		;Drv 0 - 3 rqd 1st
 	CALL	INPSAV		;Store inputs
 ;
 ;Return fm INPSAV.
 ;
 	INC	B		;# Drives commanded
 	LD	A,(42BFH)	;# Drives in system
 	CP	B		;Four drive max
 	JP	Z,MKCHNG	;No more drives
 	JR	INLOOP		;Look again
 ;
 ;IY points to storage buff; HL points to input buff.
 ;
 INPSAV	LD	A,(HL)		;Get Drive #
 	CP	34H
 	JP	NC,ERR2		;ERR2 = Bad code
 	CP	30H
 	JP	C,ERR2		;Ditto
 	SUB	30H		;Make hex
 	LD	(IY+00),A	;Save drive 0
 ;
 ;Next charcter must be S or D (UC or LC) with
 ; no separator.
 ;
 	INC	HL		;Must be S or D
 	INC	IY
 	LD	A,(HL)
 	RES	5,A		;Make upper case
 	CP	'S'		;SD Ck
 	JR	Z,INPTOK
 	CP	'D'		;DD Ck
 	JR	Z,INPTOK
 	POP	AF		;Dump RET
 	JP	ERR2		;ERR2 = Bad entry
 ;
 ;HL gets bumped in parameter input scan.
 ;
 INPTOK	LD	(IY),A		;Save Density
 	INC	IY
 	RET
 ;
 ;B contains count for number of drive DCTs to change.
 ;STORE buff contains parms in drv/dnsty format.
 ;
 MKCHNG	LD	A,B		;Save # inputs
 	LD	(INPUTS),A
 	OR	A
 	JR	Z,SPRINT	;If Z, no changes
 	PUSH	BC		;B = drive count input
 	LD	HL,(46EDH)	;HL => DDSD adrs
 	LD	BC,0100H	;Byte limit for srch
 	LD	A,0ADH		;Search value
 LKAGN	CPIR
 	PUSH	HL
 	DEC	HL
 	DEC	HL		;Backup 2 bytes
 	LD	A,(HL)
 	OR	A		;Should be zero
 	POP	HL		;HL=> DDSD DCT
 	JR	NZ,LKAGN	;Not found.
 ;If BC=00, search failed. Abort.
 ;
 	LD	A,B		;Ck if BC=00
 	CP	C
 	POP	BC		;B = Drive count input
 	JP	Z,ABORT
 ;
 ;HL=>DDSD/CMD DCT, DD block.
 ;B = Number of drives affected (DCTs to change)
 ;Use C for drive number (0 - 3) affected
 ;
 	LD	IY,STORE	;Setup buff pointer
 	PUSH	HL		;HL=> DDSD DCT
 MOVES	LD	A,(IY+00)	;Drive 0 - 3
 	LD	C,A		;Keep track in C reg
 	LD	A,(IY+01)	;S or D ?
 	CP	'D'		;If D, HL point is OK
 	POP	HL
 	PUSH	HL		;Get original pointer
 	CALL	NZ,MKSGL	;Adj HL to SD block
 	LD	DE,4291H	;Dest for drive 0
 	LD	A,C		;Drive 0 - 3 Chk
 	OR	A		;Drive 0?
 	JR	Z,NOADJ		;No Adjustment
 BLKADJ	PUSH	BC
 	LD	BC,000AH	;Increment by 10
 	ADD	HL,BC		;Bump HL by 10
 	PUSH	HL		;Save
 	PUSH	DE
 	POP	HL
 	ADD	HL,BC		;Bump DE by 10
 	PUSH	HL
 	POP	DE		;Restore DE
 	POP	HL		;Restore HL
 	POP	BC
 	DEC	C
 	JR	NZ,BLKADJ	;Bump pointers by 10
 ;
 NOADJ	PUSH	BC
 	LD	BC,000AH	;Move 10 bytes
 	INC	IY		;Bump for next move
 	INC	IY
 	LD	(SRC+01),HL	;Set up block move
 	LD	(DEST+01),DE
 	LD	(COUNT+01),BC
 	CALL	BLKMOV		;Move 10 bytes to DCT
 	POP	BC
 	DJNZ	MOVES		;Rpt for # drive chngs
 ;
 ;
 ;Display current DCT settings
 ;
 ;
 ;B gets number of inputs (drives changed) to count.
 ;
 SPRINT	LD	IX,DENMSG	;Msg pointer
 	LD	IY,4291H	;DCT pointer
 	LD	A,(42BFH)	;Report on all drives
 	LD	B,A
 	CP	01		;One drive?
 	JR	Z,PATCH
 AGN	BIT	0,(IY+07)
 	LD	A,'S'
 	JR	Z,LOADIT
 	LD	A,'D'
 LOADIT	LD	(IX+0BH),A
 	LD	DE,000AH
 	ADD	IY,DE
 	LD	DE,000CH
 	ADD	IX,DE
 	INC	IX
 	DJNZ	AGN
 	JR	DUN
 PATCH	LD	(IX+0DH),03
 ;
 DUN	LD	(IX),03
 	LD	HL,DENMSG	;Display DCT settings
 ;
 ;Subroutines
 ;
 ;
 DSP	CALL	DSPLY
 	LD	A,0C3H
 	LD	(4012H),A
 	LD	SP,41F8H
 	EI
 	JP	402DH
 ;
 DSPLY	PUSH	HL
 	CALL	01C9H
 	LD	HL,3C80H
 	LD	(4020H),HL
 	POP	HL
 	CALL	4467H
 	RET
 ;
 ;
 ;Make HL point to SD DCT block
 ;
 MKSGL	PUSH	DE
 	LD	DE,0028H
 	ADD	HL,DE		;HL Points to DR0SD
 	POP	DE
 	RET
 ;
 ;Move DCT from DDSD to DOS DCT area
 ;
 BLKMOV	DI
 SRC	LD	HL,0000
 DEST	LD	DE,0000
 COUNT	LD	BC,0000
 	LDIR
 	EI
 	RET
 ;
 ;Parameter input buffer
 ;
 STORE	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
 ;
 INPUTS	DB			;Store # inputs
 ;
 FRST	DB	00		;Set 0FFH for next pass
 ;
 ;Messages and errors
 ;
 ABORT	LD	HL,NODDSD
 	JR	DSP
 ;
 ERR2	LD	HL,BADINP
 	JR	DSP
 ;
 ;
 ;
 NODDSD	DB	'Error: DDSD Not Installed',0AH,03
 ;
 ;
 BADINP	DB	'Error: Bad Drive Specification;',0AH,0AH
 	DB	'Input format is:  DSET 0D,1S,2D,3S <Enter>',0AH
 	DB	'Drive numbers are specified as 0 - 3',0AH
 	DB	'The S or D specifies Single or Double Density',0AH,03
 ;
 ;
 DENMSG	DB	'Drive 0 =>  ',0AH
 	DB	'Drive 1 =>  ',0AH
 	DB	'Drive 2 =>  ',0AH
 	DB	'Drive 3 =>  ',0AH,03,00
 ;
 	DS	40H
 STACK	EQU	$
 	END	START
The S or D specifies Single or Double Density',0AH,03
 ;
 ;
 DENMSG	DB	'Drive 0 =>  ',0AH
 	DB	'Drive 1 =>  ',0AH
 	DB	'Drive 2 =>  ',0AH
 	DB	'Drive 3 =>  ',0AH,