;CRTNOUT BY ROD STEVENSON 12TH JUNE, 1987
;FOR PCWRITE AND SIMILARS
;TO CHANGE CR AT END OF LINE TO @ SO SCRIPSIT GLOBAL 
;DELETE CAN REMOVE 0D FROM END OF EACH LINE
;LEAVES FOLLOWING TWO CHARACTERS ALONE
;
	ORG	5200H
OPEN	EQU	4424H	;opens file
CLOSE	EQU	4428H	;closes file
READ	EQU	4436H	;reads file
CKEOF	EQU	4458H	;(MODEL1=444B) checks end of file
INBUF$	EQU	4225H	;(MODEL1=4318) keyboard input buffer
REW	EQU	443FH	;points to start of file
WRITE	EQU	4439H	;writes file
FSPEC	EQU	441CH	;transfers filename input
DSPLY	EQU	4467H	;displays message on screen
BUFFER	EQU	6000H	;memory for data read in
;
;get filename, create FCB, open file
	LD	HL,INBUF$+8	;keyboard input buffer
	LD	DE,FCB		;file area in memory
	CALL	FSPEC		;transfer filename
	JP	NZ,ERROR	;test for valid name
	LD	HL,BUFFER	;data area in memory
	LD	B,0		;zero counter
	PUSH	BC		;save counter
	CALL	OPEN
	JP	NZ,ERROR	;check it was opened
;
;read whole file into memory
LOOP	CALL	READ		;read one sector
	JP	NZ,ERROR	;check it was read
	POP	BC		;get counter and
	INC	B		;   increment it for
	PUSH	BC		;   each file read
	LD	DE,FCB		;check to see if any 
	CALL	CKEOF		;   more sectors to read
	PUSH	AF		;save flags from check
	LD	HL,(FCB+3)	;increment data memory
	INC	H		;   ready for next sector
	LD	(FCB+3),HL	;to be read from file
	POP	AF		;get flags from check
	LD	DE,FCB
	JR	Z,LOOP		;keep reading sectors
;
;calculate total amount of memory filled by reads
	POP	BC		;get count of sectors
	PUSH	BC		;save it again
	LD	HL,BUFFER	;add number of sectors
	ADD	HL,BC		;   of 256 bytes to start
	LD	A,H		;   of data buffer 
	LD	(ENDBUF),A	;   and save it
;
;***************** END OF READ-IN **********************
;
;look for CR & change it + next character, skip next
	LD	HL,BUFFER
TSTCR	LD	A,(HL)		;test for CR character, &
	CP	0DH		;   change it to @, so 
	JR	NZ,CONT		;   global delete can 
	LD	A,'@'		;   remove it in scripsit
	LD	(HL),A
	INC	HL		;skips next in case CR to
	INC	HL		;   mark new paragraph
CONT	INC	HL		;gets next character & 
	LD	A,(ENDBUF)	;checks if all done
	CP	H
	JR	NC,TSTCR
;
;*********************** END OF SPECIFICS ******************
;
;when whole file is done, re-write to disk
FINISH	POP	BC		;get sector count
	LD	DE,FCB
	CALL	REW		;start from first sector
	LD	HL,BUFFER	;   and write it to disk
	JP	NZ,ERROR	;check it was written
	LD	DE,FCB		;   and continue till all
	LD	(FCB+3),HL	;   sectors written
WRTLP	CALL	WRITE
	JP	NZ,ERROR
	LD	DE,FCB
	LD	HL,(FCB+3)
	INC	H
	LD	(FCB+3),HL
	LD	DE,FCB
	DJNZ	WRTLP
;
;when re-written, close file and return to DOS
	LD	DE,FCB
	CALL	CLOSE
	JP	NZ,ERROR
	JP	402DH
;
ERROR	LD	HL,ERRMSG	;gives same error message
	CALL	DSPLY		;   whatever the cause,
	JP	4030H		;   likely bad name
;
ERRMSG	DEFM	10,10,10,'YOU HAVE MADE AN ERROR!!!!!!!!!!!!',10,10
	DEFM	'Correct syntax is:',10,'CRTNOUT xxxxxxxx/xxx where xxxxxxxx/xxx is filename to change',10,10,13
;
FCB	DS	32		;space allocated for FCB
ENDBUF	DS	1		;store total memory used
	END	5200H
                                                                                                         