 ;CALENDAR/ASM
 ;
 ;Set date/time program for MM58274 chip
 ;
 ;Written by Dr. J. Szajman
 ;
 DISPM	EQU	4467H
 ;
 ;
 ;Set date and time
 ;
 	ORG	5300H
 START	LD	SP,52FEH
 	CALL	DISPL
 	LD	DE,3C89H	;START HERE
 ALT0	CALL	VIDOUT
 ALT1	CALL	KEYC		;GET KEY
 	CP	1		;BREAK?
 	JP	Z,EXIT
 	CALL	ASCDEC		;DECIMAL DIGIT?
 	JP	Z,ALN
 	CP	'U'		;UPDATE
 	JR	Z,UPDATE
 	CP	'u'
 	JR	NZ,FIN
 UPDATE	PUSH	DE
 	CALL	DISPL		;REDISPLAY TIME
 	POP	DE
 	JR	ALT0
 FIN	CP	'S'		;SET CLOCK
 	JR	Z,ALF
 	CP	's'
 	JR	Z,ALF		;LOW CASE
 	CP	0DH		;CR
 	JR	NZ,ALU
 ALT2	LD	A,D
 	CP	3EH		;LAST LINE?
 	JR	Z,ALT1
 	LD	A,E
 	AND	0F0H		;FIRST DIGIT
 	OR	9		;FIRST POSN
 	LD	E,A
 	LD	A,D
 	JR	ALD1		;DO DOWN ARROW
 ALU	CP	5BH		;UP ARROW?
 	JR	NZ,ALD
 	LD	A,3CH
 	CP	D		;IS IT	3C?
 	JR	NZ,ALUJP1
 	LD	A,E
 	AND	40H		;ZERO IF 3C8XH
 	JR	Z,ALT1
 ALUJP1	OR	A		;ZAP CARRY
 	LD	HL,40H		;LINE LENGTH
 	EX	DE,HL
 	SBC	HL,DE		;ONE LINE UP
 	EX	DE,HL
 	JR	ALT0
 ALD	CP	0AH		;DOWN ARROW?
 	JR	NZ,ALL
 ALD1	LD	A,D
 	CP	3EH		;LAST LINE?
 	JR	Z,ALT1
 ALD2	LD	HL,40H
 	ADD	HL,DE
 	EX	DE,HL
 	JR	ALT0
 ALL	CP	08H		;LEFT ARROW?
 	JR	NZ,ALR
 	LD	A,' '
 	LD	(DE),A		;BLANK IT
 	LD	A,E
 	AND	0FH		;ZAP MS NIBBLE
 	CP	09H
 	JR	Z,ALT1
 	DEC	DE		;POINT TO #
 	JR	ALT0		;NEW POSITION
 ALR	CP	9		;RIGHT ARROW?
 	JR	NZ,ALSL
 	LD	A,E
 	AND	0FH		;ZAP TOP NIBBLE
 	CP	0AH
 	JR	Z,ALT1
 	INC	DE
 	JP	ALT0
 ALSL	CP	18H		;SHIFT LEFT ARROW
 	JP	NZ,ALT1
 	LD	A,E
 	AND	0FH
 	CP	9
 	JP	Z,ALT1
 	DEC	DE
 	JP	ALT0
 ALN	LD	(DE),A		;DISPLAY NEW VALUE
 	LD	L,A		;SAVE CHAR
 	LD	A,E
 	AND	0FH		;ZAP TOP NIBBLE
 	CP	0AH
 	JR	NC,ALT2		;2 CHARS ON LINE
 	INC	DE
 	JP	ALT0
 ALF	LD	A,5
 	OUT	(0B0H),A	;STOP THE CLOCK
 	LD	A,1
 	OUT	(0BFH),A	;SET 24 HOUR MODE
 	LD	DE,3C89H
 	CALL	ALGET		;GET YEAR
 	LD	A,H
 	ADD	A,A		;*2
 	ADD	A,A		;*4
 	ADD	A,H		;TENS YEAR * 5
 	ADD	A,A		;*10
 	ADD	A,L
 	JR	Z,ALFJP1
 ALFLP1	SUB	4		;CALC # OF YEARS TO LEAP
 	JR	Z,ALFJP1	;THIS IS LEAP YEAR
 	JR	NC,ALFLP1
 	ADD	A,4
 ALFJP1	RLCA
 	RLCA			;SHIFT TO MS NIBBLE
 	AND	0CH		;ZERO LOW BITS
 	OR	1		;LEAP YEAR & 24 HR MODE
 	OUT	(0BFH),A	;CLOCK SETTING REGISTER
 	LD	DE,3C89H	;POINT TO YEAR
 	LD	BC,06BDH	;6 SETTINGS, START AT BD
 ALFLP2	CALL	ALGET
 	LD	A,H		;TENS
 	OUT	(C),A		;SET
 	DEC	C		;NEXT PORT
 	LD	A,L		;UNITS
 	OUT	(C),A		;SET
 	DEC	C		;NEXT PORT
 	DJNZ	ALFLP2
 	DEC	C		;CONTROL REGISTER
 	CALL	ALGET		;GET DAY OF A WEEK
 	XOR	A
 	OR	H
 	JR	NZ,ALF1
 	OR	L
 	JR	NZ,ALF1
 	INC	A		;MIN VALUE 1
 ALF1	AND	7
 	OUT	(0BEH),A
 	XOR	A
 	OUT	(C),A		;START CLOCK
 	JP	START
 ;
 ;Display updated date/dime
 ;
 DISPL	CALL	01C9H
 	LD	B,2		;TRY TWICE ONLY
 	IN	A,(0B0H)	;CLEAR FLAG
 ALLP1	PUSH	BC
 	LD	HL,3C89H	;YEAR DISPLAYED HERE
 	PUSH	DE
 	LD	BC,06BDH	;READ CLOCK 6 TIMES
 	LD	DE,3FH		;OFFSET TO NEXT POSN
 ALLP2	IN	A,(C)
 	DEC	C
 	AND	0FH		;STRIP MS NIBBLE
 	ADD	A,30H		;CONVERT TO ASCII
 	LD	(HL),A		;FIRST DIGIT
 	INC	HL
 	IN	A,(C)
 	DEC	C
 	AND	0FH		;MASK
 	ADD	A,30H		;CONVERT TO ASCII
 	LD	(HL),A		;SECOND CHAR
 	ADD	HL,DE		;NEXT
 	DJNZ	ALLP2
 	IN	A,(0BEH)	;WEEK-DAY
 	AND	7		;MASK
 	ADD	A,30H
 	LD	(HL),A
 	IN	A,(0B0H)	;CHECK FLAG
 	POP	DE
 	POP	BC
 	AND	8
 	JR	Z,ALJP2
 	DJNZ	ALLP1
 ALJP2	LD	HL,MSG14
 	CALL	DISPM
 	RET
 ;
 VIDIN	PUSH	HL
 	LD	HL,4020H
 	LD	E,(HL)
 	INC	HL
 	LD	D,(HL)
 	POP	HL
 	RET
 ;
 VIDOUT	PUSH	HL
 	LD	HL,4020H
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	POP	HL
 	RET
 ;
 DISPC	PUSH	DE
 	CALL	33H
 	POP	DE
 	RET
 ;
 DELAY	PUSH	AF
 DELP1	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,DELP1
 	POP	AF
 	RET
 ;
 ;Get key and blink cursor/char
 ;
 KEYC	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	CALL	VIDIN
 	LD	A,(DE)		;GET CHAR
 	LD	B,A
 	LD	A,0B0H
 	LD	(DE),A		;BLINK ONCE
 	PUSH	BC
 	LD	BC,1100H	;DELAY COUNT
 KEYC2	CALL	DELAY
 	POP	BC
 KEYCL1	LD	A,B
 	LD	(DE),A		;CHAR UNDER CURSOR
 	CALL	KTIMER		;DELAY
 	JR	NZ,KEYC1
 	LD	A,0B0H		;CURSOR CHAR
 	LD	(DE),A		;RESTORE CHAR
 	CALL	KTIMER
 	JR	Z,KEYCL1
 	EX	DE,HL
 	LD	(HL),B
 KEYC1	POP	HL
 	POP	DE
 	POP	BC
 	RET
 ;
 ;TIMER
 ;
 KTIMER	PUSH	BC
 	LD	B,4		;DELAY
 KTJMP1	LD	C,0
 KTLP1	PUSH	DE
 	CALL	2BH
 	POP	DE
 	CP	2
 	JP	Z,EXIT		;BACK TO MENUE
 	OR	A
 	JR	NZ,KTEXIT
 	DEC	C
 	JR	NZ,KTLP1
 	CALL	KLDT
 	DJNZ	KTJMP1
 KTEXIT	POP	BC
 	RET
 ;
 ;Display date/time
 ;
 KLDT	PUSH	AF
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	CALL	VIDIN
 	PUSH	DE		;SAVE CURRENT VID POINTER
 	LD	DE,3FC0H	;BOTTOM LINE
 	CALL	KLOCKD		;DISPLAY DATE
 	CALL	KLOCKT		;DISPLAY TIME
 	POP	DE
 	CALL	VIDOUT		;RESTORE VIDEO
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF
 	RET
 ;
 ;Get 2 ASCII numbers from the screen
 ;
 ALGET	LD	A,(DE)		;GET TENTH
 	CP	' '
 	JR	NZ,ALGET1
 	LD	A,30H
 ALGET1	SUB	30H		;CONVERT TO HEX
 	LD	H,A
 	INC	DE
 	LD	A,(DE)
 	CP	' '
 	JR	NZ,ALGET2
 	LD	L,H
 	LD	H,0
 	JR	ALGET3
 ALGET2	SUB	30H
 	LD	L,A
 ALGET3	DEC	DE
 	PUSH	HL
 	LD	HL,40H
 	EX	DE,HL
 	ADD	HL,DE
 	EX	DE,HL
 	POP	HL
 	RET
 ;
 ;SHOW TENS AND UNITS
 ;C=TENS PORT, A=SEPERATOR
 ;
 TSHOW	PUSH	AF
 	IN	A,(C)
 	AND	0FH		;ZAP MSB NIBBLE
 	DEC	C
 	ADD	A,30H		;CONVERT TO ASCII
 	CALL	DISPC		;DISPLAY
 	IN	A,(C)		;UNITS
 	AND	0FH		;ZAP MSB NIBBLE
 	DEC	C
 	ADD	A,30H
 	CALL	DISPC
 	POP	AF
 	CALL	DISPC		;DISPLAY TERMINATOR
 	RET
 ;
 ;Display DATE
 ;DE = screen  ;DE = screen pointer
 ;
 KLOCKD	LD	B,2		;TWO TRIES TO READ CLOCK
 KD7	PUSH	DE
 	CALL	VIDOUT
 	IN	A,(0B0H)	;RESET FLAG
 	LD	C,0BEH		;DAY OF WEEK
 	IN	A,(C)
 	AND	7H		;MAX VALUE = 7
 	JR	NZ,KLD1
 	INC	A		;MIN VALUE 1
 KLD1	LD	HL,DAYTBL	;DATE TABLE
 	CALL	KLOCS		;DISPLAY DAY OF WEEK
 	LD	A,0C2H		;2 SPACES
 	CALL	DISPC
 	LD	A,'-'
 	LD	C,0B9H
 	CALL	TSHOW		;SHOW DAY
 	LD	C,0BBH
 	IN	A,(C)
 	DEC	C
 	AND	1		;MAX # TENS MONTH = 1
 	JR	Z,KLD2
 	LD	A,0AH
 KLD2	LD	H,A
 	IN	A,(C)		;UNITS MONTH
 	AND	0FH		;ZAP MSB NIBBLE
 	ADD	A,H
 	JR	Z,KLD6		;ILLEGAL MONTH
 	CP	13
 	JR	C,KLD3
 KLD6	LD	A,'?'		;INCORRECT MONTH!
 	CALL	DISPC
 	CALL	DISPC
 	LD	A,' '
 	CALL	DISPC
 	JR	KLD4
 KLD3	LD	HL,MTHTBL
 	CALL	KLOCS		;DISPLAY MONTH
 	LD	A,'-'
 	CALL	DISPC
 KLD4	LD	A,' '
 	LD	C,0BDH		;TENTH YEAR
 	CALL	TSHOW
 	LD	A,0C3H		;5 SPACES
 	CALL	DISPC
 	IN	A,(0B0H)	;GET FLAG
 	AND	8
 	JR	Z,KLD5
 	POP	DE		;DATE CHANGE DURING READ
 	DJNZ	KD7
 	JR	KD8
 KLD5	POP	AF		;DATE IS CORRECT
 KD8	CALL	VIDIN		;CURRENT POINTER
 	RET
 ;
 ;Display Time
 ;DE = screen pointer
 ;
 KLOCKT	LD	B,2		;TWO TRIES ALLOWED
 KLT2	PUSH	DE		;SAVE SCREEN POINTER
 	CALL	VIDOUT
 	IN	A,(0B0H)	;RESET FLAG
 	LD	C,0B7H		;HOURS
 	LD	A,':'
 	CALL	TSHOW
 	CALL	TSHOW		;MINUTES
 	LD	A,' '
 	CALL	TSHOW		;SECONDS
 	IN	A,(0B1H)	;1/10 SECONDS
 	AND	0FH		;ZAP MSB NIBBLE
 	ADD	A,30H
 	CALL	DISPC
 	IN	A,(0B0H)	;GET FLAG
 	AND	8
 	JR	Z,KLT1
 	POP	DE		;TIME CHANGED DURING READ
 	DJNZ	KLT2
 	JR	KLT3
 KLT1	POP	AF		;REMOVE PUSH
 KLT3	CALL	VIDIN		;CURRNENT POINTER
 	RET
 ;
 ;Get day of a week or month
 ;HL=Table, DE=Video address, B=relative position in table
 ;
 KLOCS	DEC	A		;IS IT FIRST ENTRY
 	PUSH	BC
 	JR	Z,KLOCS1
 	LD	B,A
 	LD	A,3		;TERMINATOR
 KLSLP1	CP	(HL)		;TERMINATOR?
 	INC	HL		;BUMP POINTER
 	JR	NZ,KLSLP1	;LOOP IF NOT TERMINATOR
 	DJNZ	KLSLP1		;LOOP UNTIL DAY FOUND
 KLOCS1	CALL	DISPM		;SHOW
 	POP	BC
 	RET
 ;
 ;SCAN CLOCK AND DISPLAY
 ;DE = SCREEN ADDRESS
 ;
 KLSCAN	PUSH	DE
 	CALL	KLOCKD		;GET DATE
 	CALL	KLOCKT		;GET TIME
 	LD	A,0CAH
 	CALL	DISPC		;10 SPACES
 	CALL	2BH		;SCAN KEYBOARD
 	POP	DE
 	OR	A
 	RET	NZ
 	LD	BC,700H		;SPEED DELAY
 KLS1	CALL	DELAY		;DELAY
 	JR	KLSCAN
 ;
 ASCDEC	CP	'0'
 	RET	C
 	CP	'9'		;IF 9 THEN Z SET ELSE IF
 	RET	NC		; > 9 THEN Z IS NOT SET
 	PUSH	BC		;MUST BE DIGIT 0 TO 8
 	LD	B,A
 	XOR	A		;RESET Z FLAG
 	LD	A,B
 	POP	BC
 	RET
 ;Date tables
 ;
 DAYTBL	DEFM	'Sunday'
 	DEFB	3
 	DEFM	'Monday'
 	DEFB	3
 	DEFM	'Tuesday'
 	DEFB	3
 	DEFM	'Wednesday'
 	DEFB	3
 	DEFM	'Thursday'
 	DEFB	3
 	DEFM	'Friday'
 	DEFB	3
 	DEFM	'Saturday'
 	DEFB	3
 ;
 MTHTBL	DEFM	'January'
 	DEFB	3
 	DEFM	'February'
 	DEFB	3
 	DEFM	'March'
 	DEFB	3
 	DEFM	'April'
 	DEFB	3
 	DEFM	'May'
 	DEFB	3
 	DEFM	'June'
 	DEFB	3
 	DEFM	'July'
 	DEFB	3
 	DEFM	'August'
 	DEFB	3
 	DEFM	'September'
 	DEFB	3
 	DEFM	'October'
 	DEFB	3
 	DEFM	'November'
 	DEFB	3
 	DEFM	'December'
 	DEFB	3
 MSG14	DEFB	0DBH
 	DEFM	'Alter DATE/TIME'
 	DEFW	1A1AH
 	DEFB	1DH
 	DEFM	'Year....'
 	DEFW	1D1AH
 	DEFM	'Month...'
 	DEFW	1D1AH
 	DEFM	'Day.....'
 	DEFW	1D1AH
 	DEFM	'Hour....'
 	DEFW	1D1AH
 	DEFM	'Minute..'
 	DEFW	1D1AH
 	DEFM	'Second..'
 	DEFW	1D1AH
 	DEFM	'Week-day'
 	DEFW	1A1AH
 	DEFB	1DH
 	DEFM	'Use ARROW keys to move cursor'
 	DEFW	1A1DH
 	DEFM	'<U>pdate, <S>et Clock, <BREAK> to Exit'
 	DEFB	3
 ;
 EXIT	CALL	01C9H
 	JP	402DH
 	END	START
                                                                                                                  