BLANK  ;
 ;IF YOU HAVE THE HABIT (OR NECESSITY) OF LEAVING YOUR
 ;MODEL III TURNED ON FOR LONG PERIODS OF TIME WHEN NO-ONE
 ;IS ACTIVELY TYPING ANYTHING IN (AS IN MANY BUSINESS SIT-
 ;UATIONS) EVENTUALLY THE SCREEN WILL SHOW "BURNED-IN"
 ;SPOTS FROM HAVING THE SAME CHARACTERS CONTINUOUSLY
 ;DISPLAYED IN THE SAME LOCATION. THIS WAS NOT A PROBLEM
 ;WITH THE MODEL I, AS YOU COULD JUST TURN OFF THE VIDEO
 ;AND LET THE CPU CONTINUE PROCESSING (OR JUST WAITING)
 ;WITHOUT THE VIDEO DISPLAY. HAVING THE COMPUTER SITTING
 ;THERE DISPLAYING TANTALIZING INFORMATION IS ALSO A
 ;POTENTIAL SECURITY RISK AND INVITES "PLAYING".
 ;
 ;AFTER WAITING 3 YEARS FOR SOMEONE ELSE TO PUBLISH OR
 ;ADVERTISE A SCREEN-BLANKING ROUTINE FOR THE MOD III, I
 ;FINALLY GAVE UP AND DID IT MYSELF.
 ;
 ;THIS ROUTINE PATCHES INTO THE ND-80 INTERRUPT QUEUE AND
 ;IS CALLED EVERY 255TH INTERRUPT CYCLE (ABOUT 6 SECONDS
 ;AT 3.4 MHZ PROCESSOR SPEED). WHEN CALLED, IT DECREMENTS
 ;AN INTERNAL TIMER ('TIME') AND IF 'TIME' IS NOT 0, 
 ;CONTINUES WITH THE INTERRUPT QUEUE. IF 'TIME' EQUALS 0:
 ;   (1) SCREEN IS SAVED TO A 1024 BYTE BUFFER
 ;   (2) SCREEN IS BLANKED OUT
 ;   (3) CURSOR CHARACTER IS SAVED AND CURSOR IS SET TO
 ;      BLANK SPACE, SO RUNNING PROGRAM WON'T PUT CURSOR
 ;      BACK ONTO SCREEN.
 ;   (4) CHARACTER UNDER CURSOR IS SAVED AND SET TO BLANK
 ;     ('CURALT' IS LOCATION DEFINED FOR STORAGE OF CHAR-
 ;     ACTER UNDER CURSOR).
 ;   (5)'BLANK' IS REMOVED FROM INTERRUPT QUEUE (TURNED
 ;      OFF) SO IT WON'T DESTROY SAVED SCREEN BY OVER-
 ;      WRITING THE BUFFER WITH THE BLANKED-OUT SCREEN.
 ;   (6) RETURN TO INTERRUPTED PROGRAM, SO IT CAN CONTINUE
 ;     NORMAL PROCESSING WITH THE SCREEN BLANKED OUT.
 ;
 ;THERE IS A SECOND ROUTINE ('KEYS') PATCHED INTO THE KEY-
 ;BOARD SCANNING, WHICH CONTINUOUSLY MONITORS THE KEYBOARD
 ;FOR ANY KEYPRESS. WHENEVER THERE IS A KEYPRESS IT TAKES
 ;ONE OF TWO ACTIONS:
 ;   (1) IF THE VIDEO HAS NOT BEEN BLANKED, IT RESETS
 ;      'TIME' BACK TO THE ORIGINAL COUNT (5 MINUTES?) AND
 ;      JUMPS TO THE REGULAR ND-80 KEYBOARD ROUTINE.
 ;   (2) IF THE VIDEO IS ALREADY BLANKED, A KEYPRESS 
 ;      INDICATES THAT THE OPERATOR IS BACK AND WILL NEED
 ;      TO SEE WHAT IS GOING ON. THE ROUTINE THEN RESTORES
 ;      THE SCREEN, CURSOR AND ALTERNATE CURSOR CHARACTER;
 ;      PUTS 'BLANK' BACK INTO THE INTERRUPT QUEUE (REAC-
 ;      TIVATES IT FOR NEXT USE); FLUSHES THE KEYBOARD
 ;      INPUT AND RETURNS TO THE RUNNING PROGRAM.
 ;
 ;THE THIRD ROUTINE('PRINT') IS PATCHED INTO THE THE VIDEO
 ;DCB VECTOR. WHENEVER THE VIDEO DRIVER ROUTINE IS CALLED
 ;BY A RUNNING PROGRAM, IT CHECKS THE SCREEN STATE AND
 ;TAKES THE SAME ACTIONS AS THE 'KEYS' ROUTINE ABOVE.
 ;
 ;THE PROGRAM ALSO CONTAINS A SUBROUTINE, 'DEACT', WHICH
 ;CAN BE CALLED FROM ASSEMBLER OR BASIC PROGRAMS TO
 ;DEACTIVATE 'BLANK' WHEN NECESSARY.
 ;
 ;USE:
 ;  (1) SET 'ORG' TO AN APPROPRIATE LOCATION FOR YOUR
 ;     MEMORY CONFIGURATION. "BLANK" NEEDS 174 BYTES 
 ;     FOR ITSELF AND 1024 BYTES FOR A SCREEN BUFFER, AND
 ;     CAN BE ASSEMBLED TO ANY LOCATION IN MEMORY -- IT
 ;     CANNOT BE RELOCATED WITHOUT REASSEMBLY OR USE OF A
 ;     RELOCATING LOADER.
 ;  (2) CHECK THE 'EQU' LIST AND SET 'TIME' AND 'BUFFER'
 ;     VALUES TO SUIT YOUR NEEDS.
 ;  (3) ASSEMBLE AS 'BLANK/CMD'. THE APPARAT VERSION OF 
 ;    ENHANCED 'EDTASM' HAS BEEN USED HERE. 'BLANK/CMD' ON
 ;    THIS DISK IS THE ALREADY ASSEMBLED VERSION OF 
 ;    'BLANK/ASM', USING THE PARAMETERS GIVEN.
 ;  (4) SET 'HIMEM' TO THE NECESSARY LEVEL TO ALLOW ROOM
 ;    FOR THIS PROGRAM, THE SCREEN BUFFER AND ANY OTHER 
 ;    ROUTINES YOU NEED IN HIGH MEMORY. AS ASSEMBLED HERE
 ;    'HIMEM' MUST BE SET TO 64334. VIDEO BUFFER MAY BE
 ;    USED BY OTHER PROGRAMS, AS LONG AS YOU MANAGE IT SO
 ;    'BLANK' DOESN'T DESTROY A SCREEN YOU NEED FOR OTHER
 ;    PURPOSES.
 ;  (5) USE THE DOS COMMAND "BLANK" OR "BLANK/CMD"
 ;    SOMEWHERE IN YOUR INITIALIZATION PROCEDURE. THIS
 ;    WILL LOAD 'BLANK', JUMP TO 'ENTRY' TO ACTIVATE IT
 ;    AND RETURN TO THE CALLING COMMAND. THIS CAN EASILY
 ;    BE DONE AS PART OF A 'JCL' FILE CALLED BY 'AUTO'.
 ;  (6) AFTER ACTIVATION, AT ANY TIME WHEN THE SET PERIOD
 ;    (ABOUT 2 MIN.) PASSES WITHOUT A KEY BEING DEPRESSED,
 ;    THE SCREEN WILL BE BLANKED.
 ;  (7) WHENEVER SCREEN IS BLANKED, IT MAY BE RESTORED
 ;    SIMPLY BY TOUCHING ANY KEY. 'SHIFT' IS BEST --
 ;    THE ROUTINE EXECUTES SO QUICKLY THAT ANY KEY 
 ;    PRESSED WILL PROBABLY STILL BE DOWN WHEN THE
 ;    SYSTEM EXECUTES IT'S NEXT KEYBOARD SCAN AND WILL BE
 ;    RETURNED TO THE INTERRUPTED PROGRAM. 'SHIFT' RETURNS
 ;    AN ASCII '0', AS IF NO KEY WERE DEPRESSED.
 ;  (8) TO DEACTIVATE 'BLANK' FOR PROGRAMS THAT HAVE A 
 ;    CONFLICT WITH IT'S MEMORY USAGE, JUST USE THE BASIC
 ;    STATEMENTS 'DEFUSR0=XXXXH:I=USR0(0)' (SET 'XXXX' TO
 ;    THE ADDRESS GIVEN FOR 'DEACT' IN YOUR ASSEMBLER'S
 ;    SYMBOL TABLE, OR IN THE LISTING).
 ;
 ;KNOWN LIMITATIONS ARE:
 ;  (1) FUNCTIONS ONLY UNDER NEWDOS-80 AT PRESENT, USING
 ;    THE "ENQUEUE A USER TIMER INTERRUPT ROUTINE" AT
 ;    4410H. COULD BE PATCHED DIRECTLY INTO INTERRUPT 
 ;    SERVICE VECTOR OF OTHER OPERATING SYSTEMS, BUT ALL
 ;    TIMING WOULD HAVE TO BE IMPLEMENTED INTERNALLY.
 ;  (2) EXECUTING PROGRAMS WHICH DO NOT USE THE KEYBOARD
 ;    AND/OR VIDEO DCB VECTORS FOR PRINTING OR KEYBOARD
 ;    MONITORING (USE PEEK/POKE OR DRIVERS NOT PATCHED
 ;    INTO THE THE DCB'S) WILL NOT RESTORE THE SCREEN
 ;    BEFORE PROCESSING KEYBOARD OR VIDEO REQUESTS.
 ;       FOR PROGRAMS WHICH PATCH THEIR OWN DRIVER(S) INTO
 ;    THE DCB(S), YOU MUST FIRST DEACTIVATE 'BLANK' (IF
 ;    IT IS ACTIVE), THEN ACTIVATE THE APPLICATION PROGRAM
 ;    (TO GET IT'S VECTORS INTO THE DCB'S), AND LASTLY
 ;    REACTIVATE 'BLANK' BY JUMPING TO 'ENTRY'. THIS WILL
 ;    INSERT THE 'BLANK' ROUTINE(S) AHEAD OF THE OTHER
 ;    PROGRAM'S KEYBOARD/VIDEO DRIVERS.
 ;  (3) THERE ARE CONFLICTS WITH SOME MACHINE-LANGUAGE
 ;   PROGRAMS THAT MUST OCCUPY CERTAIN AREAS IN MEMORY.
 ;   THIS CAN BE CORRECTED BY RELOCATING 'BLANK' AND THE
 ;   SCREEN BUFFER TO SOME UNUSED AREA. IN PRACTICE, THIS 
 ;   IS TOO MUCH TROUBLE, AND I JUST DEACTIVATE 'BLANK'
 ;   BEFORE LOADING THESE PROGRAMS. PROGRAMS WHICH RESPECT
 ;   THE 'HIMEM' SETTING WILL FUNCTION OK, UNLESS THEY 
 ;   HAVE TROUBLE WITH THE FOLLOWING TWO PROBLEMS.
 ;  (4) 'BLANK' SAVES AND RESTORES THE CURSOR CHARACTER 
 ;   AND THE CHARACTER UNDER THE CURSOR, USING THE RAM
 ;   STORAGE AREAS DESIGNATED FOR THIS PURPOSE IN THE
 ;   VIDEO DCB. ANY PROGRAM THAT UTILIZES INTERNAL STORAGE
 ;   FOR THESE CHARACTERS MAY NOT HAVE THEM RESTORED
 ;   PROPERLY. I'VE SOLVED THIS PROBLEM IN SEVERAL
 ;   PROGRAMS BY PATCHING THEM TO USE THE SAME AREAS
 ;   (IN THE DCB) FOR THIS STORAGE.
 ;  (5) 'BLANK' STAYS ACTIVE CONTINUOUSLY (UNLESS DEACT-
 ;    IVATED) AND IS REFERENCED ON EVERY INTERRUPT CYCLE.
 ;    IF THE RIGHT ROUTINE IS NOT AT THE RIGHT ADDRESS AT
 ;    EVERY INTERRUPT, IT WILL BOMB OR HANGUP. THIS MEANS 
 ;    THAT YOU CANNOT OVERWRITE OR EVEN RELOAD 'BLANK'
 ;    ITSELF, UNLESS YOU FIRST DEACTIVATE IT. IN MANY SIT-
 ;    UATIONS A RESET ("COLD" OR "WARM") IS THE MOST
 ;    PRACTICAL WAY TO REINITIALIZE THE COMPUTER.
 ;
 ;THIS PROGRAM HAS BEEN WRITTEN TO MEET MY PARTICULAR
 ;NEEDS. THERE ARE A NUMBER OF MODIFICATIONS THAT YOU
 ;MIGHT CONSIDER TO TAILOR IT TO YOUR NEEDS. WE
 ;USE IT WITH A COMPLEX OF OTHER UTILITY ROUTINES THAT
 ;ARE ALSO KEPT IN HIGH MEMORY AT NEARLY ALL TIMES. IF
 ;USING 'BLANK' AS A SELF-CONTAINED ROUTINE, YOU MIGHT
 ;ALSO MODIFY THE INITIALIZATION ROUTINE TO SET 'HIMEM'
 ;AUTOMATICALLY TO THE FIRST BYTE BEYOND THE INITIAL-
 ;IZATION ROUTINE, THUS RECOVERING A FEW BYTES AND 
 ;ELIMINATING THE NEED TO SET 'HIMEM' SEPARATELY.
 ;
 ;
 ;********************************************************
 ;*							*
 ;*		  'BLANK/CMD'				*
 ;*							*
 ;*      ROUTINE TO BLANK SCREEN AFTER SET PERIOD	*
 ;*							*
 ;* CARL FORD, 256 N VIRGINIA AVE, PENNS GROVE, NJ 08069	*
 ;*               (609)-299-0200				*
 ;*							*
 ;*		LAST REVISED - 11/12/84			*
 ;********************************************************
 ;
 ;
 ;
 	ORG	64334		;TO TOP-OF-MEMORY
 ENQINT	EQU	447BH	;INTERRUPT ENQUE ROUTINE
 DEQINT	EQU	4413H	;INTERRUPT DEQUE ROUTINE
 TIME	EQU	10	;# OF 6 SECOND PERIODS
 VIDEO	EQU	15360	;VIDEO BEGINS
 SIZ001	EQU	1024	;LENGTH OF SCREEN
 CURCHR	EQU	16419	;CURSOR CHARACTER STORAGE
 CURALT	EQU	16418	;CHARACTER UNDER CURSOR STORAGE
 BLANK	EQU	32	;ASCII BLANK
 KEYDCB	EQU	4015H	;KEYBOARD DEVICE CONTROL BLOCK
 VIDDCB	EQU	401DH	;VIDEO DEVICE CONTROL BLOCK
 KEYTST	EQU	38FFH	;KEY-PRESSED TEST LOCATION
 ;
 ;
 ;        *** INITIALIZE ROUTINES ***
 ;
 ;*** INSERT KEYBOARD & PRINT MONITORS INTO KEYBOARD QUE
 ENTRY	LD	HL,(KEYDCB+1)	;GET CURRENT KEYBD VECTOR
 	LD	(KEYJMP+1),HL	;PUT AT END OF ROUTINE
 	LD	HL,KEYS		;KEYBD PROCESSING ADDRESS
 	LD	(KEYDCB+1),HL	;PUT INTO DCB VECTOR
 	LD	HL,(VIDDCB+1)	;GET CURRENT VIDEO VECTOR
 	LD	(VIDJMP+1),HL	;PUT AT CONTINUATION
 	LD	HL,PRINT	;RESTORE SCREEN VECTOR
 	LD	(VIDDCB+1),HL	;PUT INTO DCB VECTOR
 ;
 ;*** PUT "BLANK" INTO INTERRUPT QUE
 	LD	DE,INTRTN	;INTERRUPT RTN ADDRESS
 	CALL	ENQINT		;PUT INTO INTERRUPT QUE
 ;
 ;	*** INTERRUPT PROCESSING ROUTINE ***
 ;
 ;*** DECREMENT TIMER & CHECK FOR 0
 INTRTN	DEFB	0		;WORK AREA
 	DEFB	0		;WORK AREA
 	DEFB	255		;# OF 6 SEC INTERVALS
 	DEFB	255		;LENGTH OF 1ST INTERVAL
 	PUSH	AF		;SAVE REGISTER
 	LD	A,(TIMER)	;GET CURRENT TIMER COUNT
 	DEC	A		;SHORTEN IT BY 1
 	LD	(TIMER),A	;SAVE IT
 	JR	NZ,EXIT		;TIMER NOT 0 YET
 ;
 ;*** SAVE SCREEN
 	EXX			;SAVE REGISTERS
 	LD	DE,BUF001	;BEGINNING OF BUFFER
 	LD	HL,VIDEO	;BEGINNING OF SCREEN
 	LD	BC,SIZ001		;BYTES TO MOVE
 	LDIR			;MOVE IT
 ;
 ;*** BLANK SCREEN
 	LD	HL,VIDEO	;BEGINNING OF VIDEO
 	LD	(HL),BLANK	;BLANK 1ST BYTE
 	LD	DE,VIDEO+1	;NEXT LOCATION
 	LD	BC,SIZ001-1	;AREA TO BLANK
 	LDIR			;FILL VIDEO
 ;
 ;*** SAVE & BLANK OUT CURSOR & ALTERNATE
 	LD	A,(CURCHR)	;GET CURSOR CHARACTER
 	LD	(CURSOR),A	;STORE CURSOR
 	LD	HL,CURCHR	;CURSOR STORAGE
 	LD	(HL),BLANK	;BLANK IT
 	LD	A,(CURALT)	;GET CHAR UNDER CURSOR
 	LD	(CURSOR+1),A	;STORE IT
 	LD	HL,CURALT	;ADDRESS
 	LD	(HL),BLANK	;BLANK IT
 ;		
 ;*** RETURN TO INTERRUPTED PROGRAM
 ;
 	CALL	DEACT		;DISABLE 'BLANK'
 	EXX			;RESTORE REGISTERS
 EXIT	POP	AF		;RESTORE REGISTER
 	RET
 ;
 ;	*** REMOVE "BLANK" FROM INTERRUPT QUE ***
 ;FOR USE BY PROGRAMS THAT NEED TO DISABLE "BLANK"
 ;
 DEACT	LD	DE,INTRTN	;VECTOR TO ROM ROUTINE
 	CALL	DEQINT		;REMOVE FROM QUE
 	RET			;BACK TO CALLING PROGRAM
 ;
 ;	*** ROUTINE FOR MONITORING KEYBOARD ***
 ;
 KEYS	PUSH	AF		;SAVE REGISTER
 	LD	A,(KEYTST)	;GET TEST LOCATION
 	CP	0		;KEY PRESSED
 	CALL	NZ,RESTOR	;RESTORE SCREEN, ETC
 	POP	AF		;RESTORE REGISTER
 KEYJMP	JP	0		;TO KEYBOARD DRIVER
 ;
 ;	*** ROUTINE FOR INTERCEPTING VIDEO ***
 ;
 PRINT	PUSH	AF		;SAVE REGISTER
 	CALL	RESTOR		;RESTORE SCREEN
 	POP	AF		;RESTORE REGISTER
 VIDJMP	JP	0		;TO PRINT DRIVER
 ;
 ;   	*** CHECK SCREEN & RESTORE IF BLANKED ***
 ;
 RESTOR	EXX			;SAVE REGISTERS
 	LD	A,(TIMER)	;CHECK TIME LEFT
 	CP	0		;SCREEN ALREADY BLANKED?
 	JR	NZ,RESET	;IF NOT, GO
 ;
 	LD	DE,VIDEO	;BEGINNING OF VIDEO
 	LD	HL,BUF001	;BEGINNING OF BUFFER
 	LD	BC,SIZ001		;BYTES TO MOVE
 	LDIR			;MOVE IT
 ;
 ;*** RESTORE CURSOR & ALTERNATE
 	LD	A,(CURSOR)	;GET CURSOR CHARACTER
 	LD	(CURCHR),A	;PUT IT BACK
 	LD	A,(CURSOR+1)	;GET CHAR UNDER CURSOR
 	LD	(CURALT),A	;RESTORE IT
 ;
 ;*** PUT "BLANK" BACK INTO INTERRUPT ROUTINE
 	LD	DE,INTRTN	;ROUTINES ADDRESS
 	CALL	ENQINT		;RESTORE TO INTERUPT QUE
 ;
 ;*** RECYCLE TIMER & RETURN TO INTERRUPTED PROGRAM
 RESET	LD	A,TIME		;GET DELAY
 	LD	(TIMER),A	;RESET DELAY COUNTER
 	EXX			;RESTORE REGISTERS
 	LD	A,0		;CANCEL KEYPRESS
 	RET			;BACK TO CALLING ROUTINE
 ;
 ;***SET STORAGE SPACE
 CURSOR	DEFW	0	;STORAGE FOR CURSOR & ALTERNATE
 TIMER	DEFB	TIME	;TIMING COUNTER
 BUF001	DEFS	1024	;VIDEO STORAGE BUFFER
 	END	ENTRY	;AUTO EXECUTE FROM "CMD"
