; BELL/FLT  VERSION 1.0  05/08/81
; PROVIDES A SHORT "BEEP" THRU THE CASSETTE PORT
;  WHENEVER AN ASCII BEL (CTL-G OR 07H) IS SENT TO
;  THE FILTERED DEVICE.
;
; ACTIVATE WITH: FILTER <DEVSPEC> USING BELL
;
; THIS PROGRAM IS A MODIFICATION OF THE BEEP/FLT
;  OF TIM MANN FROM THE LDOS BBS DATABASE.
;
HIGH$	EQU	4049H
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
@LOGOT	EQU	447BH
@ABORT	EQU	4030H
SFLAG$	EQU	430FH
	ORG	5200H
;
; LDOS 'FILTER' COMMAND HANDLER
;
ENTRY	PUSH	DE		;Save DCB location
	LD	A,(DE)
	PUSH	AF
	LD	HL,SIGNON	;Signon message
        CALL @DSPLY
 	POP	AF		;Check for illegal conditions
 	CP	08H		;Device set to NIL?
	JP	Z,ISNIL		;Go if so
	CP	10H		;Routed?
	JP	Z,ROUTED	;Go if so
; Put old driver address in filter code
	POP	IX
	PUSH	IX
	LD	L,(IX+1)	;Driver address from DCB
	LD	H,(IX+2)
	LD	(FILTER+1),HL
; Allocate memory and move filter code
	LD	HL,(HIGH$)
	LD	BC,LENGTH
	XOR	A
	SBC	HL,BC
	LD	(HIGH$),HL
	INC	HL
	EX	DE,HL		;Dest addr to DE
	LD	HL,FILTER	;Present location of code
	PUSH	DE
	LDIR			;Move shared code
	POP	DE		;Retrieve filter entry addr
	LD	(IX+1),E	;And put in DCB
	LD	(IX+2),D
;
	JP	@EXIT		;DONE
;
PERROR	LD	HL,ERRMSG	;'PARAMETER ERROR'
ERROR	CALL	@LOGOT		;DISPLAY AND LOG
	JP	@ABORT		;QUIT
ISNIL	LD	HL,NILMSG
	JR	ERROR
NINPUT	LD	HL,NIMSG
	JR	ERROR
ROUTED	LD	HL,RMSG
	JR	ERROR
;
;DATA AREA
SIGNON	DEFM	'BELL/FLT - SOUND AUDIO ON ASCII BEL'
	DEFM	' - Version 1.0'
	DEFB	0DH
ERRMSG	DEFM	'Parameter error'
	DEFB	0DH
NILMSG	DEFM	'Device not active'
	DEFB	0DH
NIMSG	DEFM	'Not an input device'
	DEFB	0DH
RMSG	DEFM	'Device is routed'
	DEFB	0DH
;
; Filter code
;
PORTFF	EQU	403DH
RELAY	EQU	37E4H
TPER	EQU	30
TLENG	EQU	0F0H
FILTER	CALL	$-$		;Call driver
	PUSH	AF
	CP	07H
	JR	Z,BEEP
	POP	AF
	RET 
; Produce beep
BEEP	PUSH	BC
	PUSH	DE
;	LD	A,1
;	LD	(RELAY),A	;Switch to cassette #2
	LD	B,TLENG		;Length of tone
	LD	D,TPER		;Period of vibration
	LD	A,(SFLAG$)	;Fast clock?
	BIT	3,A
	JR	Z,SLOW
	SLA	B
	SLA	D
SLOW	LD	A,(PORTFF)	;Get port FF state
	OR	01H
; Produce one cycle
CYCLE	LD	C,D		;Period of vibration
	XOR	3
	OUT	(0FFH),A
CY1	DEC	C
	JR	NZ,CY1
	DJNZ	CYCLE
	POP	DE
	POP	BC
	POP	AF
	RET
;
LENGTH	EQU	$-FILTER
;
	END	ENTRY

