SBEEP/A00010 ; BEEP/FLT  Version 1.0  Rev A
00020 ; Provides a short "beep" through the cassette port
00025 ;  whenever a key is pressed
00030 ;
00040 ; Tim Mann  02/15/81
00050 ;
00110 *LIST OFF
00120 *GET LDOSEPT/ASM
00122 SFLAG$	EQU 430FH
00130 *LIST ON
00140 	ORG 5200H
00150 ;
00160 ; LDOS 'FILTER' COMMAND HANDLER
00170 ;
00180 ENTRY:	PUSH DE		;Save DCB location
00200 	LD A,(DE)
00210 	PUSH AF
00220         LD HL,SIGNON    ;Signon message
00230         CALL @DSPLY
00240 	POP AF		;Check for illegal conditions
00260 	CP 08H		;Device set to NIL?
00270 	JP Z,ISNIL	;Go if so
00272 	CP 10H		;Routed?
00274 	JP Z,ROUTED	;Go if so
00280 	BIT 0,A		;Input device?
00290 	JP Z,NINPUT	;Go if not
00300 ; Put old driver address in filter code
00305 	POP IX
00310 	PUSH IX
00315 	LD L,(IX+1)	;Driver address from DCB
00320 	LD H,(IX+2)
00323 	LD (FILTER+1),HL
00325 	LD (GODVR+1),HL
00330 ; Allocate memory and move filter code
00590         LD HL,(HIGH$)
00600         LD BC,LENGTH
00610         XOR A
00620         SBC HL,BC
00630         LD (HIGH$),HL
00640         INC HL
00650         EX DE,HL	;Dest addr to DE
00660         LD HL,FILTER	;Present location of code
00908 	PUSH DE
00910         LDIR		;Move shared code
01280 	POP DE		;Retrieve filter entry addr
01290 	LD (IX+1),E     ;And put in DCB
01300 	LD (IX+2),D
01400 ;
01410         JP @EXIT        ;DONE
01420 ;
01430 PERROR:	LD HL,ERRMSG    ;'PARAMETER ERROR'
01440 ERROR:	CALL @LOGOT     ;DISPLAY AND LOG
01450         JP @ABORT       ;QUIT
01460 ISNIL:	LD HL,NILMSG
01470 	JR ERROR
01480 NINPUT:	LD HL,NIMSG
01490 	JR ERROR
01512 ROUTED:	LD HL,RMSG
01514 	JR ERROR
01520 ;
01530 ;DATA AREA
01540 SIGNON:	DB 'BEEP/FLT - Keyboard audio feedback filter'
01545 	DB 0AH,'Copyright (c) 1981 Timothy P. Mann'
01550 	DB ' - Version 1.0',0AH
01555 	DB 'Reproduction permitted for personal use only'
01560 	DB 0AH,0DH
01580 ERRMSG:	DB 'Parameter error',0DH
01590 NILMSG:	DB 'Device not active',0DH
01600 NIMSG:	DB 'Not an input device',0DH
01615 RMSG:	DB 'Device is routed',0DH
02120 ;
02130 ; Filter code
02140 ;
02142 PORTFF	EQU 403DH
02143 RELAY	EQU 37E4H
02144 TPER	EQU 30
02146 TLENG	EQU 80
02150 FILTER:	JP NC,$-$	;Pass on if @PUT or @CTL
02155 GODVR:	CALL $-$	;Call driver
02160 	RET Z		;Return if no key pressed
02170 ; Produce beep
02175 	PUSH DE
02180 	PUSH BC
02190 	PUSH AF
02192 	LD A,1
02194 	LD (RELAY),A	;Switch to cassette #2
02200 	LD B,TLENG	;Length of tone
02210 	LD D,TPER	;Period of vibration
02212 	LD A,(SFLAG$)	;Fast clock?
02214 	BIT 3,A
02216 	JR Z,SLOW
02218 	SLA B
02219 	SLA D
02220 SLOW:	LD A,(PORTFF)	;Get port FF state
02225 	OR 01H
02250 ; Produce one cycle
02260 CYCLE:	LD C,D		;Period of vibration
02270 	XOR 3
02280 	OUT (0FFH),A
02290 CY1:	DEC C
02300 	JR NZ,CY1
02310 	DJNZ CYCLE
02320 	POP AF
02330 	POP BC
02335 	POP DE
02340 	RET
02350 ;
02360 LENGTH	EQU $-FILTER
02370 ;
02380 	END ENTRY
