BASLIS  TITLE   '<BASLIST/ASM>'
 ;
 ;                  by
 ;             S.K.Pramanik
 ;           Struer.  Denmark
 ;
 ;            September,1982
 ; with minor corrections throughout 1983
 ;
 ;adapted and expanded from original program
 ;      SUPERLST/CMD by Morris Jones
 ;         originally published in
 ; "80 Microcomputing" - November 1981
 ;        now in the public domain
 ;
 ;
 ;              Source  File
 ;   TRS-80 MODEL III / IV (III mode)
 ;           NEWDOS/80 VER 2.0
 ;
 ;
 ;This program was written for the personal use of
 ;the author, and is transferred to the public domain
 ;in April 1986. It may or may not be of use to anyone
 ;else. The author may not be held responsible in any
 ;way for the correct or incorrect function of this
 ;program, or the results thereof.
 ;
 ;
 ;ROM & DOS calls
 ;
 VDCHAR	EQU	33H	;display char in A at cursor
 PRCHAR	EQU	3BH	;output char in A to printer
 KBLINE	EQU	40H	;get line from keyboard
 KBWAIT	EQU	49H	;single char from keyboard
 DELAY	EQU	60H	;delay loop (in BC)
 BASIC	EQU	72H	;for jump to BASIC READY
 CONVASC	EQU	132FH	;conv.int.in 4121,4122 to ASCII
 VDLINE	EQU	21BH	;display line
 TABLE	EQU	1650H	;BASIC reserved words table
 CONVHEX	EQU	1E5AH	;conv.to HEX, put in DE
 PRTSTAT	EQU	37E8H	;printer status
 STROBE	EQU	3840H	;keyboard strobe
 PRTDCB	EQU	4025H	;printer DCB
 BASPTR	EQU	40A4H	;pointer to BASIC program
 HEXADDR	EQU	4121H	;address for HEXCONV data
 DODOS	EQU	4405H	;execute DOS command
 DOSDATE	EQU	4470H	;convert date
 ;
 ;Default values for format parameters
 ;
 LFTMAR	EQU	4	;default left margin
 BOTMLN	EQU	6	;default lines to end of page
 LNSPPG	EQU	72	;default lines/page = 72+1
 CHRPLN	EQU	80	;default char.per line
 ;
 ;
 	ORG	0F99CH		; = 63900D
 ;
 DOSCMD	EQU	$	;command to load BASIC
 	DEFM	'BASIC '
 HIMEM	DEFM	'     ,defusr=-'
 ENTRY	DEFM	'     :load"'
 FILNAME	DEFM	'            ',0DH
 FILEMSG	DEFM	1CH,1FH,'Type "A=USR(0)" from BASIC to print'
 	DEFM	0AH,0AH,'Enter BASIC file to list      ',3
 RSTPRNT	DEFM	0AH,'Change hardcopy format - type "c"',0AH,3
 CHARMSG	DEFM	'Page width in char/line - def. = '
 CHARMS1	DEFM	'       ',3
 MARGMSG	DEFM	'Left margin indentation - def. = '
 MARGMS1	DEFM	'       ',3
 PAGEMSG	DEFM	'Page size in lines/page - def. = '
 PAGEMS1	DEFM	'       ',3
 ;
 ;HIMEM protection starts here
 ;
 HARDMSG	DEFM	1CH,1FH,'For hardcopy output type "h"',3
 NOOKMSG	DEFM	0AH,0AH,'Printer not ready',3
 OKMSG	DEFM	1CH,1FH,'Printing hard-copy',0AH,3
 PSEMSG	DEFM	1CH,1FH,'SPACE-BAR pauses printing',0AH,0AH,3
 HEADER1	DEFM	'Page '
 HEADER2	DEFM	'      of '
 HEADER3	DEFM	'              - printed by BASLIST dated '
 HEADER4	DEFM	'             ',0DH,3
 LINESNO	DEFW	STMNTNO
 LINES	DEFM	0,0,'BASIC lines in program',0
 STMNTNO	DEFW	BYTESNO
 STMNTS	DEFM	0,0,'BASIC statements in program',0
 BYTESNO	DEFW	LASTBYT
 BYTES	DEFM	0,0,'bytes used by program text',0
 LASTBYT	DEFW	0		;end of BASIC prog, 00
 ;
 ;defaults and flags
 ;
 LEFTMAR	DEFB	LFTMAR		;default left margin
 CHRPLIN	DEFB	CHRPLN		;default chars/line
 LINESPG	DEFB	LNSPPG		;default print char/lin
 FIXTMAR	DEFB	1		;left margin in use
 LINELEN	DEFB	61		;char/line in use
 NEXTMAR	DEFB	0		;current indentation
 CHNGMAR	DEFB	6		;indent for next line
 CHRCT	DEFB	0		;# of chars in buffer
 PAGENO	DEFW	0		;current page no.
 IFFLAG	DEFB	0		;set to 1 for IF
 QUITFL	DEFB	0		;set to 1 if quitting
 PRINTFL	DEFB	0		;if video 0, hardcopy 1
 ;
 ;
 MAINPRG	EQU	$
 	LD	(SPADDR),SP	;save stack pointer
 	LD	SP,SPADDR	;start new stack
 	LD	HL,0		;clear HL
 	LD	(LINES),HL	;clear prog.lines count
 	LD	(STMNTS),HL	;clear prog.statements
 	LD	(PAGENO),HL	;page no. to zero
 	XOR	A		;to clear
 	LD	(PRINTFL),A	;clear hardcopy flag
 	LD	(QUITFL),A	;clear quit flag
 	LD	HL,HARDMSG	;video/printer message
 	CALL	VDLINE		;display it
 	CALL	KBWAIT		;get keyboard char
 	CALL	CONVUC		;convert to upper case
 	CP	'H'		;is hardcopy reqd.
 	JR	Z,MAIN1		;flag is reqd.
 	LD	HL,PSEMSG	;pause screen print mess.
 	CALL	VDLINE		;display it
 	LD	BC,0FFFFH	;set delay
 	CALL	DELAY		;for time to read
 	LD	A,61		;video char/line
 	LD	(LINELEN),A	;store
 	LD	A,1		;video left margin
 	LD	(FIXTMAR),A	;store
 	JR	MAIN2		;no printer defaults
 MAIN1	EQU	$
 	LD	(PRINTFL),A	;set flag
 	LD	A,(CHRPLIN)	;default char/line
 	LD	(LINELEN),A	;store
 	LD	A,(LEFTMAR)	;default margin
 	LD	(FIXTMAR),A	;store
 	LD	A,(LINESPG)	;default lines/page
 	INC	A		;incr.to correct
 	LD	(PRTDCB+3),A	;store in DCB
 	LD	HL,NOOKMSG	;not ready message
 	CALL	VDLINE		;display it
 CHKSTAT	EQU	$
 	LD	A,(PRTSTAT)	;look at printer status
 	AND	240		;check
 	CP	48		;ready if
 	JR	NZ,CHKSTAT	;loop until ready
 	LD	HL,OKMSG	;printing message
 	CALL	VDLINE		;display it
 MAIN2	EQU	$
 	CALL	HEADER		;print header
 	LD	IY,(BASPTR)	;initialize BASIC pointer
 ;
 ;find line #
 ;
 NEWLINE	EQU	$
 	PUSH	IY		;prog pointer
 	POP	HL		;get into HL
 	INC	(HL)		;to test
 	DEC	(HL)		;for 00 - end of prog
 	JP	Z,QUIT		;yes, quit
 	LD	A,(QUITFL)	;check quit flag
 	OR	A		;is it zero?
 	CALL	Z,UPDLNS	;yes, update lines-stmnts
 	LD	A,(FIXTMAR)	;text left margin
 	LD	(NEXTMAR),A	;store
 	LD	A,6		;next margin offset
 	LD	(CHNGMAR),A	;store for next time
 	CALL	RESETIF		;reset IFflag
 	CALL	INDENT		;set indentation
 	LD	A,(CHRCT)	;get char count
 	ADD	A,5		;add chars in line #s
 	LD	(CHRCT),A	;update
 	LD	L,(IY+2)	;line # LSB
 	LD	H,(IY+3)	;line # MSB
 	LD	(HEXADDR),HL	;point to line #
 	PUSH	IX		;push pointer to stack
 	POP	HL		;pop pointer to HL
 	CALL	CONVERT		;convert line # to ASCII
 	INC	HL		;update buffer pointer
 	PUSH	HL		;pointer to stack
 	POP	IX		;get pointer back
 	LD	BC,3		;to update prog.pointer
 	ADD	IY,BC		;updated
 	CALL	COLONLP		;remove : at line start
 	LD	A,(IY)		;look at next prog byte
 	CP	8FH		;is it IF
 	JP	Z,IFRTN		;decode on same line
 ;
 ;get a character from BASIC program
 ;
 GETCHR	EQU	$
 	LD	A,(IY)		;get next char
 	CP	'"'		;is it a "?
 	JR	Z,QUOTELP	;yes, do loop
 	CP	':'		;no, is it :?
 	CALL	Z,COLON		;yes, do loop
 	CP	93H		;is it REM?
 	JR	Z,REMCHK	;REM rutine
 	BIT	7,A		;no, is it reserved word?
 	JR	NZ,RESWORD	;yes, check which one
 	PUSH	AF		;save the ASCII
 	CALL	SAVECHR		;no, it is ASCII - save
 	POP	AF		;get ASCII back
 	CP	','		;is it a , ?
 	CALL	Z,SPAFTER	;put SPACE after
 	CP	';'		;is it ; ?
 	CALL	Z,SPAFTER	; SPACE
 	INC	IY		;incr. BASIC pointer
 	JR	GETCHR		;start again
 ;
 ;rutine for  "
 ;
 QUOTELP	EQU	$
 	CALL	SAVECHR		;save the "
 	INC	IY		;point to next char
 	LD	A,(IY)		;look at next char
 	CP	'"'		;no, is it "?
 	JR	NZ,QUOTELP	;and continue
 	CALL	SAVECHR		;save closing "
 	INC	IY		;point to next
 	JR	GETCHR		;yes, end loop
 ;
 ;rutine for :
 ;
 COLON	EQU	$
 	CALL	UPDSTM		;update statement count
 	CALL	INSRTCR		;print previous line
 COLONLP	EQU	$
 	INC	IY		;jump over :
 	LD	A,(IY)		;look at next char
 	CP	' '		;is it a SPACE?
 	JR	NZ,CHKTWO	;no, check for 2nd :
 	INC	IY		;skip SPACE after :
 CHKTWO	EQU	$
 	LD	A,(IY)		;get char back
 	CP	':'		;no, is it another : ?
 	JR	Z,COLONLP	;yes, remove it
 	RET
 ;
 ;rutine for REM
 ;
 REMCHK	EQU	$
 	INC	IY		;jump over REM
 	LD	A,8FH		;load a graphic char
 	CALL	SAVECHR		;save the '
 	CALL	SPAFTER		;SPACE after '
 	LD	A,0FBH		;load ' token
 	CP	(IY)		;is next char an ' ?
 	JR	NZ,REMLP2	;no action
 REMLP	EQU	$
 	INC	IY		;point to next char
 REMLP2	EQU	$
 	LD	A,(IY)		;look at next char
 	CALL	SAVECHR		;save it
 	JR	REMLP		;continue with loop
 ;
 ;rutine for reserved words
 ;
 RESWORD	EQU	$
 	PUSH	AF		;store res.word
 	CALL	SPBEFOR		;SPACE before res.word
 	POP	AF		;get res.word back
 	CP	8FH		;is it IF
 	JR	Z,MIDLNIF	;yes, decipher it
 	CP	0CAH		;is it THEN
 	JR	Z,THENRTN	;special rutine
 	CP	95H		;is it ELSE?
 	JR	Z,ELSERTN	;special rutine
 	CP	188		;is it a command
 	JR	NC,DECODE	;yes, new line
 	PUSH 	AF		;store res.word
 	LD	A,(IFFLAG)	;to test
 	OR	A		;was there an IF?
 	POP	AF		;get back res.word
 	JR	NZ,DECODE	;there was
 	JR	STMNTLN		;start new line
 MIDLNIF	EQU	$
 	LD	A,(IY-1)	;last prog.char
 	CP	' '		;was it a SPACE?
 	JR	NZ,IFLINE	;check this char
 	LD	A,(IY-2)	;else this char
 IFLINE	EQU	$
 	CP	0CAH		;is it THEN?
 	JR	Z,IFRTN		;print on same line
 	CP	95H		;is it ELSE
 	JR	Z,IFRTN		;print on same line
 	CP	':'		;is it : ?
 	CALL	NZ,INSRTCR	;start new line
 IFRTN	EQU	$
 	LD	A,1		;flag
 	LD	(IFFLAG),A	;set flag
 	LD	A,(CHNGMAR)	;previous margin change
 	ADD	A,3		;indent change
 	LD	(CHNGMAR),A	;store new margin change
 	LD	A,8FH		;load an IF
 DECODE	EQU	$
 	CALL	DECIFER		;decipher reserved word
 	JP	GETCHR		;start again
 THENRTN	EQU	$
 	LD	A,(IY+1)	;look at next char
 	CP	' '		;a SPACE?
 	JR	NZ,THEN2	;no, no action
 	INC	IY		;jump over SPACE
 THEN2	EQU	$
 	LD	A,0CAH		;load a THEN
 	CALL	DECIFER		;decipher THEN
 	JR	STMNTLN		;start new line
 ELSERTN	EQU	$
 	LD	A,-3		;load indent change
 	LD	(CHNGMAR),A	;store new margin change
 	CALL	NEWMAR		;indent for ELSE
 	LD	A,95H		;load an ELSE
 	CALL	DECIFER		;decipher ELSE
 STMNTLN	EQU	$
 	CALL	RESETIF		;clear IFflag
 	LD	A,(IY)		;get new char
 	CALL	SKIPSP2		;end this line
 	JP	GETCHR		;start again
 DECIFER	EQU	$
 	PUSH	AF		;to check for TAB(
 	AND	7FH		;waste high bit
 	LD	B,A		;store value in counter
 	INC	B		;add 1
 	LD	HL,TABLE-1	;point to res.word table
 COUNTLP	EQU	$
 	INC	HL		;point to next char
 	LD	A,(HL)		;look at char
 	BIT	7,A		;is it a res.word?
 	JR	Z,COUNTLP	;no, try next
 	DJNZ	COUNTLP		;dec.counter until zero
 	AND	7FH		;remove res.word mark
 WORDLP	EQU	$
 	PUSH	HL		;save the pointer
 	CALL	SAVECHR		;found, save the char
 	POP	HL		;get pointer back
 	INC	HL		;point to next char
 	LD	A,(HL)		;get next char
 	BIT	7,A		;is it new word
 	JR	Z,WORDLP	;no, save and cont.
 	POP	AF		;get back res.word
 	CP	188		;is it TAB( ?
 	CALL	NZ,SPAFTER	;yes, insert SPACE
 	INC	IY		;point to next char
 	RET
 ;
 ;subrutines
 ;
 SAVECHR	EQU	$
 	LD	(IX),A		;put char in A in buffer
 	OR	A		;is char 0?
 	JR	Z,PRINTLN	;yes, print the line
 	CP	0DH		;no, is it a CR?
 	JR	Z,PRINTLN	;yes, print the line
 	CP	0AH		;no, is it down arrow?
 	JR	Z,SKIPCHR	;yes, print the line
 	LD	A,(LINELEN)	;no, get chars/line
 	LD	HL,CHRCT	;get printed char count
 	CP	(HL)		;is line full?
 	JR	Z,SPLITLN	;yes, insert CR to print
 	INC	(HL)		;no, add 1 to count
 	INC	IX		;point to next addr.
 	RET
 SPBEFOR	EQU	$
 	LD	A,'0'		;load a '0'
 	CP	(IX-1)		;is last char one?
 	RET	Z		;yes, no SPACE
 	LD	A,' '		;load a SPACE
 	CP	(IX-1)		;is prev.char one?
 	CALL	NZ,SAVECHR	;no, save the SPACE
 	RET
 SPAFTER	EQU	$
 	LD	A,' '		;SPACE
 	CP	(IY+1)		;is next char a SPACE?
 	CALL	NZ,SAVECHR	;save and return
 	RET
 UPDLNS	EQU	$
 	LD	HL,LINES	;get line count
 	INC	(HL)		;add 1
 UPDSTM	EQU	$
 	LD	HL,STMNTS	;get statement count
 	INC	(HL)		;add 1
 	RET
 RESETIF	EQU	$
 	XOR	A		;clear
 	LD	(IFFLAG),A	;reset flag
 	RET
 CONVUC	EQU	$
 	CP	'a'		;is it lower case?
 	RET	C		;no, go back
 	CP	'z'+1		;more than lower case?
 	RET	NC		;no, go back
 	XOR	20H		;change to upper
 	RET
 CONVERT	EQU	$
 	LD	BC,0		;to avoid editing
 	CALL	CONVASC		;convert to ASCII
 	LD	(HL),' '	;SPACE after
 	RET
 ;
 ;standard print rutine
 ;
 SPLITLN	EQU	$
 	LD	A,(IX)		;load last buffer char
 	CP	' '		;is it a SPACE
 	JR	Z,SKIPSPC	;yes, print line
 	BIT	7,A		;no, is it graphic?
 	JR	NZ,INSRTCR	;yes, print
 	DEC	IY		;dec.prog.code pointer
 	LD	A,(IY)		;look at prog.code
 	BIT	7,A		;is it res.wd?
 	JR	NZ,DECBUFF	;yes, stop dec.prog
 	DEC	IX		;dec.buffer pointer
 	JR	SPLITLN		;and loop
 DECBUFF	EQU	$
 	DEC	IX		;dec.buffer pointer
 	LD	A,(IX)		;look at buffer char
 	CP	' '		;is it a SPACE?
 	JR	Z,INSRTCR	;no, loop until it is
 	JR	DECBUFF		;print line
 SKIPSPC	EQU	$
 	LD	A,(IY+1)	;look at next
 SKIPSP2	EQU	$
 	CP	' '		;is it a SPACE?
 	JR	NZ,INSRTCR	;print line
 SKIPCHR	EQU	$
 	INC	IY		;this char not reqd.
 INSRTCR	EQU	$
 	LD	A,0DH		;with a CR
 	LD	(IX),A		;CR into buffer
 PRINTLN	EQU	$
 	LD	A,(STROBE)	;check keyboard
 	AND	4		;BREAK pressed?
 	JP	NZ,DOBREAK	;yes, end printout
 	LD	A,(PRINTFL)	;video test
 	OR	A		;test
 	JR	NZ,PRTRT1	;printer flag set
 	LD	A,(STROBE)	;check keyboard again
 	AND	128		;SPACE bar?
 	JR	NZ,PRINTLN	;no, print line
 	LD	BC,2000H	;delay loop
 	CALL	DELAY		;delay in ROM
 	JR	VIDRT1		;jump video rutine
 PRTRT1	EQU	$
 	LD	A,(PRTDCB+3)	;lines/page
 	LD	HL,PRTDCB+4	;lines printed
 	SUB	(HL)		;lines left on page
 	CP	BOTMLN		;end of page?
 	CALL	Z,PAGEFD	;yes, feed to new page
 VIDRT1	EQU	$
 	LD	IX,BUFFER	;no, point buffer start
 SUPRESS	EQU	$
 	LD	A,'0'		;ASCII 0
 	CP	(IX)		;leading 0?
 	JR	NZ,PRNTCHR	;no, then print line
 	LD	A,' '		;replace 0 with SPACE
 	CALL	CHRPRNT		;print SPACE
 	INC	IX		;point to next
 	JR	SUPRESS		;and loop
 PRNTCHR	EQU	$
 	LD	A,(IX)		;no, get next char
 	OR	A		;is it 0 (end line)?
 	JR	Z,ENDLINE	;replace 0 with CR
 	LD	A,(PRINTFL)	;printer flag
 	OR	A		;to test
 	JR	Z,PRTRT2	;video is set
 	LD	A,(IX)		;get char again
 	BIT	7,A		;is it graphic?
 	JR	Z,PRASCII	;no, print normal ASCII
 	CP	0C0H		;< highest graphic?
 	JR	C,EPSON		;yes, convert to EPSON
 	LD	A,0EH		;no, insert (dot - 20h)
 EPSON	EQU	$
 	ADD	A,' '		;convert to "."
 	JR	PRASCII		;and print
 PRTRT2	EQU	$
 	LD	A,(IX)		;get char back
 PRASCII	EQU	$
 	CALL	CHRPRNT		;no, print char
 	INC	IX		;point to next
 	CP	0DH		;is it CR?
 	JR	NZ,PRNTCHR	;and loop
 NEWMAR	EQU	$
 	LD	HL,NEXTMAR	;get current indent
 	LD	A,(CHNGMAR)	;margin change
 	ADD	A,(HL)		;change indent for next
 	LD	(NEXTMAR),A	;update indent
 	XOR	A		;
 	LD	(CHNGMAR),A	;clear margin change
 INDENT	EQU	$
 	LD	A,(NEXTMAR)	;
 	LD	B,A		;store in counter
 	XOR	A		;clear A
 	LD	(CHRCT),A	;clear char count in buff
 	LD	IX,BUFFER	;reset buffer
 INDNTLP	EQU	$
 	LD	A,'0'		;load ASCII 0
 	LD	(IX),A		;put into buffer
 	LD	HL,CHRCT	;get chars in buff
 	INC	(HL)		;add 1
 	INC	IX		;point to next
 	DJNZ	INDNTLP		;loop til indented
 	RET
 ;
 ;print subrutines
 ;
 CHRPRNT	EQU	$
 	LD	HL,(PRINTFL)	;printer flag
 	INC	L		;to test
 	DEC	L		;is flag set?
 	JR	Z,VIDSET	;video is set
 	CALL	PRCHAR		;char to printer
 	RET
 VIDSET	EQU	$
 	CALL	VDCHAR		;char to video
 	RET
 ENDLINE	EQU	$
 	INC	IY		;point to next char
 	LD	A,0DH		;load a CR
 	CALL	CHRPRNT		;print it
 	POP	AF		;SAVECHR ret off stack
 	JP	NEWLINE		;and start new line
 PAGEFD	EQU	$
 	LD	B,A		;lines to feed in counter
 	LD	A,0DH		;set the CR
 FEEDLP	EQU	$
 	CALL	PRCHAR		;print the CR
 	DJNZ	FEEDLP		;loop to new page
 HEADER	EQU	$
 	XOR	A		;to clear
 	LD	(PRTDCB+4),A	;lines printed counter
 	LD	HL,(PAGENO)	;get current page #
 	INC	HL		;incr.page #
 	LD	(PAGENO),HL	;new page #
 	LD	(HEXADDR),HL	;load into conv.addr.
 	LD	HL,HEADER2	;point to insert posn.
 	CALL	CONVERT		;convert to ASCII
 	LD	A,(FIXTMAR)	;margin for header
 	LD	B,A		;move to counter
 	LD	A,' '		;SPACE for margin
 INDENT2	EQU	$
 	CALL	CHRPRNT		;send to printer
 	DJNZ	INDENT2		;until indented
 	LD	IX,HEADER1	;point to header
 	LD	A,(PRINTFL)	;printer flag
 	OR	A		;set for video
 	JR	NZ,RITEHDR	;no, printer
 	LD	IX,HEADER3	;header for video
 RITEHDR	EQU	$
 	CALL	SUPRESS		;no leading zeros
 	LD	A,0DH		;load a CR
 	CALL	CHRPRNT		;print a line feed
 	RET
 ;
 ;rutine to end printing/program
 ;
 QUIT	EQU	$
 	LD	A,(QUITFL)	;look at quit flag
 	OR	A		;is it 0?
 	JR	NZ,DOBREAK	;no, return to BASIC
 	LD	HL,QUITFL	;point to flag
 	INC	(HL)		;set to quit
 	PUSH	IY		;store last char pointer
 	POP	HL		;and put into HL
 	LD	DE,(BASPTR)	;BASIC prog.start to DE
 	OR	A		;clear carry
 	SBC	HL,DE		;subtract for prog.bytes
 	LD	(BYTES),HL	;put bytes in data
 	LD	A,0DH		;load a CR
 	CALL	CHRPRNT		;print a line feed
 	LD	IY,LINESNO	;get message line #
 	JP	NEWLINE		;to print prog.data
 DOBREAK	EQU	$
 	LD	SP,(SPADDR)	;restore stack
 	JP	BASIC		;return to BASIC
 ;
 ;initialization
 ;
 BUFFER	EQU	$
 ;	insert HIMEM value
 	LD	HL,HARDMSG-1	;addr.to set for HIMEM
 	LD	(HEXADDR),HL	;to convert to ASCII
 	LD	HL,HIMEM	;point to insert posn.
 	CALL	CONVERT		;convert addr.to ASCII
 	LD	(HL),','	;put , into posn.
 ;	inset program entry address
 	LD	HL,0		;as FFFFH+1
 	LD	DE,MAINPRG	;addr.of prog start
 	XOR	A		;clear carry
 	SBC	HL,DE		;gives entry addr.
 	LD	(HEXADDR),HL	;to convert to ASCII
 	LD	HL,ENTRY	;point to insert posn
 	CALL	CONVERT		;and insert
 	LD	(HL),':'	;a : before next cmd
 ;	insert BASIC file name
 	LD	HL,FILEMSG	;file name message
 	CALL	VDLINE		;print message
 	LD	HL,FILNAME	;point to dump address
 	LD	B,13		;max input length
 	CALL	KBLINE		;keyboard input
 ;	option for printer format change
 	LD	HL,RSTPRNT	;offer option
 	CALL	VDLINE		;print message
 	CALL	KBWAIT		;wait for keyboard input
 	CALL	CONVUC		;convert to upper case
 	CP	'C'		;is it yes?
 	CALL	Z,FORMAT	;no, skip other messages
 ;	move file name into header
 	LD	HL,FILNAME	;point to name again
 	LD	DE,HEADER3	;name in header
 	LD	BC,12		;chars to move
 	LDIR			;move file name
 	LD	HL,HEADER3	;point to name again
 CNGCASE	EQU	$
 	LD	A,(HL)		;file name char
 	CP	0DH		;is it a CR?
 	JR	Z,MOVED		;no more to change
 	CALL	CONVUC		;convert to upper case
 	LD	(HL),A		;return into place
 	INC	HL		;look at next
 	JR	CNGCASE		;until done
 ;	decode and insert date into header
 MOVED	EQU	$
 	LD	(HL),' '	;change CR to SPACE
 	LD	HL,HEADER4	;date address
 	CALL	DOSDATE		;call date rutine
 ;	exit initialization
 	LD	HL,DOSCMD	;point to DOS command
 	JP	DODOS		;and execute
 ;
 ;subrutines to change default printer parameters
 ;	characters/line
 FORMAT	EQU	$
 	LD	A,0DH		;a CR
 	CALL	VDCHAR		;print
 	LD	A,(CHRPLIN)	;default
 	LD	(HEXADDR),A	;to convert
 	LD	HL,CHARMS1	;insert address
 	CALL	CONVERT		;convert
 	LD	A,(CHRPLIN)	;get default chars/line
 	LD	HL,CHARMSG	;for chars/line
 	CALL	GETMSG		;display MSG1
 	LD	A,E		;get E from DE
 	LD	(CHRPLIN),A	;store chars/line
 ;	left margin
 MARGIN	EQU	$
 	LD	A,(LEFTMAR)	;default
 	LD	(HEXADDR),A	;to convert
 	LD	HL,MARGMS1	;insert address
 	CALL	CONVERT		;convert
 	LD	A,(LEFTMAR)	;get default margin
 	LD	HL,MARGMSG	;for left margin
 	CALL	GETMSG		;display msg for margin
 	LD	A,(CHRPLIN)	;recall chars/line
 	CP	E		;is margin > chars/line?
 	JR	C,MARGIN	;too big margin
 	LD	A,E		;no, get E from DE
 	LD	(LEFTMAR),A	;store margin
 ;	lines/page
 	LD	A,LNSPPG	;default
 	LD	(HEXADDR),A	;to convert
 	LD	HL,PAGEMS1	;insert address
 	CALL	CONVERT		;convert
 	LD	A,(LINESPG)	;get default lines/page
 	LD	HL,PAGEMSG	;for lines/page
 	CALL	GETMSG		;display lines/page msg
 	LD	A,E		;get E from DE
 	INC	A		;to correct
 	LD	(PRTDCB+3),A	;store in printer DCB
 	RET
 GETMSG	EQU	$
 	LD	E,A		;put default value in E
 	PUSH	DE		;and save in stack
 	CALL	VDLINE		;print message
 	LD	HL,BUFFER	;point to buffer
 	LD	B,4		;max.keyboard entry
 	CALL	KBLINE		;get keyboard line
 	POP	DE		;get default back
 	LD	HL,BUFFER	;point to buffer
 	LD	A,(HL)		;look at first char
 	CP	0DH		;is it CR?
 	CALL	NZ,CONVHEX	;no, convert to HEX
 	RET
 ;
 SPADDR	EQU	$		;stack pointer store
 ;
 	END	BUFFER
OP	DE		;get default back
 	LD	HL,BUFFER	;point to buffer
 	LD	A,(HL)		;look at first char
 	CP	0DH		;is it CR?
