;****************************************************************
;
;
;                  Auto Redialing Routine 
;
;         For use with the Hayes 300 Baud Smartmodem
;
;****************************************************************
;
;                  By Mark Quarles [72135,1605]
;
;                       September - 1984
;
;****************************************************************
;
;
;  This program will allow you to auto redial a modem number, such
;  as a bulletin board which is difficult to logon to due to high
;  traffic.
;
;
;  To use the routine, simply type in its name:
;
;  Example:  This program is named REDIAL, so to use it,  simply type
;
;               REDIAL
;
;            at the TRSDOS READY prompt.
;
;  It will program the modem, then will prompt you for the number to call.
;
;
;  Option:   You may invoke it with:
;
;               REDIAL <number>
;
;            and it will not ask for the number to dial after programming
;            the modem.
;
;
;****************************************************************
;
;    To abort the auto dialing, you may press BREAK, and the phone will
;    be placed on-hook and the routine aborted.
;
;
;****************************************************************
;
;   After a carrier is detected, the program will display a message
;   on the screen notifying you to press BREAK to enter the COMM
;   package (and will beep out the cassette port).
;
;****************************************************************
;
	PSECT	8200H
;
;
	EXT	'EQU'
;
;
;
;
START	LD	A,(HL)		;fetch char
	CP	0DH		;is it a cr?
	JR	NZ,GOFORIT	;nope
	JP	YUP		;yes
GOFORIT	LD	DE,BUFF1	;phone number buffer
	LD	B,0FH		;max number of digits
GET	LD	A,(HL)		;get the char
	CP	0DH		;is it a cr?
	JP	Z,DONE1		;YES
	LD	(DE),A		;SAVE THE CHAR
	INC	HL
	INC	DE
	DJNZ	GET
SPACE	LD	HL,ERR1		;woops..too many chars
	SVC	@DSPLY		;send a message
	SVC	@EXIT		;and exit
DONE1	LD	A,CR		;load a cr
	LD	(DE),A		;save the cr
START1	SVC	@CLS		;clear the screen
	LD	HL,MSG1		;say hello
	SVC	@DSPLY		;send it out
	LD	DE,'LC'		;*CL 
	SVC	@GTDCB		;GO HUNTING FOR IT
	JR	Z,FOUND		;WOOPS - NOT THERE
	LD	HL,CMDE1	;BETTER INSTALL COM/DVR
	SVC	@CMNDR		;INSTALL IT
	LD	DE,'LC'		;LOOK FOR DCB AGAIN
	SVC	@GTDCB
	JR	NZ,NODCB	;NOT THERE - ABORT
FOUND	LD	(CLDCB),HL	;SAVE THE ADDRESS
;
;****************************************************************
;
;  Now we need to program the modem
;
;****************************************************************
;
	LD	HL,CMD1
	CALL	MSEND
	PUSH	BC
	LD	B,0FFH
D20	CALL	DELAY
	PUSH	BC
	LD	B,015H
D30	CALL	DELAY
	DJNZ	D30
	POP	BC
	DJNZ	D20
	POP	BC
	LD	HL,CMD		;modem command
	CALL	MSEND		;send string to modem
	CALL	MLISTEN		;listen for 'OK'
	PUSH	BC
	LD	B,0FFH
D0	CALL	DELAY
	PUSH	BC
	LD	B,015H
D10	CALL	DELAY
	DJNZ	D10
	POP	BC
	DJNZ	D0
	POP	BC
	LD	B,0FFH		;delay count
D1	CALL	DELAY		;delay
	CALL	DELAY		;delay
	CALL	DELAY		;delay
	DJNZ	D1		;loop
;
;
	JP	DONE		;NOW START DIALING
;
;
NODCB	LD	C,A		;PUT ERROR CODE IN A
	SVC	@ERROR		;OUTPUT IT AND ABORT
CLDCB	DEFS	2
OLDCL	DEFS	2
ERR1	DEFB	LF,LF
	DEFM	'***ERROR***'
	DEFB	LF
	DEFM	'    Phone number exceeds maximum length'
	DEFB	LF
	DEFM	'***ERROR***'
	DEFB	LF,CR
YUP	LD	HL,MSG2		;ask for number to call
	SVC	@DSPLY		;output it
	LD	HL,BUFF1	;input buffer
	LD	B,0CH		;length of input line
	SVC	@KEYIN		;get the line of input
	JP	START1
DONE	LD	A,CR		;load a cr
	LD	C,CR
	SVC	@DSP		;display it
	JP	CONT		;BRANCH AROUND MEMORY
CMD	DEFM	'ATQ0V0S11=40E0'
	DEFB	00
CMD1	DEFM	'ATZ'
	DEFB	00
MSG1	DEFM	'Auto Redialer Routine '
	DEFM	'by Mark Quarles'
	DEFB	LF,CR
MSG2	DEFM	'Enter number to call: '
	DEFB	03H
BRKMSG	DEFB	LF
	DEFM	'Press BREAK to abort redialing'
	DEFB	LF,CR
MODEM	DEFM	'ATDT'
BUFF1	DEFB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
BUFF2	DEFB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DEFB	0,0,0,0,0,0,0,0,0,0,0,0,0
MSG3	DEFM	'Dialing: '
	DEFB	03
MSG4	DEFB	LF,LF
	DEFM	'Autodial aborted!'
	DEFB	LF,CR
MSEND	LD	A,(HL)		;get a char
	OR	A		;is it a 0?
	JP	Z,EXIT		;yes
	LD	C,A
	SVC	@DSP		;display the byte
	LD	C,A
	LD	DE,(CLDCB)	;DCB ADDRESS FOR *CL
	SVC	@PUT		;SEND IT
	INC	HL		;bump pointer
	JP	MSEND
;
EXIT	LD	C,CR
	SVC	@DSP		;display it
	LD	DE,(CLDCB)	;*CL VECTOR
	LD	C,CR
	SVC	@PUT		;SEND IT TO THE MODEM
	RET			;return to caller
;
CONT	SVC	@CLS		;clear the screen
	LD	HL,MSG1		;output header
	SVC	@DSPLY
	LD	HL,BRKMSG	;msg on how to abort
	SVC	@DSPLY
	LD	B,0FFH		;delay count
CONDEL	CALL	DELAY		;delay
	CALL	DELAY		;delay
	CALL	DELAY		;delay
	CALL	DELAY		;delay
	DJNZ	CONDEL		;loop
	LD	HL,MSG3		;load message 3 header
	SVC	@DSPLY
	LD	HL,MODEM	;dial command
	CALL	MSEND		;send to modem
MLISTEN	SVC	@CKBRKC		;CHECK FOR BREAK KEY
	JR	NZ,STOP		;BREAK PRESSED
	LD	DE,(CLDCB)	;ADD OF DCB FOR *CL
	SVC	@GET		;TRY TO GET A CHAR
	JR	NZ,MLISTEN	;NO CHAR - LOOP
	CP	31H		;is it 'CONNECT'?
	JR	Z,CONNECT	;yup yup yup
	CP	33H		;is it 'NO CARRIER'?
	JR	Z,NOCARR	;yes
	CP	30H		;is it 'OK'?
	JR	NZ,MLISTEN	;no..continue to loop
	RET
STOP	LD	HL,MSG4		;load text
	SVC	@DSPLY		;send it
	LD	C,CR
	SVC	@DSP		;send a cr to modem
	LD	DE,(CLDCB)
	LD	C,CR
	SVC	@PUT
	SVC	@EXIT		;ABORT NOW
NOCARR	LD	B,0FFH		;delay count
NOCARLP	CALL	DELAY		;delay one time
	CALL	DELAY
	DJNZ	NOCARLP		;loop around
	JP	CONT
DELAY	PUSH	BC		;save registers
	LD	B,50		;value for tone
LP	DJNZ	LP		;loop for b counts
	POP	BC		;restore regs
	RET			;return
BEEP	LD	B,127		;value for duration
LOOP	LD	A,1		;set the bit
	OUT	(CASS),A	;byte to send
	CALL	DELAY		;delay
	XOR	A		;clear bit
	OUT	(CASS),A	;clear the bit
	CALL	DELAY		;delay
	DJNZ	LOOP		;loop to make noise
	RET			;return
CONNECT	SVC	@CLS
	LD	HL,CONMSG
	SVC	@DSPLY
CONN1	CALL	BEEP
SLOW	LD	B,0FFH
SLOWER	CALL	DELAY
	CALL	DELAY
	SVC	@CKBRKC		;CHK FOR BREAK KEY
	JR	NZ,HERE
	DJNZ	SLOWER
	JP	CONN1
;
HERE	LD	HL,CMDE2	;SECOND COMMAND
	SVC	@CMNDI		;DO IT
CMDE1	DEFM	'SET *CL TO COM/DVR'
	DEFB	CR
CMDE2	DEFM	'COMM *CL'
	DEFB	CR
CONMSG	DEFB	LF
	DEFM	'***Carrier Detected***'
	DEFB	LF,LF
	DEFM	'Press <BREAK> to execute DOS Command'
	DEFB	LF,CR
	END	START

