; REDIAL/ASM   Hayes autoredial utility.  (fixed 1-20-85   21:05 Hrs.)
;****************************************************************
;
;		  Auto Redialing Routine 
;
;	 For use with the Hayes 300 Baud Smartmodem
;
;****************************************************************
;
;		By Mark Quarles [72135,1605]
;
;		September - 1984
;
;****************************************************************
;
;  This program will allow you to auto redial a modem number, such
;  as a bulletin board which is difficult to logon to due to high
;  traffic.
;
;  To use the routine, simply type in its name:
;
;  Example:  This program is named REDIAL, so to use it,  simply type
;	REDIAL
;  at the TRSDOS READY prompt.
;
;  It will program the modem, and then prompt you for the number to call.
;
;  Option:   You may invoke it with:
;	REDIAL <number>
;  and it will not ask for the number to dial after programming
;  the modem.
;
;****************************************************************
;
;    To abort the auto dialing, you may press BREAK, and the
;    phone will be placed on-hook and the routine aborted.
;
;****************************************************************
;
;   After a carrier is detected, the program will display a message
;   on the screen notifying you to press BREAK to enter the COMM
;   package (and will beep out the cassette port).
;
;****************************************************************
;
	ORG	8200H		;starting address
;
CR	EQU	0DH
LF	EQU	0AH
CASS	EQU	0FFH
@DSPLY	EQU	10
@EXIT	EQU	22
@CLS	EQU	105
@GTDCB	EQU	82
@CMNDR	EQU	25
@ERROR	EQU	26
@KEYIN	EQU	9
@DSP	EQU	2
@PUT	EQU	4
@CKBRKC	EQU	106
@GET	EQU	3
@CMNDI	EQU	24
;
SVC	MACRO	#RST_ADDR
	LD	A,#RST_ADDR
	RST	40
	ENDM
;
;
START	LD	A,(HL)	  	;fetch char
	CP	0DH		;is it a cr?
	JR	NZ,GOFORIT	;nope
	JP	YUP		;yes
GOFORIT	LD	DE,BUFF1	;phone number buffer
	LD	B,0FH		;max number of digits
GET	LD	A,(HL)		;get the char
	CP	0DH		;is it a cr?
	JP	Z,DONE1		;yes!
	LD	(DE),A		;save the char
	INC	HL
	INC	DE
	DJNZ	GET
SPACE	LD	HL,ERR1		;woops..too many chars
	SVC	@DSPLY		;send a message
	SVC	@EXIT		;and exit
DONE1	LD	A,CR		;load a cr
	LD	(DE),A		;save the cr
START1	SVC	@CLS		;clear the screen
	LD	HL,MSG1		;say hello
	SVC	@DSPLY		;send it out
	LD	DE,'LC'		;*CL 
	SVC	@GTDCB		;go hunting for it
	JR	Z,FOUND		;woops - not there
	LD      HL,CMDE1	;better install COM/DVR
	SVC	@CMNDR		;install it
	LD	DE,'LC'		;look for DCB again
	SVC	@GTDCB
	JR	NZ,NODCB	;not there - abort
FOUND	LD	(CLDCB),HL	;save the address
;
;****************************************************************
;
;  Now we need to program the modem
;
;****************************************************************
;
	LD	HL,CMD1
	CALL	MSEND
	PUSH	BC
	LD	B,0FFH
D20	CALL	DELAY
	PUSH	BC
	LD	B,015H
D30	CALL	DELAY
	DJNZ	D30
	POP	BC
	DJNZ	D20
	POP	BC
	LD	HL,CMD		;modem command
	CALL	MSEND		;send string to modem
	CALL	MLISTEN		;listen for 'OK'
	PUSH	BC
	LD	B,0FFH
D0	CALL	DELAY
	PUSH	BC
	LD	B,015H
D10	CALL	DELAY
	DJNZ	D10
	POP	BC
	DJNZ	D0
	POP	BC
	LD	B,0FFH		;delay count
D1	CALL	DELAY		;delay
	CALL	DELAY		;delay
	CALL	DELAY		;delay
	DJNZ	D1		;loop
;
	JP	DONE		;now start dialing
;
NODCB	LD	C,A		;put error code in A
	SVC	@ERROR		;output it and abort
CLDCB	DC	2,0
OLDCL	DC	2,0
ERR1	DB	LF,LF,'***ERROR***',LF
	DB	'    Phone number exceeds maximum length',LF
	DB	'***ERROR***',LF,CR
YUP	LD	HL,MSG2		;ask for number to call
	SVC	@DSPLY		;output it
	LD	HL,BUFF1	;input buffer
	LD	B,0CH		;length of input line
	SVC	@KEYIN		;get the line of input
	JP	START1
DONE	LD	A,CR		;load a cr
	LD	C,CR
	SVC	@DSP		;display it
	JP	CONT		;branch around memory
CMD	DB	'ATQ0V0S11=40E0',0
CMD1	DB	'ATZ',0
MSG1	DB	'Auto Redialer Routine by Mark Quarles',LF,CR
MSG2	DB	'Enter number to call: ',3
BRKMSG	DB	LF,'Press BREAK to abort redialing',LF,CR
MODEM	DB	'ATDT'
BUFF1	DC	18,0
BUFF2	DC	29,0
MSG3	DB	'Dialing: ',3
MSG4	DB	LF,LF,'Autodial aborted!',LF,CR
MSEND	LD	A,(HL)		;get a char
	OR	A		;is it a 0?
	JP	Z,EXIT		;yes
	LD	C,A
	SVC	@DSP		;display the byte
	LD	C,A
	LD	DE,(CLDCB)	;DCB address for *CL
	SVC	@PUT		;send it
	INC	HL		;bump pointer
	JP	MSEND
;
EXIT	LD	C,CR
	SVC	@DSP		;display it
	LD	DE,(CLDCB)	;*CL vector
	LD	C,CR
	SVC	@PUT		;send it to the modem
	RET			;return to caller
;
CONT	SVC	@CLS		;clear the screen
	LD	HL,MSG1		;output header
	SVC	@DSPLY
	LD	HL,BRKMSG 	;msg on how to abort
	SVC	@DSPLY
	LD	B,0FFH		;delay count
CONDEL	CALL	DELAY		;delay
	CALL	DELAY		;delay
	CALL	DELAY		;delay
	CALL	DELAY		;delay
	DJNZ	CONDEL		;loop
	LD	HL,MSG3		;load message 3 header
	SVC	@DSPLY
	LD	HL,MODEM	;dial command
	CALL	MSEND		;send to modem
MLISTEN	SVC	@CKBRKC		;check for break key
	JR	NZ,STOP		;BREAK pressed
	LD	DE,(CLDCB)	;address of DCB for *CL
	SVC	@GET		;try to get a char
	JR	NZ,MLISTEN	;no char - loop
	CP	31H		;is it 'CONNECT'?
	JR	Z,CONNECT	;yup yup yup
	CP	33H		;is it 'NO CARRIER'?
	JR	Z,NOCARR	;yes
	CP	30H		;is it 'OK'?
	JR	NZ,MLISTEN	;no..continue to loop
	RET
STOP	LD	HL,MSG4		;load text
	SVC	@DSPLY		;send it
	LD	C,CR
	SVC	@DSP		;send a cr to modem
	LD	DE,(CLDCB)
	LD	C,CR
	SVC	@PUT
	SVC	@EXIT		;abort now
NOCARR	LD	B,0FFH		;delay count
NOCARLP	CALL	DELAY		;delay one time
	CALL	DELAY
	DJNZ	NOCARLP		;loop around
	JP	CONT
DELAY	PUSH	BC		;save registers
	LD	B,50		;value for tone
LP	DJNZ	LP		;loop for b counts
	POP	BC		;restore regs
	RET			;return
BEEP	LD	B,127		;value for duration
LOOP	LD	A,1		;set the bit
	OUT	(CASS),A	;byte to send
	CALL	DELAY		;delay
	XOR	A		;clear bit
	OUT	(CASS),A	;clear the bit
	CALL	DELAY		;delay
	DJNZ	LOOP		;loop to make noise
	RET			;return
CONNECT	SVC	@CLS
	LD	HL,CONMSG
	SVC	@DSPLY
CONN1	CALL	BEEP
SLOW	LD	B,0FFH
SLOWER	CALL	DELAY
	CALL	DELAY
	SVC	@CKBRKC		;CHK FOR BREAK KEY
	JR	NZ,HERE
	DJNZ	SLOWER
	JP	CONN1
;
HERE	LD	HL,CMDE2	;SECOND COMMAND
	SVC	@CMNDI		;DO IT
CMDE1	DB	'SET *CL TO COM/DVR',CR
CMDE2	DB	'COMM *CL',CR
CONMSG	DB	LF,'***Carrier Detected***',LF,LF
	DB	'Press <BREAK> to execute DOS Command',LF,CR
	END	START
