/*
 *	Z80 Disassembler
 *
 *	Copyright (C) 1982 - Anthony McGrath
 *
 *	@(#) main.c - Version 1.1 - 85/10/03 18:20:04
 */

#include	"disasm.h"

main(argc, argv)
register int	argc;
register char	**argv;
	{

	if (argc == 1)	{
usage:
		fprintf(stderr, "Usage: zdis [-s addr] [-e addr] file\n");
		exit(1);
	}

	while (--argc && (++argv)[0][0] == '-')
		switch (argv[0][1])	{

		case 'e':	/* end address */
			argv++;
			argc--;
			sscanf(*argv, "%x", &endaddr);
			continue;

		case 's':	/* start address */
			argv++;
			argc--;
			sscanf(*argv, "%x", &startaddr);
			continue;
		}

	if (argc)
		filename = *argv;
	else
		goto usage;

	if (freopen(filename, "r", stdin) == NULL)	{
		fprintf(stderr, "zdis: Cannot open %s\n", filename);
		exit(1);
	}

	if (fseek(stdin, (long) startaddr, 0) < 0)	{
		fprintf(stderr, "zdis: Cannot seek to %x", startaddr);
		exit(1);
	}

	disasm();
}

disasm()
	{
	register int	b;

	while (!feof(stdin))	{
		if (endaddr > 0 && startaddr > endaddr)
			return;

		nbyte = 0;
		printf("%04x: ", startaddr);

		b = getbyte();
		printf("%02x", b);

		decode(b);

		outline();
	}
}
