/*
 *	Z80 Disassembler
 *
 *	Copyright (C) 1982 - Anthony McGrath
 *
 *	@(#) io.c - Version 1.1 - 85/10/03 18:20:03
 */

#include	"disasm.h"

char	line[40];
char	*lp = line;

getbyte()
	{
	register int	c;

	startaddr++;
	nbyte++;

	if ((c = getchar()) == EOF)
		exit(0);

	return(c);
}

out(s)
register char	*s;
	{
	register char	*p;

	p = lp;

	while (*s)
		*p++ = *s++;

	lp = p;
}

outbyte()
	{
	register int	b;
	char		s[8];

	b = getbyte();
	printf(" %02x", b);
	sprintf(s, "%02x", b);

	out(s);
}

outword()
	{
	register int	b;
	char		s[8];

	b = getbyte();
	b += (getbyte() << 8);

	printf(" %02x %02x", b & 0377, (b >> 8) & 0377);
	sprintf(s, "%04x", b);

	out(s);
}

outnum(n)
register int	n;
	{
	char	s[8];

	sprintf(s, "%x", n);
	out(s);
}

outline()
	{

	*lp = 0;

	if (nbyte < 4)
		putchar('\t');

	printf("\t%s\n", line);

	lp = line;
}

char	*regtab[] =	{
	"b", "c", "d", "e", "h", "l", "(hl)", "a"
};

reg(n)
register int	n;
	{

	if (indx && n == 6)
		if (ind < 0)
			out((indr ? "iy" : "ix"));
		else	{
			out((indr ? "(iy + " : "(ix + "));
			outnum(ind);
			out(")");
		}
	else
		out(regtab[n]);
}

char	*regpair[] =	{
	"bc", "de", "hl", "sp"
};

rpair1(n)
register int	n;
	{

	if (indx && n == 4)
		if (ind < 0)
			out((indr ? "iy" : "ix"));
		else	{
			out((indr ? "(iy + " : "(ix + "));
			outnum(ind);
			out(")");
		}
	else
		out(regpair[n / 2]);
}

rpair2(n)
register int	n;
	{

	if (n / 2 == 3)
		out("af");
	else
		rpair1(n);
}

char	*condtab[] =	{
	"nz", "z", "nc", "c", "po", "pe", "p", "m"
};

cond(n)
register int	n;
	{

	out(condtab[n]);
}

relative()
	{
	register int	b;
	char		s[8];

	b = getbyte();
	printf(" %02x", b);

	if ((b >> 7) & 01)
		b |= (~0377);

	sprintf(s, "%04x", (startaddr + b) & 0xffff);
	out(s);
}

outdig(n)
register int	n;
	{
	char	s[2];

	s[0] = n + '0';
	s[1] = 0;

	out(s);
}
