/*
 *	Z80 Disassembler
 *
 *	Copyright (C) 1982 - Anthony McGrath
 *
 *	@(#) decode.c - Version 1.1 - 85/10/03 18:20:01
 */

#include	"disasm.h"

decode(b)
register int	b;
	{
	register int	op;
	register int	r1;
	register int	r2;

	op = (b >> 6) & 03;	/* basic op code */
	r1 = (b >> 3) & 07;	/* first reg field */
	r2 = b & 07;		/* second reg field */

	switch (op)	{

	case 00:	/* opcodes 00 - 3f hex */
		switch (r2)	{

		case 00:
			if (r1 == 0)
				out("nop");
			else if (r1 == 1)
				out("ex\taf,af'");
			else if (r1 < 4)	{
				out((r1 == 3 ? "jr\t" : "djnz\t"));
				relative();
			}
			else	{
				out("jr\t");
				cond(r1 - 4);
				out(",");
				relative();
			}

			return;

		case 01:
			if (r1 % 2 == 0)	{
				out("ld\t");
				rpair1(r1);
				out(",");
				outword();
			}
			else	{
				out("add\thl,");
				rpair1(r1);
			}

			return;

		case 02:
			if(r1 % 2 == 0)	{
				out("ld\t(");
				if (r1 < 4)
					rpair1(r1);
				else
					outword();

				if (r1 != 4)
					out("),a");
				else if (indx)
					out((indr ? "),iy" : "),ix"));
				else
					out("),hl");
			}
			else	{
				if (r1 != 5)
					out("ld\ta,(");
				else if (indx)
					out((indr ? "ld\tiy,(" : "ld\tix,("));
				else
					out("ld\thl,(");

				if (r1 < 4)
					rpair1(r1);
				else
					outword();

				out(")");
			}

			return;

		case 03:
			out((r1 % 2 ? "inc\t" : "dec\t"));
			rpair1(r1);

			return;

		case 04:
			out("inc\t");

			if (indx)
				getind();

			reg(r1);

			return;

		case 05:
			out("dec\t");

			if (indx)
				getind();

			reg(r1);

			return;

		case 06:
			out("ld\t");

			if (indx)
				getind();

			reg(r1);
			out(",");
			outbyte();

			return;

		case 07:
			out(spec1[r1]);

			return;
		}

	case 01:	/* opcodes 40 - 7f hex */
		if (b == 0x76)
			out("halt");
		else	{
			out("ld\t");

			if (indx)
				getind();

			reg(r1);
			out(",");
			reg(r2);
		}

		return;

	case 02:	/* opcodes 80 - bf hex */
		out(arith[r1]);

		if (indx)
			getind();

		reg(r2);

		return;

	case 03:	/* opcodes c0 - ff hex */
		switch (r2)	{

		case 00:
			out("ret\t");
			cond(r1);

			return;

		case 01:
			if (r1 % 2 == 0)	{
				out("pop\t");
				rpair2(r1);
			}
			else if (indx)	{
				if (r1 / 2 == 2)
					out((indr ? "jp\t(iy)" : "jp\t(ix)"));

				if (r1 / 2 == 3)
					out((indr ? "ld\tsp,iy" : "ld\tsp,ix"));
			}
			else
				out(spec2[r1 / 2]);

			return;

		case 02:
			out("jp\t");
			cond(r1);
			out(",");
			outword();

			return;

		case 03:
			switch (r1)	{

			case 00:
				out("jp\t");
				outword();

				return;

			case 01:
				decode2();

				return;

			case 02:
				out("out\t");
				outbyte();
				out(",a");

				return;

			case 03:
				out("in\ta,");
				outbyte();

				return;

			case 04:
				out("ex\t(sp),hl");

				return;

			case 05:
				out("ex\tde,hl");

				return;

			case 06:
				out("di");

				return;

			case 07:
				out("ei");

				return;
			}

		case 04:
			out("call\t");
			cond(r1);
			out(",");
			outword();

			return;

		case 05:
			if (r1 % 2 == 0)	{
				out("push\t");
				rpair2(r1);
			}
			else if (r1 == 1)	{
				out("call\t");
				outword();
			}
			else if (r1 == 5)
				decode3();
			else
				index(r1);

			return;

		case 06:
			out(arith[r1]);
			outbyte();

			return;

		case 07:
			out("rst\t");
			outnum(r1 * 8);

			return;
		}
	}
}

decode2()
	{
	register int	b;
	register int	op;
	register int	r1;
	register int	r2;

	if (indx)
		getind();

	b = getbyte();
	printf(" %02x", b);

	op = (b >> 6) & 03;
	r1 = (b >> 3) & 07;
	r2 = b & 07;

	switch (op)	{

	case 00:	/* opcodes cb00 - cb3f hex */
		out(logic[r1]);
		reg(r2);

		return;

	case 01:	/* opcodes cb40 - cb7f hex */
		out("bit\t");
comm:
		outdig(r1);
		out(",");
		reg(r2);

		return;

	case 02:	/* opcodes cb80 - cbbf hex */
		out("res\t");
		goto comm;

	case 03:	/* opcodes cbc0 - cbff hex */
		out("set\t");
		goto comm;
	}
}

decode3()
	{
	register int	b;
	register int	op;
	register int	r1;
	register int	r2;

	b = getbyte();
	printf(" %02x", b);

	op = (b >> 6) & 03;
	r1 = (b >> 3) & 07;
	r2 = b & 07;

	if (op == 0 || op == 3)	{
		out("???");

		return;
	}

	if (op == 1)
		switch (r2)	{

		case 00:
			if (r1 != 6)	{
				out("in\t");
				reg(r1);
				out(",(c)");
			}
			else
				out("???");

			return;

		case 01:
			if (r1 != 6)	{
				out("out\t(c),");
				reg(r1);
			}
			else
				out("???");

			return;

		case 02:
			out((r1 % 2 ? "adc\t" : "sbc\t"));
			if (indx)
				out((indr ? "iy," : "ix,"));
			else
				out("hl,");

			rpair1(r1);

			return;

		case 03:
			out("ld\t");
			if (r1 % 2 == 0)	{
				out("(");
				outword();
				out("),");
				rpair2(r1);
			}
			else	{
				rpair2(r1);
				out(",(");
				outword();
				out(")");
			}

			return;

		case 04:
			if (r1 == 0)
				out("neg");
			else
				out("???");

			return;

		case 05:
			if (r1 == 0)
				out("retn");
			else if (r1 == 2)
				out("reti");
			else
				out("???");

			return;

		case 06:
			if (r1 % 2 == 0 && r1 < 5)	{
				out("im");
				outdig(r1 / 2);
			}
			else
				out("???");

			return;

		case 07:
			if (r1 < 2)	{
				out("ld\t");
				out((r1 ? "r" : "i"));
				out(",a");
			}
			else if (r1 < 4)	{
				out("ld\ta,");
				out((r1 == 3 ? "r" : "i"));
			}
			else if (r1 < 6)
				out((r1 == 5 ? "rld" : "rrd"));
			else
				out("???");

			return;
		}

	if (op == 2)	{
		if (r1 < 4 || r2 > 3)
			out("???");
		else
			out(extend[r2 * 4 + (r1 - 4)]);
	}
}

index(n)
register int	n;
	{
	register int	b;

	indx = 1;
	indr = (n != 3);
	ind = -1;

	b = getbyte();
	printf(" %02x", b);

	decode(b);

	indx = indr = 0;
}

getind()
	{

	ind = getbyte();
	printf(" %02x", ind);
}
