	;
	;	Source Filename:	XMODEM/SRC
	;	Object Filename:	XMODEM/CMD
	;
	;	Program Author:		Steven Bradley
	;	Creation Date:		01-27-84
	;	Version:		2.02
	;
	;	Last changed on:	06-05-84
	;
	;	This program is supplied for your personal and
	;	non-commercial use only.  No commercial use is
	;	permitted.   Any  distribution  for profit  is
	;	prohibited.  Distribution  to any  system that
	;	charges  for  computer  access  is  prohibited
	;	unless  written permission  has been  obtained
	;	from the program author.
	;
	;	Please send problem reports and suggestions
	;
	;	To:	Steven Bradley
	;		121 Cambridge Drive
	;		Longwood, Florida  32779
	;
	;	Or call (305) 788-1968
	;
	XKEY	EQU	0		; Bit for the 'X' key
	SOH	EQU	1		; Start of header
	BRKKEY	EQU	2		; Break key bit
	EOL	EQU	3		; End of line
	EOT	EQU	4		; End of transmission
	DWNARR	EQU	4		; Down arrow pressed
	ACK	EQU	6		; Acknowledge
	BELL	EQU	7		; Ding-dong!
	BCKSPC	EQU	8		; Backspace
	LF	EQU	10		; Linefeed
	CR	EQU	13		; Carriage return
	ILLFNM	EQU	19		; Illegal filename error
	INPBYT	EQU	19		; Input byte routine
	NAK	EQU	21		; Negative acknowledge
	CANCEL	EQU	24		; Cancel (ctrl-x)
	OUTBYT	EQU	27		; Output byte routine
	EOF	EQU	28		; End of file error
	LCTOUC	EQU	32		; Lower to uppercase
	SPACE	EQU	32		; Space
	COMMA	EQU	44		; Comma
	CHROUT	EQU	51		; Character to crt
	FEXIST	EQU	53		; File exists error
	OUTMEM	EQU	59		; Out of memory
	INPUT	EQU	40H		; Line input routine
	MODEL3	EQU	49H		; Test for model III
	LCCHAR	EQU	60H		; Test for lowercase char
	CONFIG	EQU	6DH		; 8-1-N configuration
	HIGH	EQU	80H		; Bit 7 value
	RETURN	EQU	0C9H		; Return instr.
	MR	EQU	0E8H		; Master reset (rs232)
	MODEM	EQU	0E8H		; Modem status port
	CARDET	EQU	5		; Carrier detect
	BAUD	EQU	0E9H		; Set baud location
	RSCTRL	EQU	0EAH		; RS232 control port
	STATUS	EQU	0EAH		; RS232 status port
	DRECVD	EQU	7		; Data received
	XEMPTY	EQU	6		; Transmit buffer empty
	OVRERR	EQU	5		; Over-run error
	FRMERR	EQU	4		; Framing error
	RSDATA	EQU	0EBH		; RS232 data port
	PORT	EQU	0FEH		; Custom options port
	M1OR3	EQU	125H		; Model I/III addr check
	VIDEO3	EQU	473H		; Model III video driver
	P10TBL	EQU	13D8H		; Powers of ten table
	XYZVEC	EQU	3808H		; XYZ keyboard vector
	CTLVEC	EQU	3840H		; Control keys
	SHIFT	EQU	3880H		; Shift key
	VIDDCB	EQU	401EH		; Video DCB
	DOS	EQU	402DH		; DOS exit
	NMSERR	EQU	4030H		; No message error exit
	HIMEM1	EQU	4049H		; Model I himem
	ERROR	EQU	4409H		; Error exit
	HIMEM3	EQU	4411H		; Model III himem
	GFSPEC	EQU	441CH		; Get filespec
	OPENN	EQU	4420H		; Open new file
	OPENE	EQU	4424H		; Open old file
	CLOSE	EQU	4428H		; Close file
	KILL	EQU	442CH		; Kill file
	MSGOUT	EQU	4467H		; Display message
	ORIGIN	EQU	5300H		; Origin of program
	STACK	EQU	ORIGIN		; Stack location
	;
	BR50	EQU	0		; Baud rate values
	BR75	EQU	11H
	BR110	EQU	22H
	BR135	EQU	33H
	BR150	EQU	44H
	BR300	EQU	55H
	BR600	EQU	66H
	BR1200	EQU	77H
	BR1800	EQU	88H
	BR2000	EQU	99H
	BR2400	EQU	0AAH
	BR3600	EQU	0BBH
	BR4800	EQU	0CCH
	BR7200	EQU	0DDH
	BR9600	EQU	0EEH
	BR1920	EQU	0FFH
	;
		ORG	ORIGIN
	;
	START	PUSH	HL		; Save command pointer
		LD	HL,(HIMEM1)	; Model I addresses
		LD	DE,VIDEO1
		LD	BC,3000H
		LD	A,(M1OR3)	; Check model
		CP	MODEL3		; Is it a model III?
		JR	NZ,CM1OR3	; No, a model I
		LD	HL,(HIMEM3)	; Model III addresses
		LD	DE,VIDEO3
		LD	BC,4000H
	CM1OR3	LD	(NEWDVR),DE	; Store video driver
		LD	(RSIDLY),BC	; and input delay
		LD	DE,ENDPGM	; Get end of pgm addr
		OR	A		; Clear carry
		SBC	HL,DE		; Enough memory?
		POP	HL		; Restore command pointer
		LD	A,OUTMEM	; Out of memory err code
		JP	C,ERROR		; and take error exit
		XOR	A		; Turn off any custom
		OUT	(PORT),A	; port 254 options
		LD	(STKSAV),SP	; Save stack pointer
		LD	SP,STACK	; and set new stack
		PUSH	HL
		CALL	ILPRNT
		DEFB	LF
		DEFM	'XMODEM File Transfer Utility - Version 2.02 / June 5, 1984'
		DEFB	LF
		DEFM	'Written by Steven Bradley.     *** Not for sale. ***'
		DEFB	CR
		POP	HL
	GETOPT	LD	A,(HL)		; Get option
		CP	CR		; CR?
		JP	NZ,CHKOPT	; No, so check the option
	BADOPT	CALL	ILPRNT		; Missing or bad option
		DEFB	LF
		DEFB	BELL
		DEFM	'Parameters available are:'
		DEFB	LF
		DEFB	LF
		DEFM	'Receive a new file:               R {filename}'
		DEFB	LF
		DEFM	'Send an existing file:            S {filename}'
		DEFB	LF
		DEFM	'Initialize the RS232 interface:   I {=baud rate}'
		DEFB	CR
		IN	A,(MODEM)	; Check for carrier
		BIT	CARDET,A	; Any present?
		JP	Z,EXIT		; Yes, so skip this cmd
		CALL	ILPRNT
		DEFM	'Direct transfer, no modems:       X'
		DEFB	CR
	EXIT	LD	SP,(STKSAV)	; Restore system stack
		JP	DOS		; and exit to DOS
	;
	CHKOPT	CP	LCCHAR		; Is it lowercase?
		JR	C,NOTLCO	; No, do not convert
		SUB	LCTOUC		; Make it uppercase
	NOTLCO	LD	(OPTSAV),A	; Save option
		CP	'R'		; Receive?
		JR	Z,RECSND
		CP	'S'		; Send?
		JR	Z,RECSND
		CP	'I'		; Initialize RS232 board?
		JP	Z,RSINIT
		PUSH	AF
		IN	A,(MODEM)	; Check for carrier
		BIT	CARDET,A	; any present?
		JP	Z,BADOPT	; Yes, so bad option
		POP	AF
		CP	'X'		; Direct transfer?
		JP	Z,NMDMCK
		JP	BADOPT		; Bad option
	;
	FNDCHR	INC	HL		; Point to next character
		LD	A,(HL)		; Get the char.
		CP	SPACE		; Is it a space?
		JR	Z,FNDCHR	; Yes, so look some more
		CP	COMMA		; Is it a comma?
		JR	Z,FNDCHR	; Yes, so look some more
		CP	CR		; Set Z flag if CR
		RET			; and return
	;
	FNDOPT	CALL	FNDCHR		; Get next character
		JP	Z,EXIT		; If CR, end options chk
		JP	GETOPT		; Go to normal checking
	;
	RECSND	CALL	FNDCHR		; Get next character
		JP	NZ,GFILE	; If not CR, go get file
		DEC	HL		; HL=HL-1
		LD	(CMDPTR),HL	; Save command pointer
		LD	A,(OPTSAV)	; Get option key
		CP	'R'		; Receive?
		JR	NZ,ASDMSG	; No, ask for send name
		CALL	ILPRNT
		DEFB	LF
		DEFM	'Receiving'
		DEFB	EOL
		JR	ASKNAM		; Go finish question
	;
	ASDMSG	CALL	ILPRNT		; Ask for send name
		DEFB	LF
		DEFM	'Sending'
		DEFB	EOL
	ASKNAM	CALL	ILPRNT		; Finish question
		DEFM	' - Enter filename:  '
		DEFB	BELL
		DEFB	EOL
		LD	B,23		; Max of 23 characters
		LD	HL,DSKBUF	; into disk buffer (temp)
		CALL	INPUT		; Get filename
		JP	C,EXIT		; If break - exit
		LD	A,(HL)		; Check for no input
		CP	CR		; CR only?
		JP	Z,EXIT		; Yes - exit
		XOR	A		; Set entry status
	GFILE	PUSH	AF		; Save entry status
		LD	DE,FILE		; Get filename
		CALL	GFSPEC		; Create filespec
		JR	Z,NAMEOK	; If no error, else
		LD	A,ILLFNM+HIGH	; must be bad name
		CALL	ERROR		; Display error
		JP	EXIT		; and abort
	;
	NAMEOK	POP	AF		; Get entry status
		JR	Z,XOPEN		; If asked for name
		DEC	HL		; HL=HL-1
		LD	(CMDPTR),HL	; Save command pointer
	XOPEN	PUSH	DE
		LD	B,23		; Format filename for
		LD	HL,FNAME	; displaying later
	XOPENL	LD	A,(DE)
		CP	EOL
		JR	Z,XOPENM
		CP	CR
		JR	Z,XOPENM
		CP	'A'
		JR	C,CHROK
		OR	LCTOUC
		SUB	LCTOUC
	CHROK	LD	(HL),A
		INC	DE
		INC	HL
		DJNZ	XOPENL
	XOPENM	LD	(HL),CR
		POP	DE
		LD	B,0		; LRL=256
		LD	HL,DSKBUF	; Sector buffer
		LD	A,(OPTSAV)	; Get option key
		CP	'R'		; Is it receive?
		JR	NZ,OPENSF	; No, it is send
		CALL	OPENN		; Open new file
		JR	Z,RFOPEN	; Go if no error
	OPNERR	OR	HIGH		; Make it CALLable
		CALL	ERROR		; Display error
		JP	EXIT		; and abort
	;
	RFOPEN	JR	C,RECEIV	; Go if new file created
		CALL	CLOSEF		; else close file because
		LD	A,FEXIST	; file already exists err
		JR	OPNERR		; Display error and exit
	;
	OPENSF	CALL	OPENE		; Open existing file
		JP	Z,SEND		; Go to send if no error
		JR	OPNERR		; Show error and exit
	;
	RECEIV	LD	HL,FMSG
		CALL	MSGOUT
		CALL	ILPRNT
		DEFB	LF
		DEFM	'Enter ctrl-x to abort file transfer.'
		DEFB	LF
		DEFB	LF
		DEFM	'Ready to receive - awaiting transmission.'
		DEFB	CR
		CALL	INITRS		; Receive-send init
		XOR	A		; Zero first block
		LD	(FIRST),A	; SOH found status
		LD	A,NAK		; Send a negative
		CALL	CRSOUT		; acknowledge
	RECFIL	CALL	INCBLK		; Increment block count
		CALL	RECBKS		; Receive a block
		JR	C,RECEND	; Go if end of file
		LD	A,(BLOCKS)	; Increment the
		INC	A		; number of
		LD	(BLOCKS),A	; transferred
		CP	20		; Have there been 20?
		CALL	Z,SAVBLK	; Yes, so save the blocks
		CALL	SNDACK		; Send acknowledge
		JR	RECFIL		; and go receive more
	;
	RECEND	LD	A,(BLOCKS)	; Get blocks xfered count
		OR	A		; Zero blocks?
		CALL	NZ,SAVBLK	; If blocks to be saved
		CALL	CLOSEF		; Close the file
		OR	A		; Any error occured?
		JP	NZ,ABORT	; Yes, so send cancel
		CALL	SNDACK		; No, so send acknowledge
		JP	SUCCES		; and xfer completed
	;
	RECBKS	XOR	A		; Zero number of tries
		LD	(TRIES),A	; counter
	RECBLK	LD	B,10		; 10 seconds per attempt
		CALL	CRSINP		; Look for a character
		JR	C,RTRIES	; If no char, check tries
		CP	CANCEL		; Cancelled?
		JP	Z,ABORT		; Yes, so abort transfer
		CP	SOH		; Is it start of header?
		JR	Z,RECBKH	; Yes, so get first block
		CP	EOT		; End of transmission?
		SCF			; Maybe...
		RET	Z		; Yes, so return
	RTRIES	CALL	WNCHRS		; No, wait until no chars
		LD	A,NAK		; and then send negative
		CALL	CRSOUT		; acknowledge
	BADACK	LD	A,(FIRST)	; Check for initial block
		OR	A		; Has it been started?
		JR	Z,CRTRYS	; No error display needed
		CALL	DPYBLK		; Display error block #
		CALL	ILPRNT		; Display * error status
		DEFM	'*   '
		DEFB	EOL
	CRTRYS	LD	A,(TRIES)	; Get number of attempts
		INC	A		; and increment it by 1
		LD	(TRIES),A	; Store # attempts left
		CP	10		; Have there been 10?
		JR	NZ,RECBLK	; If not 10, try again
		JP	ABORT		; else abort transfer!
	;
	RECBKH	LD	A,HIGH		; Since an SOH was recvd
		LD	(FIRST),A	; rest of blk should come
		CALL	DPYBLK		; Display current block #
		LD	BC,RTRIES	; Save error return addr
		PUSH	BC		; for convenient exits
		LD	B,1		; 1 second attempt
		CALL	CRSINP		; Look for a character
		RET	C		; If no character, exit
		LD	D,A		; Save first block number
		LD	B,1		; 1 second attempt
		CALL	CRSINP		; Look for a character
		RET	C		; If no character, exit
		CPL			; Make normal block #
		CP	D		; Is it the same?
		RET	NZ		; No, so error exit
		LD	A,(BLKCNT)	; Check block number
		CP	D		; Is it the same?
		JR	Z,NEWBLK	; Yes, go get block
		DEC	A		; Check for bad ack char
		CP	D		; Was it previous block?
		RET	NZ		; No, so error exit
		CALL	WNCHRS		; Yes, so wait until all
		CALL	SNDACK		; sent, then send an ack
		POP	HL		; Fix stack
		JR	BADACK		; and try block again
	;
	NEWBLK	LD	HL,(BLKADR)	; Get start of block
		LD	E,128		; 128 bytes expected
		LD	C,0		; Zero checksum
	RECBLP	LD	B,1		; 1 second attempt
		CALL	CRSINP		; Look for character
		RET	C		; If no character, exit
		LD	(HL),A		; Store character
		INC	HL		; Increment buffer ptr
		DEC	E		; Decrement # received
		JR	NZ,RECBLP	; and loop if not 0
		LD	D,C		; Save calculated chksum
		LD	B,1		; 1 second attempt
		CALL	CRSINP		; Look for character
		RET	C		; If no character, exit
		CP	D		; Do checksums match?
		RET	NZ		; If no match, error exit
		LD	(BLKADR),HL	; Save new address
		POP	HL		; and pop the error addr
		RET			; and we are done
	;
	SAVBLK	LD	HL,BUFFER	; Get start of buffer
		LD	DE,FILE		; Open file
		LD	C,A		; Number of blocks
	SAVEBK	LD	B,128		; Length of each block
	SAVELP	LD	A,(HL)		; Get a byte
		CALL	OUTBYT		; Write to disk file
		JR	Z,NSERR		; Go if no error
		OR	HIGH		; Make it CALLable
		CALL	ERROR		; Display error
		JP	ABORT		; and abort
	;
	NSERR	INC	HL		; Increment buffer
		DJNZ	SAVELP		; Loop until 128 written
		DEC	C		; Decrement blocks
		JR	NZ,SAVEBK	; Loop until all written
		XOR	A		; Zero number of blocks
		LD	(BLOCKS),A	; transferred
		LD	HL,BUFFER	; Reset block buffer
		LD	(BLKADR),HL	; to the start of buffer
		RET
	;
	SEND	LD	HL,(FILE+12)	; Get # of full records
		ADD	HL,HL		; # of 128 byte records
		LD	A,(FILE+8)	; and see if any in eof
		OR	A		; Any bytes in eof sec?
		JR	Z,CALC		; No, so go calc
		INC	HL		; Increment # of records
		CP	129		; See how many recs, 1-2
		JR	C,CALC		; If 1 record, end check
		INC	HL		; otherwise 2 records
	CALC	PUSH	HL		; Save number of records
		XOR	A		; Zero number of
		LD	(BLOCKS),A	; blocks counter
		LD	DE,0		; Init seconds counter
		LD	BC,5		; Init i/o time used
		LD	A,132		; Number bytes per record
		PUSH	AF		; and save it to stack
		JR	CALENT		; Enter calculation loop
	;
	CALC1	POP	AF		; Get number left in rec
		SUB	30		; 30 cps
		PUSH	AF		; Save number left in rec
		JR	C,CALC2		; End loop if not enough
	;
		INC	DE		; Increment # of seconds
		JR	CALC1		; and resume calculating
	;
	CALC2	POP	AF		; Get number left
		ADD	A,162		; Add previous & next rec
		PUSH	AF		; Store new value
		LD	A,(BLOCKS)	; Get record count
		INC	A		; Increment it
		CP	2		; Have there been 2?
		JR	NZ,CALC3	; No, so nothing done
	;
		INC	BC		; Inc i/o seconds count
		XOR	A		; and zero record count
	;
	CALC3	LD	(BLOCKS),A	; Store new count
		DEC	HL		; Decrement # of records
	CALENT	LD	A,H		; Check for end of record
		OR	L		; End of records?
		JR	NZ,CALC1	; No, so go get more
	;
		POP	AF		; Fix the stack
		PUSH	BC		; Save i/o seconds
		PUSH	DE		; Save seconds for later
	;
		EX	DE,HL		; Move DE to HL
		ADD	HL,BC		; Get total seconds
		LD	BC,60		; Number to divide by
		CALL	DIVIDE		; Divide 60 into HL
		PUSH	DE		; Save remainder
		LD	B,3		; 3 places
		LD	A,B		; Suppress leading zeroes
		LD	DE,BM300	; Where to store it
		CALL	BINASC		; Convert to ascii
		POP	HL		; Get remainder
		LD	B,2		; 2 places
		LD	A,B		; Suppress leading zeroes
		LD	DE,BS300	; Where to store it
		CALL	BINASC		; Convert to ascii
		POP	HL		; Now to calc for 1200
		LD	BC,4		; Number to divide by
		CALL	DIVIDE		; Divide 4 into HL
		POP	BC		; Get i/o seconds
		ADD	HL,BC		; and add for total secs
		LD	BC,60		; Number to divide by
		CALL	DIVIDE		; Divide 60 into HL
		PUSH	DE		; Save remainder
		LD	B,3		; 3 places
		LD	A,B		; Suppress leading zeroes
		LD	DE,BM1200	; Where to store it
		CALL	BINASC		; Convert to ascii
		POP	HL		; Get remainder
		LD	B,2		; 2 places
		LD	A,B		; Suppress leading zeroes
		LD	DE,BS1200	; Where to store it
		CALL	BINASC		; Convert to ascii
	;
		POP	HL		; Get number of records
		PUSH	HL		; and keep it saved
		LD	B,5		; 5 places
		LD	A,B		; Suppress leading zeroes
		LD	DE,NUMREC	; Where to store it
		CALL	BINASC		; Convert to ascii
	;
		POP	HL		; Get number of records
		LD	BC,8		; Divide them by 8 to
		CALL	DIVIDE		; get number of K bytes
		PUSH	DE		; and save the remainder
		LD	B,3		; 3 places
		LD	A,B		; Suppress leading zeroes
		LD	DE,KBYTES	; Where to store it
		CALL	BINASC		; Convert it to ascii
	;
		POP	HL		; Get number of records
		LD	B,10		; Number to multiply by
		CALL	MULT		; Multiply by 10
		LD	BC,8		; Get 10ths of a K
		CALL	DIVIDE		; Go get it
		LD	A,L		; Get value
		ADD	A,'0'		; Make it ascii
		LD	(DBYTES),A	; and store it
	;
		LD	HL,FMSG
		CALL	MSGOUT
		CALL	ILPRNT		; Show message
		DEFB	LF
		DEFM	'File size in Kilobytes:  '
	KBYTES	DEFM	'kkk.'
	DBYTES	DEFM	'd  (1 K-byte = 1024 bytes)
		DEFB	LF
		DEFM	'              Block(s):  '
	NUMREC	DEFM	'nnnnn   (1 Block = 128 bytes)'
		DEFB	LF
		DEFB	LF
		DEFM	'Send time at 1200 baud:    '
	BM1200	DEFM	'mmm minute(s), '
	BS1200	DEFM	'ss second(s).'
		DEFB	LF
		DEFM	'              300 baud:    '
	BM300	DEFM	'mmm minute(s), '
	BS300	DEFM	'ss second(s).'
		DEFB	LF
		DEFB	LF
		DEFM	'Enter ctrl-x to abort file transfer.'
		DEFB	LF
		DEFB	LF
		DEFM	'Ready to send - awaiting initial NAK.'
		DEFB	CR
	;
		CALL	INITRS		; Send initialization
	;
		LD	E,90		; Number of tries for NAK
	;
	GETNAK	LD	B,1		; 1 second attempt
		CALL	CRSINP		; Look for a character
		JR	C,NOCHAR	; If no character
	;
		CP	NAK		; NAK received?
		JR	Z,SNDFIL	; Yes, so go send file
	;
		CP	CANCEL		; Is it cancelled?
		JP	Z,ABORT		; Yes, so go abort xfer
	;
	NOCHAR	DEC	E		; Keep looking?
		JR	NZ,GETNAK	; Yes
		JP	ABORT		; No, abort transfer
	;
	SNDFIL	CALL	INCBLK		; Increment block number
		LD	A,(BLOCKS)	; Check number of blocks
		OR	A		; More needed?
		CALL	Z,GETBKS	; If we have run out
		JR	C,SNDEND	; If end of file
		CALL	SNDBKS		; Send the blocks
		JR	SNDFIL		; and go get/send more
	;
	SNDEND	LD	A,(BLOCKS)	; Check number to send
		OR	A		; Are there any left?
		JR	Z,SNDEOT	; No, so go send EOT
		CALL	SNDBKS		; Send last blocks
		CALL	INCBLK		; Increment block count
		JR	SNDEND		; Loop if more to send
	;
	SNDEOT	CALL	SNDBKS		; Send EOT character
		CALL	CLOSEF		; Close the file
		JP	SUCCES		; and xfer completed
	;
	GETBKS	LD	HL,BUFFER	; Get start of buffer
		LD	(BLKADR),HL	; Store start of block
		LD	DE,FILE		; Open file
		LD	C,0		; Zero blocks read
	;
	LOADBK	LD	B,128		; Length of each block
	;
	LOADLP	CALL	INPBYT		; Read a byte
		JR	Z,NLERR		; Go if no error
	;
		CP	EOF		; End of file?
		JR	Z,LDEOF		; Yes, go to eof routine
	;
		OR	HIGH		; Make it CALLable
		CALL	ERROR		; Display error
		JP	ABORT		; and abort
	;
	NLERR	LD	(HL),A		; Store byte
		INC	HL		; and prepare for next
		DJNZ	LOADLP		; Read rest of block
	;
		INC	C		; Increment blocks read
	;
		LD	A,20		; Check # blocks read
		CP	C		; Have we read 20?
		JR	NZ,LOADBK	; No, so read more
	;
		LD	(BLOCKS),A	; Store number read
		RET			; and return
	;
	LDEOF	LD	A,128		; Check bytes read
		CP	B		; Any bytes read in?
		JR	Z,LDEND		; No, so skip fill
	;
		XOR	A		; Set fill char = 0
	;
	LDFILL	LD	(HL),A		; Store character
		INC	HL		; Increment buffer
		DJNZ	LDFILL		; and loop until filled
	;
		INC	C		; Inc blocks read count
	;
	LDEND	LD	A,C		; Get block count
		LD	(BLOCKS),A	; and store it
		SCF			; Show end of file
		RET			; and we are done
	;
	SNDBKS	XOR	A		; Zero number of tries
		LD	(TRIES),A	; counter
	;
	SNDBLK	LD	A,(BLOCKS)	; Check if any to send
		OR	A		; Are there any blocks?
		JR	Z,SDEOTC	; No, send EOT character
	;
		CALL	DPYBLK		; Since not EOT block
	;
		LD	A,SOH		; Send start of header
		CALL	CRSOUT		; character
	;
		LD	A,(BLKCNT)	; Get block count
		CALL	CRSOUT		; Send it
		CPL			; Complement it
		CALL	CRSOUT		; Send it
	;
		LD	HL,(BLKADR)	; Get start of block
		LD	B,128		; 128 bytes / block
		LD	C,0		; Zero checksum
	;
	SNDBLP	LD	A,(HL)		; Get character
		CALL	CRSOUT		; Send it
		INC	HL		; Prepare for next
		DJNZ	SNDBLP		; and keep sending
	;
		LD	A,C		; Get checksum
		CALL	CRSOUT		; and send it
	;
	SNDAWT	LD	B,10		; 10 seconds per attempt
		CALL	CRSINP		; Look for a character
		JR	C,STRIES	; If no character
	;
		CP	CANCEL		; Is it cancelled?
		JP	Z,ABORT		; Yes, so abort
	;
		CP	ACK		; Acknowledge character?
		JR	NZ,STRIES	; No, so check tries
	;
		LD	A,(BLOCKS)	; Decrement number of
		OR	A		; Is it zero?
		RET	Z		; Yes, so end here
		DEC	A		; Decrement blocks left
		LD	(BLOCKS),A	; and store new number
		LD	(BLKADR),HL	; Store new block addr
		RET			; and we are done
	;
	SDEOTC	LD	A,EOT		; Send EOT
		CALL	CRSOUT		; character
		JR	SNDAWT		; and look for ack
	;
	STRIES	CALL	WNCHRS		; Wait until no chars
		CALL	ILPRNT		; Display * error status
		DEFM	'*   '		;
		DEFB	EOL		;
	;
		LD	A,(TRIES)	; Get number of attempts
		INC	A		; and increment it by 1
		LD	(TRIES),A	; Store # attempts left
		CP	10		; Have there been 10?
		JR	NZ,SNDBLK	; If not 10, try again
		JP	ABORT		; else abort transfer!
	;
	RSINIT	LD	BC,2		; Wait for RS232 data
		CALL	DELAY		; registers to clear
	;
		OUT	(MR),A		; Reset the RS232 board
	;
		INC	HL
		LD	A,(HL)
		CP	'='
		JR	Z,GIBAUD
		DEC	HL
		PUSH	HL
		LD	HL,BDTBL
		IN	A,(BAUD)
		AND	7
		LD	B,0
		LD	C,A
		ADD	HL,BC
		LD	A,(HL)
		JR	CRS232
	GIBAUD	PUSH	HL
		LD	B,0
	FBDLEN	INC	HL
		INC	B
		LD	A,(HL)
		CP	'0'
		JR	C,FBDEND
		CP	'9'+1
		JR	C,FBDLEN
	FBDEND	DEC	B
		POP	DE
		INC	DE
		LD	A,B
		OR	A
		JP	Z,BADOPT
		CP	6
		JP	NC,BADOPT
		CALL	ASCBIN
		PUSH	DE
		PUSH	HL
		POP	BC
		LD	IX,BDCTBL
	FIBDLP	LD	L,(IX+0)
		LD	H,(IX+1)
		LD	A,H
		OR	L
		JP	Z,BADOPT
		LD	A,(IX+2)
		INC	IX
		INC	IX
		INC	IX
		SBC	HL,BC
		JR	NZ,FIBDLP
	CRS232	LD	IX,BDCTBL-3
	GBDRLP	INC	IX
		INC	IX
		INC	IX
		CP	(IX+2)
		JR	NZ,GBDRLP
		PUSH	AF
		LD	L,(IX+0)
		LD	H,(IX+1)
		LD	DE,BAUDMS
		LD	B,5
		LD	A,B
		CALL	BINASC
		POP	AF
		OUT	(BAUD),A	; Set the baud rate
		LD	A,CONFIG	; 8 word, 1 stop, no par.
		OUT	(RSCTRL),A	; Set the configuration
	;
		CALL	ILPRNT		; Display initialized msg
		DEFB	LF
		DEFM	'The serial interface has been configured for xmodem file xfer.'
		DEFB	LF
		DEFM	'Configuration is 8 bit word length, 1 stop bit, and no parity.'
		DEFB	LF
		DEFB	LF
		DEFM	'Baud rate selected:  '
	BAUDMS	DEFM	'nnnnn bps.'
		DEFB	CR
	;
		POP	HL		; Get command pointer
		JP	FNDOPT		; Check for more options
	;
	NMDMCK	LD	A,RETURN	; Set a bypass return
		LD	(MDMCHK),A	; to not check carrier
		PUSH	HL		; Save cmd params
		CALL	ILPRNT
		DEFB	LF
		DEFM	'Modem carrier check disabled for direct serial to serial xfer.'
		DEFB	CR
	;
		POP	HL
		JP	FNDOPT		; Go check next option
	;
	DELAY	PUSH	BC		; Save count
		LD	BC,0		; 1 second of delay
		CALL	60H		; Delay for 1 second
		POP	BC		; Get count
		DEC	BC		; Decrement it
		LD	A,B		; Is it
		OR	C		; zero?
		JR	NZ,DELAY	; No, so delay some more
		RET			; otherwise return
	;
	MULT	PUSH	HL		; Move the value to DE
		POP	DE		; without losing HL
	;
	MULTLP	ADD	HL,DE		; Do the multiplying
		DJNZ	MULTLP		; Until done
		RET			; and then return
	;
	DIVIDE	OR	A		; Clear carry
		LD	DE,0		; To be used as a counter
	;
	DIVLP	SBC	HL,BC		; Subtract
		JR	C,DIVEND	; until carry
		INC	DE		; and increment each time
		JR	DIVLP		; Keep going til too much
	;
	DIVEND	ADD	HL,BC		; Fix value
		EX	DE,HL		; Flip the count and the
		RET			; remainder, then return
	;
	BINASC	LD	(BAFLAG),A	; Zero=spaces option
		LD	IX,P10TBL+10	; Get powers of ten table
		LD	A,B		; Check # of positions
		OR	A		; Zero positions?
		JR	NZ,BA0		; No, so ok
	;
		LD	B,1		; Set to 1 position
		LD	A,B		; and in register A too!
	;
	BA0	CP	6		; Check for too many
		JR	C,BA1		; Go if not too many
	;
		LD	B,5		; Set to 5 positions
		LD	A,B		; and in register A too!
	;
	BA1	DEC	IX		; Get location in table
		DEC	IX		;
		DJNZ	BA1		; and loop until found
	;
		CP	5		; Max value allowed?
		JR	Z,BA2		; Yes, so no check needed
	;
		PUSH	HL		; Save value
		LD	B,(IX-1)	; Get check value
		LD	C,(IX-2)	; to test for too high
		OR	A		; Clear carry flag
		SBC	HL,BC		; Too high?
		POP	HL		; Fix HL
		JR	C,BA2		; Not too high, so skip
	;
		PUSH	BC		; Move BC to HL
		POP	HL		;
		DEC	HL		; Set highest value
	;
	BA2	XOR	A		; Zero leading zeroes
		LD	(LEADNZ),A	; check flag
	;
	BA3	XOR	A		; Zero the A register
		LD	C,(IX+0)	; Get current power of
		LD	B,(IX+1)	; ten from the table
	;
	BA4	SBC	HL,BC		; Subtract values
		JR	C,BA5		; until too much
	;
		INC	A		; Increment ascii value
		JR	BA4		; and keep going
	;
	BA5	ADD	HL,BC		; Fix value
		ADD	A,'0'		; Make ascii character
		PUSH	AF		; Save character
		LD	A,C		; Check for last location
		CP	1		; Is it last?
		JR	Z,BA7		; Yes, no more processing
	;
		POP	AF		; Restore AF
		PUSH	AF		; and keep it on stack
		CP	'0'		; Ascii zero?
		JR	Z,BA6		; Yes, so go process
	;
		LD	A,HIGH		; Set flag to a
		LD	(LEADNZ),A	; non-zero value
	;
	BA6	LD	A,0		; Check for storing
	BAFLAG	EQU	$-1		; leading zeroes
		OR	A		; Store them?
		JR	Z,BA7		; Yes
		LD	A,0		; Check for previous
	LEADNZ	EQU	$-1		; non-zero value stored
		OR	A		; Any found?
		JR	NZ,BA7		; Yes, so store value
		POP	AF		; Get character
		LD	A,SPACE		; Change it to a space
		PUSH	AF		; and restore character
	;
	BA7	POP	AF		; Get character from stk
		LD	(DE),A		; Store character
		INC	DE		; Prepare for next
		LD	A,C		; Check for end
		CP	1		; Have we done yet?
		RET	Z		; Yes, so return
		INC	IX		; No, so get next
		INC	IX		; power of ten position
		JR	BA3		; and resume converting
	;
	ASCBIN	LD	IX,P10TBL+10	; Obtain powers of ten
		LD	HL,0		; Initialize HL to zero
		LD	A,B		; Check for zero pos(s)
		OR	A		; Zero?
		JR	NZ,AB0		; No, so skip section
	;
		LD	B,1		; Set field to 1
		LD	A,B		; and store new value
	;
	AB0	CP	6		; Check for too many!
		JR	C,AB1		; If less than 6
		LD	B,5		; Set to max allowed
	;
	AB1	DEC	IX		; Find place in table
		DEC	IX		;
		DJNZ	AB1		; Until B=0
	;
	AB2	XOR	A		; Clear flags
		LD	C,(IX+0)	; Obtain power of ten
		LD	B,(IX+1)	;
		LD	A,(DE)		; Get value from buffer
		SUB	'0'		; and make it 0-9 binary
	;
	AB3	SUB	1		; Decrement it
		JR	C,AB4		; until too many
		ADD	HL,BC		; Accum value if not
		JR	AB3		; and keep looping
	;
	AB4	LD	A,C		; Check for end
		CP	1		; Are we there?
		RET	Z		; Yes, so return
		INC	DE		; else get next position
		INC	IX		; and next power of ten
		INC	IX		;
		JR	AB2		; and keep looping
	;
	ILPRNT	POP	HL		; Get message address
		LD	A,(HL)		; and char found there
		INC	HL		; Increment for next char
		PUSH	HL		; and push back on stack
	;
		CP	EOL		; End of line?
		RET	Z		; Yes, so we are done
	;
		PUSH	AF		; Save AF and DE
		PUSH	DE		;
		CALL	CHROUT		; Display character
		POP	DE		; Restore DE and AF
		POP	AF		;
	;
		CP	CR		; Was it a CR?
		RET	Z		; Yes, so we are done
	;
		JR	ILPRNT		; Look for next character
	;
	CLOSEF	LD	DE,FILE		; Get open file
		CALL	CLOSE		; try and close it
		RET	Z		; Done if no error
		OR	HIGH		; Make it CALLable
		JP	ERROR		; and return to previous
	;
	ABORT	IN	A,(MODEM)	; Check for carrier
		BIT	CARDET,A	; Carrier detected?
		JR	NZ,ABORT1	; No, so skip cancel send
	;
		CALL	WNCHRS		; Wait until no chars
		LD	A,CANCEL	; Send the cancel char
		CALL	CRSOUT		; to show aborting
	;
	ABORT1	CALL	VIDFIX		; Fix the video output
		LD	DE,FILE		; Get open file
		LD	A,(OPTSAV)	; Check receive or send
		CP	'R'		; Receive?
		JR	NZ,SNDABT	; No, must be send
	;
		CALL	KILL		; Kill received file
		JR	RECABT		; Exit to receive abort
	;
	SNDABT	CALL	CLOSEF		; Close send file
	RECABT	JR	Z,DPYABT	; Display abort message
		OR	HIGH		; Make it CALLable
		CALL	ERROR		; Display error
	;
	DPYABT	CALL	ILPRNT		; Display message
		DEFB	BELL
		DEFB	LF
		DEFB	LF
		DEFM	'>> File transfer aborted!'
		DEFB	CR
	;
		JP	EXIT		; and take normal exit
	;
	SUCCES	CALL	VIDFIX		; Fix video output
		CALL	ILPRNT		; Display message
		DEFB	BELL
		DEFB	LF
		DEFB	LF
		DEFM	'>> File transfer completed.'
		DEFB	CR
	;
		LD	HL,(CMDPTR)	; Get command pointer
		JP	FNDOPT		; and see if more waiting
	;
	VIDFIX	LD	HL,(VIDSAV)	; Get old video driver
		LD	(VIDDCB),HL	; and store it
		RET			; and return
	;
	INCBLK	PUSH	AF		; Save AF
		LD	A,(BLKCNT)	; Get block count
		INC	A		; and increment it
		LD	(BLKCNT),A	; and save it
		POP	AF		; Restore AF
		RET			; then return
	;
	SNDACK	LD	A,ACK		; Send acknowledge
		JP	CRSOUT		; character
	;
	WNCHRS	LD	B,1		; 1 second attempt
		CALL	CRSINP		; Look for character
		JR	NC,WNCHRS	; Loop if character found
		RET			; otherwise return
	;
	ABTCHK	LD	A,(CTLVEC)	; Get control keys info
		BIT	BRKKEY,A	; Break pressed?
		JR	Z,CTLXCK	; No, so check ctrl-x
	;
	BRKLP	LD	A,(CTLVEC)	; Get control keys info
		BIT	BRKKEY,A	; Break still held down?
		JR	NZ,BRKLP	; Yes, wait 'til released
	ABTKEY	JP	ABORT		; Abort transfer
	;
	CTLXCK	LD	A,(SHIFT)	; Check shift key
		OR	A		; Is it pressed?
		JR	Z,MDMCHK	; No, so check modem
		LD	A,(CTLVEC)	; Check down arrow
		BIT	DWNARR,A	; Is it pressed?
		JR	Z,MDMCHK	; No, so check modem
		LD	A,(XYZVEC)	; Check for key X
		BIT	XKEY,A		; Is it pressed?
		JR	Z,MDMCHK	; No, so check modem
	;
	CTLXLP	LD	A,(SHIFT)	; Wait 'til keys released
		OR	A		; Is shift pressed?
		JR	NZ,CTLXLP	; Yes, so try again
		LD	A,(CTLVEC)	; Check down arrow
		BIT	DWNARR,A	; Is it pressed?
		JR	NZ,CTLXLP	; Yes, so try again
		LD	A,(XYZVEC)	; Check for key X
		BIT	XKEY,A		; Is it pressed?
		JR	NZ,CTLXLP	; Yes, so try again
		JR	ABTKEY		; Jump to abort routine
	;
	MDMCHK	NOP			; If bypass = return
		IN	A,(MODEM)	; Check for carrier
		BIT	CARDET,A	; Carrier present?
		RET	Z		; Yes, so we are done
	;
		CALL	ILPRNT		; Display a message
		DEFB	BELL
		DEFB	LF
		DEFB	LF
		DEFM	'>> No carrier detected!'
		DEFB	EOL
	;
		JP	ABORT1		; Abort transfer
	;
	INITRS	XOR	A		; Zero some counters
		LD	(BLOCKS),A	; Blocks transferred
		LD	(BLKCNT),A	; Block count
		LD	(DPYHDR),A	; Zero to dpy blk msg
		LD	HL,BUFFER	; Set block address
		LD	(BLKADR),HL	; to start of buffer
		IN	A,(RSDATA)	; Clear RS232 flags/port
	;
		LD	HL,(VIDDCB)	; Get old video driver
		LD	(VIDSAV),HL	; and save it
		LD	HL,0		; Get new video driver
	NEWDVR	EQU	$-2		; Location of driver
		LD	(VIDDCB),HL	; Store new driver
	;
		RET			; and we are done
	;
	DPYBLK	CALL	DPYHDR		; Display block message
		LD	A,BCKSPC	; Move cursor back two
		CALL	CHROUT		; positions by sending
		LD	A,BCKSPC	; two backspace codes
		CALL	CHROUT		; to the screen
		LD	A,(BLKCNT)	; Get current block count
		PUSH	AF		; and save for low bits
		CALL	HIBITS		; Display high nibble
		POP	AF		; Restore for low bits
		JP	LOBITS		; and display low nibble
	;
	HIBITS	RRCA			; We want the high
		RRCA			; nibble here, so rotate
		RRCA			; the four bits into
		RRCA			; position
	;
	LOBITS	AND	15		; Get first 4 bits only
		CP	10		; Is it > 9 ?
		JR	C,NOTAF		; No, so it is not A - F
	;
		ADD	A,7		; A-F after conversion
	;
	NOTAF	ADD	A,'0'		; Make it ascii
		JP	CHROUT		; and display it (done)
	;
	DPYHDR	NOP			; Executes once/file xfer
		LD	A,RETURN	; Make sure only once
		LD	(DPYHDR),A	; by storing a return
	;
		LD	A,(OPTSAV)	; Get option
		CP	'R'		; Is it receive?
		JR	NZ,DPYSDH	; No, must be send
	;
		CALL	ILPRNT		; Display block message
		DEFB	LF
		DEFM	'Receiving'
		DEFB	EOL
		JR	ENDHDR		; End block message
	;
	DPYSDH	CALL	ILPRNT		; Display block message
		DEFB	LF
		DEFM	'Sending'
		DEFB	EOL
	;
	ENDHDR	CALL	ILPRNT		; Display rest of blk msg
		DEFM	' Block:    '
		DEFB	EOL
		RET			; Now we are done
	;
	VIDEO1	JR	C,NORMAL	; If carry, use rom
		LD	L,(IX+3)	; otherwise get cursor
		LD	H,(IX+4)	; screen location
		LD	A,C		; and the character
		SUB	20H		; Lower it 20H
		CP	LCCHAR		; Is it lowercase?
		LD	A,C		; Obtain original again
		JP	C,47DH		; Yes, it is lc so exit
	NORMAL	JP	458H		; else use normal entry
	;
	CRSINP	PUSH	DE		; Save DE
	;
	RSINP1	LD	DE,3000H	; Count = 1 second
	RSIDLY	EQU	$-2		; Number of tries
	;
	RSINP2	CALL	ABTCHK		; Check for abort
		IN	A,(STATUS)	; Check receive buffer
		BIT	DRECVD,A	; Any data received?
		JR	NZ,DARECV	; Yes, so exit loop
	;
		DEC	DE		; Decrement counter
		LD	A,D		; Check for end of loop
		OR	E		; End?
		JR	NZ,RSINP2	; No, so try again
	;
		DJNZ	RSINP1		; Loop if more secs
	;
	RSIERR	POP	DE		; Restore DE
		IN	A,(RSDATA)	; Clear the RS data reg
		SCF			; Set carry=no char recvd
		RET			; and we are done
	;
	DARECV	IN	A,(STATUS)	; Check for errors
		BIT	OVRERR,A	; Overrun error?
		JR	NZ,RSIERR	; Yes, take error exit
	;
		BIT	FRMERR,A	; Framing error?
		JR	NZ,RSIERR	; Yes, take error exit
	;
		IN	A,(RSDATA)	; Get character
		POP	DE		; Restore DE
	;
		PUSH	AF		; Save character
		ADD	A,C		; Perform
		LD	C,A		; checksum
		POP	AF		; Restore character
		OR	A		; Clear carry if set
		RET			; and we are done
	;
	CRSOUT	PUSH	AF		; Save character
		ADD	A,C		; Perform
		LD	C,A		; checksum
	;
	RSOUT	CALL	ABTCHK		; Check for abort
		IN	A,(STATUS)	; Check xmit buffer
		BIT	XEMPTY,A	; Is it empty?
		JR	Z,RSOUT		; No, so keep looping
	;
		POP	AF		; Restrieve character
		OUT	(RSDATA),A	; and sent it
		RET			; and we are done
	;
	BDTBL	DEFB	BR110
		DEFB	BR150
		DEFB	BR300
		DEFB	BR600
		DEFB	BR1200
		DEFB	BR2400
		DEFB	BR4800
		DEFB	BR9600
	;
	BDCTBL	DEFW	50
		DEFB	BR50
		DEFW	75
		DEFB	BR75
		DEFW	110
		DEFB	BR110
		DEFW	135
		DEFB	BR135
		DEFW	150
		DEFB	BR150
		DEFW	300
		DEFB	BR300
		DEFW	600
		DEFB	BR600
		DEFW	1200
		DEFB	BR1200
		DEFW	1800
		DEFB	BR1800
		DEFW	2000
		DEFB	BR2000
		DEFW	2400
		DEFB	BR2400
		DEFW	3600
		DEFB	BR3600
		DEFW	4800
		DEFB	BR4800
		DEFW	7200
		DEFB	BR7200
		DEFW	9600
		DEFB	BR9600
		DEFW	19200
		DEFB	BR1920
		DEFW	0
	;
	FMSG	DEFB	LF
		DEFM	'File = '
	FNAME	DEFS	24
	STKSAV	DEFS	2		; Save area for stack ptr
	VIDSAV	DEFS	2		; Save area for video dvr
	OPTSAV	DEFS	1		; Save area for opt key
	TRIES	DEFS	1		; Number of attempts
	BLKCNT	DEFS	1		; Block counter
	BLOCKS	DEFS	1		; Number transferred
	BLKADR	DEFS	2		; Current buffer pointer
	CMDPTR	DEFS	2		; End of current command
	FIRST	DEFS	1		; First block flag
	FILE	DEFS	50		; Filespec work area
	DSKBUF	DEFS	256		; Disk sector buffer
	BUFFER	DEFS	2560		; Big buffer for blocks
	ENDPGM	EQU	$-1		; Last addr used by pgm
	;
		END	START
Downloaded from Guy Omer of 8/N/1 #1 at 904/377-1200 in Gainesville,FL.


