;Wave1: Display waveforms on screen.
;Ver 1.1 on 25-May-85
; by Nick Andrew for Bresike.
;
	ORG	5300H
START	LD	SP,START
	CALL	SIGNON
	CALL	SETUP
;
LOOP	CALL	GET_VALUE
	CALL	DISPLAY
	LD	A,(3880H)
	OR	A
	JR	Z,NO_SHIFT
	LD	HL,0
	LD	(DELAY+1),HL
NO_SHIFT
	LD	A,(3840H)
	BIT	2,A
	JP	NZ,402DH
	BIT	3,A
	JR	Z,NO_UP
	LD	HL,(DELAY+1)
	LD	A,H
	OR	L
	JR	Z,LOOP
	LD	DE,8
	OR	A
	SBC	HL,DE
	LD	(DELAY+1),HL
	JR	LOOP
NO_UP
	BIT	4,A
	JR	Z,NO_DOWN
	LD	HL,(DELAY+1)
	LD	DE,32
	ADD	HL,DE
	LD	(DELAY+1),HL
	JR	LOOP
NO_DOWN	JR	LOOP
;
GET_VALUE
	LD	A,(VALUE)
	LD	(OLD_VALU),A
	XOR	A
	OUT	(0),A
	LD	B,50
	DJNZ	$
	CALL	DELAY
	IN	A,(0)
	LD	(VALUE),A
	RET
;
DELAY	LD	BC,0
	LD	A,B
	OR	C
	RET	Z
	CALL	60H
	RET
;
GET_VALUE_X
	CALL	DELAY
	LD	A,(VALUE)
	LD	(OLD_VALU),A
	LD	A,R
	AND	15
	SUB	8
	LD	B,A
	LD	A,(VALUE)
	ADD	A,B
	LD	(VALUE),A
	RET
;
DISPLAY
	LD	A,(OLD_VALU)
	CALL	SCALE
	LD	(SC_OV),A
	LD	A,(VALUE)
	CALL	SCALE
	LD	(SC_VAL),A
	LD	A,(COLUMN)
	INC	A
	CP	128
	JR	NZ,DISP_1
	XOR	A
DISP_1	LD	(COLUMN),A
	CALL	CLR_COLUMN
	LD	A,(SC_OV)
	LD	B,A
	LD	A,(SC_VAL)
	CP	B
	JR	NZ,NOT_EQ
	LD	(COL_TOP),A
	LD	(COL_BOT),A
	JR	DISP_2
NOT_EQ	JR	C,NOT_GE
	LD	A,(SC_OV)
	INC	A
	LD	(COL_TOP),A
	LD	A,(SC_VAL)
	LD	(COL_BOT),A
	JR	DISP_2
NOT_GE	LD	A,(SC_OV)
	DEC	A
	LD	(COL_BOT),A
	LD	A,(SC_VAL)
	LD	(COL_TOP),A
;
DISP_2	LD	HL,COL_BOT
	LD	A,(COL_TOP)
DISP_3	PUSH	HL
	PUSH	AF
	CALL	DOT
	POP	AF
	POP	HL
	CP	(HL)
	RET	Z
	INC	A
	JR	DISP_3
;
VALUE	NOP
OLD_VALU NOP
COLUMN	NOP
COL_TOP	NOP
COL_BOT	NOP
MASK	NOP
SC_OV	NOP
SC_VAL	NOP
;
SIGNON	LD	HL,MESS1
	CALL	4467H
	CALL	49H
	RET
;
SETUP	XOR	A
	LD	(COLUMN),A
	LD	A,16
	LD	(OLD_VALU),A
	LD	(VALUE),A
	LD	HL,3D00H
	LD	DE,3D01H
	LD	BC,02FFH
	LD	(HL),80H
	LDIR
	RET
;
SCALE	SRL	A
	SRL	A
	SRL	A
	LD	B,A
	LD	A,47
	SUB	B
	RET
;
MESS1	DEFM	1CH,1FH
	DEFM	'Wave display program #1.1 - Nick Andrew',0AH
	DEFM	'For Geoff Arthur only!',0AH
	DEFM	'ESC=Speed up CTRL=Speed down BREAK=exit',0AH
	DEFM	'SHIFT=To fastest speed',0DH
;
CLR_COLUMN
	LD	A,(COLUMN)
	BIT	0,A
	JR	Z,CLR_ZERO
CLR_ONE
	LD	HL,MASK
	LD	(HL),95H
	JR	PAST
CLR_ZERO
	LD	HL,MASK
	LD	(HL),0AAH
;
PAST	SRL	A
	LD	E,A
	LD	D,0
	LD	HL,3D00H
	ADD	HL,DE
	LD	DE,64
	LD	B,12
LOOP_C	LD	A,(MASK)
	AND	(HL)
	LD	(HL),A
	ADD	HL,DE
	DJNZ	LOOP_C
	RET
;
DOT	;courtesy bill barden.
	LD	D,A
	LD	A,(COLUMN)
	LD	E,A
	LD	A,D
	LD	B,-1
DOT_1	INC	B
	SUB	3
	JP	P,DOT_1
	ADD	A,3
	SLA	A
	LD	C,A
	LD	L,B
	LD	H,0
	LD	B,6
DOT_2	ADD	HL,HL
	DJNZ	DOT_2
	LD	D,0
	SRL	E
	JR	NC,DOT_3
	INC	C
DOT_3	ADD	HL,DE
	LD	DE,3C00H
	ADD	HL,DE
	SLA	C
	SLA	C
	SLA	C
	LD	A,(DOT_4+1)
	OR	C
	LD	(DOT_4+1),A
DOT_4	SET	0,(HL)
	SET	7,(HL)
	LD	A,0C6H
	LD	(DOT_4+1),A
	RET
;
	END	START
                                                                                                                                                                                                                                                 