       ;Routine to read in a disk file in ASCII and
 ;view it on the screen or send it to the printer.
 ;<c> 1983 by Mel Patrick
 	ORG	8000H
 START	LD	HL,BUFFER	;point to buffer
 	LD	(POINT),HL	;reset end
 DISK	CALL	01C9H
 	LD	HL,MENU		;point to menu
 	CALL	DISPLY		;show it
 CMDLP	CALL	49H		;wait for inkey
 	PUSH	AF		;save the character
 	CALL	33H		;display it
 	POP	AF		;get the character back
 	CP	'L'		;load a file?
 	JR	Z,LOAD		;yes then go
 	CP	'V'		;view a file?
 	JP	Z,VIEW		;yes then go
 	CP	'E'		;exit to Dos?
 	JP	Z,402DH		;back to Dos if yes
 	CP	'F'		;for format
 	JP	Z,FORMAT	;go if yes
 	LD	A,08H		;load a backspace
 	CALL	33H		;display it
 	JR	CMDLP		;back if not valid
 DISPLY	LD	A,(HL)		;get a byte
 	CP	03H		;end of printing?
 	RET	Z		;back if yes
 	CALL	33H		;else display it
 	INC	HL		;point to next
 	JR	DISPLY		;loop til done
 LOAD	LD	HL,BUFFER	;point to buffer
 	LD	(POINT),HL	;set end address
 	LD	HL,LTEXT	;point to prompt
 	CALL	DISPLY		;show it
 	LD	HL,DCB		;point to control block
 	LD	B,20H		;maximum size
 	CALL	40H		;input from ROM
 	JP	C,DISK		;restart on break
 	LD	HL,IO		;point to io area
 	LD	DE,DCB		;point to control block
 	LD	B,00H		;set record length 256
 	CALL	4424H		;OPEN but not create
 	JR	Z,FOUND		;continue if file valid
 ERROR	SET	7,A		;set return route
 	RES	6,A		;empashised message
 	CALL	4409H		;dos error routine
 	CALL	49H		;wait for a key
 	JP	DISK		;back to menu
 FOUND	CALL	4436H		;read in 256 bytes
 	JR	NZ,ERROR	;go if error happened
 	CALL	MVBUFF		;go move out
 	LD	BC,(NUM)	;get record number
 	INC	BC		;add one to it
 	LD	(NUM),BC	;save the value
 	LD	DE,DCB		;point to block
 	CALL	4442H		;shift to next
 	JR	Z,FOUND		;go if not at end
 	JR	DONE		;go when done
 MVBUFF	LD	HL,(POINT)	;get storage address
 	LD	B,00H		;bytes to move
 	LD	DE,IO		;point to disk buffer
 COPY	LD	A,(DE)		;get a byte
 	LD	(HL),A		;move it
 	LD	A,(3C3EH)	;get screen char
 	XOR	0AH		;toggle a splat
 	LD	(3C3EH),A	;and put it back
 	INC	DE		;point to next
 	INC	HL		;"	"
 	DJNZ	COPY		;loop til moved
 	LD	(POINT),HL	;reset end of buffer
 	RET			;back to caller
 DONE	LD	IX,DCB		;point to control block
 	LD	DE,IO		;point to disk buffer
 	LD	HL,(POINT)	;get end address
 	DEC	H		;back up 256 bytes
 	LD	B,(IX+08H)	;get last byte offset
 DLP	LD	A,(DE)		;get a byte
 	LD	(HL),A		;move to buffer
 	INC	DE		;point to next
 	INC	HL		;point to next
 	DJNZ	DLP		;loop til done
 	LD	A,0FFH		;end marker for file
 	LD	(HL),A		;put in the buffer
 	LD	(POINT),HL	;save new end of program
 	JP	DISK		;back to menu
 VIEW	CALL	01C9H		;clear the video
 	LD	HL,BUFFER	;point to buffer
 	LD	DE,(POINT)	;get end address
 	RST	18H		;compare them
 	JP	Z,DISK		;back if no file
 	LD	HL,BUFFER	;else point to buffer
 VLP	LD	A,(HL)		;get character
 	CP	0DH		;end of line
 	CALL	Z,TERM		;go if yes
 	CALL	33H		;else display it
 	INC	HL		;point to next
 	LD	A,(HL)		;get the character
 	CP	0FFH		;end of file?
 	JR	Z,VEND		;go if yes
 	JR	VLP		;else loop til found
 TERM	PUSH	AF		;save C/R
 TERM1	CALL	49H		;wait for inkey
 	CP	5BH		;up arrow?
 	JR	NZ,TERM1	;no then wait for it
 	POP	AF		;else restore 0dh
 	RET			;and go back
 VEND	LD	HL,ENDMSG	;point to file end
 	CALL	DISPLY		;show it
 VEND1	CALL	49H		;wait for inkey
 	CP	5BH		;up arrow?
 	JR	Z,VEND1		;yes then loop back
 	JP	DISK		;else menu again
 FORMAT	LD	HL,BUFFER	;point to main buffer
 	LD	(LOC),HL	;save starting address
 	LD	HL,SMSG		;point to prompt
 	CALL	DISPLY		;show it
 	LD	HL,SPEC		;point to filename
 	LD	B,6		;length of input
 	CALL	40H		;get input
 	JP	C,DISK		;back on break
 	LD	HL,CMSG		;point to prompt
 	CALL	DISPLY		;show it
 	LD	HL,COMMEN	;point to comments
 	LD	B,40		;length of input
 	CALL	40H		;get input
 	JP	C,DISK		;back if break
 	LD	HL,SPLIT	;point to pompt
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for inkey
 	PUSH	AF		;save the character
 	CALL	33H		;display it
 	POP	AF		;restore it now
 	CP	'N'		;n for no
 	JR	Z,TOG		;go set it
 	CP	'n'		;test lower case
 	JR	Z,TOG		;go set if yes
 	JR	CNT		;else continue
 TOG	XOR	A		;set to off
 CNT	LD	(CFLAG),A	;set flag byte
 	LD	HL,SPMSG	;point to line spacing
 	CALL	DISPLY		;show it
 	CALL	GETNUM		;go get a number
 	LD	(LSPACE),A	;save the number
 	LD	HL,TMSG		;point to tab prompt
 	CALL	DISPLY		;show it
 	CALL	GETNUM		;get a number 1-9
 	CP	00H		;0 for tab?
 	JR	NZ,SAVEIT	;go if its 1-9
 	INC	A		;else make it 1
 SAVEIT	LD	(MAR),A		;and save the value
 	CALL	01C9H		;clear the video
 	LD	HL,FMSG		;point to formatting
 	CALL	DISPLY		;show it
 	LD	HL,0001H	;reset page count
 	LD	(PNUM),HL	;now.
 	CALL	HEADER		;print header
 FMT	LD	HL,(LOC)	;get pointer back
 	LD	B,00H		;reset length counter
 	LD	DE,BUFF		;point to user buffer
 MOVE	LD	A,(HL)		;get a byte
 	CP	0FFH		;end of file
 	JP	Z,DISK		;back if done
 	LD	(DE),A		;else move to buffer
 	INC	DE		;point to next
 	INC	HL		;in text too
 	INC	B		;add to counter
 	CP	0DH		;end of line
 	JR	Z,MVDN		;go if yes
 	JR	MOVE		;loop til done
 MVDN	LD	(LOC),HL	;save next location
 	LD	A,B		;get length of text
 	DEC	A		;skip C/R on end
 	LD	(LEN),A		;save length
 	LD	A,(MAR)		;get margin value
 	LD	B,A		;move to loop
 TABIN	LD	A,' '		;get a space byte
 	CALL	3BH		;lprint it
 	DJNZ	TABIN		;loop til done
 	LD	A,(MAR)		;get margin
 	LD	(CHAR),A	;set up line length
 	LD	HL,BUFF		;point to user buffer
 	PUSH	HL		;save address
 	LD	A,' '		;get a space byte
 	LD	B,1		;set counter
 SCAN	CP	(HL)		;loop for space
 	JR	Z,GOTSPC	;go if space
 	INC	HL		;else point to next
 	INC	B		;and add to count
 	JR	SCAN		;loop til space
 GOTSPC	LD	A,(MAR)		;get margin value
 	ADD	A,B		;find new total
 	LD	(TAB2),A	;save point
 	POP	HL		;point to start buffer
 	LD	IX,16064	;point to video
 LPRINT	LD	A,(3840H)	;look for break key
 	CP	04H		;break?
 	JP	Z,DISK		;menu if yes
 	LD	A,(HL)		;get a byte
 	CP	'"'		;is it quotes?
 	CALL	Z,QUOTE		;go if yes
 	CP	0AH		;else linefeed?
 	JR	NZ,OVER		;go if not
 	CALL	SUB		;else process l/f
 	JR	BYPASS		;and bypass remainder
 OVER	CP	':'		;is it colon?
 	CALL	Z,COLON		;go if yes
 	CP	0DH		;end of line?
 	JR	Z,END		;go if yes
 	LD	(IX+00H),A	;else show it on video
 	INC	HL		;point to next
 	INC	IX		;on screen too
 	CALL	3BH		;lprint character
 	LD	A,(CHAR)	;get line length
 	INC	A		;add one character
 	LD	(CHAR),A	;and save value
 	CP	78		;end of line
 	JR	NZ,LPRINT	;loop if not full line
 	LD	A,0DH		;else get a C/R
 	CALL	3BH		;lprint it
 BYPASS	LD	A,(LCOUNT)	;get lien counter
 	INC	A		;add one to it
 	LD	(LCOUNT),A	;save value
 	CALL	LFEED		;check for end of page
 	LD	A,(TAB2)	;get second margin
 	LD	(CHAR),A	;reset length count
 	LD	B,A		;move to loop
 LOOP4	LD	A,' '		;setup a space
 	CALL	3BH		;lprint it
 	DJNZ	LOOP4		;tab in x spaces
 	LD	A,(HL)		;get back character
 	CP	':'		;colon again?
 	JR	Z,PAST2		;go if yes
 	LD	A,(CFLAG)	;check for split list
 	OR	A		;test for on/off
 	JR	Z,PAST2		;go if off
 	LD	A,' '		;else in one space
 	CALL	3BH		;lprint it
 	LD	A,(CHAR)	;get length
 	INC	A		;add one to it
 	LD	(CHAR),A	;put it back
 PAST2	CALL	CLRVID		;erase video
 	JP	LPRINT		;loop til done
 END	LD	A,0DH		;do a C/R
 	CALL	3BH		;on paper
 	LD	A,(LCOUNT)	;get line counter
 	INC	A		;add one to it
 	LD	(LCOUNT),A	;save new line
 	CALL	LFEED		;check end of page
 	XOR	A		;zero out a
 	LD	(CHAR),A	;move to value
 	LD	(QFLAG),A	;reset quote flag
 	CALL	SPACE		;check for line spacing
 	CALL	LFEED		;check end of page
 	CALL	CLRVID		;erase screen
 	JP	FMT		;and loop til done
 SUB	LD	A,0DH		;replace LF with CR
 	CALL	3BH		;lprint it
 	INC	HL		;point to next
 	RET			;back to caller
 QUOTE	PUSH	AF		;save character
 	LD	A,(QFLAG)	;get quote flag
 	OR	A		;test for on/off
 	JR	Z,SET		;toggle if off
 	DEC	A		;else make it zero
 BK	LD	(QFLAG),A	;save new result
 	POP	AF		;get back character
 	RET			;back to caller
 SET	INC	A		;make a=1
 	JR	BK		;and save it
 LFEED	PUSH	AF		;save character
 	PUSH	BC		;save count
 	LD	A,(LCOUNT)	;get line counter
 	LD	B,A		;move for compare
 	LD	A,66		;lines on a page
 	CP	B		;same?
 	CALL	Z,FFEED		;yes, then form feed
 	POP	BC		;else restore
 	POP	AF		;both
 	RET			;and go back
 FFEED	LD	A,68		;lines to next page
 	SBC	A,B		;get difference
 	LD	B,A		;move to loop
 FEED	LD	A,' '		;get a space
 	CALL	3BH		;lprint it
 	LD	A,0DH		;and a C/R
 	CALL	3BH		;lprint it
 	DJNZ	FEED		;loop til done
 	CALL	HEADER		;print header
 	RET			;and return
 COLON	PUSH	BC		;save counter
 	PUSH	AF		;and character
 	LD	A,(QFLAG)	;test for quotes
 	OR	A		;0=off 1=on
 	JR	NZ,BACK1	;no then back
 	LD	A,(CFLAG)	;test for split or not
 	OR	A		;split?
 	JR	Z,BACK1		;back if 0 (off)
 	LD	A,0DH		;else get a C/R
 	CALL	3BH		;lprint it
 	LD	A,(LCOUNT)	;get line counter
 	INC	A		;add one to it
 	LD	(LCOUNT),A	;save it
 	CALL	LFEED		;check end of page
 	LD	A,(TAB2)	;get tab position
 	LD	(CHAR),A	;reset start pos.
 	LD	B,A		;move to loop
 LOOP2	LD	A,' '		;get a space
 	CALL	3BH		;lprint it
 	DJNZ	LOOP2		;loop til done
 	CALL	CLRVID		;erase screen
 BACK1	POP	AF		;restore
 	POP	BC		;"	"
 	RET			;back to caller
 CLRVID	LD	IX,16064	;video location
 	PUSH	IX		;save it
 	LD	B,200		;bytes to erase
 LOOP3	LD	(IX+00H),20H	;load with a space
 	INC	IX		;point to next
 	DJNZ	LOOP3		;loop til done
 	POP	IX		;restore position
 	RET			;back to caller
 SPACE	LD	A,(LSPACE)	;get line spacing
 	OR	A		;test for none
 	RET	Z		;back if none
 	LD	B,A		;else move to loop
 LOOP5	LD	A,' '		;get a space
 	CALL	3BH		;lprint it
 	LD	A,0DH		;get a C/R
 	CALL	3BH		;lprint it
 	LD	A,(LCOUNT)	;get line counter
 	INC	A		;add one to it
 	LD	(LCOUNT),A	;save it
 	CALL	LFEED		;loop
 	DJNZ	LOOP5		;loop til done
 	RET			;back to caller
 HEADER	PUSH	HL		;save address
 	LD	A,07H		;set line counter
 	LD	(LCOUNT),A	;to 7
 	LD	A,0DH		;do a C/R
 	CALL	3BH		;lprint it
 	LD	B,80		;bytes to print
 SHDH	LD	A,'-'		;get a dash
 	CALL	3BH		;lprint it
 	DJNZ	SHDH		;loop til done
 	LD	A,0DH		;get a C/R
 	CALL	3BH		;lprint it
 	LD	HL,SPEC		;point to filename
 	LD	B,6		;bytes to print
 	CALL	PCOM		;lprint the name
 	LD	A,' '		;space
 	CALL	3BH		;lprint it
 	LD	A,' '		;space over
 	CALL	3BH		;lprint it
 	LD	HL,DATE		;point to date buffer
 	CALL	4470H		;get date
 	LD	HL,TIME		;point to time
 	CALL	446DH		;get time
 	LD	HL,DATE		;point to date
 	LD	B,20		;bytes to print
 	CALL	PCOM		;and print it
 	LD	HL,COMMEN	;point to comments
 	LD	B,40		;length of input
 	CALL	PCOM		;and lprint them
 	LD	HL,(PNUM)	;get page number
 	LD	DE,PBUFF	;point to buffer
 	LD	BC,-10000	;10 to 4th
 	CALL	CAL		;figure it
 	LD	BC,-1000	;10 to 3rd
 	CALL	CAL		;figure it
 	LD	BC,-100		;10 to 2nd
 	CALL	CAL		;figure it
 	LD	BC,-10		;10 to 1st
 	CALL	CAL		;figure it
 	LD	BC,-1		;digits
 	CALL	CAL		;figure it
 	LD	A,0DH		;get a C/R
 	LD	(DE),A		;put in the buffer
 	JR	CONTA		;and continue
 CAL	LD	A,0FFH		;-1 to A
 CAL1	INC	A		;add to count
 	ADD	HL,BC		;subtract power of ten
 	JR	C,CAL1		;loop til smaller
 	OR	A		;test for none
 	SBC	HL,BC		;get back last number
 	ADD	A,30H		;make digit a number
 	LD	(DE),A		;store in buffer
 	INC	DE		;point to next
 	RET			;back to caller
 CONTA	LD	HL,(PNUM)	;get page number
 	INC	HL		;add one to it
 	LD	(PNUM),HL	;save next page
 	LD	HL,PAGE		;point to message
 	LD	B,13		;bytes to print
 SUBA	LD	A,(HL)		;get a byte
 	CALL	3BH		;lprint it
 	INC	HL		;point to next
 	DJNZ	SUBA		;loop til doe
 	LD	B,80		;bytes to print
 SHDH1	LD	A,'-'		;get a -
 	CALL	3BH		;lprint it
 	DJNZ	SHDH1		;loop til done
 	LD	A,0DH		;get a C/R
 	CALL	3BH		;lprint it
 	LD	A,0DH		;get C/R
 	CALL	3BH		;lprint it
 	POP	HL		;restore address
 	RET			;back to caller
 PCOM	LD	A,(HL)		;get a byte
 	CP	0DH		;end of line?
 	JR	Z,PSPACE	;yes then space
 	CALL	3BH		;else lprint it
 	INC	HL		;point to next
 	DJNZ	PCOM		;loop til done
 	RET			;back to caller
 PSPACE	LD	A,' '		;get a space
 	CALL	3BH		;lprint it
 	DJNZ	PSPACE		;loop for remainder
 	RET			;back to caller
 GETNUM	CALL	49H		;wait for number
 	CP	30H		;check for zero
 	JR	C,GETNUM	;back if <0
 	CP	3AH		;check for >9
 	JR	NC,GETNUM	;back if too high
 	PUSH	AF		;else save character
 	CALL	33H		;display it
 	POP	AF		;get back character
 	SUB	30H		;make it digit 0-9
 	RET			;and back to caller
 MENU	DEFM	'                  <Listing Formatter Version 2.0>
 	DEFB	0DH
 	DEFM	'                  <CopyRight 1983 By Mel Patrick>'
 	DEFB	0DH
 	DEFM	'                     <Programs in ASCII only>'
 	DEFW	0D0DH
 	DEFM	'<L>oad ASCII File from Disk'
 	DEFB	0DH
 	DEFM	'<V>iew ASCII File on Video'
 	DEFB	0DH
 	DEFM	'<E>xit to Dos READY'
 	DEFB	0DH
 	DEFM	'<F>ormat Listing on Printer'
 	DEFW	0D0DH
 	DEFM	'Press Option Key :'
 	DEFB	03H
 LTEXT	DEFW	0D0DH
 	DEFM	'ASCII Filespec -> '
 	DEFB	03H
 SPLIT	DEFB	0DH
 	DEFM	'Split Colon Listing (Y/N) : '
 	DEFB	03H
 SMSG	DEFB	0DH
 	DEFM	'Filename --> '
 	DEFB	03H
 CMSG	DEFB	0DH
 	DEFM	'Header Comments --> '
 	DEFB	03H
 TMSG	DEFB	0DH
 	DEFM	'Left-Hand Margin (1-9) : '
 	DEFB	03H
 SPMSG	DEFB	0DH
 	DEFM	'Line Spacing (0-9) : '
 	DEFB	03H
 ENDMSG	DEFB	0DH
 	DEFM	'------------------ End of File, Press any Key -----------------'
 	DEFB	03H
 FMSG	DEFM	'          <Formatting Listing to Printer>'
 	DEFB	03H
 COMMEN	DEFS	45		;header comments
 CHAR	DEFB	00H		;character count
 BUFF	DEFS	256		;working buffer
 SPEC	DEFS	45		;comments
 DATE	DEFS	08		;date buffer
 	DEFW	2020H		;two spaces
 TIME	DEFS	08H		;time buffer
 PAGE	DEFM	'  Page '
 PBUFF	DEFS	06H		;ascii buffer
 PNUM	DEFW	0000H		;page numbers
 LEN	DEFB	00H		;for line length
 MAR	DEFB	06H		;left hand margin
 LOC	DEFW	0000H		;for buffer position
 TAB2	DEFB	00H		;after line number
 LCOUNT	DEFB	00H		;for line counter
 QFLAG	DEFB	00H		;quote flag
 CFLAG	DEFB	00H		;test for split colon
 LSPACE	DEFB	01H		;line spacing
 POINT	DEFW	0000H		;end address buffer
 NUM	DEFW	0000H		;record number storage
 DCB	DEFS	40		;area for control block
 IO	DEFS	256		;disk buffer on input
 BUFFER	DEFB	00H		;start of buffer
 	END	START
