       ;Last Module for Video Tracker
 ;Filename : TRC/ASM
 INVENT	LD	HL,(MOVTOT)	;get total movies
 	LD	A,H
 	OR	L
 	JP	Z,TRACK0	;back if none on file
 	CALL	01C9H
 	LD	HL,TITLE3	;point to heading
 	CALL	DISPLY		;show it
 	LD	HL,MSBANS
 	LD	B,6		;erase last value
 	CALL	ERA2		;erase last answer
 	LD	HL,LSBANS
 	LD	B,6
 	CALL	ERA2		;erase last value
 	LD	HL,0000H	;reset total buffers
 	LD	(TEMP1),HL
 	LD	(TEMP2),HL
 	LD	HL,MNAME
 	LD	DE,FBUFF
 	CALL	441CH		;set file I/O block
 	LD	HL,DUMMY
 	LD	DE,FBUFF
 	LD	B,64
 	CALL	4424H		;open not create
 	LD	HL,(MOVTOT)	;get total movies
 	LD	(TEMP3),HL	;save it for now
 	LD	HL,0000H	;reset to first#
 	LD	(NUMB1),HL	;for read
 	LD	A,1
 	LD	(ROUTE),A	;set return byte
 RDINV	CALL	SERM3		;read in 1 record
 	LD	A,(M8)		;get cost byte
 	CP	' '		;is it a space?
 	JR	Z,SKPTOT	;bypass if yes
 	LD	HL,BUFF		;point to number buffer
 	LD	B,6		;bytes to erase
 	CALL	ERA2		;erase them
 	LD	HL,M8		;point to cost
 	LD	DE,BUFF+1	;point to start of buffer
 	LD	BC,3		;bytes to copy out
 	LDIR			;copy them
 CHKINV	LD	A,(DE)		;get last byte
 	CP	' '		;is it a space?
 	JR	NZ,INVSPC	;go if not
 	DEC	DE		;else back up 1
 	JR	CHKINV		;and check next byte
 INVSPC	PUSH	DE		;move end of buffer to
 	POP	HL		;HL for conversion
 	CALL	ASCB1		;convert to number
 	PUSH	HL		;move to counter
 	POP	BC		;BC=value now
 	LD	HL,(TEMP1)	;get current value
 	LD	DE,0001H	;set add byte to 1
 INVADD	ADD	HL,DE		;add 1 to it
 	CALL	C,ADDMSB	;go if >65535 (FFFF)
 	DEC	BC		;minus 1 from count
 	LD	A,B
 	OR	C
 	JR	NZ,INVADD	;loop for value
 	LD	(TEMP1),HL	;save value now
 SKPTOT	LD	HL,(NUMB1)
 	INC	HL
 	LD	(NUMB1),HL
 	LD	HL,(TEMP3)	;get records
 	DEC	HL		;minus 1 from it
 	LD	(TEMP3),HL
 	LD	A,H
 	OR	L		;zero then done
 	JR	NZ,RDINV	;loop til done
 	LD	HL,(TEMP2)	;get MSB value
 	LD	DE,MSBANS
 	CALL	BINASC		;convert to number
 	LD	A,' '
 	LD	(DE),A		;remove last byte
 SKPMSB	LD	HL,(TEMP1)	;get LSB value
 	LD	DE,LSBANS	;point to buffer
 	CALL	BINASC		;convert now
 	LD	A,' '
 	LD	(DE),A
 	LD	DE,MSBANS	;point to MSB
 	LD	B,4		;bytes max
 BLANK	LD	A,(DE)		;get a byte
 	CP	'0'		;zero?
 	JR	NZ,SHANS	;go if all done
 	LD	A,' '		;else space it out
 	LD	(DE),A		;leading zeros
 	INC	DE		;point to next
 	DJNZ	BLANK		;loop for 5
 SHANS	LD	HL,TANS		;point to answer
 	CALL	DISPLY		;show it
 	CALL	49H
 	JP	TRACK0
 ADDMSB	PUSH	HL		;save counter
 	LD	HL,(TEMP2)
 	INC	HL
 	LD	(TEMP2),HL
 	POP	HL
 	OR	A		;clear the carry
 	RET			;just add 1 for MSB
 DAYREN	LD	A,1		;set up for daily
 	LD	(DAILY),A	;save it
 	LD	HL,0000H	;set size to zero
 	LD	(TEMP1),HL	;save it
 	CALL	01C9H		;clear the video
 	LD	HL,TITLE2	;point to title
 	CALL	DISPLY		;show it
 	JR	OVC2		;and continue
 OVERD	LD	HL,(MOVTOT)	;get total movies
 	LD	A,H		;test for any
 	OR	L		;0=none
 	JP	Z,TRACK0	;back if none
 	XOR	A		;remove daily flag
 	LD	(DAILY),A	;save it
 	CALL	01C9H		;clear the video
 	LD	HL,MENUI	;point to title
 	CALL	DISPLY		;show it
 	LD	HL,(4020H)	;start of video
 	LD	(VIDEO),HL	;start for field
 	LD	HL,QUEST8	;point to question
 	CALL	DISPLY		;show it
 	LD	HL,BUFF		;point to buffer
 	PUSH	HL		;save the address
 	LD	B,6		;bytes to erase
 	CALL	ERA2		;erase it
 	CALL	FNDFLD		;find the field
 	POP	HL		;point to buffer
 	INC	HL		;and step in 1
 	LD	A,2		;get days old
 	CALL	INPUT		;get input
 	PUSH	IX		;move end to
 	POP	HL		;hl for number
 	CALL	ASCBIN		;convert it to number
 	LD	(TEMP1),HL	;save difference
 	LD	A,H		;test for zero
 	OR	L		;0=only todays rentals
  	JP	Z,TRACK0	;loop if zero input
 OVC2	LD	HL,DBUFF	;point to buffer
 	CALL	DVECT		;copy the date
 	LD	HL,YRS		;point to year
 	LD	IX,TABLE1	;point to year table
 	LD	B,4		;must loop four times
 	CALL	OVERLP		;check for leap year
 	LD	HL,DBUFF	;point to months
 	INC	HL		;second digit
 	CALL	ASCB1		;convert to number
 	DEC	L		;minus 1 from it
 	LD	A,L		;test for first month
 	OR	A		;january selected?
 	JR	Z,DAYLP1	;continue if yes
 	LD	B,A		;move to counter
 	LD	HL,0000H	;set days to zero
 	LD	IX,TABLE2	;point to days in months
 	DEC	IX		;back up
 DAYLP	INC	IX		;point to next
 	LD	E,(IX)		;get LSB to add
 	LD	D,00		;make MSB 0
 	ADD	HL,DE		;add for total
 	DJNZ	DAYLP		;count the days
 DAYLP1	LD	(DAY1),HL	;save the total
 	LD	HL,DAYS		;point to days
 	INC	HL		;second digit
 	CALL	ASCB1		;convert to number
 	LD	DE,(DAY1)	;get last days
 	ADD	HL,DE		;add them up
 	LD	(DAY1),HL	;and save result
 	LD	HL,MNAME	;point to filename
 	LD	DE,FBUFF	;point to buffer
 	CALL	441CH		;move it
 	LD	HL,DUMMY	;point to dummy
 	LD	DE,FBUFF	;point to file
 	LD	B,64		;LRL=64
 	CALL	4424H		;open don't create
 	LD	HL,(MOVTOT)	;get number of movies
 	LD	(TEMP2),HL	;save it
 	LD	HL,0000H	;set record to zero
 	LD	(NUMB1),HL	;and save it
 	LD	A,1		;set route to return
 	LD	(ROUTE),A	;and save it
 AGAIN	CALL	SERM3		;read in 1 movie
 	LD	A,(M4)		;check for rental
 	CP	' '		;space = not rented
 	JP	Z,OVC1		;continue if not
 	LD	DE,DBUFF	;point to date buffer
 	LD	HL,M3		;record buffer
 	LD	BC,8		;bytes to copy
 	LDIR			;copy them
 	LD	HL,YRS		;point to years
 	LD	IX,TABLE1
 	LD	B,4
 OVLP1	PUSH	HL
 	PUSH	BC
 	LD	B,2
 DSCAN1	LD	A,(HL)
 	CP	(IX)
 	JR	NZ,DIFF1
 	INC	HL
 	INC	IX
 	DJNZ	DSCAN1
 	POP	BC
 	POP	HL
 	LD	A,29
 	LD	(FEB),A
 	JR	OVCONT
 DIFF1	INC	IX
 	DJNZ	DIFF1
 	POP	BC
 	POP	HL
 	DJNZ	OVLP1
 	LD	A,28
 	LD	(FEB),A
 OVCONT	LD	HL,DBUFF
 	INC	HL
 	CALL	ASCB1
 	DEC	L
 	LD	A,L
 	OR	A
 	JR	Z,DAYLP2
 	LD	B,A
 	LD	HL,0000H
 	LD	IX,TABLE2
 	DEC	IX
 DAYLP0	INC	IX
 	LD	E,(IX)
 	LD	D,00H
 	ADD	HL,DE
 	DJNZ	DAYLP0
 DAYLP2	LD	(DAY2),HL
 	LD	HL,DAYS
 	INC	HL
 	CALL	ASCB1
 	LD	DE,(DAY2)
 	ADD	HL,DE
 	LD	(DAY2),HL
 	LD	HL,(DAY1)	;get today
 	LD	DE,(DAY2)	;get movie date
 	LD	A,(DAILY)	;get daily flag
 	OR	A		;0=all 1=todays only
 	JR	Z,OVC3		;continue if all
 	RST	18H		;else compare them
 	JP	Z,PRTDAT	;print if the same day
 	JR	OVC1		;else continue to next
 OVC3	RST	18H		;compare them
 	JR	C,PREVYR	;go if spans year end
 	OR	A		;remove carry
 	SBC	HL,DE		;find days out
 	JR	OVC0		;and continue
 PREVYR	LD	A,(FEB)		;test for leap year
 	CP	29		;is it?
 	JR	Z,LPYR		;go if yes
 	LD	HL,365		;else standard year
 	JR	PREVO		;and continue
 LPYR	LD	HL,366		;days in a leap year
 PREVO	LD	DE,(DAY2)	;get day of movie
 	OR	A		;clear the carry
 	SBC	HL,DE		;find number of days
 	LD	DE,(DAY1)	;get todays number
 	ADD	HL,DE		;find total days out
 OVC0	LD	DE,(TEMP1)	;get limited days out
 	RST	18H		;compare them
 	JR	NC,PRTDAT	;go if out>limit
 	JR	Z,PRTDAT	;go if equal
 OVC1	LD	HL,(NUMB1)	;get record
 	INC	HL		;point to next
 	LD	(NUMB1),HL	;save it
 	LD	HL,(TEMP2)	;get total movies
 	DEC	HL		;check for done
 	LD	A,H		;test
 	OR	L		;0=done
 	JP	Z,TRACK0	;go if done
 	LD	(TEMP2),HL	;else save it
 	JP	AGAIN		;and repeat til done
 PRTDAT	LD	HL,(NUMB1)	;get record #
 	INC	HL		;make it real
 	LD	DE,BUFF		;point to buffer
 	CALL	BINASC		;convert to ascii
 	LD	HL,BUFF		;point to buffer
 	LD	B,5		;bytes to lprint
 	CALL	LSHOW		;lprint them
 	LD	B,2		;spaces
 	CALL	LSPACE
 	LD	HL,M1		;point to movie title
 	LD	B,20
 	CALL	LSHOW		;lprint it
 	LD	HL,M3		;point to date
 	LD	B,8
 	CALL	LSHOW
 	LD	B,2
 	CALL	LSPACE
 	LD	B,4
 	CALL	LSHOW		;lprint member number
 	LD	A,0DH
 	CALL	3BH
 	JR	OVC1		;and continue
 OVERLP	PUSH	HL		;save start of digits
 	PUSH	BC		;save counter
 	LD	B,2		;bytes to compare
 DSCAN	LD	A,(HL)		;get a byte
 	CP	(IX)		;same as table
 	JR	NZ,DIFF		;go if not
 	INC	HL		;point to next
 	INC	IX		;"	"
 	DJNZ	DSCAN		;else count the next
 	POP	BC		;fix the stack
 	POP	HL		;fix stack
 	LD	A,29		;set up feb
 	LD	(FEB),A		;in the days
 	RET			;back to caller
 DIFF	INC	IX		;point to next
 	DJNZ	DIFF		;loop to next year
 	POP	BC		;repeat 4 times
 	POP	HL		;point to start again
 	DJNZ	OVERLP		;do it
 	LD	A,28		;set feb to 28 days
 	LD	(FEB),A		;save it
 	RET			;back to caller
 MENU1	DEFM	'               Video Tracker System - Version 2.1'
 	DEFB	0DH
 	DEFM	'                   <c> 1984 by Mel Patrick'
 	DEFW	0D0DH
 	DEFM	'<1> Add Member         <2> Add Movie         <3> Movie Rental'
 	DEFB	0DH
 	DEFM	'<4> View/Edit Member   <5> View/Edit Movie   <6> Movie Return'
 	DEFB	0DH
 	DEFM	'<7> List Reserves      <8> Print Movies      <9> Movie Reserve'
 	DEFB	0DH
 	DEFM	'<A> Print Members      <B> OverDue Rentals   <C> Daily Rentals'
 	DEFB	0DH
 	DEFM	'<D> Inventory Total    <Q> Return to Dos'
 	DEFB	0DH
 	DEFM	'Option (1-9,A-D,Q) : '
 	DEFB	03H
 MSG0	DEFM	'  Movies :'
 	DEFB	03H
 MSG0A	DEFM	'      Mem :'
 	DEFB	03H
 MSG1	DEFM	'      Res :'
 	DEFB	03H
 MENU2	DEFM	'                   Add Movie to File'
 	DEFW	0D0DH
 	DEFM	'Previous Entry : '
 PREMOV	DEFM	'                    '
 	DEFM	'      '
 	DEFM	'  Movie Number :'
 MNUMB	DEFM	'      '
 	DEFW	0D0DH
 	DEFB	03H
 MENU3	DEFW	0D0DH
 	DEFM	'Title --> '
 	DEFB	0DH
 	DEFM	'Format -> '
 	DEFB	0DH
 	DEFM	'Price --> '
 	DEFB	0DH
 	DEFB	03H
 MENU4	DEFM	'                Add Membership to File'
 	DEFB	0DH
 	DEFM	'Last Entry : '
 PREMEM	DEFM	'                     '
 	DEFM	'  File : '
 PREF	DEFB	' '
 	DEFM	'   '
 	DEFM	'Mem# : '
 MEMNUM	DEFM	'      '
 	DEFB	03H
 MENU5	DEFW	0D0DH
 	DEFM	'Name ----> '
 	DEFB	0DH
 	DEFM	'Address -> '
 	DEFB	0DH
 	DEFM	'City ----> '
 	DEFB	0DH
 	DEFM	'Zip Code-> '
 	DEFB	0DH
 	DEFM	'Phone# --> '
 	DEFB	0DH
 	DEFM	'Drivers Liscence --> '
 	DEFB	0DH
 	DEFM	'Credit Card Number-> '
 	DEFB	0DH
 	DEFM	'Additional Info ---> '
 	DEFB	03H
 MENU6	DEFM	'                   Search / Edit Movie File'
 	DEFB	0DH
 MENU6A	DEFM	'Movie # --> '
 MORN	DEFM	'       '
 	DEFW	0D0DH
 	DEFB	03H
 MENU7	DEFM	'Title --> '
 MIN	DEFS	20		;title info
 	DEFM	'       Format -> '
 MIN0	DEFB	01H
 	DEFM	'   Cost -> '
 MIN1	DEFS	03H
 	DEFB	0DH
 	DEFM	'Rental Date -> '
 MIN2	DEFS	08H
 	DEFM	'              	Reserved -> '
 MIN3	DEFB	00H
 	DEFB	0DH
 	DEFM	'Rental Mem# -> '
 MIN4	DEFS	04H
 	DEFM	'                  Reserve # > '
 MIN5	DEFS	04H
 	DEFB	0DH
 	DEFM	'Total Rental-> '
 MIN6	DEFS	06H
 	DEFM	'                Res. Date -> '
 MIN7	DEFS	08H
 	DEFB	0DH
 	DEFM	'Additional Information --> '
 MIN8	DEFS	12
 	DEFB	0D
 	DEFB	03H
 MENU8	DEFM	'              Search / Edit Membership Files'
 	DEFB	0DH
 MENU8A	DEFM	'Which File (A-Z) --> '
 MEMN	DEFB	' '
 	DEFM	'      Membership # --> '
 MERN	DEFM	'      '
 	DEFW	0D0DH
 	DEFB	03H
 MENU9	DEFB	0DH
 	DEFM	'Name ---> '
 ME	DEFS	20
 	DEFM	'   '
 	DEFM	'Address-> '
 ME0	DEFS	20
 	DEFB	0DH
 	DEFM	'City ---> '
 ME1	DEFS	16
 	DEFM	'       '
 	DEFM	'Zip Code> '
 ME2	DEFS	8
 	DEFB	0DH
 	DEFM	'Phone --> '
 ME3	DEFS	8
 	DEFB	0DH
 	DEFM	'Drivers Liscense -> '
 ME4	DEFS	8
 	DEFB	0DH
 	DEFM	'Credit Card # ----> '
 ME5	DEFS	20
 	DEFB	0DH
 	DEFM	'Misc. Information > '
 ME6	DEFS	20
 	DEFB	0DH
 	DEFB	03H
 MENUA	DEFM	'         Video Tracker  Rental/Return/Reserve  Mode'
 	DEFW	0DH
 	DEFB	03H
 MENUB	DEFM	'                 Movie Reserve Listing'
 	DEFB	0DH
 	DEFB	03H
 MENUC	DEFM	'              Sort and Print Movie Listing'
 	DEFW	0D0DH
 	DEFM	'Loading Movie....'
 	DEFW	0D0DH
 	DEFB	03H
 MENUD	DEFB	0DH
 	DEFM	'Sorting.....'
 	DEFW	0D0DH
 	DEFB	03H
 MENUE	DEFM	'                      Video Tracker File Listing - '
 DBUFF	DEFM	'00'		;months
 	DEFB	'/'
 DAYS	DEFM	'00'		;days
 	DEFB	'/'
 YRS	DEFM	'00'		;years in date
 	DEFM	'        Page : '
 PBUFF	DEFM	'      '
 	DEFB	0DH
 MENUF	DEFM	'Movie Number          Title            Format     Rentals   Cost'
 	DEFB	0DH
 MENUG	DEFM	'Member Number       Name             Address             City            Phone#'
 	DEFB	0DH
 MENUH	DEFM	'          Video Tracker Membership File Printing'
 	DEFW	0D0DH
 	DEFB	03H
 MENUI	DEFM	'           Video Tracker Overdue Module'
 	DEFW	0D0DH
 	DEFM	'   This mode will allow any movie which has been rented past'
 	DEFB	0DH
 	DEFM	'a user definable amount of time, to be tracked down. The Movie'
 	DEFB	0DH
 	DEFM	'number will be printed on the line printer.'
 	DEFB	0DH
 	DEFB	03H
 QUESTA	DEFW	0D0DH
 	DEFM	'Print <A>ll Files or <S>ingle File (A/S) : '
 	DEFB	03H
 QUESTB	DEFW	0D0DH
 	DEFM	'File to Print (A-Z) : '
 	DEFB	03H
 SMSG	DEFW	0D0DH
 	DEFM	'Working on File :  '
 	DEFB	03H
 FULMSG	DEFB	23D
 	DEFM	' * --> This file is FULL <-- *'
 	DEFW	0D0DH
 	DEFM	' Press ......<C>ontinue'
 	DEFB	0DH
 	DEFM	'    or ......<M>ain Menu'
 	DEFW	0D0DH
 	DEFB	03H
 FLMSG	DEFB	23D
 	DEFM	' * All Member Files FULL * '
 	DEFW	0D0DH
 	DEFM	'Press any key for Main Menu'
 	DEFB	03H
 FLMSG2	DEFB	23
 	DEFM	'   * Movie File FULL *'
 	DEFW	0D0DH
 	DEFM	'Press any key for Main Menu'
 	DEFB	03H
 TITLE	DEFW	0D0DH
 	DEFM	'               Video Tracker Information Summary'
 	DEFB	03H
 TITLE2	DEFM	'               Video Movie Rentals Today'
 	DEFB	0DH
 	DEFM	'Files being scanned.....'
 	DEFB	03H
 TITLE3	DEFM	'               Movie Inventory Total Cost'
 	DEFW	0D0DH
 	DEFB	03H
 QUEST	DEFW	0D0DH
 	DEFM	'    Data Correct - <Y>es / <N>o / <E>xit'
 	DEFB	03H
 QUEST1	DEFM	'File to Add to (A-Z) : '
 	DEFB	03H
 QUEST2	DEFB	0DH
 	DEFM	'               Information Correct (Y/N/Exit)'
 	DEFB	03H
 QUEST3	DEFM	'            * * Another Entry for Same Member (Y/N) * *'
 	DEFB	03H
 QUEST4	DEFM	'              - Enter Additonal Information -'
 	DEFB	03H
 QUEST5	DEFW	0D0DH
 	DEFM	'    [ - To Backup / '
 	DEFB	5CH
 	DEFM	' - To Advance / Q - Quit / E - Edit'
 	DEFB	03H
 QUEST6	DEFB	0DH
 	DEFM	'            Press any Key to Continue Display'
 	DEFB	03H
 QUEST7	DEFB	0DH
 	DEFM	'Position paper to TOP OF FORM - Press any key to start...'
 	DEFB	0DH
 	DEFB	03H
 QUEST8	DEFW	0D0DH
 	DEFM	'Enter Days Overdue for Scan (1-99 or 0-Abort) -> '
 	DEFB	03H
 PRMT	DEFB	0DH
 	DEFM	'           - Press Any Key to Return to Menu -'
 	DEFB	03H
 TANS	DEFW	0D0DH
 	DEFM	'Total cost of inventory in file'
 	DEFW	0D0DH
 MSBANS	DEFM	'      x 65536'
 	DEFB	0DH
 	DEFM	'      + '
 LSBANS	DEFM	'      '
 	DEFW	0D0DH
 	DEFM	'           - Press any key to return to Menu -'
 	DEFB	03H
 DTMSG	DEFB	0DH
 	DEFM	'        * * * * * * Invalid Date Set * * * * * *'
 	DEFW	0D0DH
 	DEFM	'Enter the Date as follows : DATE MM/DD/YY <ENTER>'
 	DEFB	0DH
 	DEFM	'Then type in : TRACK <ENTER> to restart the program.'
 	DEFW	0D0DH
 	DEFB	03H
 PREMSG	DEFM	'Previous Information : '
 MNAME	DEFM	'MOVIE/DAT:'	;filespec
 MEMDRV	DEFM	'1'
 	DEFB	0DH
 MEMBER	DEFB	' '		;file ID code
 	DEFM	'/DAT:'		;extension
 MOVDRV	DEFM	'1'
 	DEFB	0DH		;terminator
 INFO	DEFM	'SYSINFO:'	;filename
 INFO1	DEFM	'1'		;default drive
 	DEFB	0DH		;end of filespec
 TABLE1	DEFM	'84889296'	;leap years
 TABLE2	DEFB	31		;days in month
 FEB	DEFB	00H		;february
 	DEFB	31,30,31,30,31,31
 	DEFB	30,31,30,31
 DAY1	DEFW	0000H		;day of year today
 DAY2	DEFW	0000H		;day of year rented
 SCTRL	DEFW	0000H		;address sort
 	DEFW	0000H		;items to sort
 	DEFB	00H		;length of record
 	DEFB	00H		;offset to field
 	DEFB	00H		;length of sort field
 CAP	DEFB	00H		;0=U+L 1=Upper only
 MODE	DEFB	00H		;mode flag
 MEMTOT	DEFW	0000H		;total members
 MEMLIM	DEFW	0000H		;total member limit
 MOVLIM	DEFW	0000H		;movie limits
 TEMP1	DEFW	0000H		;number usage
 TEMP2	DEFW	0000H		;video addresses
 TEMP3	DEFW	0000H		;number storage
 MAXMEM	DEFW	999D		;maximum members 999
 ROUTE	DEFB	00H		;0=continue 1=return
 HFLAG	DEFB	00H		;for heading info
 FFLAG	DEFB	00H		;0=1 file NZ=all files
 TFLAG	DEFB	00H		;file flag
 TEMP	DEFB	00H		;char storage
 LEN	DEFB	00H		;length of string
 LEN1	DEFB	00H		;moving size
 DAILY	DEFB	00H		;overdue flag
 FLDST	DEFW	0000H		;start of field
 NUMB1	DEFW	0000H		;movie number
 NUMB2	DEFW	0000H		;member number
 VIDEO	DEFW	0000H		;video storage
 LINE	DEFB	00H		;line page counter
 PNUM	DEFW	0000H		;line page number
 MARGIN	DEFB	07		;left margin
 OFFSET	DEFB	68		;lines per page
 M1	DEFS	20		;movie title
 M2	DEFS	1		;format code (BVD)
 M3	DEFS	8		;rental date
 M4	DEFS	4		;membership number
 M5	DEFS	2		;# rentals total
 M6	DEFS	1		;misc code option
 M7	DEFS	12		;misc buffer for rental
 M7A	DEFS	4		;reserve member
 M7B	DEFB	00H		;flag for reserve
 M7C	DEFS	8		;date for reserve
 M8	DEFS	3		;price code
 GAP	DEFW	0000H
 MB1	DEFS	20		;membership name
 MB2	DEFS	20		;address
 MB3	DEFS	16		;city prov.
 MB4	DEFS	8		;zip code
 MB5	DEFS	8		;phone number
 MB6	DEFS	8		;DL number
 MB7	DEFS	20		;Credit Card Number
 MB8	DEFS	20		;misc info
 DATA	DEFS	52		;26 file totals
 MOVTOT	DEFW	0000H		;movie totals
 RESTOT	DEFW	0000H		;reservation totals
 RTABLE	DEFS	400		;allow for 200 reserves
 DUMMY	DEFS	256		;dummy IO buffer
 FBUFF	DEFS	50		;buffer for filespecs
 FBUFF1	DEFS	50		;second file buffer
 BUFF	DEFM	'      '	;number buffer
 LAST	DEFB	00H		;end of program
 SORT	DEFB	00H		;start of buffer

