       ;Video Manager Program for tracking Movie
 ;rentals and returns.
 ;<c>1983 by Mel Patrick
 	ORG	5700H		;prgrm Start
 DVECT	EQU	3033H		;date vector CALL
 	DEFM	'            '
 LOGO	DEFM	'*************** '
 	DEFM	'*    Video    * '
 	DEFM	'*   Tracker   * '
 	DEFM	'* Version 2.0 * '
 	DEFM	'*  Copyright  * '
 	DEFM	'*    c1984    * '
 	DEFM	'*      by     * '
 	DEFM	'* Mel Patrick * '
 	DEFM	'* Serial# 001 * '
 	DEFM	'*************** '
 	DEFM	'Sysinfo Drive :'
 DV1	DEFM	'1'
 	DEFM	' Member Drive :'
 DV2	DEFM	'1'
 	DEFM	'  Movie Drive :'
 DV3	DEFM	'1'
 	DEFM	' Max. Mem. '
 MXMEM	DEFM	'00005'		;maximum per disk
 	DEFM	' Max Movie:'
 MXMOV	DEFM	'00005'		;max movie per disk
 TRACK	CALL	01C9H		;erase title page
 	LD	HL,FBUFF	;point to buffer
 	PUSH	HL		;save address
 	CALL	DVECT		;read the date in
 	POP	HL		;get back address
 	LD	B,8		;bytes to read
 	LD	C,0		;checksum byte
 CHKDT	LD	A,(HL)		;get a byte
 	CP	'0'		;count the 0's
 	JR	NZ,CHKDT1	;continue if not 0
 	INC	C		;else add 1
 CHKDT1	INC	HL		;point to next
 	DJNZ	CHKDT		;loop for 8 char.
 	LD	A,C		;get number of 0's
 	CP	03H		;look for >3 0's
 	JR	C,TRACKA	;go if <3 0's
 	LD	HL,DTMSG	;else point to msg
 	CALL	DISPLY		;show it
 	JP	402DH		;and return to DOS
 TRACKA	LD	HL,FBUFF	;point to buffer
 	LD	B,8		;bytes to erase
 	CALL	ERA2		;erase any entry
 	LD	HL,MXMEM	;point to limit
 	LD	DE,FBUFF+1	;point to buffer
 	LD	BC,5		;bytes to copy
 	LDIR			;copy them
 	PUSH	DE		;move de to hl
 	POP	HL		;hl=end of number
 	CALL	ASCBIN		;convert to binary
 	LD	(MEMLIM),HL	;save total allowed
 	LD	HL,FBUFF	;point to buffer
 	LD	B,8		;bytes to erase
 	CALL	ERA2		;erase buffer
 	LD	HL,MXMOV	;point to max movies
 	LD	DE,BUFF+1	;point to buffer
 	LD	BC,5		;bytes to move
 	LDIR			;copy it
 	PUSH	DE
 	POP	HL		;hl=number units
 	CALL	ASCBIN		;convert to binary
 	LD	(MOVLIM),HL	;save max movies
 	LD	A,(DV1)		;get info drive#
 	LD	(INFO1),A	;store it
 	LD	A,(DV2)		;get member drive
 	LD	(MEMDRV),A	;store it
 	LD	A,(DV3)		;get movie drive
 	LD	(MOVDRV),A	;store it
 	CALL	GETINFO		;get all totals
 TRACK0	CALL	01C9H		;erase the video
 	XOR	A		;remove flag
 	LD	(ROUTE),A	;for return route
 	LD	(TFLAG),A	;reset times counter
 	LD	(HFLAG),A	;reset heading
 TRACK1	LD	HL,MENU1	;point to menu
 	CALL	DISPLY		;show it
 TRACK2	LD	HL,(4020H)	;get cursor address
 	LD	(VIDEO),HL	;save it
 	LD	HL,TITLE	;point to title
 	CALL	DISPLY		;show it
 	CALL	NUMCAL		;get totals
 	LD	HL,(VIDEO)	;get cursor address
 	LD	(4020H),HL	;put it back
 INKEY	CALL	49H		;wait for INKEY
 	CALL	33H		;print character
 	CP	'1'		;add members?
 	JP	Z,ADDMEM	;go if yes
 	CP	'2'		;add to Movie List
 	JP	Z,ADDMOV	;go if yes
 	CP	'5'		;search for Movie?
 	JP	Z,SERMO		;go if yes
 	CP	'3'		;want a RENTAL
 	JP	Z,MRENT		;go if yes
 	CP	'4'		;search edit member?
 	JP	Z,SERME		;go if yes
 	CP	'6'		;want return
 	JP	Z,MRET		;go if yes
 	CP	'7'		;show reserved?
 	JP	Z,SHOWRE	;go if yes
 	CP	'9'		;want a reserve?
 	JP	Z,SETRE		;go if yes
 	CP	'8'		;sort Movies?
 	JP	Z,SORMOV	;go do it then
 	AND	5FH		;convert to upper
 	CP	'Q'		;exit to DOS Ready
 	JP	Z,402DH		;go if yes
 	CP	'A'		;sort members
 	JP	Z,SORMEM	;go if yes
 	CP	'B'		;want overdue list?
 	JP	Z,OVERD		;go if yes
 	CP	'C'		;daily rental list?
 	JP	Z,DAYREN	;go if yes
 	CP	'D'		;want inventory cost
 	JP	Z,INVENT	;go if yes
 	LD	A,08H		;backspace cursor
 	CALL	33H		;erase input
 	JR	INKEY		;else loop back
 WRINFO	LD	HL,INFO		;point to file
 	LD	DE,FBUFF1	;buffer
 	CALL	441CH		;move it
 	LD	HL,DUMMY	;point to IO
 	LD	DE,FBUFF1	;point to buffer
 	LD	B,00H		;set LRL=256
 	CALL	4424H		;open not create
 	LD	HL,DATA		;point to data
 	LD	BC,456		;point to data block
 WREX	LD	DE,FBUFF1	;point to file
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write to disk
 	INC	HL		;point to next
 	DEC	BC		;minus 1 from count
 	LD	A,B		;get MSB
 	OR	C		;test for done
 	JR	NZ,WREX		;continue til done
 	LD	DE,FBUFF1	;now close
 	CALL	4428H		;the file
 	RET			;back to caller
 ADDMOV	CALL	01C9H		;clear the screen
 	LD	HL,(MOVLIM)	;get limited
 	LD	DE,(MOVTOT)	;get total
 	RST	18H		;compare them
 	JR	NZ,ADMV		;go if not full
 	LD	HL,FLMSG2	;movie file full
 	CALL	DISPLY		;show it
 	CALL	49H		;wait
 	JP	TRACK0		;and back
 ADMV	CALL	ERASE1		;erase last entry
 	CALL	GETPRE		;get previous entry
 ADDM4	CALL	GETREC		;get record number
 	CALL	01C9H		;erase video
 	LD	HL,MENU2	;point to second menu
 	CALL	DISPLY		;show it
 ADDM1	LD	HL,(4020H)	;get cursor location
 	LD	(VIDEO),HL	;save it for later
 ADDM2	LD	A,31		;clear bottom of screen
 	CALL	33H		;go do it
 	LD	HL,MENU3	;point to inputs
 	CALL	DISPLY		;show them
 	CALL	FNDFLD		;find the field
 	LD	A,20		;number of char.
 	LD	HL,M1		;point to buffer
 	CALL	INPUT		;get input
 	CALL	FNDFLD		;get next field
 	LD	A,1		;input length
 	LD	(CAP),A		;set to UPPER
 	LD	HL,M2		;point to buffer
 	CALL	INPUT		;get input
 	XOR	A		;remove CAP
 	LD	(CAP),A		;save it
 	CALL	FNDFLD		;find next field
 	LD	A,3		;length of input
 	LD	HL,M8		;buffer for it
 	CALL	INPUT		;get the input
 	LD	HL,QUEST	;point to question
 	CALL	DISPLY		;show it
 LP0	CALL	49H		;wait for INKEY
 	AND	5FH		;convert to upper
 	CP	'N'		;bad input?
 	JR	Z,ADDM6		;repeat if bad
 	CP	'E'		;want to exit?
 	JP	Z,ADDM5		;exit if done
 	LD	A,(TFLAG)	;else get times
 	OR	A		;0?
 	JR	NZ,ADDM3	;go if already open
 	INC	A		;make it a 1
 	LD	(TFLAG),A	;save it for now
 	LD	HL,MNAME	;else point to name
 	LD	DE,FBUFF	;point to file buffer
 	CALL	441CH		;move to buffer
 	LD	HL,DUMMY	;point to dummy
 	LD	DE,FBUFF	;point to file buffer
 	LD	B,64		;length of buffer
 	CALL	4420H		;open or create
 	JR	C,ADDM3		;go if no file there
 	LD	DE,FBUFF	;else step to end
 	CALL	4448H		;of file to add on
 ADDM3	LD	HL,0000H	;remove rental times
 	LD	(M5),HL		;put in buffer
 	LD	HL,M1		;point to data
 	LD	B,64		;bytes to write out
 ADDWR	LD	DE,FBUFF	;point filespec
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write it to disk
 	INC	HL		;point to next
 	DJNZ	ADDWR		;loop til done
 	LD	HL,(MOVTOT)	;get total movies
 	INC	HL		;add 1 to it
 	LD	(MOVTOT),HL	;save it
 	LD	DE,(MOVLIM)	;get limits
 	RST	18H		;compare them
 	JR	Z,MVFULL	;go if full
 	CALL	GETPRE		;move last title
 	CALL	ERASE1		;remove entry
 	JP	ADDM4		;loop til done
 MVFULL	CALL	01C9H		;clear the video
 	LD	HL,FLMSG2	;point to full
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for inkey
 	JP	ADM5AA		;close and menu
 ADDM6	LD	HL,(VIDEO)	;get address
 	LD	(4020H),HL	;restore it
 	JP	ADDM2		;and go back
 ADDM5	LD	A,(TFLAG)	;check for open file
 	OR	A		;0=closed 1=opened
 	JR	Z,ADDM5A	;go if never opened
 	LD	DE,FBUFF	;point to file
 	CALL	4428H		;close it
 	XOR	A		;remove pointer
 	LD	(TFLAG),A	;reset it
 	CALL	WRINFO		;write new info file
 ADDM5A	JP	TRACK0		;and back to main
 ADDM0	LD	HL,(VIDEO)	;get cursor
 	LD	(4020H),HL	;reset it
 	CALL	ERASE		;erase all entry
 	JP	ADDM1		;and redo the input
 GETINFO	LD	HL,INFO		;point to filename
 	LD	DE,FBUFF	;point to file buffer
 	CALL	441CH		;do it in DOS
 	LD	HL,DUMMY	;point to dummy
 	LD	DE,FBUFF	;point to filename
 	LD	B,00H		;set LRL=256
 	CALL	4424H		;open don't create
 	JR	NZ,NOFILE	;go if not created yet
 	LD	HL,DATA		;else point to data block
 	LD	BC,456		;set length to read in
 GETIN	LD	DE,FBUFF	;point to filespec
 	CALL	13H		;read a byte
 	LD	(HL),A		;store it
 	INC	HL		;point to next
 	DEC	BC		;minus from count
 	LD	A,B		;get MSB
 	OR	C		;test for zero
 	JR	NZ,GETIN	;continue til zero
 	RET			;and then go back
 NOFILE	LD	HL,DATA		;point to data
 	LD	BC,456		;bytes to write out
 ERASE	LD	(HL),00H	;zero out entries
 	INC	HL		;point to next
 	DEC	BC		;minus 1
 	LD	A,B		;get MSB
 	OR	C		;zero?
 	JR	NZ,ERASE	;no then continue
 	LD	HL,INFO		;point to name
 	LD	DE,FBUFF	;point to buffer
 	CALL	441CH		;move it
 	LD	HL,DUMMY	;point to IO
 	LD	DE,FBUFF	;point to name
 	LD	B,00H		;set LRL=256
 	CALL	4420H		;CREATE the file
 	LD	HL,DATA		;point to data
 	LD	BC,456		;bytes to write out
 NOF	LD	DE,FBUFF	;point to buffer
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write it to disk
 	INC	HL		;point to next
 	DEC	BC		;minus 1
 	LD	A,B		;get MSB
 	OR	C		;zero?
 	JR	NZ,NOF		;loop if not
 	LD	DE,FBUFF	;point to file
 	CALL	4428H		;and close it
 	RET			;and back to routine
 FNDFLD	LD	HL,(VIDEO)	;get starting add
 FNDLP	LD	A,(HL)		;look for >
 	CP	'>'		;found it?
 	JR	Z,FNDIT		;go if yes
 	CP	144		;block there?
 	JR	NZ,FNDLP1	;no then skip
 	LD	(HL),' '	;else remove it
 FNDLP1	INC	HL		;else point to next
 	JR	FNDLP		;loop til found
 FNDIT	LD	(HL),':'	;change it
 	INC	HL		;point to next
 	INC	HL		;start of field
 	LD	(FLDST),HL	;save it
 	RET			;back now
 INPUT	LD	(LEN),A		;save length
 	LD	(LEN1),A	;moving length
 	PUSH	HL		;move buffer to	IX
 	POP	IX		;IX=input buffer
 	LD	HL,(FLDST)	;get field start
 	LD	(4020H),HL	;reset cursor
 	LD	B,A		;move for blocks
 IN0	LD	(HL),144	;set a block
 	INC	HL		;point to next
 	DJNZ	IN0		;loop til done
 IN1	CALL	49H		;get input
 	CP	0DH		;enter?
 	RET	Z		;back if yes
 	CP	08H		;backspace?
 	JR	Z,IN4		;go if yes
 	CP	20H		;less than a space
 	JR	C,IN1		;back if yes
 	PUSH	AF		;save the character
 	LD	A,(LEN1)	;get length
 	OR	A		;test for zero
 	JR	Z,IN5		;back if full
 	DEC	A		;else minus 1
 	JR	IN2		;go if ok to use
 IN5	POP	AF		;else fix the stack
 	JR	IN1		;and loop back
 IN2	LD	(LEN1),A	;save new total
 	POP	AF		;get back char.
 	PUSH	AF		;save char
 	LD	A,(CAP)		;UPPER case only?
 	OR	A		;0=no 1=yes
 	JR	Z,BOTH		;go if both
 	POP	AF		;else get char
 	AND	5FH		;convert to upper
 	JR	IN2A		;and continue
 BOTH	POP	AF		;get back char
 IN2A	LD	(IX),A		;store it
 	INC	IX		;point to next
 	CALL	33H		;print it
 	JR	IN1		;loop til done
 IN4	LD	A,(LEN1)	;get input length
 	LD	B,A		;move for compare
 	LD	A,(LEN)		;get max
 	SUB	B		;maximum compare
 	JR	Z,IN1		;back if full
 	LD	A,(LEN1)	;get input length
 	INC	A		;else add 1
 	LD	(LEN1),A	;save new total
 	LD	HL,(4020H)	;get address
 	LD	A,08H		;back space
 	CALL	33H		;do it
 	LD	A,(LEN1)	;get input length
 	CP	01H		;1 charcater only
 	JR	Z,SKIP		;go if full
 	LD	(HL),144	;reset block
 SKIP	DEC	HL		;minus 1
 	LD	(HL),144	;set it too
 	DEC	IX		;backup in buffer
 	LD	(IX),' '	;remove char
 	JP	IN1		;back now
 ADDMEM	CALL	01C9H		;clear the video
 	LD	HL,(MEMLIM)	;get max allowed
 	LD	DE,(MEMTOT)	;get total so far
 	RST	18H		;compare them
 	JR	NZ,ADCONT	;go if HL<>DE
 	LD	HL,FLMSG	;else message
 	CALL	DISPLY		;show it
 	CALL	49H
 	JP	TRACK0		;and return then
 ADCONT	CALL	01C9H		;clear video
 	LD	HL,QUEST1	;get file to add to
 	CALL	DISPLY		;show prompt
 	XOR	A		;zero out A
 	LD	(TFLAG),A	;save it for now
 ADM	CALL	49H		;wait for inkey
 	CP	01H		;break?
 	JP	Z,TRACK0	;back if yes
 	AND	5FH		;convert to upper
 	CP	'A'		;check limits
 	JR	C,ADDMEM	;back if too low
 	CP	5BH		;check top limit
 	JR	NC,ADDMEM	;back if too high
 	LD	(MEMBER),A	;save file name
 	LD	(PREF),A	;store for display
 	SUB	40H		;make number 1-26
 	LD	B,A		;move to loop
 	LD	HL,DATA		;point to table
 	DEC	HL		;minus 1
 	DEC	HL		;back up 1 more
 FNDPNT	INC	HL		;step 1
 	INC	HL		;step another
 	DJNZ	FNDPNT		;loop til pointer found
 	PUSH	HL		;move it to
 	POP	IY		;IY.
 	LD	HL,MB1		;start of buffer
 	LD	B,120		;buffer length
 	CALL	ERA2		;fill with spaces
 	CALL	GETPR1		;get previous entry
 ADM4	LD	HL,(MEMTOT)	;get total
 	INC	HL		;add 1 to it
 	LD	(MEMTOT),HL	;save it
 	LD	DE,(MEMLIM)	;get limit
 	INC	DE		;add 1 for test
 	RST	18H		;check for max
 	JR	NZ,ADM40	;go if not full yet
 	CALL	01C9H		;else erase video
 	LD	HL,FLMSG	;point to full
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for a KEY
 	LD	A,0DH		;put in a C/R
 	JR	ADM45		;and close and exit
 ADM40	LD	L,(IY+00)	;get LSB total
 	LD	H,(IY+01)	;get MSB total
 	INC	HL		;add 1 to it
 	LD	DE,(MAXMEM)	;get maximum per file
 	RST	18H		;compare them
 	JR	NZ,ADM4A	;go if still lower
 ADM44	CALL	01C9H		;else clear the video
 	LD	HL,3DC0H	;new cursor position
 	LD	(4020H),HL	;reset it
 	LD	HL,FULMSG	;point to message
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for key press
 	AND	5FH		;convert to upper
 ADM45	PUSH	AF		;save character
 	LD	A,(TFLAG)	;get counter byte
 	OR	A		;0=not opened yet
 	JR	Z,ADM4AB	;go if no file there
 	LD	DE,FBUFF	;now close the file
 	CALL	4428H		;close it
 	XOR	A		;remove flag
 	LD	(TFLAG),A	;from routine
 	CALL	WRINFO		;write out totals
 ADM4AB	POP	AF		;get back char.
 	CP	'C'		;continue
 	JP	Z,ADDMEM	;go if yes
 	JP	TRACK0		;else main menu
 ADM4A	LD	L,(IY+00)	;get LSB
 	LD	H,(IY+01)	;get MSB
 	INC	HL		;add for next
 	LD	DE,MEMNUM	;point to buffer
 	CALL	BINASC		;convert it
 	CALL	01C9H		;clear screen
 	LD	HL,MENU4	;get heading
 	CALL	DISPLY		;show it
 ADM1	LD	HL,(4020H)	;get cursor add.
 	LD	(VIDEO),HL	;save it
 ADM2	LD	A,31		;erase to bottom
 	CALL	33H		;do it
 	LD	HL,MENU5	;point to prompts
 	CALL	DISPLY		;show them
 ADM2A	CALL	FNDFLD		;find field
 	LD	A,20		;input length
 	LD	HL,MB1		;buffer
 	CALL	CPDAT		;check for previous
 	CALL	INPUT		;go get it
 	CALL	FNDFLD		;next field
 	LD	A,20		;length
 	LD	HL,MB2		;address buffer
 	CALL	CPDAT		;check for prev.
 	CALL	INPUT		;get input
 	CALL	FNDFLD		;find next field
 	LD	A,16		;length
 	LD	HL,MB3		;city or province
 	CALL	CPDAT		;check previous
 	CALL	INPUT		;get it
 	CALL	FNDFLD		;get next
 	LD	A,8		;length
 	LD	HL,MB4		;zip code
 	CALL	CPDAT		;check prev.
 	CALL	INPUT		;get it
 	CALL	FNDFLD		;next field
 	LD	A,8		;length
 	LD	HL,MB5		;phone number
 	CALL	CPDAT		;check prev.
 	CALL	INPUT		;get it
 	CALL	FNDFLD		;find next
 	LD	A,8		;length
 	LD	HL,MB6		;driver liscence
 	CALL	CPDAT		;check prev.
 	CALL	INPUT		;get it
 	CALL	FNDFLD		;find next
 	LD	A,20		;credit card number
 	LD	HL,MB7		;buffer
 	CALL	CPDAT		;check prev.
 	CALL	INPUT		;go get it
 	CALL	FNDFLD		;find last input
 	LD	A,20		;length
 	LD	HL,MB8		;misc info
 	CALL	CPDAT		;check prev.
 	CALL	INPUT		;get input
 	LD	A,(ROUTE)	;get route
 	OR	A		;0=continue 1=jump
 	RET	NZ		;back if routed
 	LD	HL,QUEST	;check entry
 	CALL	DISPLY		;show it
 ALP	CALL	49H		;wait for inkey
 	AND	5FH		;convert to upper
 	CP	'N'		;bad input
 	JR	Z,ADM6		;go if bad
 	CP	'E'		;else all done?
 	JR	Z,ADM5		;go if done
 	LD	A,(TFLAG)	;get flag
 	OR	A		;test for first time
 	JR	NZ,ADM3		;go if second time
 	INC	A		;else make it 1
 	LD	(TFLAG),A	;and store it
 	LD	HL,MEMBER	;point to name
 	LD	DE,FBUFF	;point to buffer
 	CALL	441CH		;move it
 	LD	HL,DUMMY	;point to DUMMY
 	LD	DE,FBUFF	;point to name
 	LD	B,120		;LRL=120
 	CALL	4420H		;open or create
 	JR	C,ADM3		;go if no file
 	LD	DE,FBUFF	;else point to file
 	CALL	4448H		;step to the end
 ADM3	LD	HL,MB1		;start of buffer
 	LD	B,120		;bytes to write
 ADWR	LD	DE,FBUFF	;point to buffer
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write to disk
 	INC	HL		;point to next
 	DJNZ	ADWR		;loop til done
 	LD	L,(IY+00)	;get LSB total
 	LD	H,(IY+01)	;get MSB
 	INC	HL		;add 1 to it
 	LD	(IY+00),L	;save it
 	LD	(IY+01H),H	;save MSB
 	CALL	GETPR1		;get last entry
 	LD	HL,MB1		;point to buffer
 	LD	B,120		;bytes to erase
 	CALL	ERA2		;erase entry
 	JP	ADM4		;loop til done
 ADM6	LD	HL,(VIDEO)	;get address
 	LD	(4020H),HL	;reset it
 	JP	ADM2		;and repeat entry
 ADM5	LD	A,(TFLAG)	;get for open file
 	OR	A		;0=closed 1=opened
 	JR	Z,ADM5A		;go if closed
 ADM5AA	LD	DE,FBUFF	;point to file
 	CALL	4428H		;close it
 	XOR	A		;zero out a
 	LD	(TFLAG),A	;save it
 	CALL	WRINFO		;write new info file
 ADM5A	JP	TRACK0		;and back to menu
 SERMO	LD	HL,(MOVTOT)	;get total movies
 	LD	A,H		;test for entries
 	OR	L		;0=none
 	JP	Z,TRACK0	;back if none in file
 	CALL	01C9H		;clear screen
 	LD	HL,MENU6	;point to menu
 	CALL	DISPLY		;show it
 	LD	HL,3C00H	;reset field info
 	LD	(VIDEO),HL	;store it
 SUBIN2	LD	HL,MORN		;point to buffer
 	LD	B,6		;bytes to zero
 	CALL	ERA2		;erase any entry
 	CALL	FNDFLD		;find the field
 	LD	A,5		;maximum input
 	LD	HL,MORN		;point to buffer
 	CALL	INPUT		;get info
 	LD	A,(LEN1)	;get length entered
 	LD	B,A		;move for subtract
 	LD	A,(LEN)		;get maximum length
 	SUB	B		;find difference
 	JP	Z,TRACK0	;back if no input
 	PUSH	IX		;move IX to
 	POP	HL		;HL for routine
 	CALL	ASCBIN		;convert to binary
 	DEC	HL		;minus 1 for retrieve
 	LD	(NUMB1),HL	;save number now
 	LD	DE,(MOVTOT)	;get total number
 	RST	18H		;HL must be <= DE
 	JP	NC,TRACK0	;back if too high
 SERM1	LD	HL,MNAME	;point to file
 	LD	DE,FBUFF	;point to buffer
 	CALL	441CH		;move it
 SERM1A	LD	HL,DUMMY	;point to IO
 	LD	DE,FBUFF	;point to name
 	LD	B,64		;LRL=64
 	CALL	4424H		;just open it
 SERM3	LD	BC,(NUMB1)	;get logical Rec#
 	LD	HL,DUMMY	;point to dummy
 	LD	DE,FBUFF	;point to buffer
 	CALL	4442H		;and position it
 	LD	HL,M1		;point to buffer
 	LD	B,64		;bytes to read in
 SERM2	LD	DE,FBUFF	;point to name
 	CALL	13H		;read a byte
 	LD	(HL),A		;store it
 	INC	HL		;point to next
 	DJNZ	SERM2		;loop til done
 	LD	A,(ROUTE)	;get route
 	OR	A		;0=continue
 	RET	NZ		;back if >=1
 	CALL	01C9H		;clear video
 	LD	HL,MENU6	;point to heading
 	CALL	DISPLY		;show it
 	LD	HL,(4020H)	;get cursor
 	LD	(VIDEO),HL	;save it for now
 SUBIN3	LD	HL,M1		;set for copy
 	LD	DE,MIN		;point for info
 	LD	BC,20
 	LDIR			;copy it
 	LD	HL,M2
 	LD	A,(HL)
 	LD	DE,MIN0
 	LD	(DE),A
 	LD	HL,M8
 	LD	DE,MIN1
 	LD	BC,3
 	LDIR
 	LD	HL,M3
 	LD	DE,MIN2
 	LD	BC,8
 	LDIR
 	LD	HL,M7B
 	LD	DE,MIN3
 	LD	A,(HL)
 	LD	(DE),A
 	LD	HL,M4
 	LD	DE,MIN4
 	LD	BC,4
 	LDIR
 	LD	HL,M7A
 	LD	DE,MIN5
 	LD	BC,4
 	LDIR
 	LD	HL,M7C
 	LD	DE,MIN7
 	LD	BC,8
 	LDIR
 	LD	HL,M7
 	LD	DE,MIN8
 	LD	BC,12
 	LDIR
 	LD	HL,(M5)		;get total rentals
 	LD	DE,MIN6
 	CALL	BINASC
 	LD	A,' '		;remove last 03H
 	LD	(DE),A
 	LD	HL,MENU7
 	CALL	DISPLY
 	LD	A,(ROUTE)	;get route
 	OR	A		;0=continue 1 return
 	RET	NZ		;back if routine
 	LD	HL,QUEST5	;point to prompt
 	CALL	DISPLY		;show it
 SERLP	CALL	49H		;wait for INKEY
 	CP	5BH		;up arrow?
 	JR	Z,STEPB		;step back one
 	CP	0AH		;else down arrow
 	JR	Z,STEPA		;step ahead then
 	AND	5FH		;convert to upper
 	CP	'Q'		;quit?
 	JP	Z,TRACK0	;back if yes
 	CP	'E'		;edit it?
 	JR	Z,EDMOV		;go if yes
 	JR	SERLP		;else loop
 STEPB	LD	HL,(NUMB1)	;get record#
 	DEC	HL		;minus 1
 	JR	STEPC		;and continue
 STEPA	LD	HL,(NUMB1)	;get number
 	INC	HL		;point to next
 STEPC	LD	DE,(MOVTOT)	;get total
 	RST	18H		;compare them
 	JR	NC,SERLP	;back if too high
 	LD	(NUMB1),HL	;else save new number
 	INC	HL		;back to orig number
 	LD	DE,MORN		;point to buffer
 	CALL	BINASC		;convert
 	LD	A,' '		;remove last 03H
 	LD	(DE),A		;in buffer
 	JP	SERM3		;and get it
 EDMOV	CALL	SHMSG		;show message
 	CALL	FNDFLD		;find the field
 	LD	A,20		;bytes to get
 	LD	HL,M1		;title buffer
 	CALL	CPDATA		;copy last data
 	CALL	INPUT		;get input
 	CALL	FNDFLD		;find next
 	LD	A,1		;setup caps only
 	LD	(CAP),A		;set it
 	LD	HL,M2		;format buffer
 	CALL	CPDATA		;display last entry
 	CALL	INPUT		;get input
 	XOR	A		;zero out caps
 	LD	(CAP),A		;now
 	CALL	FNDFLD		;find field
 	LD	A,3		;length
 	LD	HL,M8		;cost buffer
 	CALL	CPDATA		;show last entry
 	CALL	INPUT		;get info
 	CALL	FNDFLD		;next input
 	LD	A,8		;length
 	LD	HL,M3		;rental date buffer
 	CALL	CPDATA		;show last entry
 	CALL	INPUT		;get new info
 	CALL	FNDFLD		;point to reserve flag
 	CALL	FNDFLD		;go to Rental Mem #
 	LD	A,4		;length
 	LD	HL,M4		;member number
 	CALL	CPDATA		;show last entry
 	CALL	INPUT		;get it
 	CALL	FNDFLD		;point to reserve#
 	LD	A,(M7B)		;get reserve flag
 	CP	'*'		;anything?
 	JR	NZ,SKP		;no then skip it
 	LD	A,4		;else get input
 	LD	HL,M7A		;reserve buffer
 	CALL	CPDATA		;show last data
 	CALL	INPUT		;get new number
 SKP	CALL	FNDFLD		;point to total
 	CALL	FNDFLD		;point to reserve date
 	LD	A,(M7B)		;check for flag
 	CP	'*'		;set?
 	JR	NZ,SKP1		;go if not
 	LD	A,8		;length
 	LD	HL,M7C		;res date buffer
 	CALL	CPDATA		;show last entry
 	CALL	INPUT		;get it
 SKP1	CALL	FNDFLD		;point to info now
 	LD	A,12		;bytes to input
 	LD	HL,M7		;buffer
 	CALL	CPDATA		;show last info
 	CALL	INPUT		;get it
 	LD	HL,DUMMY	;point to dummy
 	LD	DE,FBUFF	;point to buffer
 	LD	BC,(NUMB1)	;get record number
 	CALL	4442H		;position it
 	LD	HL,M1		;point to buffer
 	LD	B,64		;bytes to write out
 SKP2	LD	DE,FBUFF	;point to name
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write to disk
 	INC	HL		;point to next
 	DJNZ	SKP2		;loop til done
 	LD	DE,FBUFF	;point to file
 	CALL	4428H		;close and write it
 	JP	SERM1A		;and read it back
 ERA3	LD	HL,3FDCH	;location to erase
 	LD	B,20H		;bytes to erase
 	CALL	ERA2		;erase it
 	RET			;back to caller
 CPDAT	PUSH	AF		;save length
 	LD	A,(ROUTE)	;get route
 	OR	A		;1=on 0=off
 	JR	Z,CPBCK		;go if off
 	POP	AF		;else its on
 	JR	CPDATA		;copy data to bottom
 CPBCK	POP	AF		;get back character
 	RET			;back to caller
 CPDATA	PUSH	HL		;save data location
 	PUSH	AF		;save length
 	CALL	ERA3		;erase last entry
 	POP	AF		;get back registers
 	POP	HL		;"	"
 	PUSH	HL		;save them for return
 	PUSH	AF		;"	"
 	LD	DE,3FDCH	;DE=destination
 	LD	B,0		;zero out MSB
 	LD	C,A		;move LSB to counter
 	LDIR			;copy data down
 	POP	AF		;get back length
 	POP	HL		;and location
 	RET			;back to caller
 SHMSG	LD	HL,PREMSG	;point to message
 	LD	DE,3FC5H	;bottom of video
 	LD	BC,23		;bytes to move
 	LDIR			;copy them
 	RET			;back to caller
 SERME	LD	HL,MERN		;point to record
 	LD	B,6		;bytes to erase
 	CALL	ERA2		;erase them
 	CALL	01C9H		;clear video
 	LD	HL,MENU8	;point to menu
 	CALL	DISPLY		;show it
 	LD	HL,3C00H	;reset video
 	LD	(VIDEO),HL	;save it
 SUBIN	CALL	FNDFLD		;find field
 	LD	HL,MEMN		;point to buffer
 	LD	A,1		;length
 	LD	(CAP),A		;save it
 	CALL	INPUT		;get it
 	XOR	A		;remove flag
 	LD	(CAP),A		;and reset it
 	LD	A,(MEMN)	;get file
 	LD	(MEMBER),A	;move it
 	CALL	FNDFLD		;find field
 	LD	HL,MERN		;point to buffer
 	LD	A,3		;max input
 	CALL	INPUT		;get it
 	LD	A,(LEN1)	;get length
 	LD	B,A		;move it
 	LD	A,(LEN)		;get max
 	SUB	B		;find dif
 	JP	Z,TRACK0	;back if none
 	PUSH	IX		;else move to HL
 	POP	HL		;HL = end now
 	CALL	ASCBIN		;get number
 	DEC	HL		;minus 1 for GET
 	LD	(NUMB2),HL	;save in second
 	LD	A,(MEMBER)	;get file to use
 	SUB	40H		;make it 1-26
 	LD	B,A		;move to loop
 	LD	HL,DATA		;point to table
 	DEC	HL
 	DEC	HL		;back up twice
 SER1	INC	HL		;step
 	INC	HL		;through now
 	DJNZ	SER1		;loop til found
 	PUSH	HL		;move to IY
 	POP	IY		;IY=number entries
 	LD	E,(IY+00)	;get LSB
 	LD	D,(IY+01)	;get MSB
 	LD	(TEMP1),DE	;save total
 	LD	HL,(NUMB2)	;get our number
 	RST	18H		;compare them
 	JP	NC,TRACK0	;back if too high
 SER2	LD	HL,MEMBER	;point to file
 	LD	DE,FBUFF	;point to buffer
 	CALL	441CH		;move it
 SER2A	LD	HL,DUMMY	;IO
 	LD	DE,FBUFF	;filespec
 	LD	B,120		;LRL=120
 	CALL	4424H		;open not create
 SER3	LD	BC,(NUMB2)	;get REC#
 	LD	DE,FBUFF	;point to file
 	CALL	4442H		;find record
 	LD	HL,MB1		;point to buffer
 	LD	B,120		;bytes to read
 SER4	LD	DE,FBUFF	;point to file
 	CALL	13H		;read a byte
 	LD	(HL),A		;store it
 	INC	HL		;point to next
 	DJNZ	SER4		;loop til read in
 	LD	A,(ROUTE)	;get route
 	OR	A		;test for 0
 	RET	NZ		;back if set
 	CALL	01C9H		;clear video
 	LD	HL,MENU8	;point to menu
 	CALL	DISPLY		;show it
 	LD	HL,(4020H)	;get cursor address
 	LD	(VIDEO),HL	;save it
 SUBIN4	LD	HL,MB1		;copy all info for
 	LD	DE,ME		;display purposes
 	LD	BC,20
 	LDIR
 	LD	HL,MB2
 	LD	DE,ME0
 	LD	BC,20
 	LDIR
 	LD	HL,MB3
 	LD	DE,ME1
 	LD	BC,16
 	LDIR
 	LD	HL,MB4
 	LD	DE,ME2
 	LD	BC,8
 	LDIR
 	LD	HL,MB5
 	LD	DE,ME3
 	LD	BC,8
 	LDIR
 	LD	HL,MB6
 	LD	DE,ME4
 	LD	BC,8
 	LDIR
 	LD	HL,MB7
 	LD	DE,ME5
 	LD	BC,20
 	LDIR
 	LD	HL,MB8
 	LD	DE,ME6
 	LD	BC,20
 	LDIR
 	LD	HL,MENU9
 	CALL	DISPLY
 	LD	A,(ROUTE)	;get byte
 	OR	A		;0=continue
 	RET	NZ		;back if ret instruction
 	LD	HL,QUEST5	;point to question
 	CALL	DISPLY		;show it
 SER5	CALL	49H		;wait for inkey
 	CP	5BH		;up arrow
 	JR	Z,SER6		;go if yes
 	CP	0AH		;else down arrow
 	JR	Z,SER7		;go if yes
 	AND	5FH		;else convert to upper
 	CP	'Q'		;quit?
 	JP	Z,TRACK0	;back if yes
 	CP	'E'		;edit member
 	JR	Z,EDMEM		;go if yes
 	JR	SER5		;else loop
 EDMEM	LD	A,1		;set flag now
 	LD	(TFLAG),A	;set it up
 	LD	(ROUTE),A	;set route command
 	CALL	SHMSG		;show message
 	CALL	ADM2A		;go get all inputs
 	LD	HL,DUMMY	;point to dummy
 	LD	DE,FBUFF	;point to file
 	LD	BC,(NUMB2)	;get record number
 	CALL	4442H		;move to it
 	LD	HL,MB1		;point to buffer
 	LD	B,120		;bytes to write out
 EDM0	LD	DE,FBUFF	;point to name
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write it to disk
 	INC	HL		;point to next
 	DJNZ	EDM0		;loop til written
 	LD	DE,FBUFF	;point to name
 	CALL	4428H		;close to write it
 	XOR	A		;remove route
 	LD	(ROUTE),A	;from routine
 	LD	(TFLAG),A	;and times as well
 	JP	SER2A		;and then read it back
 SER6	LD	HL,(NUMB2)	;get user number
 	DEC	HL		;minus 1
 	JR	SER8		;and continue
 SER7	LD	HL,(NUMB2)	;get user#
 	INC	HL		;add 1
 SER8	LD	DE,(TEMP1)	;get total recs
 	RST	18H		;compare them
 	JR	NC,SER5		;back if too high
 	LD	(NUMB2),HL	;else save it
 	INC	HL		;add 1 for video
 	LD	DE,MERN		;point to buffer
 	CALL	BINASC		;convert
 	LD	A,' '		;remove 03h
 	LD	(DE),A		;from buffer
 	JP	SER3		;and redo it
 	GET	TRB/ASM		;get second part
 	GET	TRC/ASM		;get third part
 	ORG	0C000H
 MARQ	CALL	01C9H		;clear the video
 	LD	HL,3CD8H	;start position
 	LD	IX,LOGO		;point to logo
 	LD	B,10		;lines to print
 LOLP	PUSH	BC		;save counter
 	PUSH	HL
 	LD	B,16		;bytes to print
 LOPTLP	LD	A,(IX)		;get info
 	LD	(HL),A		;copy it
 	INC	IX
 	INC	HL
 	DJNZ	LOPTLP		;loop for 16 bytes
 	POP	HL		;get address
 	POP	BC		;get back count
 	LD	DE,64		;bytes to offset
 	ADD	HL,DE		;find next
 	DJNZ	LOLP		;loop til done
 	LD	HL,3C00H	;top right corner
 	LD	B,32		;draw top line
 DRW	LD	(HL),140	;set graphic block
 	INC	HL		;point to next
 	LD	(HL),80H	;set graphic space
 	INC	HL		;point to next
 	DJNZ	DRW		;loop for 32 time
 	LD	HL,3C7FH	;end of next line
 	LD	DE,64		;offset between lines
 	LD	B,7		;loop counter
 DRW1	LD	(HL),179	;show graphic
 	ADD	HL,DE		;point to next
 	LD	(HL),140	;different block
 	ADD	HL,DE		;find next
 	DJNZ	DRW1		;loop til done
 	LD	HL,3FFFH	;end of video
 	LD	B,32		;bytes to draw
 DRW2	LD	(HL),140	;graphic block
 	DEC	HL		;back up one
 	LD	(HL),80H	;set space
 	DEC	HL		;back up another
 	DJNZ	DRW2		;loop til done
 	LD	HL,3F80H	;second botm left
 	LD	B,7		;lines to do
 	LD	DE,64		;offset between lines
 DRW3	LD	(HL),179	;set graphic
 	OR	A		;clear carry
 	SBC	HL,DE		;find previous
 	LD	(HL),140	;graphic
 	OR	A		;again
 	SBC	HL,DE		;find previous
 	DJNZ	DRW3		;loop til done
 ROTATE	LD	HL,3C00H	;start of video
 	LD	B,64		;bytes to scan
 R1	CALL	DELAY		;wait a bit
 	LD	A,(HL)		;get a byte
 	CP	140		;graphic?
 	JR	Z,GRAPH		;go if graphic
 	LD	(HL),140	;else its a space
 R1A	INC	HL		;point to next
 	DJNZ	R1		;loop til done
 	CALL	2BH		;do keyboard scan
 	OR	A		;look for keypress
 	JP	NZ,TRACK	;start program now
 	JR	ROT2		;go on to second line
 GRAPH	LD	(HL),80H	;replace with space
 	JR	R1A		;and return
 ROT2	LD	HL,3C7FH	;point to end line
 	LD	B,14		;bytes to loop through
 R2	CALL	DELAY		;wait a bit
 	LD	A,(HL)		;get a byte
 	CP	140		;graphic?
 	JR	Z,GR2		;go if yes
 	LD	(HL),140	;else make it one
 R2A	LD	DE,64		;offset to next
 	ADD	HL,DE		;find next line
 	DJNZ	R2		;and ocntinue
 	JR	ROT3		;continue to bottom
 GR2	LD	(HL),179	;different block
 	JR	R2A		;and return
 ROT3	LD	HL,3FFFH	;end of video
 	LD	B,64		;bytes to loop
 R3	CALL	DELAY		;wait a bit
 	LD	A,(HL)		;get a byte
 	CP	140		;graphic?
 	JR	Z,GR3		;go if yes
 	LD	(HL),140	;else make it one
 R3A	DEC	HL		;back up one
 	DJNZ	R3		;loop til done
 	JR	ROT4		;and do last line
 GR3	LD	(HL),80H	;replace the block
 	JR	R3A		;and return
 ROT4	LD	HL,3F80H	;start of last
 	LD	DE,64		;offset used
 	LD	B,14		;lines to check
 R4	CALL	DELAY		;wait a bit
 	LD	A,(HL)		;get a byte
 	CP	140		;block?
 	JR	Z,GR4		;go if yes
 	LD	(HL),140	;else make it one
 R4A	OR	A		;clear the carry
 	SBC	HL,DE		;find previous line
 	DJNZ	R4		;loop til done
 	JP	ROTATE		;continue now
 GR4	LD	(HL),179	;different block
 	JR	R4A		;and return
 DELAY	PUSH	BC		;save counter
 	LD	BC,55		;else reset value
 DELAY1	CALL	60H		;do rom delay
 	POP	BC		;restore count
 	RET			;delay routine
 	END	MARQ		;end of routine

