HHHH   ; VIDEO DISPLAY OF INTERRUPT AND BASIC PROGRAM AR55 & 56
 ; SAVE EVERYTHING INCLUDING THE KITCHEN SINK:
 ; AF, BC, DE, HL, & IX REGISTERS
 ; ACCUM AND CDBL STORE IN TACUM 1 & 2
 ; CURSOR , LINE POSTION, AND CURSOR CHARACTER IN MEM
 ; RELOCATE STACK POINTER TO 31998 IN MEMORY
 START	EQU	7D00H		;= 32000 DECIMAL
 	ORG	START		;PGM. BEGINS AT 32000
 	EX	AF,AF'		;SWAP ALT. AF REGISTERS
 	EXX			;SWAP BC-DE-HL REGISTERS
 	PUSH	IX		;SAVE IX REG. IN STACK
 	LD	DE,411DH	;ACCUM ADDRESS
 	LD	HL,TACUM1	;TEMPORARY ACCUM STASH
 	LD	B,8		;BYTES TO MOVE
 	CALL	09D7H		;MOVE IT SUBROUTINE
 	LD	DE,4127H	;CDBL STORE ADDRESS
 	LD	HL,TACUM2	;TEMPORARY CDBL STASH
 	LD	B,8		;BYTES TO MOVE
 	CALL	09D7H		;MOVE IT SUBROUTINE
 	LD	A,(40AFH)	;NUMBER TYPE FLAG
 	LD	(TNTF),A	;SAVE NUMBER TYPE FLAG
 	LD	HL,(4020H)	;CURSOR POSITION IN MEM
 	LD	(32400),HL	;SAVE IT AT 32400/32401
 	LD	A,(40A6H)	;CURSOR LINE POSITION
 	LD	(32402),A	;SAVE IT AT 32402
 	LD	A,(4022H)	;CURSOR CHARACTER
 	LD	(32403),A	;SAVE IT AT 32403
 	LD	HL,15369	;VIDEO MEM LOCATION
 	LD	(4020H),HL	;MOVE CURSOR TO 15370
 VIDEO	DEFM	'INTERRUPT  CYCLES ='
 	DEFB	0		;DEF MESSAGE DELIMITER
 	LD	HL,VIDEO	;MESSAGE LOCATION IN MEM
 	CALL	28A7H		;DISPLAY MESSAGE AT HL
 	LD	A,2		; 2 = INTEGER NUMBER TYPE
 	LD	(40AFH),A	;NUMBER TYPE MEM LOCATION
 	LD	DE,(32404)	;INTERRUPT COUNTER STORE
 	INC	DE		;ADD + 1 TO DE
 	LD	(32404),DE	;STASH IT AWAY IN MEM
 	DEC	DE		;SUBTRACT - 1 FROM DE
 	LD	HL,1		;+1 TO HL REGISTER
 	CALL	0BD2H		;ADD DE + HL IN ACCUM
 	CALL	0FBDH		;CONVERT ACCUM TO STRING
 	CALL 28A7H		;DISPLAY STRING ON VIDEO
 WAIT	LD	A,(14400)	;MEM-ARROW KEYBOARD ROW
 	CP	64		;RIGHT ARROW PRESSED = 64
 	JR	NZ,WAIT		;GOTO WAIT TILL RT. ARROW
 	LD	HL,(32400)	;OLD CURSOR POSTION
 	LD	(4020H),HL	;RESTORE ORIGINAL CURSOR
 	LD	A,(32402)	;ORIG. LINE POSITION
 	LD	(40A6H),A	;RESTORE IT
 	LD	A,(32403)	;ORIG. CURSOR CHARACTER
 	LD	(4022H),A	;RESTORE IT
 	LD	DE,TACUM1	;TEMP. ACCUM. ADDRESS
 	LD	HL,411DH	;NORMAL ACCUM ADDRESS
 	LD	B,8		;BYTES TO MOVE
 	CALL	09D7H		;MOVE TEMP ACCUM BACK
 	LD	DE,TACUM2	;TEMP. CDBL STORE ADDRESS
 	LD	HL,4127H	;NORMAL CDBL STORE ADDR.
 	LD	B,8		;BYTES TO MOVE
 	CALL 	09D7H		;MOVE CDBL STORE BACK
 	LD	A,(TNTF)	;TEMP NUMBER TYPE FLAG
 	LD	(40AFH),A	;RESTORE NUMBER TYPE FLAG
 	EX	AF,AF'		;RESTORE ORIGINAL REGS.
 	EXX			; "	  "	   "
 	POP	IX		;RESTORE IX REG. FM STACK
 	EI			;ENABLE INTERRUPT IFF1
 	RET			;BASIC ADDRESS FM STACK
 TACUM1	DEFS	8		;8 BYTES ACCUM STASH
 TACUM2	DEFS	8		;8 BYTES CDBL STORE STASH
 TNTF	DEFS	1		;NUMBER TYPE FLAG STASH
 	ORG	32200		;CONT. PGM. AT 32200 DEC.
 	LD	SP,START-2	;MOVE STACK POINTER
 	IM	1		;SET INTERRUPT MODE 1
 	EI			;ENABLE INTERRUPT IFF1
 	JP	114		;RETURN TO BASIC 'READY'
 	END	32200		;INITIALIZE AT 32200
