QQQQ   ; W4UCH TRS-80 VHF DATA LINK PROGRAM - QQQQ & R
 ;
 ; WILL TRANSMIT AND RECEIVE KEYBOARD DATA VIA DUPLEX
 ;
 ; PLUS TRANSFER BASIC AND ASSEMBLER PROGRAM LISTINGS
 ;
 W4UCH	EQU	32000		;= 7D00H FOR PURISTS ?
 	ORG	W4UCH		;START THE PROGRAM HERE
 	CALL	01C9H		;CLS ROM SUBROUTINE
 	LD	SP,32760	;MOVE STACK HERE
 	OUT	(232),A		;UART MASTER RESET LATCH
 	LD	HL,MESS1	;STRING MEM ADDRESS
 	CALL	28A7H		;DISPLAY STRING ROUTINE
 MESS1	DEFM	'A = ONE HUNDRED TEN BAUD & B = THREE HUNDRED BAUD ? '
 	DEFB	00		;END OF MESSAGE DELIMITER
 	CALL	049H		;KEYBOARD INPUT TO 'A'
 	CALL	032AH		;DISPLAY INPUT
 	CP	65		;A=65 SUBTRACT FROM 'A'
 	JR	Z,LOAD		;GOTO LOAD IF ZERO
 	LD	A,13		;13 = CONTROL SKIP A LINE
 	CALL	033H		;DO IT ON VIDEO DISPLAY
 	LD	A,55H		;55H = 300 BAUD
 	OUT	(233),A		;SET BAUD RATE AT 300
 	LD	A,237		;8 BITS, 1 STOP, NO PAR
 	OUT	(234),A		;INITIALIZE ABOVE
 LOOK	LD	A,14		;CONTROL 14 = CURSOR 'ON'
 	CALL	033H		;DO IT ON VIDEO
 	LD	A,(14400)	;= KEYBOARD CLEAR KEY ROW
 	CP	2		;2 = CLEAR KEY PRESSED
 	JP	Z,W4UCH		;CHANGE BAUD RATE
 	CP	4		;4 = 'BREAK' KEY PRESSED
 	JP	Z,XMIT2		;GOTO XMIT2 SUBROUTINE
 	CP	6		;'CLEAR & BREAK' PRESSED?
 	JP	Z,0072H		;RETURN TO BASIC 'READY'
  	CALL	INPUT		;INPUT SUBROUTINE
 	CALL	OUTPUT		;OUTPUT SUBROUTINE
 	JP	LOOK		;TAKE ANOTHER LOOK
 INPUT	IN	A,(234)		;IS UART READY ?
 	BIT	7,A		;TEST BIT 7 SET 'Z'
 	RET	Z		;RETURN 'IF' NOT READY
 	IN	A,(235)		;LOAD PORT 235 INTO 'A'
 	JP	Z,INPUT		;IF ZERO, LOOK AGAIN
 	CALL	033H		;IF NOT ZERO, DISPLAY IT
 	JP	INPUT		;LOOK AGAIN
 OUTPUT	CALL	02BH		;CHECK THE KEYBOARD
 	OR	A		;SET 'Z' FLAG
 	RET	Z		;RETURN IF ZERO
 	PUSH	AF		;SAVE AF IN STACK
 XMIT1	IN	A,(234)		;TEST UART 'READY'
 	BIT	6,A		;TEST BIT 6 SET 'Z'
 	JP	Z,XMIT1		;IF 'NOT' LOOK AGAIN
 	POP	AF		;RESTORE FROM STACK
 	OUT	(235),A		;SEND BYTE TO UART
 	RET			;RETURN TO 'LOOP'
 LOAD	LD	A,13		;13 = CONTROL SKIP A LINE
 	CALL	033H		;DO IT ON VIDEO
 	LD	A,33H		;33H = 110 BAUD
 	OUT	(233),A		;SET BAUD RATE TO 110
 	LD	A,253		;8 BITS, 2 STOP, NO PAR
 	OUT 	(234),A		;INITIALIZE ABOVE
 	JP	LOOK		;GOTO LOOK AGAIN
 ;
 ; BASIC & ASSEMBLER PGM TRANSFER VIA VHF DATA LINK
 ;
 XMIT2	LD	A,13		;CONTROL 13 = SKIP A LINE
 	CALL	033H		;DO IT ON VIDEO
 	LD	HL,MESS2	;MESSAGE 2 ADDRESS TO HL
 	CALL	28A7H		;DISPLAY STRING ROUTINE
 MESS2	DEFM	'INPUT PROGRAM BEGINNING ADDRESS  ?  '
 	DEFB	0		;END OF MESSAGE DELIMITER
 	CALL	1BB3H		;KYBD/VIDEO INPUT ROUTINE
 	RST	10H		;SCAN STRING - SET C FLAG
 	CALL	0E6CH		;ASCII - ACCUM RET MIN
 	CALL	0A7FH		;CONVERT ACCUM TO INTEGER
 	PUSH	HL		;SAVE ACCUM IN STACK
 	LD	HL,MESS3	;MESSAGE 3 ADDRESS TO HL
 	CALL	28A7H		;DISPLAY STRING ROUTINE
 MESS3	DEFM	'INPUT NO. OF PROGRAM BYTES TO MOVE ?  '
 	DEFB	0		;END OF MESSAGE DELIMITER
 	CALL	1BB3H		;KYBD/VIDEO INPUT ROUTINE
 	RST	10H		;SCAN STRING - SET C FLAG
 	CALL	0E6CH		;ASCII - ACCUM RET MIN
 	CALL	0A7FH		;CONVERT ACCUM TO INTEGER
 	PUSH	HL		;SAVE NO. TO MVE IN STACK
 	LD	HL,MESS4	;MESSAGE 4 ADDRESS TO HL
 	CALL	28A7H		;DISPLAY STRING ROUTINE
 MESS4	DEFM	'TRANSMIT OR RECEIVE (T/R)  ?  '
 	DEFB	0		;END OF MESSAGE DELIMITER
 	CALL	049H		;AWAIT KEYBOARD INPUT
 	CP	82		;R=82 SUBTRACT FROM 'A'
 	JP	Z,TELL1		;GOTO TELL IF 'R' PRESSED
 	POP	DE		;RESTORE NO. BYTES TO MVE
 	POP	HL		;RESTORE BEGIN ADDRESS
 PORT	IN	A,(234)		;IS UART READY ?
 	BIT	6,A		;TEST BIT 6 SET 'Z' FLAG
 	JP	Z,PORT		;GO BACK FOR ANOTHER LOOK
 	LD	A,(HL)		;HL MEM LOCATION TO 'A'
 	OUT 	(235),A		;OUTPUT VIA UART AT 235
 	INC	HL		;+1 TO MEMORY LOCATION
 	DEC	DE		;-1 TO BYTE COUNTER
 	PUSH	DE		;SAVE IN THE STACK
 	PUSH	HL		; "    "  "   "
 	CALL	SHOW		;GOTO SHOW SUBROUTINE
 	POP	HL		;RESTORE HL FROM STACK
 	POP	DE		; "      DE  "    "
 	LD	A,D		;PART OF ZERO TEST
 	OR	E		;OR 'A' WITH 'E'
 	JP	NZ,PORT		;GOTO PORT TILL ZERO
 WAIT	LD	A,(14400)	;KEYBOARD 'SPACE' BAR ROW
 	CP	128		;SPACE BAR 'PRESSED' ?
 	JP	NZ,WAIT		;GOTO WAIT TILL PRESSED
 	JP	LOOK		;RETURN TO KYBD PROGRAM
 SHOW	LD	L,A		;LD L REG WITH BYTE VALUE
 	LD	A,0		;LD A REGISTER WITH ZERO
 	LD	H,A		;ZERO OUT H REGISTER
 	CALL	0A9AH		;MOVE HL INTO ACCUM
 	CALL	0FBDH		;CONVERT ACCUM TO STRING
 	CALL	28A7H		;DISPLAY STRING ON VIDEO
 	LD	A,(14400)	;KEYBOARD 'BREAK' ROW
 	CP	4		;IS 'BREAK' PRESSED ?
 	JP	Z,LOOK		;RETURN TO KYBD PROGRAM
 	RET			;RET FOR NEXT CHARACTER
 TELL1	POP	DE		;RESTORE NO. BYTES TO MVE
 	POP	HL		;RESTORE BEGIN ADDRESS
 	DEC	HL		;ADJUST RECV MEM LOCATION
 TELL2	IN	A,(234)		;UART STATUS REGISTER
 	BIT	7,A		;TEST BIT 7 SET Z FLAG
 	JP	Z,TELL2		;LOOK AGAIN 'NOT' READY
 	IN	A,(235)		;INCOMING BYTE PORT
 	JP	Z,TELL2		;LOOK AGAIN IF 'ZERO'
 	LD	(HL),A		;STASH BYTE IN MEMORY
 	INC	HL		;+1 TO MEMORY LOCATION
 	DEC	DE		;-1 TO PGM BYTE COUNTER
 	PUSH	DE		;SAVE IN THE STACK
 	PUSH	HL		; "    "  "   "
 	CALL	SHOW		;GOTO SHOW SUBROUTINE
 	POP	HL		;RESTORE HL FROM STACK
 	POP	DE		; "      DE  "    "
 	LD	A,D		;PART OF ZERO TEST
 	OR	E		;OR 'A' WITH 'E' REGS
 	JP	NZ,TELL2	;GOTO TELL IF NOT ZERO
 HOLD	LD	A,(14400)	;KEYBOARD 'SPACE' BAR ROW
 	CP	128		;SPACE BAR 'PRESSED' ?
 	JP	NZ,HOLD		;GOTO HOLD TILL PRESSED
 	JP	LOOK		;GOTO KEYBOARD PROGRAM
 	END	W4UCH		;EL FIN = EL BEGUINE
