EARIE2 ; #######################################################
 ; TWO-VOICE SUBROUTINE FOR USE WITH "YOUR CALIFORNIA" AND
 ; OTHER DUET PIECES.  OTHER ASPECTS REMAIN SIMILAR TO THE
 ; FOUR-VOICE VERSION WITH THE EXCEPTION OF SOME LABELS.
 ; ** NOTE ONE MAJOR CHANGE!  THE ALTERNATE MEMORY MAPPING
 ; (TO 8FFF) IS USED HERE SO THE BASIC PROGRAM WILL FIT!
 ; #######################################################
 ;
 	ORG	4F60H		;  :NEAR TOP OF MEMORY
 	LD	IX,5000H	;  :START PITCH & RHYTHM
 	LD	BC,8FFFH	;  :MEMORY-MAPPED SOUND
 ;
 ; #######################################################
 ; OUTER LOOP BEGINS HERE (OCCURS BETWEEN EACH NOTE/REST)
 ; #######################################################
 ;
 LOOP1	EXX			;04:READY DURATION REGS.
 	LD	B,(IX+0)	;19:MSB OF NOTE DURATION
 	LD	C,(IX+1)	;19:LSB OF NOTE DURATION
 	EXX			;04:STASH REGISTER AWAY
 	LD	H,(IX+2)	;19:FIRST PITCH INTO H
 	LD	L,(IX+3)	;19:SECOND PITCH INTO L
 ;
 ; #######################################################
 ; EACH VALUE ACQUIRED FROM IX IS TESTED TO SEE IF IT IS 0
 ; AND THE VOICE IS TURNED OFF IF IT IS (DEFINING A REST).
 ; #######################################################
 ;
 	LD	A,(BC)		;07:READY TO TWEAK MEM
 	AND	0FH		;04:TURN ALL VOICES ON
 	INC	H		;04:BUMP VALUE; REST TEST
 	DEC	H		;04:BUMP VALUE; REST TEST
 	JP	NZ,REST1	;10:ONLY 00 DEFINES REST
 	SET	4,A		;08:SILENCE VOICE IF REST
 REST1	INC	L		;04:BUMP VALUE; REST TEST
 	DEC	L		;04:BUMP VALUE; REST TEST
 	JP	NZ,REST2	;10:ONLY 00 DEFINES REST
 	SET	5,A		;08:SILENCE VOICE IF REST
 REST2	LD	(BC),A		;07:SET VOICES ON OR OFF
 ;
 ; #######################################################
 ; DECREMENT H AND L (WAVEFORM DURATION FOR EACH VOICE)...
 ; NEEDED EACH TIME THE WAVEFORM IS TOGGLED DURING LOOPS..
 ; #######################################################
 ;      COUNT DOWN THE PITCH LOOP FOR VOICE NUMBER ONE
 ; #######################################################
 ;
 LOOP2	LD	A,(BC)		;07:WHAT WAVE IS LURKING
 	DEC	H		;04:COUNTDOWN FREQUENCY 1
 	JP	NZ,EXIT1	;10:SAME WAVE IF NOT 0
 	XOR	1		;07:TOGGLE WAVEFORM BIT 1
 	LD	H,(IX+2)	;19:RESTORE PITCH VALUE
 	JP	EXIT1A		;10:JUMP PAST TIMEWASTERS
 EXIT1	PUSH	IY		;15:WASTE 15 T-STATES
 	POP	IY		;14:WASTE 14 T-STATES
 	AND	0FFH		;07:WASTE 7 MORE T-STATES
 ;
 ; #######################################################
 ;      COUNT DOWN THE PITCH LOOP FOR VOICE NUMBER TWO
 ; #######################################################
 ;
 EXIT1A	DEC	L		;04:COUNTDOWN FREQUENCY 2
 	JP	NZ,EXIT2	;10:SAME WAVE IF NOT 0
 	XOR	2		;07:TOGGLE WAVEFORM BIT 2
 	LD	L,(IX+3)	;19:RESTORE PITCH VALUE
 	JP	EXIT2A		;10:JUMP PAST TIMEWASTERS
 EXIT2	PUSH	IY		;15:WASTE 15 BANANAS
 	POP	IY		;14:DRUM FINGERS ON 14
 	AND	0FFH		;07:USELESS ARITHMETIC
 ;
 ; #######################################################
 ; CHECK FOR END OF NOTE DURATION; GET MORE NOTES IF DONE
 ; #######################################################
 ;
 EXIT2A	LD	(BC),A		;07:OUTPUT NEW WAVEFORMS
 	EXX			;04:GET STASHED DURATION
 	DEC	BC		;06:COUNT DOWN DURATION
 	LD	A,B		;04:SET UP B FOR TEST
 	OR	C		;04:CHECK AGAINST C
 	EXX			;04:STASH DURATION AGAIN
 	JP	NZ,LOOP2	;10:GO BACK TIL NOTE END
 ;
 ; #######################################################
 ; MOVE ALL POINTERS PAST CURRENT BATCH OF NOTES/DURATIONS
 ; #######################################################
 ;
 	LD	DE,4		;10:MEMORY POS'NS TO MOVE
 	ADD	IX,DE		;15:MOVE 6 PLACES FORWARD
 ;
 ; #######################################################
 ; CHECK FOR END OF PROGRAM CODE (00) OR DEPRESSED BREAK
 ; #######################################################
 ;
 	LD	A,(IX+0)	;19:NEXT NOTE DURATION
 	OR	A		;04:SET END-OF-MUSIC FLAG
 	RET	Z		;05:BACK TO BASIC IF DONE
 	LD	A,(3840H)	;13:TEST BREAK KYBD ROW
 	OR	A		;04:SET FLAG FOR KEY TEST
 	JP	Z,LOOP1		;10:CONTINUE PIECE IF OK
 	RET			;  :TO BASIC IF BREAK
 ;
 ; #######################################################
 ;
 	END	06CCH		;  :READY AFTER SLASH
 ;
