;sort: Sort-Merge an input file.
;
*GET	DOSCALLS.HDR
*GET	EXTERNAL.HDR
*GET	ASCII.HDR
;
	ORG	PROG_START
	DEFW	BASE
	DEFW	THIS_PROG_END
	DEFW	ABORT_CLEAN
	DEFW	CLEANUP
;End of program load info.
;
	COM	'<Sort 1.0a 12-May-86>'
	ORG	BASE+100H
START
	LD	SP,START
	LD	A,(HL)
	OR	A
	JP	Z,USAGE
	CP	CR
	JP	Z,USAGE
;
	LD	DE,FCB_IN
	CALL	EXTRACT
;
	LD	DE,FCB_IN
	LD	HL,BUFF_IN
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
;
SORT_00	XOR	A
	LD	(EOFIN),A
	LD	(WHICHFILE),A
	LD	(FINALMERGE),A
	LD	A,1
	LD	(FIRSTMERGE),A
;
	CALL	READRECS
;
SORT_01	LD	HL,(NUMRECS)
	LD	A,H
	OR	L
	JR	Z,SORT_03
;
	CALL	SORT
	LD	A,(EOFIN)
	OR	A
	JR	NZ,SORT_03
;
	CALL	MERGE
	LD	A,(WHICHFILE)
	XOR	1
	LD	(WHICHFILE),A
	CALL	READRECS
	JR	SORT_01
;
SORT_03	LD	A,1
	LD	(FINALMERGE),A
	CALL	MERGE
	XOR	A
	JP	TERMINATE
;
READRECS
	LD	HL,0
	LD	(NUMRECS),HL
	LD	HL,BUFF
	LD	(CP),HL
	LD	HL,INDEX
	LD	(INDEXPTR),HL
;
RR_01
;
	LD	HL,(CP)
	LD	DE,ENDBUFF
	OR	A
	SBC	HL,DE
	JR	NC,RR_04
;
	LD	HL,(NUMRECS)
	LD	DE,MAXREC-2
	OR	A
	SBC	HL,DE
	JR	NC,RR_04
;
	LD	IX,(INDEXPTR)
	LD	HL,(CP)
	LD	(IX),L
	LD	(IX+1),H
;
	LD	B,0
RR_02
	LD	DE,FCB_IN
	CALL	$GET
	JR	Z,RR_03
	CP	1CH
	JP	NZ,ERROR
;
	LD	A,1
	LD	(EOFIN),A
	JR	RR_04
;
RR_03	LD	(HL),A
	INC	HL
	CP	CR
	JR	Z,RR_03A
	DJNZ	RR_02
;
RR_03A	LD	(CP),HL
	DEC	HL
	LD	(HL),0
	LD	HL,(NUMRECS)
	INC	HL
	LD	(NUMRECS),HL
;
	LD	HL,(INDEXPTR)
	INC	HL
	INC	HL
	LD	(INDEXPTR),HL
	JR	RR_01
;
RR_04
	LD	HL,(INDEXPTR)
	LD	(HL),0
	INC	HL
	LD	(HL),0
	RET
;
SORT
	XOR	A
	LD	(SWAP),A
	CALL	SORT_SUB
	LD	A,(SWAP)
	OR	A
	JR	NZ,SORT
	RET
;
SORT_SUB
ST_01
;
	LD	HL,INDEX
	LD	(SORT_POS),HL
;
	LD	A,(HL)
	INC	HL
	LD	B,(HL)
	OR	B
	RET	Z
;
ST_02
	LD	HL,(SORT_POS)
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(SORT_POS),HL
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
;
	LD	A,B
	OR	C
	RET	Z
;
	PUSH	BC
	POP	HL
	CALL	STR_CMP
	JR	C,ST_02
	JR	Z,ST_02
;
	LD	A,1
	LD	(SWAP),A
	LD	IX,(SORT_POS)
	LD	B,(IX+1)
	LD	C,(IX)
	LD	D,(IX-1)
	LD	E,(IX-2)
;
	LD	(IX-2),C
	LD	(IX-1),B
	LD	(IX),E
	LD	(IX+1),D
	JR	ST_02
;
MERGE:
;
	XOR	A
	LD	(M_INFILE),A
	LD	(M_OUTFILE),A
	LD	(FILEFLAG),A
;
	LD	A,(FIRSTMERGE)
	OR	A
	JR	NZ,MG_01
	LD	A,1
	LD	(M_INFILE),A
;
	LD	A,(WHICHFILE)
	LD	E,A
;
	INC	A		;=1 or 2
	LD	HL,WORKN
	OR	(HL)
	LD	(HL),A
;
	LD	D,0
	LD	HL,FCB_ADDR
	ADD	HL,DE
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	LD	DE,MERGE_IN
	LD	BC,32
	LDIR
	LD	DE,MERGE_IN
	LD	HL,MERGE_INB
	LD	B,0
	CALL	DOS_OPEN_NEW
	JP	NZ,ERROR
;
MG_01	XOR	A
	LD	(FIRSTMERGE),A
	LD	A,(FINALMERGE)
	OR	A
	JR	NZ,MG_02
;
	LD	A,1
	LD	(M_OUTFILE),A
	LD	A,(WHICHFILE)
	XOR	1
	LD	E,A
	LD	D,0
;
	LD	A,(WHICHFILE)
	LD	HL,WORKN
	INC	A
	OR	(HL)
	LD	(HL),A
;
	LD	HL,FCB_ADDR
	ADD	HL,DE
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	LD	DE,MERGE_OUT
	PUSH	DE
	LD	BC,32
	LDIR
	POP	DE
	LD	HL,MERGE_OUTB
	LD	B,0
	CALL	DOS_OPEN_NEW
	JP	NZ,ERROR
;
MG_02
	LD	HL,INDEX
	LD	(LISTPOS),HL
	LD	HL,(INDEX)
	LD	(BUFPTR),HL
MG_02A
	LD	A,(M_INFILE)
	OR	A
	JR	Z,MG_03
;
	LD	HL,FILESTR
	LD	DE,MERGE_IN
	LD	BC,256
	CALL	FGETS
	LD	A,H
	OR	L
	JR	NZ,MG_04
;
MG_03	LD	A,1
	LD	(FILEFLAG),A
	XOR	A
	LD	(FILESTR),A
	JR	MG_05
;
MG_04
;
MG_05	LD	A,(FILEFLAG)
	OR	A
	JR	Z,MG_05A
	LD	HL,(BUFPTR)
	LD	A,H
	OR	L
	JR	NZ,MG_07
	JP	Z,MG_13
;
MG_05A
	LD	HL,(BUFPTR)
	LD	A,H
	OR	L
	JR	Z,MG_10
;
MG_06	LD	HL,FILESTR
	LD	DE,(BUFPTR)
	CALL	STR_CMP
	JR	NC,MG_10
MG_07	LD	DE,($STDOUT)
	LD	A,(M_OUTFILE)
	OR	A
	JR	Z,MG_07A
	LD	DE,MERGE_OUT
MG_07A	LD	HL,(BUFPTR)
	CALL	FPUTS
	JP	NZ,ERROR
	LD	A,CR
	CALL	$PUT
	JP	NZ,ERROR
	LD	HL,(LISTPOS)
	INC	HL
	INC	HL
	LD	(LISTPOS),HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(BUFPTR),DE
MG_07B
	JR	MG_05
;
MG_10
	LD	DE,($STDOUT)
	LD	A,(M_OUTFILE)
	OR	A
	JR	Z,MG_10A
	LD	DE,MERGE_OUT
MG_10A	LD	HL,FILESTR
	CALL	FPUTS
	JP	NZ,ERROR
	LD	A,CR
	CALL	$PUT
	JP	NZ,ERROR
;
	LD	HL,FILESTR
	LD	DE,MERGE_IN
	LD	BC,256
	CALL	FGETS
	LD	A,H
	OR	L
	JR	NZ,MG_11
	LD	A,1
	LD	(FILEFLAG),A
	JP	MG_05
MG_11
	JP	MG_05
;
MG_13
	LD	DE,MERGE_IN
	LD	A,(M_INFILE)
	OR	A
	CALL	NZ,DOS_CLOSE
	JP	NZ,ERROR
;
	LD	DE,MERGE_OUT
	LD	A,(M_OUTFILE)
	OR	A
	CALL	NZ,DOS_CLOSE
	JP	NZ,ERROR
;
	RET
;
CLEANUP
	CALL	FILE_CLEAN
	JP	TERM_DISCON
;
ABORT_CLEAN
	CALL	FILE_CLEAN
	JP	TERM_ABORT
;
FILE_CLEAN
	LD	A,(WORKN)
	BIT	0,A
	JR	Z,FC_1
;
	LD	HL,FCB_1
	LD	DE,MERGE_IN
	LD	BC,32
	LDIR
;
	LD	DE,MERGE_IN
	LD	HL,0
	LD	B,0
	CALL	DOS_OPEN_EX
	CALL	DOS_KILL
FC_1	LD	A,(WORKN)
	BIT	1,A
	RET	Z
	LD	HL,FCB_2
	LD	DE,MERGE_OUT
	LD	BC,32
	LDIR
	LD	DE,MERGE_IN
	LD	HL,0
	LD	B,0
	CALL	DOS_OPEN_EX
	CALL	DOS_KILL
	RET
;
FGETS	LD	IX,0
FGETS_1	DEC	BC
	LD	A,B
	OR	C
	JR	Z,FGETS_2
	CALL	$GET
	JR	NZ,FGETS_3
	LD	(HL),A
	INC	HL
	INC	IX
	CP	CR
	JR	NZ,FGETS_1
	DEC	HL
FGETS_2	LD	(HL),0
	JR	FGETS_4
;
FGETS_3	CP	1CH
	JP	NZ,ERROR
	LD	IX,0
FGETS_4	PUSH	IX
	POP	HL
	RET
;
USAGE	LD	HL,M_USAGE
	LD	DE,($STDOUT_DEF)
	CALL	FPUTS
	XOR	A
	JP	TERMINATE
;
ERROR	PUSH	AF
	OR	80H
	CALL	DOS_ERROR
	POP	AF
	JP	TERMINATE
;
*GET	ROUTINES
*GET	FILENAME.HDR
;
M_USAGE	DEFM	'Sort:  Sort-Merge a file',CR
	DEFM	'Usage: SORT infile',CR
	DEFM	'Eg:    SORT filelist.zms',CR,0
;
	DEFM	'eofin>'
EOFIN	DEFB	0
WHICHFILE	DEFB	0
FINALMERGE	DEFB	0
FIRSTMERGE	DEFB	0
;
FCB_ADDR	DEFW	FCB_1
		DEFW	FCB_2
;
MERGE_IN	DEFS	32
MERGE_OUT	DEFS	32
;
BUFF_IN		DEFS	256
;
MERGE_INB	DEFS	256
MERGE_OUTB	DEFS	256
;
	DEFM	'numrecs>'
NUMRECS	DEFW	0
BUFPTR	DEFW	0
;
FCB_IN	DEFS	32
;
CP	DEFW	0
INDEXPTR	DEFW	0
;
SWAP		DEFB	0
SORT_POS	DEFW	0
;
LISTPOS		DEFW	0
FILEFLAG	DEFB	0
FILESTR		DEFS	256
;
M_INFILE	DEFB	0
M_OUTFILE	DEFB	0
;
FCB_1	DEFM	'SORTWRK1:1',CR
FCB_2	DEFM	'SORTWRK2:1',CR
;
WORKN	DEFB	0
;
MAXREC	EQU	512
INDEX	DEFS	MAXREC*2
;
BUFF	NOP
	DEFS	16384-256
ENDBUFF	DEFS	256
;
THIS_PROG_END	EQU	$
;
	END	START
                                                                                                                                                  