;Restore: SYSres for 256k ram system (zeta)
;
*GET	DOSCALLS.HDR
*GET	EXTERNAL.HDR
*GET	ASCII.HDR
*GET	PROGNUMB.HDR
;
	COM	'<Restore 1.1b 29-Mar-87 (zeta)>'
;
PATCH	EQU	04BDAH		;Address to patch Dos.
;
PAGE1	EQU	80H		;table page (init only)
PAGE1X	EQU	16		;logical page 32.
ADDR1	EQU	8000H
OLD1	EQU	10H
;
PAGE2	EQU	84H		;system page (init only)
PAGE2X	EQU	17		;logical page 33.
ADDR2	EQU	8400H
OLD2	EQU	11H
;
	ORG	PATCH		;Back off any changes
	LD	HL,4317H
;
	ORG	BASE+100H
START
	LD	SP,START
	LD	A,(HL)
	CP	CR
	JP	Z,USAGE
	OR	A
	JP	Z,USAGE
;
	PUSH	HL
;Install code from SLOAD to END_CODE in high memory.
	LD	HL,(HIMEM)
	LD	DE,END_CODE-SLOAD
	OR	A
	SBC	HL,DE
	LD	(HIMEM),HL
	INC	HL
	PUSH	HL		;new sload value
	LD	(NEW_SLOAD),HL
	OR	A
	LD	DE,SLOAD
	SBC	HL,DE
	EX	DE,HL
;
	LD	HL,(RELOC1+1)
	ADD	HL,DE
	LD	(RELOC1+1),HL
;
	LD	HL,(RELOC2+1)
	ADD	HL,DE
	LD	(RELOC2+1),HL
;
	LD	HL,(RELOC3+1)
	ADD	HL,DE
	LD	(RELOC3+1),HL
;
	LD	HL,(RELOC4+1)
	ADD	HL,DE
	LD	(RELOC4+1),HL
;
	LD	HL,(RELOC5+1)
	ADD	HL,DE
	LD	(RELOC5+1),HL
;
	LD	HL,(RELOC6+1)
	ADD	HL,DE
	LD	(RELOC6+1),HL
;
	LD	HL,(RELOC7+1)
	ADD	HL,DE
	LD	(RELOC7+1),HL
;
	LD	HL,(RELOC8+1)
	ADD	HL,DE
	LD	(RELOC8+1),HL
;
	LD	HL,(RELOC9+1)
	ADD	HL,DE
	LD	(RELOC9+1),HL
;
	LD	HL,(RELOC10+1)
	ADD	HL,DE
	LD	(RELOC10+1),HL
;
	LD	HL,(RELOC11+1)
	ADD	HL,DE
	LD	(RELOC11+1),HL
;
	LD	HL,(RELOC12+1)
	ADD	HL,DE
	LD	(RELOC12+1),HL
;
	LD	HL,(RELOC13+1)
	ADD	HL,DE
	LD	(RELOC13+1),HL
;
	LD	HL,(RELOC14+1)
	ADD	HL,DE
	LD	(RELOC14+1),HL
;
	LD	HL,(RELOC15+1)
	ADD	HL,DE
	LD	(RELOC15+1),HL
;
	LD	HL,(RELOC16+1)
	ADD	HL,DE
	LD	(RELOC16+1),HL
;
	LD	HL,(RELOC17+1)
	ADD	HL,DE
	LD	(RELOC17+1),HL
;
	LD	HL,(RELOC18+1)
	ADD	HL,DE
	LD	(RELOC18+1),HL
;
	LD	HL,(RELOC19+1)
	ADD	HL,DE
	LD	(RELOC19+1),HL
;
;Allocate the table page number.
	LD	A,NUM_RESTORE
	CALL	ALLOC_PAGE
	LD	(TABLE_PAGE),A
	LD	(THIS_PAGE),A
;
	POP	DE
	LD	HL,SLOAD
	LD	BC,END_CODE-SLOAD
	LDIR
;
;Swap in table page and first data page.
	LD	A,(TABLE_PAGE)
	LD	B,PAGE1X
	CALL	SWAP_PAGE
;
;
	LD	A,(TABLE_PAGE)
	LD	B,PAGE2X
	CALL	SWAP_PAGE
;
;
	LD	HL,ADDR1
	LD	(TABLE_PTR),HL
;
	LD	(HL),0		;empty the table.
	LD	HL,ADDR2+100H	;bypass table!
	LD	(RAM_PTR),HL
;
	POP	HL
RDNAME	LD	A,(HL)		;test for end of cmd line
	CP	CR
	JR	Z,ISEND
	OR	A
	JR	NZ,NOTEND
;
;Re-address original pages
ISEND
	LD	A,OLD1
	LD	B,PAGE1X
	CALL	SWAP_PAGE
;
	LD	A,OLD2
	LD	B,PAGE2X
	CALL	SWAP_PAGE
;
;
	CALL	SETUP		;fix dos pointers.
	LD	HL,MESS1
	CALL	MESS_0
	JP	DOS		;Auth.
;
USAGE
	LD	HL,M_USAGE
	CALL	MESS_0
	JP	DOS
;
NOTEND	CALL	GETNUM		;GET NUMBER OF SYSTEM FILE
	PUSH	HL
	CALL	RDSYS		;READ INTO MEMORY & ADD TO TABLE.
	POP	HL
	JR	RDNAME
;
;
;GETNUM: Get system file number.
GETNUM	LD	(CST),HL	;SAVE START OF WORD.
	PUSH	HL
	POP	BC
	LD	HL,0
GETV01	CALL	GETCH		;GET DIGIT IN L (OR SP/CR
	JR	Z,GPAST		;WITH NZ FLAG SET).
	LD	A,L
	LD	(CURSYS),A	;SAVE NUMBER OF SYSFILE
	PUSH	BC
	POP	HL
	LD	(CEN),HL	;SAVE END OF CURRENT WORD.
	RET
GPAST	PUSH	HL		;MULTIPLY HL BY 10 AND ADD L
	POP	DE
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,DE
	ADD	HL,HL
	ADD	A,L
	LD	L,A
	JR	GETV01		;CONTINUE SEARCH FOR NUMBERS
GETCH	LD	A,(BC)
	INC	BC
	CP	CR		;TEST FOR CR CHARACTER
	JR	Z,CHEND		;IF SO, EXIT WITH NZ FLAG SET.
	CP	' '
	JR	NZ,GCHV01
GCHL01	LD	A,(BC)		;BYPASS ANY SPACES THEN EXIT
	INC	BC		;WITH NZ SET.
	CP	' '
	JR	Z,GCHL01
CHEND	LD	A,0FFH		;SET NZ FLAG AND RETURN.
	DEC	BC
	OR	A
	RET
GCHV01	CP	'9'+1
	JR	NC,GETCH	;DISREGARD ALPHA CHARACTERS:
	CP	'0'
	JR	C,GETCH		;NUMBERS ONLY FALL THROUGH.
	SUB	'0'
	LD	D,A
	XOR	A		;SET Z FLAG.
	LD	A,D
	RET
;
RDSYS	LD	HL,(CST)
	LD	DE,FCB_IN
	CALL	DOS_EXTRACT	;extract 'sysxx.sys'
	LD	HL,DEFEXT
	LD	DE,FCB_IN
	CALL	DOS_EXTEND	;ADD DEFAULT EXTENSION '.SYS'.
	LD	HL,BUFF_IN
	LD	DE,FCB_IN
	LD	B,0
	CALL	DOS_OPEN_EX	;OPEN FILE 'SYSXX.SYS'.
	RET	NZ		;don't add if cannot open
;
	LD	A,(FCB_IN+1)
	AND	0F8H
	OR	5
	LD	(FCB_IN+1),A
;
	LD	A,(CURSYS)	;GET NUMBER OF SYSFILE.
	LD	HL,(TABLE_PTR)
	LD	(HL),A		;poke sys number
	INC	HL
;
	LD	A,(THIS_PAGE)
	LD	(HL),A		;poke page number.
	INC	HL
;
	LD	DE,(RAM_PTR)
	LD	A,D
	AND	3		;convert to 1k offset
	LD	D,A
	LD	(HL),E		;poke page address.
	INC	HL
	LD	(HL),D
;
LV01	LD	DE,FCB_IN
	CALL	DOS_READ_SECT	;READ A RECORD INTO 'BUFF_IN'
	JR	NZ,LV02		;IF DISK ERROR,OR EOF.
	LD	B,0		;poke buffer into
	CALL	POKE		;save area
	JR	LV01
LV02	CP	1DH		;TEST FOR PARTIAL SECTOR
	JR	NZ,LV05
	LD	A,(FCB_IN+8)
	LD	B,A
LV03	CALL	POKE		;POKE IN PARTIAL SECTOR.
LV04
	LD	HL,(TABLE_PTR)
	LD	BC,4
	ADD	HL,BC
	LD	(TABLE_PTR),HL
	LD	(HL),0
	LD	HL,(CEN)
	RET
;
LV05	CP	1CH		;TEST FOR FULL LAST SECTOR.
	JP	NZ,DOS_ERROR	;IF NOT, THEN TAKE ERROR EXIT.
	JR	LV04
;
POKE	LD	DE,BUFF_IN	;POKE #B BYTES
	LD	HL,(RAM_PTR)
POKV01
	LD	A,H
	AND	3
	CP	3
	JR	NZ,POKV02
	LD	A,L
	CP	0FFH
	JR	Z,POKV03
POKV02
	LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	POKV01
	LD	(RAM_PTR),HL
	RET
;
;Switch to next lower page of ram.
POKV03
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	A,NUM_RESTORE
	CALL	ALLOC_PAGE
	POP	HL
	LD	(HL),A		;chain page numbers.
	LD	HL,ADDR2
	LD	(RAM_PTR),HL
	LD	(THIS_PAGE),A
	LD	B,PAGE2X
	CALL	SWAP_PAGE
	LD	HL,(RAM_PTR)
	POP	DE
	POP	BC
	JR	POKV01
;
;
SETUP	LD	HL,PATCH	;setup dos for restore.
	LD	(HL),195	;poke 'JP sload' into
	LD	HL,(NEW_SLOAD)
	LD	(PATCH+1),HL
;Patch dos so drives with head settle delay get extra
;time.
	LD	HL,0C000H	;New Index Pulse delay
	LD	(47F4H),HL
	RET
;
MESS_0	LD	A,(HL)
	OR	A
	RET	Z
	CALL	33H
	INC	HL
	JR	MESS_0
;
;Variables etc used only by initial loader.
BUFF_IN	DEFS	256
FCB_IN	DEFS	32
MESS1	DEFM	'"Restore" for 256k paged ram (zeta)',CR
	DEFM	'Author: N.P Andrew.',CR
	DEFM	'Now patching Newdos/80 for SYStem loader',CR,0
M_USAGE	DEFM	'Usage: restore sys1 sys2 ... sysn',CR,0
;
NEW_SLOAD	DEFW	0
TABLE_PTR	DEFW	0
CST	DEFW	0
CEN	DEFW	0
DEFEXT	DEFM	'SYS'
CURSYS	DEFB	0
;
;Dos jumps to sload when it requires a system file.
;
SLOAD	LD	HL,4317H	;TEST IF SYSFILE ALREADY
	CP	(HL)		;IN MEMORY.
	JP	Z,4C19H		;IF SO, THEN EXECUTE.
	LD	(HL),A		;SET SYSFILE # IN MEMORY
	LD	C,A
	DEC	C
	DEC	C		;FIND TRUE SYSTEM NUMBER
;
	PUSH	BC
;
;
;Swap in the table page.
	LD	B,TEMP_PAGEX	;46
RELOC18	LD	A,(TABLE_PAGE)
	CALL	SWAP_PAGE
	LD	A,C
RELOC12	LD	(OLD_PAGE),A	;Save # of old page
;
	POP	BC
	LD	HL,TEMP_RAM
SEARCH	LD	A,(HL)		;SEARCH TABLE CONTENTS
	OR	A
	JR	Z,NOTFOUND
	CP	C
	JR	Z,MLOAD
	INC	HL		;ELSE FIND NEXT ENTRY.
	INC	HL
	INC	HL
	INC	HL
	JR	SEARCH
;
NOTFOUND
;
;Swap in page which was there before
	PUSH	BC
RELOC13	LD	A,(OLD_PAGE)
	LD	B,TEMP_PAGEX
	CALL	SWAP_PAGE
	POP	BC
;
	LD	A,C		;IF END OF TABLE, GET SYSFILE #
	ADD	A,2
	LD	HL,4317H
	JP	4BE1H		;LET DOS LOAD SYSTEM FILE.
;
MLOAD	INC	HL		;GET address from table
	LD	A,(HL)
RELOC16	LD	(THIS_PAGE),A
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
;
	PUSH	DE
;Address the starting page.
	LD	B,TEMP_PAGEX
	CALL	SWAP_PAGE
;
	POP	DE
;
	LD	HL,TEMP_RAM
	ADD	HL,DE
RELOC17	LD	(RAM_PTR),HL
;
MLOV01
RELOC1	CALL	GET_BYTE
	CP	2
	JR	NZ,MLOV02
RELOC2	CALL	GET_BYTE
RELOC3	CALL	GET_BYTE
	LD	E,A
RELOC4	CALL	GET_BYTE
	LD	D,A
	EX	DE,HL
	LD	(4C1EH),HL	;set exec address
;
;Swap in page which was there before
	PUSH	HL
RELOC14	LD	A,(OLD_PAGE)
	LD	B,TEMP_PAGEX
	CALL	SWAP_PAGE
	POP	HL
;
	JP	4C19H		;execute the sys file.
;
MLOV02	CP	1
	JR	Z,MLOV04	;LOAD BLOCK INTO MEMORY
RELOC5	CALL	GET_BYTE	;skip block
	LD	B,A
MLOV03
RELOC6	CALL	GET_BYTE
	DJNZ	MLOV03
	JR	MLOV01
MLOV04				;get length of load block
RELOC7	CALL	GET_BYTE
	LD	B,A
RELOC8	CALL	GET_BYTE	;get load addr
	LD	E,A
RELOC9	CALL	GET_BYTE
	LD	D,A
	DEC	B
	DEC	B
MLOV05
RELOC10	CALL	GET_BYTE
	LD	(DE),A
	INC	DE		;DE IS INCREASING
	DJNZ	MLOV05
	JR	MLOV01
;
GET_BYTE
RELOC11	LD	HL,(RAM_PTR)
	LD	A,H
	AND	3
	CP	3
	JR	NZ,GB_99
	LD	A,L
	CP	0FFH
	JR	Z,GB_98
GB_99
	LD	A,(HL)
	INC	HL
RELOC19	LD	(RAM_PTR),HL
	RET
;Load next page in.
GB_98
	PUSH	BC
	PUSH	DE
	LD	B,TEMP_PAGEX
	LD	A,(HL)
	CALL	SWAP_PAGE
;
	LD	HL,TEMP_RAM
RELOC15	LD	(RAM_PTR),HL
	POP	DE
	POP	BC
	JR	GET_BYTE
;
RAM_PTR		DEFW	0
OLD_PAGE	DEFB	0
THIS_PAGE	DEFB	0
TABLE_PAGE	DEFB	0
;
END_CODE	NOP
;
	END	START
                                                                                                                       