;cp: Copy one file to another.
;
BUF_PAGES	EQU	40		;10 kbytes
;
*GET	DOSCALLS.HDR
*GET	EXTERNAL.HDR
*GET	ASCII.HDR
;
	ORG	PROG_START
	DEFW	BASE
	DEFW	THIS_PROG_END
	DEFW	0
	DEFW	0
;End of program load info.
;
	COM	'<CP 1.1  16-Jan-88>'
	ORG	BASE+100H
START	LD	SP,START
	LD	A,(HL)
	CP	CR
	JR	Z,USAGE
	OR	A
	JR	NZ,NOUSAGE
USAGE
	LD	HL,M_USAGE
	LD	DE,$2
	CALL	MESS_0
	LD	A,128
	JP	TERMINATE
;
NOUSAGE
	LD	A,(PRIV_1)
	BIT	IS_SYSOP,A
	JP	Z,NOCOPY
	LD	DE,FCB_IN
	CALL	EXTRACT
	LD	DE,FCB_OUT
	CALL	EXTRACT
;
	LD	HL,BUF_IN
	LD	DE,FCB_IN
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR_IN
;
	LD	HL,BUF_OUT
	LD	DE,FCB_OUT
	LD	B,0
	CALL	DOS_OPEN_NEW
	JP	NZ,ERROR_OUT
;
	LD	HL,CP_BUF
	LD	(BUFFER_POS),HL
	XOR	A
	LD	(BUF_USED),A
;
LOOP
	XOR	A
	LD	(BUF_LAST),A
;
	LD	DE,FCB_IN
	CALL	DOS_READ_SECT
	JR	NZ,POSS_EOF
;
	LD	A,(BUF_USED)
	CP	BUF_PAGES
	CALL	Z,FLUSH_BUF
;
	LD	HL,BUF_IN
	LD	DE,(BUFFER_POS)
	LD	BC,256
	LDIR
	LD	(BUFFER_POS),DE
;
	LD	HL,BUF_USED
	INC	(HL)
	JR	LOOP
;
POSS_EOF
	CP	1CH
	JR	Z,IS_EOF
	CP	1DH
	JR	Z,PART_SECT
	JR	ERROR
;
PART_SECT
	LD	A,(FCB_IN+8)
	LD	(BUF_LAST),A
IS_EOF
	CALL	FLUSH_BUF
	LD	DE,FCB_OUT
	CALL	DOS_CLOSE
	JP	NZ,ERROR
	XOR	A
	JP	TERMINATE
;
FLUSH_BUF
	LD	HL,CP_BUF
	LD	(BUFFER_POS),HL
;
FB_01
	LD	A,(BUF_USED)
	OR	A
	JR	Z,FB_04
	DEC	A
	LD	(BUF_USED),A
	JR	NZ,FB_02		;Not last sector
;
	LD	A,(BUF_LAST)
	OR	A
	JR	Z,FB_02			;Full sector
;
	LD	B,A
	LD	DE,FCB_OUT
	LD	HL,(BUFFER_POS)
FB_03
	LD	A,(HL)
	CALL	$PUT
	JP	NZ,ERROR
	INC	HL
	DJNZ	FB_03
	RET
;
FB_02
	LD	HL,(BUFFER_POS)
	LD	DE,BUF_OUT
	LD	BC,256
	LDIR
	LD	(BUFFER_POS),HL
;
	LD	DE,FCB_OUT
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
	JR	FB_01
;
FB_04
	XOR	A
	LD	(BUF_USED),A
	LD	HL,CP_BUF
	LD	(BUFFER_POS),HL
	RET
;
NOCOPY	LD	HL,M_NOCOPY
	LD	DE,$2
	CALL	MESS_0
	LD	A,131
	JP	TERMINATE
;
ERROR	PUSH	AF
	OR	80H
	CALL	DOS_ERROR
	POP	AF
	JP	TERMINATE
;
ERROR_IN
	LD	HL,M_IN
	LD	DE,$2
	CALL	MESS_0
	LD	A,129
	JP	TERMINATE
;
ERROR_OUT
	LD	HL,M_OUT
	LD	DE,$2
	CALL	MESS_0
	LD	A,130
	JP	TERMINATE
;
*GET	ROUTINES
;
M_IN	DEFM	'cp: Can''t open input file',CR,0
M_OUT	DEFM	'cp: Can''t open output file',CR,0
;
M_NOCOPY
	DEFM	'cp: Sorry, only the sysop can copy at this time.',CR,0
M_USAGE
	DEFM	'cp:    Copy one file to another.',CR
	DEFM	'Usage: CP inputfile outputfile',CR
	DEFM	'Eg:    CP sydpams.txt tempfile',CR,0
;
BUF_LAST	DEFB	0	;# bytes in last sector
BUF_USED	DEFB	0	;# of buffer pages used
BUFFER_POS	DEFW	0	;Addr of top of buffer
;
FCB_IN	DEFS	32
FCB_OUT	DEFS	32
BUF_IN	DEFS	256
BUF_OUT DEFS	256
;
CP_BUF	DEFS	256*BUF_PAGES
;
THIS_PROG_END	EQU	$
;
	END	START
                                            