;Filsys/Asm: Tree structured filesystem.
; Ver 1.0 on 18-Oct-85.
;
*GET	DOSCALLS
;
FS_OPEN_NEW
	CALL	FS_OPEN_EX
	SCF		;Say: Existing.
	CCF
	RET	Z
	CP	66	;Dir/File nonex
	RET	NZ
;Check 'W' permission in parent.
;Skip off back to parent to check write perms
	LD	HL,(CURR_ENODE)
	LD	(OLD_ENODE),HL
	LD	A,(TYPE)
	OR	A
	JR	Z,FS_111
	LD	HL,(EN_PARENT)
	CALL	ACCESS_ENODE
	JP	NZ,GET_BACK
FS_111	CALL	CHK_PERMS
	AND	4	;'w--'
	JR	NZ,FS_104
	LD	A,71	;No perms
	OR	A
	JP	GET_BACK
FS_104
;Skip back again
	LD	HL,(OLD_ENODE)
	LD	(CURR_ENODE),HL
	CALL	ACCESS_ENODE
	JP	NZ,GET_BACK
;
	CALL	NEXT_ENODE
	JP	NZ,GET_BACK
	CALL	SET_FILENAME
	CALL	GET_REG
	CALL	DOS_OPEN_NEW
	RET	NZ
	JR	C,FS_113
;If pre-existing.
	LD	A,70
	OR	A
	JP	GET_BACK
FS_113
	CALL	CREATE_ENODE
	JP	NZ,GET_BACK
	CALL	GET_REG
	XOR	A
	SCF
	RET
;
FS_OPEN_EX
	CALL	SAVE_REG
	CALL	FSE_SETROOT
	JR	NZ,FS_002
	LD	A,DE_BAD_FSPEC
	OR	A
	RET
FS_002
	CALL	TREE_SEARCH
	JP	NZ,GET_BACK
FS_005
;Make sure item is a file
	LD	A,(EN_FLAGS)
	BIT	IS_DIR,A
	JR	Z,FS_103
	LD	A,65	;end of path is dir
	OR	A
	JP	GET_BACK
FS_103
;Check 'R' permission.
	CALL	CHK_PERMS
	AND	2	;'r'
	JR	NZ,FS_105
	LD	A,71	;Perm den
	OR	A
	JP	GET_BACK
FS_105
	LD	DE,(REG_DE)
	LD	HL,EN_FNAME
	LD	BC,24
	LDIR
	CALL	GET_REG
	CALL	DOS_OPEN_EX
	RET	Z
	CP	DE_FNID
	RET	NZ
	LD	A,69	;internal error
	OR	A
	RET
;
TREE_SEARCH
	LD	HL,(ROOT_ENODE)
	LD	(CURR_ENODE),HL
	CALL	ACCESS_ENODE
	RET	NZ
;Check perms on directories. (Must be directory).
FS_006
;
	LD	HL,(PATH_PTR)
FS_007	LD	A,(HL)
	CP	'/' 
	JR	NZ,FS_008
	INC	HL
	JR	FS_007
FS_008	CALL	IF_TERM		;was OR A
	JR	Z,FS_011
	CALL	COPY_ENTRY
	RET	NZ
	LD	A,(EN_FLAGS)
	BIT	IS_DIR,A
	JR	NZ,FS_106
	LD	A,64	;Path component not directory
	OR	A
	RET
FS_106
	CALL	CHK_PERMS
	AND	5	;'r-x', was 03 WRONG!
	JR	NZ,FS_107
	LD	A,71	;Perms denied
	OR	A
	RET
FS_107
	LD	HL,(EN_CHILD)
	LD	A,H
	OR	L
	LD	(TYPE),A
FS_010	LD	A,H
	OR	L
	JR	Z,FS_012
	LD	(CURR_ENODE),HL
	CALL	ACCESS_ENODE
	JP	NZ,GET_BACK
;Disregard if deleted.
	LD	A,(EN_FLAGS)
	BIT	IS_DELETED,A
	JR	NZ,FS_108
	CALL	NAME_CMP
	JR	Z,FS_006
FS_108	LD	HL,(EN_SIBLING)
	JR	FS_010
;
FS_011	XOR	A
	RET
FS_012	;Decide whether dir/file nonex or path nonex
	LD	HL,(PATH_PTR)
	LD	A,(HL)
	CALL	IF_TERM		;was OR A
	LD	A,68
	RET	NZ
	LD	A,66
	OR	A
	RET
;
SAVE_REG
	LD	(REG_HL),HL
	LD	(REG_DE),DE
	LD	(REG_IX),IX
	LD	(REG_BC),BC
	RET
;
GET_REG
	LD	BC,(REG_BC)
	LD	IX,(REG_IX)
	LD	DE,(REG_DE)
	LD	HL,(REG_HL)
	RET
;
COPY_ENTRY
	LD	DE,ENTRY_BUF
	LD	B,0
FS_013	LD	A,(HL)
	CALL	IF_TERM		;was OR A
	JR	Z,FS_014
	CP	'/'
	JR	NZ,FS_015
	INC	HL
FS_014	XOR	A
	LD	(DE),A
	LD	(PATH_PTR),HL
	RET	;ZZ
FS_015	CP	'A'
	JR	C,FS_016
	CP	'Z'+1
	JR	NC,FS_016
	OR	20H
FS_016	LD	(DE),A
	INC	HL
	INC	DE
	INC	B
	LD	A,B
	CP	15
	JR	C,FS_013
	LD	A,70	;entry too long
	OR	A
	RET
;
ACCESS_ENODE
	PUSH	HL
	POP	BC
	LD	DE,FS_FCB
	CALL	DOS_POSIT
	RET	NZ
	LD	HL,ENODE
	CALL	DOS_READ_SECT
	RET	NZ
	RET
;
NAME_CMP
	LD	DE,ENTRY_BUF
	LD	HL,EN_NAME
FS_017	LD	A,(DE)
	CALL	IF_TERM
	JR	Z,FS_114
	CP	(HL)
	RET	NZ
	INC	HL
	INC	DE
	JR	FS_017
FS_114	XOR	A
	CP	(HL)
	RET	;Z or NZ if one entry longer.
;
WRITE_ENODE
	LD	BC,(CURR_ENODE)
	LD	DE,FS_FCB
	CALL	DOS_POSIT
	RET	NZ
	LD	HL,ENODE
	CALL	DOS_WRIT_SECT
	RET	NZ
	RET
;
NEXT_ENODE
	LD	HL,(CURR_ENODE)
	LD	(OLD_ENODE),HL
	LD	A,(TYPE)
	OR	A
	JR	Z,FS_018
	LD	HL,(EN_PARENT)
	JR	FS_019
FS_018	LD	HL,(CURR_ENODE)
FS_019	LD	(NEW_EN_PAR),HL
;
	LD	HL,0
	LD	(CURR_ENODE),HL
	CALL	ACCESS_ENODE
	RET	NZ
	LD	HL,(EN_FNAME)	;last Number
	INC	HL
	LD	(EN_FNAME),HL
	LD	(NEW_ENODE),HL
	CALL	WRITE_ENODE
	RET	NZ
;
	LD	HL,(NEW_ENODE)
	LD	(FILENO),HL
	XOR	A
	RET
;
CREATE_ENODE
;Setup new enode data.
	LD	HL,NEW_ENODE_ENTRY
	LD	(HL),0
	LD	DE,NEW_EN_NAME
	LD	HL,ENTRY_BUF
	LD	BC,16
	LDIR
	LD	HL,FILNAM
	LD	DE,NEW_EN_FNAME
	LD	BC,24
	LDIR
	LD	HL,NEW_EN_PERMS
	LD	(HL),36H	;'rw-rw-'
	LD	HL,0002H	;Sysop
	LD	(NEW_EN_OWNER),HL
	LD	HL,(NEW_EN_PAR)
	LD	(NEW_EN_PARENT),HL
;
	LD	HL,NEW_ENODE_ENTRY
	LD	DE,ENODE
	LD	BC,48
	LDIR
	LD	HL,(NEW_ENODE)
	LD	(CURR_ENODE),HL
	CALL	WRITE_ENODE
	RET	NZ
	LD	HL,(OLD_ENODE)
	LD	(CURR_ENODE),HL
	CALL	ACCESS_ENODE
	RET	NZ
	LD	HL,(NEW_ENODE)
	LD	A,(TYPE)
	OR	A
	JR	Z,FS_020
	LD	(EN_SIBLING),HL
	JR	FS_021
FS_020	LD	(EN_CHILD),HL
FS_021	CALL	WRITE_ENODE
	CALL	GET_REG
	RET	NZ
;Ensure enode is written.
	LD	DE,FS_FCB
	CALL	443FH
	RET	NZ
;
	RET
;
;Data definitions
PATH_PTR	DEFW	0
UID		DEFW	0	;User-id.
ROOT_ENODE	DEFW	0
CDIR_ENODE	DEFW	0
CURR_ENODE	DEFW	0
;
ENODE		;1 enode data.
EN_FLAGS	DEFB	0
EN_NAME		DC	14,0
EN_FNAME	DC	24,0
EN_PERMS	DEFB	0
EN_OWNER	DEFW	0
EN_PARENT	DEFW	0
EN_CHILD	DEFW	0
EN_SIBLING	DEFW	0
;
IS_DELETED	EQU	7
IS_DIR		EQU	6
;
REG_HL	DEFW	0
REG_DE	DEFW	0
REG_IX	DEFW	0
REG_BC	DEFW	0
;
ENTRY_BUF	DC	16,0
;
FS_FCB	DEFM	'Filsys/tem',0DH
	DC	32-11,0
;
FS_BUF	DEFS	256
;
OLD_ENODE	DEFW	0
NEW_EN_PAR	DEFW	0
;
TYPE	DEFB	0
;
NEW_ENODE	DEFW	0
FILENO		DEFW	0
;
NEW_ENODE_ENTRY
NEW_EN_FLAGS	DEFB	0
NEW_EN_NAME	DEFM	'Name.........',0
NEW_EN_FNAME	DEFW	0
		DC	22,0
NEW_EN_PERMS	DEFB	0
NEW_EN_OWNER	DEFW	0002	;Sysop
NEW_EN_PARENT	DEFW	0
NEW_EN_CHILD	DEFW	0
NEW_EN_SIBLING	DEFW	0
;
SET_FILENAME
	LD	IX,FNUM
	LD	HL,(FILENO)
	LD	DE,10000
	CALL	POKE_NUMB
	LD	DE,1000
	CALL	POKE_NUMB
	LD	DE,100
	CALL	POKE_NUMB
	LD	DE,10
	CALL	POKE_NUMB
	LD	DE,1
	CALL	POKE_NUMB
	LD	HL,FILNAM
	LD	DE,(REG_DE)
	LD	BC,24
	LDIR
	RET
;
POKE_NUMB
	LD	B,'0'-1
FS_022	INC	B
	OR	A
	SBC	HL,DE
	JR	NC,FS_022
	ADD	HL,DE
	LD	(IX+0),B
	INC	IX
	RET
;
FILNAM	DEFM	'fil'
FNUM	DEFM	'00000/fil',0DH
	DC	24-13,0
;
FS_INIT
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	DE,FS_FCB
	LD	HL,FS_BUF
	LD	B,48
	CALL	DOS_OPEN_EX
	JR	NZ,FS_101
	LD	HL,0
	LD	(CDIR_ENODE),HL
	XOR	A
FS_101	POP	HL
	POP	DE
	POP	BC
	RET
;
FS_TERMINATE
	PUSH	HL
FS_023	LD	A,(HL)
	OR	A
	JR	Z,FS_024
	CP	0DH
	JR	Z,FS_024
	CP	' '
	JR	Z,FS_024
	INC	HL
	JR	FS_023
FS_024	LD	(HL),0
	POP	IX
	RET
;
FS_CLOSE
	CALL	DOS_CLOSE
	RET	Z
	PUSH	AF
	CALL	FS_EXIT
	POP	AF
	RET
;
FS_EXIT
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
	LD	DE,FS_FCB
	CALL	4451H	;Write eof.
	JR	NZ,FS_025
	CALL	443FH	;Posn to zero.
	JR	NZ,FS_025
	XOR	A
FS_025
	POP	HL
	POP	DE
	POP	BC
	RET
;
GET_BACK
	CALL	GET_REG
	RET
;
FS_MKDIR
	CALL	SAVE_REG
	CALL	FSE_SETROOT
	JR	NZ,FS_026
	LD	A,DE_BAD_FSPEC
	OR	A
	RET
FS_026
	CALL	TREE_SEARCH
	JR	NZ,FS_029
;Directory/file exists
	LD	A,67	;Already exists
	OR	A
	JP	GET_BACK
FS_029	CP	66	;File/dir nonex
	JP	NZ,GET_REG
;Skip off back to parent to check write perms
	LD	HL,(CURR_ENODE)
	LD	(OLD_ENODE),HL
	LD	A,(TYPE)
	OR	A
	JR	Z,FS_110
	LD	HL,(EN_PARENT)
	CALL	ACCESS_ENODE
	JP	NZ,GET_BACK
;Check for 'w' in current (parent) directory.
FS_110	CALL	CHK_PERMS
	AND	2	;'-w-'
	JR	NZ,FS_109
	LD	A,71	;Perms denied
	OR	A
	JP	GET_BACK
FS_109
;Move back to wherever..
	LD	HL,(OLD_ENODE)
	LD	(CURR_ENODE),HL
	CALL	ACCESS_ENODE
	JP	NZ,GET_BACK
;
;OK then. Make a directory.
FS_030	CALL	NEXT_ENODE
	JP	NZ,GET_BACK
;Create directory type e-node
	LD	HL,NEW_ENODE_ENTRY
	LD	(HL),40H	;Directory
	LD	DE,NEW_EN_NAME
	LD	HL,ENTRY_BUF
	LD	BC,16
	LDIR
	LD	HL,NEW_EN_PERMS
	LD	(HL),36H	;rw-rw-
	LD	HL,0002H	;Sysop
	LD	(NEW_EN_OWNER),HL
	LD	HL,(NEW_EN_PAR)
	LD	(NEW_EN_PARENT),HL
;
	LD	HL,NEW_ENODE_ENTRY
	LD	DE,ENODE
	LD	BC,48
	LDIR
	LD	HL,(NEW_ENODE)
	LD	(CURR_ENODE),HL
	CALL	WRITE_ENODE
	JP	NZ,GET_BACK
	LD	HL,(OLD_ENODE)
	LD	(CURR_ENODE),HL
	CALL	ACCESS_ENODE
	JP	NZ,GET_BACK
	LD	HL,(NEW_ENODE)
	LD	A,(TYPE)
	OR	A
	JR	Z,FS_031
	LD	(EN_SIBLING),HL
	JR	FS_032
FS_031	LD	(EN_CHILD),HL
FS_032	CALL	WRITE_ENODE
	CALL	GET_REG
	RET	Z
	RET
;
FS_LS	;List directory contents
	CALL	SAVE_REG
	CALL	FSE_SETROOT
	CALL	TREE_SEARCH
	JP	NZ,GET_BACK
;Check if current enode is a directory
	LD	A,(EN_FLAGS)
	BIT	IS_DIR,A
	JR	NZ,FS_035
	LD	A,64	;not a directory
	OR	A
	JP	GET_BACK
FS_035
;Check for 'r' perms
	CALL	CHK_PERMS
	AND	4	;'r--'
	JR	NZ,FS_102
	LD	A,71	;Perms denied
	OR	A
	JP	GET_BACK
FS_102
	LD	A,0DH
	CALL	33H
	LD	HL,EN_NAME
	CALL	FSE_PUTS
	LD	A,':'
	CALL	33H
	LD	A,0DH
	CALL	33H
	LD	HL,(EN_CHILD)
	LD	A,H
	OR	L
	JP	Z,GET_BACK
;
FS_036	LD	(CURR_ENODE),HL
	CALL	ACCESS_ENODE
	JP	NZ,GET_BACK
;Do permissions now
;
	LD	B,'d'
	LD	A,(EN_FLAGS)
	BIT	IS_DIR,A
	CALL	FSE_FLAG
	LD	B,'r'
	LD	A,(EN_PERMS)
	BIT	5,A
	CALL	FSE_FLAG
	LD	B,'w'
	BIT	4,A
	CALL	FSE_FLAG
	LD	B,'x'
	BIT	3,A
	CALL	FSE_FLAG
	LD	B,'r'
	BIT	2,A
	CALL	FSE_FLAG
	LD	B,'w'
	BIT	1,A
	CALL	FSE_FLAG
	LD	B,'x'
	BIT	0,A
	CALL	FSE_FLAG
	LD	A,' '
	CALL	33H
	LD	A,' '
	CALL	33H
	LD	HL,EN_NAME
	CALL	FSE_PUTS
;
	LD	A,0DH
	CALL	33H
	LD	HL,(EN_SIBLING)
	LD	A,H
	OR	L
	JR	NZ,FS_036
	JP	GET_BACK
;
FSE_PUTS
	LD	A,(HL)
	OR	A
	RET	Z
	CALL	33H
	INC	HL
	JR	FSE_PUTS
;
FSE_STRLEN
	PUSH	HL
	LD	B,0
FS_037	LD	A,(HL)
	OR	A
	JR	Z,FS_038
	INC	B
	INC	HL
	JR	FS_037
FS_038	LD	A,B
	POP	HL
	RET
;
FSE_FLAG
	PUSH	AF
	JR	NZ,FS_039
	LD	A,'-'
	CALL	33H
	POP	AF
	RET
FS_039	LD	A,B
	CALL	33H
	POP	AF
	RET
;
FS_DOS_ERROR
	PUSH	AF
	CALL	FS_FS_CLOSE
	JR	Z,FS_040
	OR	80H
	CALL	DOS_ERROR
FS_040	POP	AF
	PUSH	BC
	LD	B,A
	AND	7FH
	CP	64
	JR	NC,FS_112
	LD	A,B
	POP	BC
	JP	DOS_ERROR
;Special File-System error.
FS_112	LD	A,B
	POP	BC
	PUSH	AF
	AND	7FH
	SUB	64
	ADD	A,A
	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	HL,ERR_MSG
	LD	E,A
	LD	D,0
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	CALL	FSE_PUTS
	POP	BC
	POP	DE
	POP	HL
	POP	AF
	BIT	7,A
	RET	NZ
	JP	4030H
;
FS_DOS	CALL	FS_FS_CLOSE
	JP	NZ,DOS_ERROR
	JP	DOS
;
ERR_MSG	DEFW	E_64
	DEFW	E_65
	DEFW	E_66
	DEFW	E_67
	DEFW	E_68
	DEFW	E_69
	DEFW	E_70
	DEFW	E_71
;
E_64	DEFM	'Path component is not a directory',0DH,0
E_65	DEFM	'End of path is a directory',0DH,0
E_66	DEFM	'Dir/File does not exist',0DH,0
E_67	DEFM	'Dir/File already exists',0DH,0
E_68	DEFM	'Path component does not exist',0DH,0
E_69	DEFM	'File-System Internal error',0DH,0
E_70	DEFM	'Name too long',0DH,0
E_71	DEFM	'Permissions denied',0DH,0
;
CHK_PERMS
	LD	HL,(UID)
	LD	DE,(EN_OWNER)
	OR	A
	SBC	HL,DE
	LD	A,H
	OR	L
	JR	NZ,FS_041
	LD	A,(EN_PERMS)
	SRL	A
	SRL	A
	SRL	A
	AND	7
	RET
FS_041	LD	A,(EN_PERMS)
	AND	7
	RET
;
FSE_SETROOT
	LD	A,(IX)
	CP	'/'
	JR	NZ,FS_042
	LD	HL,0
	INC	IX
	JR	FS_043
FS_042	LD	HL,(CDIR_ENODE)
FS_043	LD	(ROOT_ENODE),HL
	LD	(PATH_PTR),IX
	OR	A
	RET
;
IF_TERM		;Return Z if terminator.
	OR	A
	RET	Z
	CP	' '
	RET	Z
	CP	0DH
	RET
;
FS_FS_CLOSE
	LD	DE,FS_FCB
	CALL	DOS_CLOSE
	RET
;
   