TRACE  ;********************************************************
 ;
 ;TRACE/ASM - by Greg Small - 17jan85 - 19:00
 ;Installs TRACE function plus for Newdos/80 Version 2.x
 ;
 ;Copyright 1985 by Greg Small
 ;
 ;Permission to use for non-commercial applications is
 ;hereby granted -- all other rights reserved.
 ;
 ;program from an original idea by Randy Cook
 ;relocation section from an idea by Jack Decker
 ;
 ;********************************************************
 ;
 	ORG	05200H
 ;
 FOLLOW	EQU	0000H		;Byte to follow
 ;
 INIT	EQU	$
 ;
 	LD	A,(4427H)	;Get Newdos/80 ID byte
 	CP	82H		;Is it Newdos/80 Vers. 2
 	JR	NZ,ERROR1	;NO - go process error
 	LD	A,(442BH)	;Get Model number
 	CP	01H		;Is it a I
 	JR	Z,RELOC		;YES - then go to RELOC
 	CP	03H		;Is it a III
 	JR	NZ,ERROR2	;NO - go process error
 	LD	HL,4411H	;Get Model 3 himem in HL
 	LD	(GETMEM+2),HL	;Patch initialization
 	LD	(STRMEM+2),HL	; for a III
 	LD	HL,447BH	;Get M3 ENQUE in HL
 	LD	(SETUP+1),HL	; and patch init.
 	LD	A,14H		;Get SP offset in A
 	LD	(ADDER),A	; and patch working part
 	LD	HL,44D2H	;Get M3 SHOWBY in HL
 	LD	(WORD+1),HL	; and patch working part
 	LD	HL,44D7H	;Get M3 SHOWRD in HL
 	LD	(BYTE+1),HL	; and patch working part
 ;
 RELOC	EQU	$
 ;
 	LD	HL,END		;Get current END in HL
 ;
 GETMEM	EQU	$
 ;
 	LD	DE,(4049H)	;Get HIMEM in DE
 	LD	BC,END-START+1	;Get length of prog in BC
 	LDDR			;Move working part
 	PUSH	DE		;Save new memory size
 	INC	DE		;To point to START
 ;
 SETUP	EQU	$
 ;
 	CALL	4410H		;CALL ENQUE to patch into
 				;interrupt chain
 	POP	DE		;Get new HIMEM back
 ;
 STRMEM	EQU	$
 ;
 	LD	(4049H),DE	; and put it into HIMEM
 	RET			;RET to DOS READY
 ;
 ERROR1	EQU	$
 ;
 	LD	HL,MSG1		;Point HL to MSG1
 	DEFB	0DDH		;Make LD HL look like
 				;     LD IX to save bytes
 ;
 ERROR2	EQU	$
 ;
 	LD	HL,MSG2		;Point HL to MSG2
 	JP	4467H		; and JP to display msg
 				; and RET to DOS READY
 ;
 MSG1	EQU	$
 ;
 	DEFM	'This program is for Newdos/80 only.'
 	DEFB	0DH
 ;
 MSG2	EQU	$
 ;
 	DEFM	'This program is for Model I or III only.'
 	DEFB	0DH
 ;
 START	EQU	$
 ;
 ;Refer to section 3.8 on page 3-3 for information on the
 ;following four bytes and their uses.
 ;
 	DEFW	0000H		;2 bytes for DOS's use
 	DEFW	0101H		;2 bytes for counters
 ;
 	LD	A,(FOLLOW)	;Get byte to follow in A
 	LD	HL,3C2AH	;Point to screen location
 ;
 BYTE	EQU	$
 ;
 	CALL	4068H		;CALL SHOWBY
 ;
 ADDER	EQU	$+1
 ;
 	LD	HL,0EH		;Get SP adder in HL
 	ADD	HL,SP		; add it to SP value
 				; and store result in HL
 	LD	E,(HL)		;Move HL
 	INC	HL		; over
 	LD	D,(HL)		;  to DE
 	LD	HL,3C2EH	;Point HL to screen loc.
 WORD	EQU	$
 	JP	4063H		;JP to SHOWRD and RET
 END	EQU	$-1
 	END	INIT		;Auto start at INIT
