TAPERE ; #######################################################
 ; TAPE READER AND 256-BYTE LOADER ROUTINE
 ; DENNIS BATHORY KITSZ, ROXBURY, VERMONT 05669
 ; #######################################################
 ;
 VECTOR	EQU	4013H		;INTERRUPT VECTOR PATCH
 BASIC	EQU	06CCH		;RETURN TO BASIC READY
 VIDEO	EQU	3C00H		;BEGINNING OF SCREEN
 ;
 ; #######################################################
 ; INTERRUPT VECTOR AT 4012H
 ; #######################################################
 ;
 	ORG	4012H		;CURRENT VALUE IS C9
 	DEFB	0C3H		;REPLACE WITH JUMP
 	ORG	07D00H		;ROUTINES BEGIN HERE
 ;
 ; #######################################################
 ; CLEAR SCREEN SUBROUTINE
 ; #######################################################
 ;
 CLEAR	LD	HL,VIDEO	;GET START OF VIDEO
 	LD	DE,VIDEO+1	;GET DESTINATION POINT
 	LD	BC,03FFH	;GET MEMORY BLOCK SIZE
 	LD	(HL),20H	;WRITE SPACE INTO VIDEO
 	LDIR			;BLOCK MOVE CLEAR SCREEN
 	RET			;BACK FROM SUBROUTINE
 ;
 ; #######################################################
 ; SCAN FOR ENTER SUBROUTINE
 ; #######################################################
 ;
 ENTER	LD	A,(3840H)	;"ENTER" KEYBOARD ROW
 	CP	2		;"ENTER" KEYBOARD COLUMN
 	JR	NZ,ENTER	;LOOP UNTIL KEY PRESSED
 	RET			;BACK FROM SUBROUTINE
 ;
 ; #######################################################
 ; DISPLAY MESSAGE SUBROUTINE
 ; #######################################################
 ;
 DISPLY	LD	A,(HL)		;GET BEGINNING OF TEXT
 	AND	A		;CHECK IF A NULL
 	RET	Z		;EXIT SUBROUTINE IF NULL
 	LD	(DE),A		;DISPLAY CHARACTER IN A
 	INC	HL		;GET NEXT MESSAGE LOC'N
 	INC	DE		;GET NEXT SCREEN LOC'N
 	JR	DISPLY		;LOOP FOR CHARACTER TEST
 ;
 ; #######################################################
 ; CONVERT TO ASCII SUBROUTINE
 ; #######################################################
 ;
 CONVRT	PUSH	AF		;SAVE ACCUM. AND FLAGS
 	AND	0F0H		;MASK OUT LOW 4 BITS
 	RRA			;MOVE NIBBLE TO RIGHT...
 	RRA			;  ...SOME MORE
 	RRA			;  ...SOME MORE
 	RRA			;  ...UNTIL DONE
 	CP	0AH		;IS IT TEN OR GREATER?
 	JR	NC,HIBYTE	;MOVE ALONG IF > TEN
 	ADD	A,30H		;ASCII = NUMBER PLUS 30H
 	JR	NEXT		;GO ON TO LOW NIBBLE
 HIBYTE	ADD	A,37H		;ASCII = NUMBER PLUS 37H
 NEXT	LD	(HL),A		;DISPLAY FIRST ASCII CHAR
 	INC	HL		;GET NEXT SCREEN LOC'N
 	POP	AF		;RESTORE ORIGINAL HEX
 	AND	0FH		;MASK OUT HIGH 4 BITS
 	CP	0AH		;IS IT TEN OR GREATER?
 	JR	NC,HIBTE2	;MOVE ALONG IF > TEN
 	ADD	A,30H		;ASCII = NUMBER PLUS 30H
 	JR	NEXT2		;GO TO DISPLAY & OUT
 HIBTE2	ADD	A,37H		;ASCII = NUMBER PLUS 37H
 NEXT2	LD	(HL),A		;DISPLAY NEXT ASCII VALUE
 	RET			;BACK FROM SUBROUTINE
 ;
 ; #######################################################
 ; CLEAR TAPE READER INTERRUPT ACKNOWLEDGE
 ; #######################################################
 ;
 SERVE0	DI			;INTERRUPT OFF IN SERVICE
 	XOR	A		;CLEAR ACCUM. & FLAGS
 	RET			;BACK FROM SUBROUTINE
 ;
 ; #######################################################
 ; PAGE ADDRESS INTERRUPT SERVICE
 ; #######################################################
 ;
 SERVE1	DI			;INTERRUPT OFF IN SERVICE
 	IN	A,(3FH)		;GET VALUE FROM READER
 	CALL	CONVRT		;CONVERT VALUE TO ASCII
 	XOR	A		;CLEAR ACCUM. & FLAGS
 	RET			;BACK FROM SUBROUTINE
 ;
 ; #######################################################
 ; READ DATA / PLACE ON SCREEN INTERRUPT
 ; #######################################################
 ;
 SERVE2	DI			;INTERRUPT OFF IN SERVICE
 	IN	A,(3FH)		;GET VALUE FROM READER
 	LD	(HL),A		;PUT IT INTO MEMORY
 	ADD	A,C		;GET VALUE FROM CHECKSUM
 	LD	C,A		;RESTORE UPDATED CHECKSUM
 	INC	HL		;GET NEXT MEMORY LOC'N
 	XOR	A		;CLEAR ACCUM. & FLAGS
 	RET			;BACK FROM SUBROUTINE
 ;
 ; #######################################################
 ; CHECKSUM INTERRUPT ROUTINE
 ; #######################################################
 ;
 SERVE3	DI			;INTERRUPT OFF IN SERVICE
 	IN	A,(3FH)		;GET VALUE FROM READER
 	LD	B,A		;SAVE IT IN B REGISTER
 	XOR	A		;CLEAR ACCUM. & FLAGS
 	RET			;BACK FROM SUBROUTINE
 ;
 ; #######################################################
 ; MESSAGES FOLLOW
 ; #######################################################
 ;
 MSGNO1	DEFM	'THREAD TAPE AND PRESS CLEAR.'
 	DEFB	00
 MSGNO2	DEFM	'LOADING PAGE ADDRESS:  '
 	DEFB	00
 MSGNO3	DEFM	'BYTES LOADING AS FOLLOWS:'
 	DEFB	00
 MSGNO4	DEFM	'CALCULATED CHECKSUM IS:  '
 	DEFB	00
 MSGNO5	DEFM	'CHECKSUM AS READ IS:  '
 	DEFB	00
 MSGNO6	DEFM	'CHECKSUM ERROR IN THIS BLOCK.'
 	DEFB	00
 MSGNO7	DEFM	'BLOCK LOADED CORRECTLY.'
 	DEFB	00
 MSGNO8	DEFM	'ANOTHER BLOCK?  REPLY 1 FOR YES, 2 FOR NO'
 	DEFB	00
 MSGNO9	DEFM	'PRESS CLEAR TO RETURN TO BASIC.'
 	DEFB	00
 ;
 ; #######################################################
 ; REMEMBER THIS IS ENTRY POINT AND NOT!
 ; BEGINNING OF PROGRAM.......
 ; CLEAR SCREEN, DISPLAY "THREAD" MESSAGE
 ; #######################################################
 ;
 START	CALL	CLEAR		;OUT TO CLEAR SUBROUTINE
 	LD	HL,MSGNO1	;GET MESSAGE #1 LOCATION
 	LD	DE,VIDEO	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 	CALL	ENTER		;WAIT FOR ENTER SUBROUT.
 ;
 ; #######################################################
 ; DISPLAY "ADDRESS" MESSAGE & FIND IT
 ; #######################################################
 ;
 	LD	HL,MSGNO2	;GET MESSAGE #2 LOCATION
 	LD	DE,VIDEO+40H	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 	LD	HL,SERVE0	;GET INT #1 SERVICE ROUT.
 	LD	(VECTOR),HL	;INSTALL AT INT. VECTOR
 	SCF			;CARRY FLAG IS IMPORTANT
 	IM	1		;SET INTERRUPT MODE
 	EI			;INTERRUPTS ON & WAITING
 	JR	C,$		;SUBROUTINE CLEARS CARRY!
 	LD	HL,SERVE1	;GET INT #2 SERVICE ROUT.
 	LD	(VECTOR),HL	;INSTALL AT INT. VECTOR
 	LD	HL,VIDEO+57H	;GET DISPLAY LOCATION
 	SCF			;CARRY DETERMINES LOOP
 	EI			;INTERRUPTS ON & WAITING
 	JR	C,$		;SUBROUTINE CLEARS CARRY!
 ;
 ; #######################################################
 ; DISPLAY "BYTES" MESSAGE & LOAD 256
 ; #######################################################
 ;
 	LD	HL,MSGNO3	;GET MESSAGE #3 LOCATION
 	LD	DE,VIDEO+80H	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 	LD	HL,SERVE2	;GET INT #3 SERVICE ROUT.
 	LD	(VECTOR),HL	;INSTALL AT INT. VECTOR
 	LD	HL,VIDEO+100H	;GET FIRST DISPLAY LOC'N
 	XOR	A		;CLEAR ACCUM. & FLAGS
 	LD	C,A		;CLEAR CHECKSUM REGISTER
 	LD	B,00H		;LOAD B REGISTER WITH 256
 LOOP2	SCF			;INSTALL "JR C" LOOP
 	EI			;INTERRUPS ON & WAITING
 	JR	C,$		;SUBROUTINE CLEARS CARRY!
 	DJNZ	LOOP2		;WRITE ONE PAGE TO MEMORY
 ;
 ; #######################################################
 ; DISPLAY "CHECKSUM CALC" MESSAGE
 ; #######################################################
 ;
 	LD	HL,SERVE3	;GET INT #4 SERVICE ROUT.
 	LD	(VECTOR),HL	;INSTALL AT INT. VECTOR
 	LD	HL,MSGNO4	;GET MESSAGE #4 LOCATION
 	LD	DE,VIDEO+240H	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 	LD	A,C		;GET CHECKSUM CALCULATION
 	PUSH	DE		;SAVE DISPLAY INFORMATION
 	POP	HL		;TRANSFER IT TO HL PAIR
 	CALL	CONVRT		;CNVRT. CHECKSUM TO ASCII
 ;
 ; #######################################################
 ; DISPLAY "CHECKSUM READ" MESSAGE & DO IT
 ; #######################################################
 ;
 	LD	HL,MSGNO5	;GET MESSAGE #5 LOCATION
 	LD	DE,VIDEO+280H	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 	EI			;INTERRUPTS ON & WAITING
 	SCF			;CARRY FLAG LOOP SET
 	JR	C,$		;SUBROUTINE CLEARS CARRY!
 ;
 ; #######################################################
 ; DISPLAY CHECKSUM AND CHECK IT
 ; #######################################################
 ;
 	LD	A,B		;GET READ CHECKSUM BACK
 	PUSH	DE		;STASH DE REGISTER PAIR
 	POP	HL		;TRANSFER TO HL PAIR
 	CALL	CONVRT		;CNVRT. CHECKSUM TO ASCII
 	LD	A,B		;GET VALUE AGAIN FROM B
 	CP	C		;CHECK WITH CALC CHECKSUM
 	JR	Z,CKSMOK	;CHECKSUM OKAY IF A MATCH
 ;
 ; #######################################################
 ; DISPLAY CHECKSUM BAD MESSAGE
 ; #######################################################
 ;
 	LD	HL,MSGNO6	;GET MESSAGE #6 LOCATION
 	LD	DE,VIDEO+2C0H	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 	JR	LEAVE		;LOAD COMPLETE - GO OUT
 ;
 ; #######################################################
 ; DISPLAY CHECKSUM OKAY MESSAGE
 ; #######################################################
 ;
 CKSMOK	LD	HL,MSGNO7	;GET MESSAGE #7 LOCATION
 	LD	DE,VIDEO+2C0H	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 LEAVE	LD	HL,MSGNO8	;GET MESSAGE #8 LOCATION
 	LD	DE,VIDEO+300H	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 ;
 ; #######################################################
 ; SCAN KEYBOARD FOR 1 OR 0 & DO IT
 ; #######################################################
 ;
 FINDYN	LD	A,(3810H)	;GET 0-7 KEYBOARD ROW
 	CP	2		;IS IT NUMBER ONE?
 	JP	Z,START		;BACK TO START IF SO
 	CP	4		;IS IT NUMBER TWO?
 	JR	Z,DONE		;FINISHED ROUTINE IF SO
 	JR	FINDYN		;KEEP LOOKING IF NEITHER
 DONE	LD	HL,MSGNO9	;GET MESSAGE #9 LOCATION
 	LD	DE,VIDEO+340H	;GET DISPLAY LOCATION
 	CALL	DISPLY		;OUT TO DISPLAY SUBROUT.
 LOOKNG	CALL	ENTER	;LOOK FOR ENTER SUBROUT.
 	JP	BASIC		;BACK TO BASIC READY
 ;
 ; #######################################################
 	END	START		;SYSTEM ENTRY POINT
 ; #######################################################
