VID/AS 	ORG	$
 ; vid/asm
 DISPLY	EX	(SP),HL		;get data address
 	PUSH	DE		;save hl and de
 	EX	DE,HL		;de=> data
 	CALL	PRINT		;print the line
 	EX	DE,HL		;hl=> data +1
 	POP	DE		;restore de and hl
 	EX	(SP),HL		;and put back return addr
 	RET			;done
 PRINT	LD	A,(DE)
 	INC	DE
 	CP	7
 	RET	C
 	CALL	VOUT
 	CP	13
 	RET	Z
 	JR	PRINT
 VOUT	LD	(OUTBYTE),A	;save byte
 	LD	A,0
 DUALFLAG	EQU	$-1	;dual on/off flag
 	RLCA			;check bit 7
 	LD	A,0
 OUTBYTE	EQU	$-1		;get byte back
 	CALL	C,POUT		;output to printer
 	PUSH	HL		;save hl
 	LD	HL,(CURSOR)	;get cursor posit
 	CP	20H		;control byte ?
 	JR	C,DISCTL	;go if yes
 	LD	(HL),A		;display the byte
 	CP	(HL)		;still there ?
 	JR	Z,DISOK		;lowercase mod there
 	SUB	20H		;make it upper case
 	LD	(HL),A		;put it back
 DISOK	INC	HL		;bump cursor
 CTLDON	LD	A,H
 	CP	40H
 	CALL	NC,SCROLL
 	LD	A,H
 	CP	3CH
 	JR	NC,CSOK
 	LD	HL,3C00H
 CSOK	LD	(CURSOR),HL
 	LD	A,(OUTBYTE)
 	POP	HL		;restore it
 	RET
 DISCTL	CP	7		;CLEAR SCREEN
 	JR	Z,CLS
 	CP	10		;linefeed ?
 	JR	Z,CARRET
 	CP	13		;ENTER
 	JR	Z,CARRET
 	CP	14		;sh enter
 	JR	Z,CARRET
 	CP	1DH		;begin of line ?
 	JR	Z,BOL
 	CP	1EH		;end of line ?
 	JR	Z,EOL
 	CP	9		;tab ?
 	JR	Z,TAB
 	CP	8		;backspace ?
 	JR	Z,BKSP
 	JR	CTLDON		;FINISHED
 BKSP	LD	(HL),20H	;character off
 	DEC	HL		;move back
 	JR	CTLDON
 TAB	LD	A,L
 	AND	0F8H
 	PUSH	DE
 	LD	DE,8
 	LD	L,A
 	ADD	HL,DE
 	POP	DE
 	JR	CTLDON		;finished
 EOL	CALL	BELINE
 	PUSH	BC
 	LD	BC,3FH		;one line -1
 FIXCON	PUSH	HL
 	PUSH	DE		;save registers
 	LD	D,H
 	LD	E,L
 	INC	DE		;de = hl+1
 	LD	(HL),20H	;space there
 	LDIR			;make them all spaces
 	POP	DE
 	POP	HL
 	POP	BC
 	JR	CTLDON		;done with control
 BOL	CALL	BELINE
 	JR	CTLDON		;done
 CLS	XOR	A		;set single width
 	OUT	(0FFH),A
 	LD	HL,3C00H	;top of video
 	PUSH	BC
 	LD	BC,1023		;video length -1
 	JR	FIXCON		;continue
 CARRET	CALL	BELINE
 	PUSH	DE
 	LD	DE,40H		;# chars / line
 	ADD	HL,DE		;point to next line
 	POP	DE
 	JR	CTLDON
 BELINE	LD	A,L
 	AND	0C0H
 	LD	L,A
 	RET
 GETSTR	LD	C,B		;c=requested length
 	LD	DE,STRING	;input buffer
 	LD	B,0		;current length
 NEWKEY	LD	HL,(CURSOR)	;cursor position
 KEYWT	LD	(HL),5DH	;up arrow
 	CALL	KEY		;scan keyboard
 	JR	NZ,KEYHAV	;have a key if nz
 	PUSH	BC
 	LD	BC,500H
 	CALL	DELAY
 	POP	BC
 	LD	A,(HL)
 	CP	5DH
 	JR	NZ,KEYWT
 	INC	(HL)
 	JR	KEYWT+2
 KEYHAV	LD	(DE),A		;save in buffer
 	LD	(HL),20H	;cursor off
 	CP	13		;enter ?
 	JR	Z,DONE
 	CP	14
 	JR	Z,DONE
 	CP	8		;backspace ?
 	JP	Z,BACKSPACE
 	CP	18H		;sh left arrow ?
 	JP	Z,NEWST		;new start
 	CP	3		;clear ?
 	JP	Z,NEWST
 	CP	20H
 	JP	C,KEYWT		;invalid input
 	LD	A,B		;get length
 	CP	C		;test for max.
 	JR	NC,KEYWT	;too many char
 	LD	A,(DE)		;get byte back
 	CALL	VOUT		;print it
 	INC	B		;bump count
 	INC	DE
 	JR	NEWKEY
 NEWST	LD	A,B
 	OR	A
 	JP	Z,NEWKEY
 	CALL	GOBAK
 	JR	NEWST
 BACKSPACE	LD	A,B
 	OR	A
 	JR	Z,KEYWT
 	CALL	GOBAK
 	JR	NEWKEY
 GOBAK	LD	A,8
 	DEC	B
 	DEC	DE
 	JP	VOUT
 DONE	CALL	VOUT		;DISPLAY LINEFEED
 	LD	A,B		;CHECK FOR ANY LENGTH
 	OR	A		;SET FLAGS
 	LD	HL,STRING	;point to buffer
 	LD	A,(HL)		;return with 1st char
 	RET			;DONE
 SCROLL	PUSH	DE
 	PUSH	BC
 	LD	DE,3C00H
 	LD	HL,3C40H
 	LD	BC,3C0H
 	LDIR
 	LD	HL,3FC0H
 	PUSH	HL
 	LD	BC,3F20H
 	CALL	FILL
 	POP	HL
 	POP	BC
 	POP	DE
 	RET
 	END
 	RET			;DONE
 SCROLL	PUSH	DE
 	PUSH	BC
 	LD	DE,3C00H
 	LD	HL,3C40H
 	LD	BC,3C0H
 	LDIR
 	LD	HL,3FC0H
 	PUSH	HL
 	LD	BC,3F20H
 	CALL	FILL
 	POP	HL
 	POP	BC
 	ULTRADOSULTRADOSULTRADOSULTRA