SUBS/A 	ORG	$
 ; subs/asm
 GOTABLE	POP	HL		;get pointer from stack
 	DEC	HL
 	DEC	HL		;table -2
 	LD	B,A		;position counter
 GOTLG	INC	HL		;bump position
 	INC	HL
 	DJNZ	GOTLG		;go to right spot
 	LD	A,(HL)		;get a byte
 	INC	HL		;point to msb
 	LD	H,(HL)		;get that
 	LD	L,A		;hl=address
 	JP	(HL)		;go there
 HEXCV	LD	(HEXSAV),A	;save for later
 	SRL	A		;move top 4 bit down
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST		;make it hex ascii
 	LD	C,A		;save it here
 	LD	A,0		;get byte back
 HEXSAV	EQU	$-1
 	AND	0FH		;mask top 4 bits off
 	CALL	HEXTST		;make it ascii
 	LD	B,A		;bc = ascii in hex
 	RET			;done
 HEXTST	ADD	A,30H		;make it ascii
 	CP	3AH		;0-9 ?
 	RET	M		;yes
 	ADD	A,7		;adjust for a-f
 	RET
 ASCII	PUSH	HL		;save hl
 	CALL	ASCI		;convert to decimal ascii
 	LD	H,B		;save low number
 	PUSH	HL		;save it
 	LD	A,C		;get msb ascii
 	SUB	30H		;remove the ascii
 	CALL	ASCI		;make that lsb/msb ascii
 	LD	A,C		;a = mmsb
 	POP	HL		;restore temporary
 	LD	C,B		;swap
 	LD	B,H		;acb = decimal ascii
 	POP	HL		;restore hl
 	RET
 ASCI	LD	C,30H		;start with 0
 ASCII1	SUB	0AH		;less 10
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A		;make b = remainder
 	RET			;done
 TASK	PUSH	AF		;save this
 	LD	A,(37E0H)
 	BIT	6,A		;fdc making roster ?
 	JR	NZ,FDCROS
 	BIT	7,A		;time yet ?
 	JR	Z,TASKDN	;return if not
 	LD	A,(3840H)
 	BIT	2,A		;check for break key
 	JR	Z,TASKDN
 	LD	A,(3880H)	;check shift key
 	OR	A		;set flags
 	JP	Z,GOBACK	;return to sub-menu
 	JP	MENU		;return to master menu
 TASKDN	LD	A,(37E0H)	;clear latch
 	POP	AF		;restore it
 	EI			;enable interrupts
 	RET			;done
 FDCROS	LD	A,(37ECH)	;clear fdc
 	JR	TASKDN
 FILL	CALL	FILL1		;fill routines
 	DJNZ	FILL
 	RET
 FILL1	LD	(HL),C
 	INC	HL
 	RET
 STAT	PUSH	HL		;check disk status
 	PUSH	DE		;save registers
 	PUSH	BC
 	CALL	SELECT		;turn motor on
 	LD	A,(37ECH)	;available ?
 	RLCA			;check bit 7
 	LD	A,1		;drive not ready
 	JP	C,HOLDER	;go error
 	LD	BC,00CDH	;count for sector holes
 	LD	A,29		;no diskette in drive
 	EX	AF,AF'		;save it here
 TT1	DEC	BC
 	LD	A,B
 	OR	C
 	JP	Z,HOLDER-1	;wait till fixed
 	LD	A,(37ECH)	;check for hole
 	AND	2
 	JR	NZ,TT1
 	LD	BC,199DH	;no sector hole now
 	LD	A,28		;door not closed
 	EX	AF,AF'		;save here
 TT2	DEC	BC
 	LD	A,B
 	OR	C
 	JP	Z,HOLDER-1
 	LD	A,(37ECH)
 	AND	2
 	JR	Z,TT2		;wait till hole comes
 	LD	DE,0		;init count
 	LD	BC,00BAH	;another count
 	LD	A,29		;no disk in drive
 	EX	AF,AF'
 TT3	DEC	BC
 	LD	A,B
 	OR	C
 	JP	Z,HOLDER-1
 	INC	DE		;bump counter
 	LD	A,(37ECH)
 	AND	2
 	JR	NZ,TT3		;de = count
 	LD	BC,1720H
 	LD	A,28		;door not closed
 	EX	AF,AF'
 TST4	DEC	BC
 	LD	A,B
 	OR	C
 	JP	Z,HOLDER-1
 	INC	DE
 	LD	A,(37ECH)
 	AND	2
 	JR	Z,TST4		;wait for next hole
 	LD	HL,0EACBH
 	ADD	HL,DE
 	LD	A,26		;hard sectored disk
 	JR	NC,HOLDER
 	POP	BC
 	POP	DE
 	POP	HL		;restore registers
 	RET
 HOLDER	CALL	ERROR		;print the message
 	RST	8		;display
 	DB	'Press <ENTER> when corrected. ',3
 	LD	B,0
 	RST	10H
 	JP	STAT+3		;resume
 MOVE	PUSH	HL		;move subroutine
 	OR	A		;clear carry
 	SBC	HL,DE		;compare
 	POP	HL
 	JR	C,MOV		;move backwards
 	LDIR
 	RET
 MOV	ADD	HL,BC
 	DEC	HL
 	EX	DE,HL
 	ADD	HL,BC
 	DEC	HL
 	EX	DE,HL
 	LDDR
 	RET
 PRESS	RST	8
 	DB	'Press <ENTER> to continue. ',3
 	LD	B,0
 	RST	10H
 	RET
 VALUE	LD	IX,TYPSAV	;parameter pointer
 	LD	(IX),10
 	LD	(IX+1),6
 	LD	B,0
 	LD	(DATPNT),HL
 VALPOS	LD	A,(HL)		;get first byte
 	CP	60H
 	JR	C,VALCONTI
 	RES	5,A
 VALCONTI	CP	'H'
 	JR	Z,VHEXI
 	CP	'D'
 	JR	Z,VDECI
 	CP	'O'
 	JR	Z,VOCTI
 	CP	'B'
 	JR	Z,VBINI
 	CALL	IFNUM
 	RET	C		;non-numeric
 VALGIN	LD	A,(HL)		;get the byte
 	CALL	IFNUM		;numeric ?
 	JR	NC,DECCON	;continue if yes
 	CP	','
 	JR	Z,VALCOM	;compute
 	CP	21H
 	JR	C,VALCOM
 VALBAD	LD	HL,0
 DATPNT	EQU	$-2
 VABAD	SCF			;carry = error
 	RET
 DECCON	INC	HL
 	INC	B
 	JR	VALGIN
 VALPOSOD	OR	A	;clear carry
 	RET
 IFNUM	CP	30H		;0-9 ?
 	JR	C,VABAD		;bad
 	CP	3AH
 	JR	C,VALPOSOD
 	CP	41H
 	JR	C,VABAD
 	RES	5,A
 	CP	47H
 	JR	NC,VABAD
 	JR	VALPOSOD
 VDECI	LD	(IX),10
 	LD	(IX+1),6
 VALGO	INC	HL
 	LD	(DATPNT),HL
 	JR	VALGIN
 VHEXI	LD	(IX),16
 	LD	(IX+1),5
 	JR	VALGO
 VBINI	LD	(IX),2
 	LD	(IX+1),17
 	JR	VALGO
 VOCTI	LD	(IX),8
 	LD	(IX+1),8
 	JR	VALGO
 VALCOM	LD	A,B		;get length
 	OR	A
 	JR	Z,VALBAD
 	CP	(IX+1)
 	JR	Z,VCOK
 	JR	NC,VALBAD
 	LD	HL,(DATPNT)
 VALCOM2	LD	A,B
 	CP	(IX+1)
 	JR	Z,VCOK
 	DEC	HL
 	LD	(HL),'0'
 	INC	B
 	JR	VALCOM2
 VCOK	LD	DE,0
 	DEC	(IX+1)
 VCOKLP	LD	A,(HL)
 	CALL	MAKNUM
 	CP	(IX)
 	JR	NC,VALBAD
 	PUSH	HL
 	LD	L,A
 	LD	H,0
 	PUSH	DE
 	LD	B,(IX+1)
 VALHRR	PUSH	BC
 	CALL	MULT
 	POP	BC
 	DJNZ	VALHRR
 	POP	DE
 	ADD	HL,DE
 	EX	DE,HL
 	POP	HL
 	INC	HL
 	DEC	(IX+1)
 	JR	NZ,VCOKLP
 	LD	A,(HL)
 	CALL	MAKNUM
 	CP	(IX)
 	JP	NC,VALBAD
 	PUSH	HL
 	LD	L,A
 	LD	H,0
 	ADD	HL,DE
 	EX	DE,HL
 	POP	HL
 	INC	HL
 	INC	HL
 	LD	A,D
 	OR	A
 	PUSH	DE
 	POP	BC
 	LD	A,E
 	RET
 MAKNUM	SUB	30H
 	CP	0AH
 	RET	C
 	SUB	7
 	CP	17
 	RET	C
 	SUB	20H
 	RET
 MULT	EX	DE,HL
 	LD	HL,0
 	LD	B,(IX)
 MULTLP	SRL	B
 	JR	NC,MULTCON
 	ADD	HL,DE
 MULTCON	RET	Z
 	EX	DE,HL
 	ADD	HL,HL
 	EX	DE,HL
 	JR	MULTLP
 TYPSAV	DW	0
 UPCURSOR	PUSH	HL
 	PUSH	BC
 	LD	HL,(CURSOR)
 	LD	BC,-40H
 	ADD	HL,BC
 	LD	(CURSOR),HL
 	POP	BC
 	POP	HL
 	RET
 	END
T	Z
 	EX	DE,HL
 	ADD	HL,HL
 	EX	DE,HL
 	JR	MULTLP
 TYPSAV	DW	0
 UPCURSOR	PUSH	HL
 	PUSH	BC
 	LD	HL,(CURSOR)
 	LD	BC,-40H
 	ADD	HL,BC
 	LD	(CURSOR),HL
 	POP	BC
 	POP	HL
 	RET
 	EN)
