MEMORY 	ORG	$
 ; memory/asm
 MEMORY	DI
 	LD	SP,STACK
 	LD	A,2
 	LD	(WHERE),A
 	RST	8
 	DB	7,'***  Memory Test  ***',10,10
 	DB	'1.  Test ROM',10
 	DB	'2.  Test RAM',10
 	DB	'3.  Test Video',10
 	DB	'4.  Test Keyboard',10
 	DB	10,'Choice ? ',3
 	LD	B,1		;one key input
 	RST	10H		;go keyboard
 	JR	Z,MEMORY	;z = no input
 	SUB	30H		;remove ascii
 	JR	C,MEMORY	;too small
 	CP	5		;4 menu options
 	JR	NC,MEMORY	;too big
 	EI			;enable now
 	CALL	GOTABLE		;jump to table
 	DW	TESROM,TESRAM,TVIDEO,TESKEY
 TESROM	RST	8		;display following
 	DB	10,13
 	LD	HL,0
 	LD	(TEMP0),HL	;initialize passes
 	LD	(TEMP1),HL	;initialize error count
 TROM	LD	HL,0		;initialize checksum
 	LD	BC,1000H	;4K
 	LD	DE,0		;test 1st 4K
 	LD	A,'A'		;rom A
 	LD	(CKTYP),A
 	CALL	SHOWCKSUM	;compute and display
 	LD	HL,0AE5DH	;valid checksums
 	OR	A
 	SBC	HL,DE
 	JP	Z,RT1OK
 	LD	HL,0AE60H
 	OR	A
 	SBC	HL,DE
 	JP	Z,RT1OK
 	LD	HL,0B078H
 	OR	A
 	SBC	HL,DE
 	JP	Z,RT1OK
 	CALL	RTBAD		;no matches from above
 RT2	LD	HL,0
 	LD	BC,1000H
 	LD	DE,1000H	;2nd 4K
 	LD	A,'B'		;rom B
 	LD	(CKTYP),A
 	CALL	SHOWCKSUM
 	OR	A
 	LD	HL,0DA84H
 	SBC	HL,DE
 	JP	Z,RT2OK
 	OR	A
 	LD	HL,0DA45H
 	SBC	HL,DE
 	JP	Z,RT2OK
 	CALL	RTBAD
 RT3	LD	HL,0
 	LD	BC,1000H
 	LD	DE,2000H	;3rd 4K
 	LD	A,'C'		;rom C
 	LD	(CKTYP),A
 	CALL	SHOWCKSUM
 	OR	A
 	LD	HL,3E3EH
 	SBC	HL,DE
 	JP	Z,RT3OK
 	OR	A
 	LD	HL,4002H
 	SBC	HL,DE
 	JP	Z,RT3OK
 	OR	A
 	LD	HL,4006H
 	SBC	HL,DE
 	JP	Z,RT3OK
 	OR	A
 	LD	HL,40BAH
 	SBC	HL,DE
 	JP	Z,RT3OK
 	OR	A
 	LD	HL,40E0H
 	SBC	HL,DE
 	JP	Z,RT3OK
 	CALL	RTBAD
 RT4	CALL	SHOWPASSES	;display # of passes
 	CALL	UPCURSOR	;move cursor up 4 lines
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	LD	BC,0		;one second delay
 	CALL	DELAY
 	LD	HL,(TEMP0)	;get passes
 	INC	HL		;bump count
 	LD	(TEMP0),HL	;put it back
 	JP	TROM
 SHOWCKSUM	LD	A,(DE)	;get byte from rom
 	INC	DE		;point to next byte
 	PUSH	BC		;save count
 	LD	C,A		;give byte to bc
 	LD	B,0
 	ADD	HL,BC		;add to total
 	POP	BC		;restore count
 	DEC	BC		;less one
 	LD	A,B		;any bits on ?
 	OR	C
 	JR	NZ,SHOWCKSUM	;continue if not zero
 	LD	(DESAVE),HL	;save checksum value
 	LD	A,H		;get msb
 	RST	30H		;convert to hex ascii
 	LD	(RCK1),BC	;save in string
 	LD	A,L		;get lsb
 	RST	30H		;hex ascii
 	LD	(RCK2),BC	;put in string
 	RST	8		;display following
 	DB	'Rom '
 CKTYP	DB	'A checksum = '
 RCK1	DB	'00'
 RCK2	DB	'00H  -  ',3
 	LD	DE,0		;return with checksum
 DESAVE	EQU	$-2
 	RET
 SHOWPASSES	LD	HL,(TEMP0)	;get passes
 	INC	HL		;correct # of passes
 	LD	IY,PASSES	;point to string
 	CALL	ASCII16		;put decimal ascii
 	LD	HL,(TEMP1)	;get error count
 	LD	IY,ROMERR	;point to string
 	CALL	ASCII16		;put ascii
 	RST	8		;display
 PASSES	DB	'00000 Passes, '
 ROMERR	DB	'00000 Errors occured.',13
 	RET
 RT1OK	CALL	RTOK		;rom test A good
 	JP	RT2
 RTBAD	RST	8		;bad rom test
 	DB	'** BAD **',13
 	LD	HL,(TEMP1)	;get error count
 	INC	HL		;bump it
 	LD	(TEMP1),HL	;put it back
 	RET
 RTOK	RST	8		;display OK
 	DB	'GOOD     ',13
 	RET
 RT2OK	CALL	RTOK		;rom test B OK
 	JP	RT3
 RT3OK	CALL	RTOK		;rom test C OK
 	JP	RT4
 TVIDEO	RST	8		;test video memory
 	DB	10,10,'Lower case ',3
 	XOR	A		;lower case flag
 	LD	(TEMP0),A
 	LD	HL,0
 	LD	(TEMP2),HL	;error counter
 	LD	(TEMP3),HL	;pass counter
 	LD	HL,3C00H	;point to top video
 	LD	A,60H		;lower case @
 	LD	B,(HL)		;get byte from video
 	LD	(HL),A		;display lower case @
 	CP	(HL)		;still there ?
 	LD	(HL),B		;put original back
 	JR	Z,LCASE		;z = lower case in
 	RST	8		;else print not in
 	DB	'** NOT ** ',3
 	LD	A,1		;flag upper case
 	LD	(TEMP0),A
 LCASE	RST	8
 	DB	'installed.',10
 	DB	'Press <ENTER> for video test. ',3
 	LD	B,0		;wait for enter only
 	RST	10H
 TVIDNEXT	XOR	A		;test byte, start with 0
 	LD	(TEMP1),A
 TVID	LD	A,(TEMP1)	;get test byte
 	LD	HL,3C00H
 	LD	DE,3C01H
 	LD	BC,1023
 	LD	(HL),A
 	LDIR			;fill screen with test
 	LD	HL,3C00H	;see if they're still on
 	LD	BC,1024		;video length
 TVID1	CP	(HL)		;still there ?
 	JR	NZ,TVID1BAD	;nz = nope
 	INC	HL		;bump pointer
 	DEC	C		;go till end
 	JR	NZ,TVID1
 	DJNZ	TVID1
 	LD	A,(TEMP1)	;bump test byte
 	INC	A
 	LD	(TEMP1),A
 	JR	Z,TVIDDONE	;0 = finished
 	CP	60H		;test for lower case
 	JR	C,TVID		;not lower case yet
 	CP	81H		;test for end of LC
 	JR	NC,TVID
 	LD	A,(TEMP0)	;get lower case flag
 	OR	A		;set flags
 	JR	Z,TVID		;z = lower case
 	LD	A,81H		;else skip lower case
 	LD	(TEMP1),A	;save new test byte
 	JR	TVID		;continue
 TVID1BAD	LD	HL,(TEMP2)	;get error count
 	INC	HL		;bump it
 	LD	(TEMP2),HL
 	LD	A,(TEMP1)	;get test byte
 	RST	28H		;convert to ascii
 	LD	(TVBYTE),A
 	LD	(TVBYTE+1),BC	;put in string
 	RST	8
 	DB	7,'Bad Video memory.  Test byte = '
 TVBYTE	DB	'000.',13
 	CALL	PRESS		;press enter to continue
 	JP	TVID		;continue
 TVIDDONE	LD	HL,(TEMP2)	;get error count
 	LD	IY,TVIDNUM	;point to string
 	CALL	ASCII16		;put decimal ascii there
 	LD	HL,(TEMP3)	;get # of passes
 	INC	HL		;adjust to true count
 	LD	IY,TCNTNUM	;point to string
 	CALL	ASCII16
 	RST	8
 	DB	7,'Video Test Pass '
 TCNTNUM	DB	'00000 completed.',10
 TVIDNUM	DB	'00000 Errors encountered.',13
 	LD	HL,(TEMP3)	;get pass count
 	INC	HL
 	LD	(TEMP3),HL	;bump it
 	LD	BC,0		;wait 3 seconds
 	LD	E,10
 DEPLP	LD	BC,0
 	CALL	DELAY
 	DEC	E
 	JR	NZ,DEPLP
 	JP	TVIDNEXT	;go next test
 TESRAM	RST	8
 	DB	10,13
 TESRAM1	RST	8
 	DB	1EH
 	DB	'<Q>uick test or <C>omplete test ? ',3
 	LD	B,1
 	RST	10H
 	JR	Z,TESRAM1
 	AND	5FH
 	CP	'Q'
 	JP	Z,QTRAM
 	CP	'C'
 	JR	NZ,TESRAM1
 TRAM	RST	8
 	DB	7,'**  Complete RAM test in progress  **',10,13
 	DI
 	CALL	INITBITS
 	LD	HL,-1
 	LD	(TEMP0),HL
 	INC	HL
 	LD	(TEMP1),HL
 	LD	IY,RAMERRNUM
 	CALL	ASCII16
 TOTLP	LD	HL,(TEMP0)
 	INC	HL
 	LD	(TEMP0),HL
 	LD	IY,TRPASS
 	CALL	ASCII16
 	LD	HL,4000H
 TRAMNEXT	LD	A,H
 	CALL	HEXCV
 	LD	(ADDMSG),BC
 	LD	A,L
 	CALL	HEXCV
 	LD	(ADDMSG+2),BC
 	PUSH	HL
 	RST	8
 	DB	1DH,'Testing Address '
 ADDMSG	DB	'0000H.  '
 RAMERRNUM	DB	'00000 Errors encountered, '
 TRPASS	DB	'00000 Passes.',13
 	CALL	SHOBITS
 	POP	HL
 TRSTART	XOR	A
 	LD	B,(HL)
 TBYTE	LD	(HL),A
 	CP	(HL)
 	JR	NZ,BADBYT
 	INC	A
 	JR	NZ,TBYTE
 	LD	(HL),B
 	JR	NEXTBYT
 BADBYT	LD	(HL),B
 TREND	PUSH	HL
 	CALL	GETBADBIT
 	LD	HL,(TEMP1)
 	INC	HL
 	LD	(TEMP1),HL
 	LD	IY,RAMERRNUM
 	CALL	ASCII16
 	POP	HL
 NEXTBYT	INC	HL
 	LD	A,(3840H)
 	BIT	2,A
 	JR	Z,NEXTBYTE
 	LD	A,(3880H)
 	OR	A
 	JP	Z,MEMORY
 	JP	MENU
 NEXTBYTE	EX	DE,HL
 	LD	HL,TRSTART
 	OR	A
 	SBC	HL,DE
 	JR	NZ,TRAMCONT
 	LD	DE,TREND
 TRAMCONT	LD	HL,(TOPMEM)
 	OR	A
 	SBC	HL,DE
 	EX	DE,HL
 	JP	NZ,TRAMNEXT
 	JP	TOTLP
 QTRAM	RST	8
 	DB	7,'**  Quick RAM test in progress  **',10,13
 	CALL	INITBITS
 	LD	HL,0
 	DI
 	LD	(TEMP1),HL
 	LD	IY,QERROR
 	CALL	ASCII16
 	LD	HL,-1
 	LD	(TEMP0),HL
 QTLOOP	LD	HL,(TEMP0)
 	INC	HL
 	LD	(TEMP0),HL
 	LD	IY,QPASS
 	CALL	ASCII16
 	CALL	QSHOW
 	LD	HL,4000H
 QALOOP	LD	B,(HL)
 	LD	A,1
 QFLOOP	LD	(HL),A
 	CP	(HL)
 	LD	(HL),B
 QBLOOP	JP	NZ,QABAD
 	SLA	A
 	JR	NZ,QFLOOP
 	INC	HL
 	LD	A,(3840H)
 	BIT	2,A
 	JR	Z,QDLOOP
 	LD	A,(3880H)
 	OR	A
 	JP	Z,MEMORY
 	JP	MENU
 QDLOOP	EX	DE,HL
 	LD	HL,QALOOP
 	OR	A
 	SBC	HL,DE
 	JR	NZ,QCLOOP
 	LD	DE,QBLOOP
 QCLOOP	LD	HL,(TOPMEM)
 	OR	A
 	SBC	HL,DE
 	EX	DE,HL
 	JR	NZ,QALOOP
 	JP	QTLOOP
 QSHOW	RST	8
 	DB	1DH
 QPASS	DB	'00000 Passes, '
 QERROR	DB	'00000 Errors.',13
 	CALL	SHOBITS
 	RET
 QABAD	PUSH	HL
 	CALL	GETBADBIT
 	LD	HL,(TEMP1)
 	INC	HL
 	LD	(TEMP1),HL
 	LD	IY,QERROR
 	CALL	ASCII16
 	CALL	QSHOW
 	POP	HL
 	JP	QBLOOP+3
 SHOBITS	RST	8
 	DB	10,10,'Bit 0 - Chip ZXX - '
 BIT0	DB	'Good',10,'Bit 1 - Chip ZXX - '
 BIT1	DB	'Good',10,'Bit 2 - Chip ZXX - '
 BIT2	DB	'Good',10,'Bit 3 - Chip ZXX - '
 BIT3	DB	'Good',10,'Bit 4 - Chip ZXX - '
 BIT4	DB	'Good',10,'Bit 5 - Chip ZXX - '
 BIT5	DB	'Good',10,'Bit 6 - Chip ZXX - '
 BIT6	DB	'Good',10,'Bit 7 - Chip ZXX - '
 BIT7	DB	'Good',3
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	CALL	UPCURSOR
 	JP	UPCURSOR
 INITBITS	LD	IY,BIT0
 	LD	IX,BIT1
 	CALL	PUTGOOD
 	LD	IY,BIT2
 	LD	IX,BIT3
 	CALL	PUTGOOD
 	LD	IY,BIT4
 	LD	IX,BIT5
 	CALL	PUTGOOD
 	LD	IY,BIT6
 	LD	IX,BIT7
 PUTGOOD	LD	(IX),'G'
 	LD	(IX+1),'o'
 	LD	(IX+2),'o'
 	LD	(IX+3),'d'
 	LD	(IY),'G'
 	LD	(IY+1),'o'
 	LD	(IY+2),'o'
 	LD	(IY+3),'d'
 	RET
 PUTBAD	LD	(IX),'B'
 	LD	(IX+1),'A'
 	LD	(IX+2),'D'
 	LD	(IX+3),'!'
 	RET
 GETBADBIT	LD	IX,BIT0
 	BIT	0,A
 	CALL	NZ,PUTBAD
 	LD	IX,BIT1
 	BIT	1,A
 	CALL	NZ,PUTBAD
 	LD	IX,BIT2
 	BIT	2,A
 	CALL	NZ,PUTBAD
 	BIT	3,A
 	LD	IX,BIT3
 	CALL	NZ,PUTBAD
 	LD	IX,BIT4
 	BIT	4,A
 	CALL	NZ,PUTBAD
 	LD	IX,BIT5
 	BIT	5,A
 	CALL	NZ,PUTBAD
 	LD	IX,BIT6
 	BIT	6,A
 	CALL	NZ,PUTBAD
 	LD	IX,BIT7
 	BIT	7,A
 	CALL	NZ,PUTBAD
 	RET
 TESKEY	RST	8
 	DB	7,'***  Keyboard Matrix Examination  ***',10,10,10
 	DB	'Address:   Bit  7  6  5  4  3  2  1  0',10
 	DB	'3801H',10,'3802H',10,'3804H',10,'3808H',10,'3810H',10,'3820H',10,'3840H',10,'387FH',10,'3880H',3
 TESTKEYLP	LD	IY,3C00H+256
 	LD	A,(3801H)
 	CALL	PUTBITS
 	LD	DE,40H
 	ADD	IY,DE
 	LD	A,(3802H)
 	CALL	PUTBITS
 	ADD	IY,DE
 	LD	A,(3804H)
 	CALL	PUTBITS
 	ADD	IY,DE
 	LD	A,(3808H)
 	CALL	PUTBITS
 	ADD	IY,DE
 	LD	A,(3810H)
 	CALL	PUTBITS
 	ADD	IY,DE
 	LD	A,(3820H)
 	CALL	PUTBITS
 	LD	A,(3840H)
 	ADD	IY,DE
 	CALL	PUTBITS
 	LD	A,(387FH)
 	ADD	IY,DE
 	CALL	PUTBITS
 	ADD	IY,DE
 	LD	A,(3880H)
 	CALL	PUTBITS
 	JP	TESTKEYLP
 PUTBITS	PUSH	IY
 	LD	BC,16
 	ADD	IY,BC
 	LD	BC,3
 	BIT	7,A
 	CALL	SHOB
 	BIT	6,A
 	CALL	SHOB
 	BIT	5,A
 	CALL	SHOB
 	BIT	4,A
 	CALL	SHOB
 	BIT	3,A
 	CALL	SHOB
 	BIT	2,A
 	CALL	SHOB
 	BIT	1,A
 	CALL	SHOB
 	BIT	0,A
 	CALL	SHOB
 	POP	IY
 	RET
 SHOB	JR	Z,PUT0
 	LD	(IY),'1'
 SHOBGO	ADD	IY,BC
 	RET
 PUT0	LD	(IY),'0'
 	JR	SHOBGO
 	END
ALL	SHOB
 	BIT	2,A
 	CALL	SHOB
 	BIT	1,A
 	CALL	SHOB
 	BIT	0,A
 	CALL	SHOB
 	POP	IY
 	RET
 SHOB	JR	Z,PUT0
 	LD	(IY),'1'
 SHOBGO	ADD	IY,BC
 	RET
 PUT0	LD	(IY),'0'
 ULTRADOSULTRADOSULTRAD