KEY/AS 	ORG	$
 ;KEY/ASM
 LSTKEY	DB	0		;last key mask
 KYBRD	DS	7
 KEYGONE	POP	BC		;return here to get regs.
 	POP	DE
 RKRT	POP	HL
 	OR	A		;return with flags set
 	RET
 KEY	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	HL,KEYGONE
 	PUSH	HL
 	LD	A,(KIFLAG)	;get flag byte
 	AND	2		;repeat on ?
 	LD	HL,LSTKEY	;last key mask
 	LD	A,(387FH)	;get new key bit
 	JR	Z,NORPT		;z = repeat off
 	CP	(HL)		;same as last key ?
 	LD	(HL),A		;save this key
 	JR	Z,BKEY		;between key delay
 	LD	A,20H		;first repeat delay
 	LD	(IDELY),A	;save counter
 	LD	A,5		;between key delay
 	LD	(RDELY),A	;save that too
 	JR	SKEY
 ZBACK	XOR	A		;zero
 	RET			;go back
 BKEY	LD	A,0		;get first time count
 IDELY	EQU	$-1
 	OR	A
 	JR	Z,RDELY
 	DEC	A
 	LD	(IDELY),A
 	JR	ZBACK
 	LD	A,0		;between key count
 RDELY	EQU	$-1
 	OR	A		;repeat time
 	JR	Z,GORPT		;do it
 	DEC	A
 	LD	(RDELY),A	;save count
 	JR	ZBACK		;return with nill
 GORPT	LD	A,5
 	LD	(RDELY),A
 	LD	HL,KYBRD
 	LD	DE,KYBRD+1
 	LD	BC,6
 	LD	(HL),0
 	LDIR
 	JR	SKEY
 NORPT	LD	(HL),A		;no repeat, save mask
 SKEY	LD	HL,KYBRD	;point to mask area
 	LD	BC,3801H	;keyboard row 1
 	LD	D,0		;row counter
 NEXROW	LD	A,(BC)		;get a byte from keyboard
 	LD	E,A		;save it
 	XOR	(HL)		;compare to last key
 	LD	(HL),E		;save new key
 	AND	E		;same as last ?
 	JR	NZ,HAVEIT	;have new key
 	INC	D		;bump row counter
 	INC	HL		;bump mask table
 	RLC	C		;bump keyboard pointer
 	JP	P,NEXROW	;test all but shift key
 	RET			;nothing
 HAVEIT	LD	HL,KIDONE	;get obvious route
 	PUSH	HL		;make a commom return add
 	LD	E,A		;save key here
 	LD	A,D		;get row
 	SLA	A
 	SLA	A
 	SLA	A
 	LD	D,A		;row * 8
 	LD	C,1		;column mask bit
 KI1	LD	A,C		;get bit
 	AND	E		;same as new key ?
 	JR	NZ,KI2		;nope
 	INC	D		;bump row * 8
 	SLA	C		;move test bit
 	JR	KI1		;keep going till column
 KI2	LD	A,(3880H)	;get shift key
 	OR	A		;flags
 	LD	B,0		;set all bits if pressed
 	JR	Z,KI2A		;continue if not
 	DEC	B		;make B -1
 KI2A	LD	A,(3840H)	;get last row
 	AND	0EFH		;check all but d arrow
 	JR	NZ,GETLROW
 	LD	A,40H		;make input ascii
 	ADD	A,D		;add to total
 	CP	60H		;test for @-Z
 	JR	C,KI3		;@-Z go
 	SUB	70H		;test for last row
 	JR	NC,KI5
 	ADD	A,40H		;make it numeric
 	CP	3CH		;test for: < = > ?
 	JR	C,KI6		;continue if not
 	RRC	B		;shift key ?
 	RET	C		;works opposite of
 	SUB	10H		;rest of keyboard
 	RET			;have the key
 KI6	RRC	B		;shift key ?
 	RET	NC		;don't adjust
 	SUB	10H		;shift numbers
 	CP	20H		;sh 0 ?
 	RET	NZ		;nope
 	LD	A,5		;control for sh 0
 	RET			;go now
 KI3	LD	D,A		;save input
 	LD	A,2		;get keyboard flag
 KIFLAG	EQU	$-1
 	RRCA			;lower case on ?
 	LD	A,D		;key back
 	JR	NC,KIDE		;don't adjust for shift
 	RRC	B		;get shift bit
 	JR	C,KIDE		;shift, keep upper case
 	ADD	A,20H		;otherwise make lower
 	RET			;have key
 KIDE	LD	A,(3840H)
 	AND	10H
 	LD	A,D
 	RET	Z
 	RRC	B
 	RET	NC
 	SUB	40H
 	RET
 GETLROW	LD	A,D		;get counter
 	AND	7
 KI5	RLCA			;double it for table
 	RRC	B		;get shift key
 	LD	C,A
 	JR	NC,SKKI		;no shift
 	INC	C		;adjust for shift entry
 SKKI	LD	B,0		;for table
 	LD	HL,KEYTBL	;point to table
 	ADD	HL,BC		;point to ascii char.
 	LD	A,(HL)		;get the byte
 	RET
 KIDONE	LD	BC,500H		;debounce delay
 	CALL	DELAY		;wait
 	CP	1
 	JP	Z,GOBACK
 	CP	2
 	JP	Z,MENU
 	CP	4
 	JP	Z,ADJGRP
 	CP	5
 	JP	Z,ULFLAG
 	CP	16H
 	JP	Z,VIDNO
 	CP	17H
 	JP	Z,VIDYES
 	CP	60H		;sh @
 	JR	Z,FLIPDUAL
 	CP	40H		;@
 	JR	Z,FLIPDUAL
 	CP	80H		;sh sp
 	JR	Z,RPONOFF
 	LD	HL,(KIFLAG)	;keyboard flag
 	RL	L
 	RET	NC		;no adjust
 	OR	80H
 	RET			;done
 FLIPDUAL	RRC	B	;check shift key
 	RET	NC
 	LD	A,(DUALFLAG)
 	XOR	80H
 	LD	(DUALFLAG),A
 	XOR	A
 	RET
 RPONOFF	LD	A,(KIFLAG)
 	XOR	2
 	JR	ADJCON
 ULFLAG	LD	A,(KIFLAG)	;get upper/lower flag
 	XOR	1		;reverse bit
 ADJCON	LD	(KIFLAG),A	;put it back
 	XOR	A		;zero for input char.
 	RET			;done
 ADJGRP	LD	A,(KIFLAG)	;get flag
 	XOR	80H
 	JR	ADJCON
 ;
 ;VID
 ;	entry	- none
 ;	exit	- Z flag set
 ;	reg.	- A HL DE BC
 ;	func.	- print screen to printer
 VIDNO	XOR	A
 	JR	VID
 VIDYES	LD	A,1
 VID	LD	(PRFLAG),A
 	LD	B,16		;16 VIDEO LINES
 	LD	HL,3C00H	;top of video
 VIDE1	LD	C,64		;char/line
 	PUSH	HL		;save begin of line
 	LD	A,L		;get lsb cursor
 	ADD	A,3FH		;point to end of line
 	LD	E,A		;give to DE
 	LD	D,H		;DE = HL + 3FH
 VIDE3	LD	A,(DE)		;get byte from end
 	CP	20H		;space ?
 	JR	NZ,VIDIT	;last char in line
 	DEC	DE		;less one
 	DEC	C		;less count
 	JR	NZ,VIDE3	;go more
 	LD	A,0AH		;linefeed
 	JR	$+4		;give to printer
 VDLIN	LD	A,0DH		;carriage return
 	CALL	POUT		;print it
 VIDNEX	POP	HL		;start of line
 	LD	DE,40H		;char/line
 	ADD	HL,DE		;next line
 	DJNZ	VIDE1		;for 16 lines
 	XOR	A		;no input
 	RET			;done
 VIDIT	INC	DE		;end + 1
 VIDIT1	LD	A,0		;get graphics test
 PRFLAG	EQU	$-1
 	OR	A
 	LD	A,(HL)		;get byte
 	JR	NZ,VID4		;don't adjust
 	BIT	7,A		;graphics ?
 	JR	Z,VID4		;skip adjust if not
 	LD	A,'.'		;otherwise, use period
 VID4	CP	20H		;control byte ?
 	JR	NC,VID5		;don't adjust if not
 	LD	A,'.'		;period for this too
 VID5	CALL	POUT		;send to printer
 	INC	HL		;bump video pointer
 	PUSH	HL		;save for test
 	OR	A		;clear carry flag
 	SBC	HL,DE		;test end of line
 	POP	HL		;restore pointer
 	JR	NZ,VIDIT1	;continue if not at end
 	JR	VDLIN		;output carriage return
 KEYTBL	DB	13		;enter
 	DB	14		;sh enter
 	DB	3		;clear
 	DB	4		;sh clear
 	DB	1		;break
 	DB	2		;sh break
 	DB	91		;u arrow
 	DB	27		;sh u arrow
 	DB	5CH		;d arrow
 	DB	26		;sh d arrow
 	DB	8		;l arrow
 	DB	24		;sh l arrow
 	DB	5EH		;r arrow
 	DB	5DH		;sh r arrow
 	DB	32		;space
 	DB	128		;sh space
 POUT	EX	AF,AF'
 	LD	A,(37E8H)
 	AND	0C0H
 	JR	Z,OKP
 	LD	A,(3840H)
 	AND	2
 	JR	Z,POUT+1
 	LD	(KYBRD+6),A
 	EX	AF,AF'
 	RET
 OKP	EX	AF,AF'
 	LD	(37E8H),A
 	RET
 	END
DB	128		;sh space
 POUT	EX	AF,AF'
 	LD	A,(37E8H)
 	AND	0C0H
 	JR	Z,OKP
 	LD	A,(3840H)
 	AND	2
 	JR	Z,POUT+1
 	LD	(KYBRD+6),A
 	EX	AF,AF'
 	RET
 OKP	EX	AF,RET	NC
 	CALL	IGET
 	RET	Z
 	PU