DISKIO 	ORG	$
 ;	DISKIO/ASM
 ;
 DELAY	DEC	C
 	JR	NZ,DELAY
 	DJNZ	DELAY
 	RET
 ;
 ;SELECT
 ;	entry	- (DRIV) = bit set for desired drive
 ;		- HL = 37ECH
 ;	exit	- Z = ok
 ;		- NZ = bad, error code in Accum.
 ;	reg.	- A
 ;	func.	- select a drive.  turn motor on.
 ;		- if motor on, return else wait
 ;		- for motor speed delay time
 SELECT	LD	A,(37ECH)	;read drive status
 	BIT	7,A		;on now ?
 	LD	A,(DRIV)	;get drive bit
 	LD	(37E1H),A	;select drive
 	RET	Z		;motor already on
 	OR	A		;clear carry
 	CALL	GETTYPE		;read drive type
 	AND	0C0H		;clear all other bits
 	PUSH	BC		;save load address
 	LD	B,A		;for delay loop
 	CALL	DELAY		;wait
 	POP	BC		;restore load addr
 	LD	A,(37ECH)	;check status now
 	BIT	7,A		;ok ?
 	LD	A,1		;"NOT READY" message
 	RET			;z=ok nz=error
 ;
 ;MOVE
 ;	entry	- A = type 1 command (seek/step/restore)
 ;			speed byte automatically set
 ;		 HL = 37ECH
 ;		(37EDH) = where head is now
 ;	exit	- Z = ok
 ;		 NZ = bad, A = error code.
 ;		 Current track table is updated
 ;	reg.	- A
 ;	func.	- Issue a head move command to FDC
 MMOVE	LD	(SETMOVE),A	;save operation type
 	CALL	SELECT		;turn drive on
 	RET	NZ		;drive not ready
 	OR	A		;clear carry for table
 	CALL	GETTYPE		;get drive type byte
 	AND	3		;low 2 bits only
 	OR	18H		;have command
 SETMOVE	EQU	$-1		;point to or byte
 	LD	(HL),A		;hl=37ECH
 MOVEST	CALL	SELECT		;motor on for long seek
 	RET	NZ		;dropped ready if nz
 	LD	A,(HL)		;GET STATUS
 	BIT	0,A		;COMMAND DONE ?
 	JR	NZ,MOVEST	;wait if not done
 	AND	81H		;check status
 	JP	NZ,SKERR	;decode seek error
 	SCF			;set carry for tables
 	LD	A,(37EDH)	;get where head is now
 	CALL	GETTRK		;put byte in table
 	XOR	A		;zero for success
 	RET			;done
 ;
 ;RESTORE
 ;	entry	- HL = 37ECH
 ;	exit	- Z = ok
 ;		 NZ = bad, error code in Accum.
 ;	reg.	- A
 ;	func.	- Move head to track 0 on drive
 RESTORE	LD	A,0		;restore command
 	CALL	MMOVE		;move the head
 	LD	A,(HL)		;head over track 0 ?
 	CPL			;reverse bits
 	BIT	2,A		;check it now
 	LD	A,2		;drive not in system err.
 	RET			;done
 ;
 ;SEEK
 ;	entry	- D = Track to seek
 ;		HL = 37ECH
 ;	exit	- Z = ok
 ;		NZ = bad, error code in accum
 ;	reg.	- A
 ;	func.	- move drive head to desired track
 SEEK	OR	A		;clear carry flag
 	CALL	GETTRK		;get current drive track
 	LD	(37EDH),A	;give to FDC track reg.
 	JR	NZ,SEEKCNT	;not track 0
 	CALL	RESTORE		;if track 0, do restore
 	RET	NZ		;nz=bad
 SEEKCNT	LD	(37EEH),DE	;give to FDC sector reg.
 	LD	A,(37EDH)	;where is the head ?
 	CP	D		;same one we want ?
 	RET	Z		;return if yes
 	LD	A,18H		;seek command
 	JR	MMOVE		;move the head
 ;
 ;DSKSLO
 ;	entry	- NONE
 ;	exit	- 8 ms. delay
 ;	reg.	- NONE
 ;	func.	- wait 8 ms. for Disk Controller status
 ;			to become valid
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 ;
 ;XFER
 ;	entry	- (TYPE) is valid read/write command
 ;		- (WAY) is valid read/write direction
 ;		HL = 37ECH
 ;		BC = load/save address for/of data
 ;		if sector operation, (37EEH) = Sector #
 ;			which is set from SEEK
 ;	exit	- Accum. = result of operation
 ;		 FDC is force interrupted
 ;		- BC = last byte in buffer +1 if good
 ;			else BC = invalid
 ;	reg.	- A
 ;	func.	- perform data transfer for read/write
 XFER	CALL	SELECT		;motor on
 	RET	NZ		;not available
 	DI			;cannot interrupt
 	LD	(HL),88H	;issue command
 TYPE	EQU	$-1		;point to command
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;transfer address
 	CALL	DSKSLO		;wait 8 ms.
 	JR	XFER2
 WAY	LD	A,(DE)
 	LD	(BC),A
 	INC	BC
 XFER2	BIT	1,(HL)
 	JR	NZ,WAY
 	BIT	1,(HL)
 	JR	NZ,WAY
 	BIT	1,(HL)
 	JR	NZ,WAY
 	BIT	0,(HL)
 	JR	NZ,XFER2
 	LD	A,(HL)		;get transfer result
 	LD	(RESULT),A	;save I/O result
 	LD	(HL),0D0H	;force interrupt
 	POP	DE		;restore track/sector
 	EI			;can enable now
 	RET			;done, z flag set
 ;
 ;READ
 ;	entry	- DE = Track/Sector to read
 ;		- BC = load address
 ;	exit	- Z = ok
 ;		NZ = bad, error code in Accum.
 ;	reg.	- A, HL
 ;	func.	- read a single disk sector
 READ	LD	A,88H		;fdc read command
 	LD	HL,021AH	;for (way)
 	JP	IOCOMM		;go common
 ;
 ;DREAD
 ;	entry	- Same as READ except that read is
 ;			expected to be directory
 DREAD	LD	A,E		;get sector
 	LD	(SECSAVE),A	;save sector
 	LD	A,5		;tries b4 dir error
 DICOUNT	EQU	$-1		;initial count B4 error
 	LD	(DCOUNT),A	;save count
 	OR	A		;clear carry
 	CALL	GETDIR		;get directory track
 	LD	D,A		;give to d reg.
 DIRAGN	LD	HL,ERSPCL	;for directory DAM
 	RES	5,(HL)		;so dir. read not error
 	PUSH	HL		;save pointer
 	CALL	READ		;read the sector
 	POP	HL		;restore pointer
 	SET	5,(HL)		;reset error mask
 	LD	(DIRERR),A	;read error code
 	JR	NZ,DRDERR	;go read error
 	LD	A,0		;result of I/O
 RESULT	EQU	$-1		;point to A load
 	CPL			;reverse the bits
 	BIT	5,A		;directory ?
 	RET	Z		;yes if bit was set
 	LD	A,0		;error counter
 DCOUNT	EQU	$-1		;point to load byte
 	DEC	A		;less 1
 	LD	(DCOUNT),A	;put it back
 	JR	NZ,FINDDIR	;find it if not done
 	LD	A,3		;cannot find directory
 	LD	(DIRERR),A	;save in code
 DRDERR	LD	A,4		;directory read error
 	CALL	ERROR		;display it
 	LD	A,0		;get error code back
 DIRERR	EQU	$-1		;directory error code
 	OR	A		;set nz flag
 	RET			;return in error
 FINDDIR	LD	DE,0		;read the boot
 	CALL	READ		;read it
 	RET	NZ		;can't read it
 	LD	HL,(TRYMORE)	;point to buffer
 	LD	A,(HL)		;get the byte
 	OR	A		;must be 0
 	JR	NZ,NOTBOOT	;else not a boot
 	INC	HL
 	LD	A,(HL)
 	CP	0FEH		;2nd byte must be 0FEH
 	JR	NZ,NOTBOOT
 	INC	HL
 	LD	A,(HL)		;this is the directory
 	OR	A		;check for directory
 	JR	NZ,NOTBOOT+2	;have the track
 NOTBOOT	LD	A,17		;default directory track
 	LD	D,A		;give it to D reg.
 	SCF			;carry for table in
 	CALL	GETDIR		;save directory track
 	LD	E,0		;restore sector
 SECSAVE	EQU	$-1		;point to load A
 	JR	DIRAGN		;try again
 ;
 ;WRITE
 ;	entry	- Same as READ, except writing to disk
 ;
 ;DWRITE
 ;	entry	- Same as WRITE, except to directory
 DWRITE	LD	A,0A9H		;directory write
 	CALL	WRITE+2		;write it out
 	RET	Z		;return
 	PUSH	AF		;save error code
 	LD	A,5		;directory write error
 	CALL	ERROR		;display it
 	POP	AF		;restore error code
 	RET			;return in error
 WRITE	LD	A,0A8H		;data write
 	PUSH	AF		;save on stack
 	LD	HL,37ECH	;point to FDC
 	CALL	SELECT		;turn on drive
 	LD	A,(HL)		;get result
 	POP	HL		;fix stack
 	BIT	6,A		;write protected ?
 	JP	NZ,RWERR	;decode error
 	LD	A,H		;get command back
 	LD	HL,120AH	;for (way)
 IOCOMM	LD	(WAY),HL	;transfer direction
 	LD	HL,37ECH	;must point to FDC
 	CALL	SETRDWT		;set density/side
 	LD	(TYPE),A	;put into TRANSFER
 	CALL	SEEK		;move head to track
 	RET	NZ		;not good
 	LD	A,5		;initialize tries B4 err
 ICOUNT	EQU	$-1		;initial count
 	LD	(COUN),A	;put it here
 	LD	(TRYMORE),BC	;save load address
 ; if read/write is successfull, BC => last byte in buffer
 ;	+1, else BC = first load address
 	LD	BC,0		;buffer address
 TRYMORE	EQU	$-2		;point to address
 	CALL	XFER		;transfer data
 	RET	NZ		;not good already
 	AND	0FCH		;check status
 ERSPCL	EQU	$-1		;for directory read/write
 	RET	Z		;done ok
 	LD	A,5
 COUN	EQU	$-1
 	DEC	A
 	LD	(COUN),A
 	JR	NZ,TRYMORE-1	;try again ?
 	LD	BC,(TRYMORE)	;reset load address
 	JR	RWERR
 ;
 ;RWERR
 ;	entry	- A = status from disk I/O
 ;	exit	- A = error code
 ;		NZ flag set
 ;	reg.	- A A'
 ;	func.	- Compute error code from disk I/O
 ;		(type)=88H if read else write
 RWERR	LD	HL,WRTBL	;write error table
 	LD	(WTBL),HL
 	LD	HL,RDTBL
 	LD	(RTBL),HL	;save pointer
 	JR	GOERR		;continue
 SKERR	LD	HL,WSKTBL	;write seek table
 	LD	(WTBL),HL
 	LD	HL,RSKTBL	;read seek table
 	LD	(RTBL),HL
 GOERR	EX	AF,AF'		;af' = STATUS
 	LD	A,(TYPE)	;check for read/write
 	CP	88H		;read ?
 	LD	HL,0		;read error table
 RTBL	EQU	$-2
 	JR	NZ,$+5		;skip if read
 	LD	HL,0		;write error table
 WTBL	EQU	$-2
 	PUSH	BC		;save load address
 	LD	B,6		;go for 6 bits
 	EX	AF,AF'		;get error condition back
 ERLOPP	RLCA			;check a bit
 	JR	C,ERRHAVE	;have an error if bit set
 	INC	HL		;bump table
 	DJNZ	ERLOPP		;go for 6 bits
 	LD	A,6		;programmer error
 	DB	2		;ld b,N opcode
 ERRHAVE	LD	A,(HL)		;get table byte
 	POP	BC		;restore load address
 	OR	A		;set nz flag
 	RET			;done
 ;
 ;WRTBL and RDTBL are 6 byte tables of error codes
 ;	for corresponding status bits 7-2
 ;WSKTBL and RSKTBL are read/write seek errors
 WRTBL	DB	1		;drive not ready
 	DB	7		;write protected
 	DB	8		;disk drive write fault
 	DB	9		;data record not found
 	DB	10		;parity error
 	DB	11		;lost data during write
 RDTBL	DB	1		;drive not ready
 	DB	12		;illegal DAM
 	DB	13		;read protected
 	DB	14		;data record not found
 	DB	15		;parity error
 	DB	16		;lost data during read
 WSKTBL	DB	1		;not ready
 	DB	6		;programmer error
 	DB	6		;programmer error
 	DB	17		;seek error during write
 	DB	18		;header read parity error
 	DB	6		;programmer error
 RSKTBL	DB	1		;not ready
 	DB	6		;programmer
 	DB	6		;programmer
 	DB	19		;seek error during read
 	DB	20		;header write parity bad
 	DB	6		;programmer
 GETTRK	PUSH	HL		;must save
 	LD	HL,CTRACK	;current track table
 	JR	GETCOMM		;go common
 GETDIR	PUSH	HL
 	LD	HL,DTRACK	;directory track table
 	JR	GETCOMM
 GETTKS	PUSH	HL
 	LD	HL,TRACKS	;track count table
 	JR	GETCOMM
 GETTYPE	PUSH	HL
 	LD	HL,DTYPE	;drive type table
 GETCOMM	PUSH	AF
 	LD	A,(DRIVE)	;binary drive
 	ADD	A,L		;point to table byte
 	LD	L,A
 	POP	AF		;restore c flag/byte
 	JR	C,PUTIN		;c=put in table
 	LD	A,(HL)		;nc = read table
 PUTIN	LD	(HL),A		;common exit
 	POP	HL		;restore hl
 	OR	A		;set flags
 	RET			;done
 ;
 ;SETRDWT
 ;	entry	- A = read/write command
 ;	exit	- A = adjusted read write command
 ;	reg.	- A A'
 ;	func.	- get byte from drive type table
 ;		- select either single/double side bit
 ;		- select single/double density
 SETRDWT	PUSH	BC		;save for use as mask
 	PUSH	AF		;save current command
 	OR	A		;clear carry
 	CALL	GETTYPE		;get drive type
 	PUSH	AF		;save for later use
 	BIT	4,A		;set if double density
 	LD	A,0FFH		;start with single dens.
 	JR	Z,$+3		;z=single density
 	DEC	A		;else make it double
 	EX	AF,AF'		;save it
 	LD	A,(37EDH)	;read track register
 	EX	AF,AF'		;get single/double back
 	LD	(37ECH),A	;select the chip
 	LD	A,0D0H		;must force interrupt
 	LD	(37ECH),A	;FDC
 	EX	AF,AF'		;get track back
 	LD	(37EDH),A	;give to track register
 	LD	B,0		;mask byte
 	POP	AF		;get drive type back
 	POP	BC		;restore bc
 	RET			;A = adjusted command
 	END
 force interrupt
 	LD	(37ECH),A	;FDC
 	EX	AF,AF'		;get track back
 	Lk
 	RRCA			;odd number ?
 	LD	D,A		;D = Track/2
 	JR	NC,SELFINI	;finished if even track
 	SET	2,B		;set compare to side 1
 SELFINI	POP	AF		;get st