DISK/A 	ORG	$
 ; disk/asm
 DISK	DI
 	LD	SP,STACK
 	LD	A,1
 	LD	(WHERE),A
 	RST	8
 	DB	7,'***  Disk Test  ***',10,10
 	DB	'1.  Configure Drives',10
 	DB	'2.  Move all Drives to Inner Track',10
 	DB	'3.  Move all Drives to Outer Track',10
 	DB	'4.  Seek a Track',10
 	DB	'5.  Read a Sector',10
 	DB	'6.  Write a Sector',10
 	DB	'7.  Continuous Head Motion',10
 	DB	'8.  Continuous Read/Write',10
 	DB	'9.  Check Drive Status',10
 	DB	'Selection ? ',3
 	LD	B,1
 	RST	10H
 	JP	Z,DISK
 	SUB	30H
 	JP	C,DISK
 	JP	Z,DISK
 	CP	10
 	JP	NC,DISK
 	EI
 	CALL	GOTABLE
 	DW	CONFIG,MOVEIN,MOVEOUT,DOSEEK,DOREAD
 	DW	DOWRITE,CONTMOVE,CONTRDWRT,CHECKSTAT
 CONFIG	XOR	A
 	LD	(DRIVE),A
 	INC	A
 	LD	(DRIV),A
 CONFLP	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(CONDRV),A
 	RST	8
 	DB	'Enter parameters for Drive '
 CONDRV	DB	'0.',13
 	OR	A		;clear carry flag
 	CALL	GETTKS		;get current track count
 	CALL	ASCII		;convert to decimal ascii
 	LD	(GTRK),A
 	LD	(GTRK+1),BC
 GTK	RST	8
 	DB	'Track count now at '
 GTRK	DB	'000, new count ? ',3
 	LD	B,3
 	RST	10H
 	JR	Z,GSPD
 	CALL	VALUE
 	JR	C,GTK
 	JR	NZ,GTK
 	SCF			;carry = put in table
 	CALL	GETTKS		;put it there
 GSPD	OR	A		;clear carry flag
 	CALL	GETTYPE		;get drive type
 	AND	3		;mask off upper 5 bits
 	ADD	A,30H		;make it ascii
 	LD	(GSPED),A
 GSPEED	RST	8
 	DB	'Current step speed = '
 GSPED	DB	'0.  New step speed ? ',3
 	LD	B,1
 	RST	10H
 	JR	Z,GETWAIT
 	SUB	30H
 	JR	C,GSPEED
 	CP	4
 	JR	NC,GSPEED
 	LD	B,A		;save it here
 	OR	A
 	CALL	GETTYPE
 	AND	0FCH		;remove low 2 bits
 	OR	B		;set new speed
 	SCF
 	CALL	GETTYPE		;put in table
 GETWAIT	OR	A
 	CALL	GETTYPE
 	AND	0C0H		;mask off low 6 bits
 	SRL	A
 	SRL	A		;move to low 2 bits
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	OR	A		;0 ?
 	JR	NZ,GETWGO
 	LD	A,4
 GETWGO	ADD	A,30H		;make it ascii
 	LD	(WDELY),A
 GWT	RST	8
 	DB	'Motor on delay = '
 WDELY	DB	'0 quarter seconds.  New delay ? ',3
 	LD	B,1
 	RST	10H
 	JR	Z,CONDEN
 	SUB	30H
 	JR	C,GWT
 	JR	Z,GWT
 	CP	5
 	JR	NC,GWT
 	CP	4
 	JR	NZ,TWG
 	XOR	A
 TWG	SLA	A
 	SLA	A
 	SLA	A
 	SLA	A
 	SLA	A
 	SLA	A
 	LD	B,A
 	OR	A
 	CALL	GETTYPE
 	AND	3FH
 	OR	B
 	SCF
 	CALL	GETTYPE
 CONDEN	OR	A
 	CALL	GETTYPE
 	BIT	4,A		;check density
 	LD	HL,SNG		;single message
 	JR	Z,HADV
 	LD	HL,DBL
 HADV	LD	DE,DENMSG
 	LD	BC,6
 	LDIR
 GETDNS	RST	8
 	DB	'Current density = '
 DENMSG	DB	'Single.  New density ? ',3
 	LD	B,6
 	RST	10H
 	JP	Z,CONNEXT
 	AND	5FH		;remove lower case
 	CP	'S'		;single ?
 	LD	B,0		;mask bit
 	JR	Z,GOTDEN
 	CP	'D'		;double ?
 	LD	B,10H		;mask bit
 	JP	NZ,GETDNS
 GOTDEN	OR	A
 	CALL	GETTYPE
 	AND	0EFH
 	OR	B
 	SCF
 	CALL	GETTYPE
 CONNEXT	LD	A,(DRIV)
 	SLA	A
 	LD	(DRIV),A
 	LD	A,(DRIVE)
 	INC	A
 	LD	(DRIVE),A
 	CP	4
 	JP	NC,DISK
 	JP	CONFLP
 SNG	DB	'Single'
 DBL	DB	'Double'
 MOVEIN	LD	HL,37ECH
 	XOR	A
 	LD	(DRIVE),A
 	INC	A
 	LD	(DRIV),A
 MOVINLP	OR	A
 	CALL	GETTKS
 	DEC	A
 	LD	D,A
 	LD	E,0
 	CALL	SEEK
 	LD	A,(DRIVE)
 	INC	A
 	LD	(DRIVE),A
 	CP	4
 	JP	NC,DISK
 	LD	A,(DRIV)
 	SLA	A
 	LD	(DRIV),A
 	JR	MOVINLP
 MOVEOUT	LD	HL,37ECH
 	XOR	A
 	LD	(DRIVE),A
 	INC	A
 	LD	(DRIV),A
 MOVOUTLP	LD	DE,0
 	CALL	SEEK
 	LD	A,(DRIVE)
 	INC	A
 	LD	(DRIVE),A
 	CP	4
 	JP	NC,DISK
 	LD	A,(DRIV)
 	SLA	A
 	LD	(DRIV),A
 	JR	MOVOUTLP
 CONTMOVE	XOR	A
 	LD	(DRIVE),A
 	INC	A
 	LD	(DRIV),A
 	LD	HL,37ECH
 CNTMVLP	CALL	RESTORE
 	LD	A,(DRIVE)
 	INC	A
 	LD	(DRIVE),A
 	CP	4
 	JR	NC,CTNMVLP
 	LD	A,(DRIV)
 	SLA	A
 	LD	(DRIV),A
 	JR	CNTMVLP
 CTNMVLP	XOR	A
 	LD	(DRIVE),A
 	INC	A
 	LD	(DRIV),A
 CXMNLP	OR	A
 	CALL	GETTKS
 	DEC	A
 	LD	D,A
 	LD	E,0
 	CALL	SEEK
 	LD	A,(DRIVE)
 	INC	A
 	LD	(DRIVE),A
 	CP	4
 	JR	NC,CONTMOVE
 	LD	A,(DRIV)
 	SLA	A
 	LD	(DRIV),A
 	JR	CXMNLP
 CHECKSTAT	XOR	A
 	LD	(DRIVE),A
 	INC	A
 	LD	(DRIV),A
 	LD	HL,DISK
 	PUSH	HL
 	LD	HL,37ECH
 CKST	CALL	STAT
 	LD	A,(DRIVE)
 	INC	A
 	LD	(DRIVE),A
 	CP	4
 	JP	NC,PRESS
 	LD	A,(DRIV)
 	SLA	A
 	LD	(DRIV),A
 	JR	CKST
 	END
A
 	LD	(DRIV),A
 	LD	HL,DISK
 	PUSH	HL
 	LD	HL,37ECH
 CKST	CALL	STAT
