; suboot3/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
$DIF3	EQU	4300H-$		;offset to actual load
$SECL3	EQU	01		;lowest sector on track
$SECH3	EQU	18		;highest sector
;
;	boot entry point 4300H
;
BOOT3	CP	0		;dir byte #2
;
	LD	DE,0002H	;track 0, sector 2
	LD	L,-1		;set buffer as empty
	EXX			;save in alt set
;
@3DLOOP	CALL	@3DGETB+$DIF3	;fetch a byte
;
;	begin of load block, check which type
;
	DEC	A		;01 header?
	JR	Z,@3DLOAD	;load it!
	DEC	A		;02 header?
	JR	Z,@3DSTRT	;done!
	CP	1EH		;valid remark? (0-1FH)
	JR	NC,@3DSER	;data error!
;
;	remark block, remove and re-loop
;
	CALL	@3DGETB+$DIF3	;fetch a byte
	LD	B,A		;B = block length
;
@3DLOP2	CALL	@3DGETB+$DIF3	;fetch a remark byte
	DJNZ	@3DLOP2		;finish it off
	JR	@3DLOOP		;go next loop
;
;	entry point marker, fetch address and go!
;
@3DSTRT	CALL	@3DGETL+$DIF3	;fetch load address
	JP	(HL)		;go program!
;
;	load block marker, get address and load it!
;
@3DLOAD	CALL	@3DGETL+$DIF3	;get block address
;
@3DLOP3	CALL	@3DGETB+$DIF3	;fetch block length
	LD	(HL),A		;to buffer
	CP	(HL)		;memory there for it?
	JR	NZ,@3DMER	;memory error
	INC	HL		;bump buffer
	DJNZ	@3DLOP3		;finish off the block
	JR	@3DLOOP		;go next block
;
;	fetch 2 byte address from file
;
@3DGETL	CALL	@3DGETB+$DIF3	;fetch length byte
	SUB	2		;adjust to actual
	LD	B,A		;B = data length
	CALL	@3DGETB+$DIF3	;fetch LSB address
	LD	L,A		;pass it
	CALL	@3DGETB+$DIF3	;fetch MSB address
	LD	H,A		;pass it
	RET			;HL = address
;
;	error vectors
;
;	memory error (attempt to load non-existing mem)
;
@3DMER	LD	HL,@3DREM+$DIF3	;memory error text
	JR	@3DERR		;go common
;
;	invalid data (file format error)
;
@3DSER	LD	HL,@3DRES+$DIF3	;data error text
	JR	@3DERR		;go common
;
;	disk I/O error
;
@3DDER	LD	HL,@3DRED+$DIF3	;disk error text
;
@3DERR	CALL	021BH		;display message
	LD	HL,@3DRRE+$DIF3	;'error'
	CALL	021BH		;display also
;
;	wait for a key then re-boot
;
	CALL	0040H		;wait for ENTER key
	RST	00H		;re-boot Mod III
;
;	fetch byte from file
;
@3DGETB	EXX			;get disk set back
	INC	L		;bump LSB buff pointer
	JR	NZ,@3DHAVB	;go if in buffer
;
;	read another sector
;
	LD	BC,4D00H	;I/O buffer to use
	CALL	@3DRD+$DIF3	;read the sector
	JR	NZ,@3DDER	;disk error!
	LD	A,E		;get sector
	INC	E		;bump sector
	SUB	$SECH3		;highest sector/track
	JR	NZ,@3DHAVB	;go, not at track end
	LD	E,$SECL3	;lowest sector/track
	INC	D		;bump track
;
;	byte in buffer => by HL
;
@3DHAVB	LD	A,(HL)		;fetch byte
	EXX			;store registers again
	RET			;done, A = byte
;
;	message text for errors
;
@3DREM	DEFM	'Memory',03
@3DRES	DEFM	'Data',03
@3DRED	DEFM	'Disk',03
@3DRRE	DEFM	' Error',03
;
;	short delay for FDC to load valid status byte
;
@3DSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	sector read: DE = track/sector, BC = buff address
;
;	actual sector I/O - double density Mod III
;
@3DRD	LD	A,5		;5 retries
;
@3DRD1	EX	AF,AF'		;save retry counter
	PUSH	BC		;save load buffer
	CALL	@3DRD0+$DIF3	;read sector
	POP	HL		;HL => buffer
	RET	Z		;no error, return
	EX	AF,AF'		;get counter back
	DEC	A		;less this try
	JR	NZ,@3DRD1	;go if more
	EX	AF,AF'		;restore error
	RET			;return NZ
;
@3DRD0	LD	A,81H		;select drive 0
	OUT	(0F4H),A	;selected
;
	LD	A,D		;get track
	OUT	(0F3H),A	;to FDC
	LD	A,E		;get sector
	OUT	(0F2H),A	;to FDC
	LD	H,B		;pass buffer to HL
	LD	L,C		;HL => I/O buffer
	LD	C,0F0H		;FDC command port
	LD	A,1BH		;seek command
	OUT	(C),A		;issue command
	CALL	@3DSLO+$DIF3	;wait for valid status
;
@3DSK	IN	A,(C)		;fetch status
	RRCA			;command done?
	JR	C,@3DSK		;wait for head if yes
;
	LD	A,0C3H		;JP opcode
	LD	(4049H),A	;save for NMI
	LD	DE,@3DNMIR+$DIF3 ;NMI disk return vector
	LD	(404AH),DE	;save it
	LD	A,0C0H		;allow interrupt
	OUT	(0E4H),A	;NMI ON!
;
	LD	A,80H		;read command
	OUT	(C),A		;issue it
	CALL	@3DSLO+$DIF3	;wait for valid status
;
@3DRD2	IN	A,(C)		;get status
	AND	2		;bit 1 (byte available)?
	JR	Z,@3DRD2	;wait for it
	LD	C,0F3H		;transfer address
	INI			;fetch the byte
;
	LD	A,0C1H		;get 'wait' state command
@3DRD3	OUT	(0F4H),A	;go to wait state
	INI			;read a byte
	JR	@3DRD3		;wait for interrupt
;
;	NMI return vector
;
@3DNMIR	POP	HL		;remove int vector
	LD	HL,@3DRNMI+$DIF3 ;non-disk vector
	XOR	A		;load zero
	OUT	(0E4H),A	;turn off interrupts
	LD	(404AH),HL	;save new vector
	IN	A,(C)		;read status
	AND	9FH		;set flags on operation
	RET	Z		;return with no error
;
	LD	A,0D0H		;interrupt controller
	OUT	(C),A		;send to port
	RET			;return!
;
@3DRNMI	RETN			;non-disk NMI vector
;
BOOT3L	EQU	$-BOOT3		;length of module
;
