; subacka/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/16/83 - kjw
;
	PAGE
;
;	$SCOPY - standard disk backup
;
SCOPY	LD	A,2		;init format type
	LD	(FMTYPE),A	;save into flag
	XOR	A		;set start track to 0
	LD	(STRTRK),A	;save starting track #
;
;	fetch source information
;
	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Source'
	DEFB	ETX
;
	CALL	ONEDRIV		;fetch drive number
	LD	A,(DRIV)	;get the drive
	LD	(SDRIVE),A	;save it
;
;	get destination info
;
	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Destination'
	DEFB	ETX
;
	CALL	GETDRVS		;get which drives
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	XOR	A		;save starting drive
	LD	(POSA),A	;start position
	DEC	A		;set mount flag
	LD	(MFLAG),A	;init flag
;
;	check if source drive = any dest drive
;
	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;fetch DCT into IY
	BIT	5,(IY+5)	;selected as dest drive?
	JR	Z,ASKFMT	;nope, go!
	XOR	A		;set mount flag active
	LD	(MFLAG),A	;save it
;
ASKFMT	RST	@08		;prompt for format
;
	DEFB	EOL
	DEFM	'Format Drives? '
	DEFB	ETX
;
	XOR	A		;set TRUE flag
	LD	(SKVER),A	;enable verify
	LD	(HASFLAG),A	;enable prompt if format
	INC	A		;set non-zero
	LD	(IFBFMT),A	;enable format prompt
	LD	B,1		;1 key input
	RST	@10		;get from keyboard
	CALL	POSHL		;find a char
	JR	Z,SOLOOP	;go if nil input
;
AKBAK	CALL	POSHL		;move to next field
	JR	Z,ANOBAK	;go if done
	CALL	UCASE		;convert first char
	CP	'*'		;skip verify?
	JR	Z,VERSKP	;yes, go!
	CP	'!'		;overwrite on format?
	JR	Z,BAKFMTS	;yes, go!
	CP	'Y'		;format?
	JR	Z,BAKFMT0	;yes, go!
	CP	'N'		;no format?
	JR	Z,BAKFMT1	;yes, go!
	JR	ASKFMT		;else invalid, ask again
;
;	skip verify on backup
;
VERSKP	LD	A,1		;set flag
	LD	(SKVER),A	;save flag
;
BAKVGO	INC	HL		;bump input pointer
	JR	AKBAK		;check for more input
;
BAKFMTS	LD	A,-1		;format over data
	LD	(HASFLAG),A	;save flag
;
BAKFMT0	LD	A,1		;disable format
	LD	(IFBFMT),A	;save flag
	JR	BAKVGO		;check next field
;
BAKFMT1	XOR	A		;enable flag
	JR	BAKFMT0+2	;set flag & continue
;
;	copy completed, do another backup
;
ANOBAK	LD	A,0		;fetch flag
IFBFMT	EQU	$-1
	DEC	A		;format dest disks?
	JR	NZ,SCPYBAK	;no, continue past!
;
;	copy disk outer loop
;
SOLOOP	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Mount DESTINATION diskettes:'
	DEFB	ETX
;
	CALL	ONEKEY		;wait for single key
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	DE,SCOPYO	;formatter subroutine
	LD	BC,SCPYBAK	;return here after format
	JP	DRVCOMM		;do all dest drives
;
SCOPYO	CALL	DSTAT		;is drive ready?
	JP	NZ,REMDRIV	;nope, remove from que
	CALL	RESTORE		;move head to track 0
	JP	NZ,REMDRIV	;not there, remove it
	LD	A,(IY+6)	;get system flags
	PUSH	AF		;save on stack
	CALL	FORMIT		;format the disk!
	POP	AF		;restore
	LD	(IY+6),A	;reset relative
	RET			;done!
;
SCPYBAK	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;setup for I/O
	CALL	CNTOTAL		;compute total sectors
	LD	(TEMP2),HL	;save sector count
;
	LD	D,0		;set track 0
	CALL	FIRSTS		;load E with first sector
	LD	(TEMP0),DE	;save starting position
;
	CALL	INITBD1		;enable error monitor
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
;	check to see if any dest drives are active
;
SCOPYLP	LD	BC,(DRIVES)	;C = # drives
	LD	B,C		;pass # to B
	LD	C,0		;C = counter
;
SCOPYCK	LD	A,C		;get drive #
	CALL	SETDRV		;locate DCT
	BIT	5,(IY+5)	;active drive?
	JR	NZ,SCOPYK0	;yes, go!
	INC	C		;bump drive #
	DJNZ	SCOPYCK		;check all 8 drives
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'No Destination Drives'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
;	enable/disable mount prompt
;
SCOPYK0	LD	A,(SDRIVE)	;get source drive
	PUSH	AF		;save drive #
	CALL	SETDRV		;fetch DCT
	POP	AF		;get drive back
	BIT	5,(IY+5)	;drive on?
	JR	NZ,MSTMNT	;yes, go!
	INC	A		;else set non-source driv
;
MSTMNT	LD	(DDRIVE),A	;setup for prompts
;
;	setup params for current loop
;
	LD	DE,(TEMP0)	;get start track/sector
	LD	(TEMP1),DE	;save for write
	LD	HL,(TEMP2)	;get # sectors remaining
	LD	BC,BUFFER	;start of I/O buffer
	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;setup for I/O
	CALL	DRVSAME		;source & dest same?
	CALL	Z,SMOUNT	;yes, prompt for mounts
;
;	read a buffer full
;
	PUSH	HL		;save remain count
	CALL	MREAD		;read as many as possible
	LD	(TEMP2),HL	;save remaining count
	LD	(TEMP0),DE	;save next track/sector
	LD	B,H		;pass remaining to BC
	LD	C,L		;BC = # sectors left
	POP	HL		;HL = total number start
	OR	A		;clear carry flag
	SBC	HL,BC		;HL = # sectors just read
	LD	(TEMP3),HL	;save for each drive loop
	LD	DE,CPLP1	;subroutine vector
	LD	BC,CPLP2	;return vector after copy
	JP	DRVCOMM		;do all dest drives
;
CPLP1	LD	A,(DRIV)	;get current drive
	LD	(DDRIVE),A	;save into dest drive
	CALL	DRVSAME		;source & dest same?
	CALL	Z,DMOUNT	;yes, mount dest disk
;
	LD	HL,(TEMP3)	;get # sectors to write
	LD	DE,(TEMP1)	;get start track/sector
	LD	BC,BUFFER	;start of data buffer
	CALL	DSTAT		;check if drive is ready
	JR	NZ,REMDRIV	;nope, remove from que
;
	CALL	MWRITE		;write buffer to dest
	JR	CPYVER		;verify!
;
;	drive found faulty, remove drive from que
;
REMDRIV	RES	5,(IY+5)	;remove drive
	RET			;done!
;
;	dest disks to be verified?
;
CPYVER	LD	A,0		;get flag
SKVER	EQU	$-1
	DEC	A		;verify on?
	RET	Z		;nope, skip it!
;
	LD	HL,(TEMP3)	;get # sectors to verify
	LD	DE,(TEMP1)	;get start track/sector
	LD	BC,BUFFER	;start of data
	LD	(TEMP9),BC	;save buffer pointer
;
CPYVER1	PUSH	HL		;save # sectors to go
	LD	BC,DAMBUFF	;read sector here
	CALL	SHOVERF		;verify the sectors
;
	LD	HL,(TEMP9)	;get buff pointer
	PUSH	DE		;save track/sector
	LD	DE,DAMBUFF	;verify data here
	LD	B,0		;256 bytes to compare
	CALL	COMPARE		;same?
	CALL	NZ,NOGOODV	;nope, show as bad!
;
	LD	HL,(TEMP9)	;get buff pointer
	INC	H		;bump by 256 bytes
	LD	(TEMP9),HL	;put back new pointer
	POP	DE		;restore track/sector
	POP	HL		;restore remain count
	CALL	NEXSEC		;move DE to next sector
	RET	C		;go if disk end
;
	DEC	HL		;less sector just read
	LD	A,H		;any more to do?
	OR	L		;any bits on?
	JR	NZ,CPYVER1	;go if more to do
	RET			;else on to next drive
;
CPLP2	LD	HL,(TEMP2)	;get remaining sectors
	LD	A,H		;anything?
	OR	L		;any bits on?
	JP	NZ,SCOPYLP	;go if more to do
;
;	verify disk remainder if track count > source
;
	LD	DE,CPLPX	;subroutine vector
	LD	BC,CPLPY	;return vector when done
	JP	DRVCOMM		;do all active drives
;
;	see if dest disk larger than source disk
;	and verify the additional sectors
;
CPLPX	LD	DE,(TEMP0)	;get current track/sector
	CALL	NEXSEC		;move to next
	RET	C		;not beyond disk boundary
	LD	DE,(TEMP0)	;re-fetch it
;
CPLPZ	LD	BC,BUFFER	;I/O buffer
	CALL	SHOVERF		;verify it
	CALL	NEXSEC		;move to next sector
	JR	NC,CPLPZ	;go if not at disk end
;
;	disk completely verified
;	update directory to new track count
;
UPDIRX	LD	A,(IY+1)	;get track count
	RST	@18		;convert to ascii
	LD	(UPDIRY),A	;to the string
	LD	(UPDIRY+1),BC	;rest to string
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Updating Directory to '
UPDIRY	DEFM	'xxx Tracks'
	DEFB	LF
	DEFB	ETX
;
	CALL	RDDIR		;read directory
	JR	NZ,UPDIRZ	;skip if any errors
	CALL	MAKEGAT+3	;re-create GAT sector
	JP	WRDIR		;write dir and return
;
UPDIRZ	RST	@08		;display message
;
	DEFB	EOL
	DEFM	'Cannot Update Directory'
	DEFB	LF
	DEFB	ETX
;
	RET			;on to the next drive
;
;	all diskettes copied, see if to repeat
;
CPLPY	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	JP	SFMT4		;ask if to do again!
;
	PAGE
;
;	$CPASSW - endcode/decode password
;
CPASSW	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
COMPP1	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'E>ncode or D>ecode? '
	DEFB	ETX
;
	LD	B,1		;allow 1 keys
	RST	@10		;get from keyboard
	JR	Z,COMENC	;go default 'encode'
	CALL	UCASE		;convert input to ucase
	CP	'D'		;decode?
	JP	Z,COMDEC	;yes, go!
	CP	'E'		;encode?
	JR	NZ,COMPP1	;neither, invalid input
;
COMENC	RST	@08		;ask for password to code
;
	DEFB	LF
	DEFM	'Password? '
	DEFB	ETX
;
	LD	B,8		;8 char input
	RST	@10		;fetch from keyboard
	CALL	CODE		;code it!
	LD	C,H		;pass value to BC
	LD	B,L		;BC = coded password
	LD	HL,COMPW	;string to hold it
	CALL	PUTHEX		;load hex to string
	RST	@08		;display result
;
	DEFB	LF
	DEFM	'Encoded = '
COMPW	DEFM	'xxxxH'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
;	compute existing password
;
COMDEC	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	ASKFILE		;get filename
;
	RST	@08		;another linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	HL,(CURSOR)	;fetch cursor location
	CALL	SHOWIT		;display filename
;
	LD	E,(IX+18)	;get access password
	LD	D,(IX+19)	;get MSB
	LD	C,D		;pass DE to BC
	LD	B,E		;BC = password
	LD	HL,ACC1		;string to hold it
	CALL	PUTHEX		;load to string
	RST	@08		;display current
;
	DEFB	LF
	DEFM	'Access   = '
ACC1	DEFM	'xxxxH'
	DEFB	LF
	DEFB	ETX
;
	CALL	FIGPASS		;compute password
;
WTTC	CALL	IFCLEAR		;check for CLEAR key
	JR	C,WTTC		;hold if pressed
;
	LD	E,(IX+16)	;get UPDATE password
	LD	D,(IX+17)	;get MSB password
	LD	C,D		;pass to BC
	LD	B,E		;BC = password
	LD	HL,ACC2		;string to hold ascii
	CALL	PUTHEX		;load hex into string
	RST	@08		;display it
;
	DEFB	LF
	DEFM	'Update   = '
ACC2	DEFM	'xxxxH'
	DEFB	LF
	DEFB	ETX
;
	CALL	FIGPASS		;compute password
	JP	GOBACK		;back to sub-menu
;
;	display resulting password
;
FIGPOT	LD	C,D		;pass to BC
	LD	B,E		;BC = password reverse
	LD	HL,DUMPU	;string to hold ascii
	CALL	PUTHEX		;load HEX ascii there
	RST	@08		;display password
;
	DEFB	BOL		;beginning of line
DUMPASS	DEFM	'xxxxxxxx = '
DUMPU	DEFM	'xxxxH'
	DEFB	ETX
;
	RET			;done!
;
;	compute password, DE = encoded word
;
FIGPASS	LD	HL,DUMPASS	;password string
	LD	B,8		;8 chars to do
	LD	A,SPACE		;space
	CALL	FILL		;fill with spaces
	LD	BC,(CURSOR)	;get cursor location
	LD	A,99H		;graphic char
	LD	(BC),A		;to video
;
FIGPSLP	PUSH	DE		;save DE
	LD	DE,DUMPASS+7	;password string at end
	CALL	CODEZZ		;code it
	POP	DE		;re-fetch DE
	OR	A		;clear carry for compare
	SBC	HL,DE		;see if we have it
	JR	Z,FIGPOT	;yes! display it!
;
	CALL	IFCLEAR		;check for clear key
	RET	C		;yes, return from it
;
;	advance password string to next
;
	LD	HL,DUMPASS	;dummy password
	LD	A,(HL)		;fetch first char
	CP	SPACE		;space?
	CALL	Z,DUMP5		;yes, convert to alpha
	INC	A		;bump one
	CP	'Z'+1		;beyond alpha range?
	JR	NZ,DUMP44	;nope, continue
	LD	(HL),'A'	;else reset to start
	INC	HL		;bump pointer
	LD	BC,(CURSOR)	;fetch cursor
	LD	A,(BC)		;get char
	XOR	3FH		;change graphic
	LD	(BC),A		;back to video
;
DUMP1	LD	A,(HL)		;get string char
	CP	SPACE		;blank?
	CALL	Z,DUMP6		;yes, convert to number
	INC	A		;+1
	CP	'9'+1		;beyond numeric?
	JR	Z,DUMP2		;yes, go!
	CP	'Z'+1		;beyond alpha?
	JR	Z,DUMP3		;yes, go!
;
DUMP44	LD	(HL),A		;put new char
;
DUMP4	JR	FIGPSLP		;compute new word
;
DUMP2	LD	A,'A'		;reset to alpha
	JR	DUMP44		;continue
;
DUMP3	LD	(HL),'0'	;reset to numeric
	INC	HL		;bump pointer
	LD	A,(HL)		;fetch next char
	CP	SPACE		;blank?
	CALL	Z,DUMP6		;yes, change it
	LD	(HL),A		;put back in string
	JR	DUMP1		;continue
;
DUMP5	LD	A,'A'-1		;reset to alpha
	RET			;done
;
DUMP6	LD	A,'0'-1		;reset to numeric
	RET			;done
;
;	display sector mismatch from $BACKUP
;
NOGOODV	RST	@08		;display
;
	DEFM	'  ** BAD **'
	DEFB	LF
	DEFB	ETX
;
	RET
;
