; supurgd/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/16/83 - kjw
;
	PAGE
;
;	$MAKEHIT - create HIT table
;
;	ENT	directory loaded starting at $GATBUFF
;
;	EXT	HIT table at $HITBUFF completely rebuilt
;
;	NOTE	TRSDOS Mod III and I double density
;		both keep their system files logged into
;		this sector in differing lengths
;		their table is not disturbed
;
MAKEHIT	CALL	SAVEREG		;save registers
	LD	HL,HITBUFF	;point to HIT table
;
;	first zero out the table so we have fresh start
;	compute the actual maximum length of the table
;
	LD	B,0		;maximum 256 bytes
	LD	A,(IY+7)	;get dos type
	CP	2		;t1d?
	JR	C,MKHINT	;go if not
	CP	4		;t3?
	JR	NC,MKHINT	;go in not
	CP	3		;trsdos III?
	LD	B,0D0H		;208 bytes Mod I DD
	LD	A,5		;5 entries / sector
	JR	NZ,MKHI		;go if mod I
	LD	B,0E0H		;224 bytes Mod III DD
	JR	MKHI		;continue
;
MKHINT	LD	A,8		;8 entries / sector
MKHI	LD	(HHIS+1),A	;save for later testing
	XOR	A		;fill with 0's
	CALL	FILL		;fill the table
;
;	TRSDOS III and I DD keep the HIT table
;	positions (directory entry codes DEC)
;	'entry relative'
;	all others keep their DEC's
;	'sector/byte relative'
;	we need to keep both types of positions
;	and offsets to take care of 'em all
;
MU13	CALL	ENTRIES		;load E with # dir entrys
	LD	IX,FILBUFF	;start of file records
	LD	C,0		;relative sector counter
	LD	D,C		;relative entry counter
;
HITLP1	LD	B,0		;rel byte in sector
;
HITLP2	BIT	4,(IX)		;active entry?
	CALL	NZ,PUTHIT	;put the hit in if active
;
	CALL	IXDIR		;IX => next entry
	DEC	E		;any more left?
	RET	Z		;nope, return
;
	INC	D		;bump file counter
	INC	B		;posit in sector
HHIS	LD	A,5		;# entries / sector
	CP	B		;end of sector?
	JR	NZ,HITLP2	;finish if not
	INC	C		;bump sector counter
	JR	HITLP1		;do next sector
;
	PAGE
;
;	$HASH - compute hashcode for file
;
;	ENT	IX => directory file entry
;
;	EXT	A = hash code for file
;
HASH	PUSH	IX		;save these regs
	PUSH	BC
;
	LD	BC,0B00H	;B=#chars, C=hash code
;
HASHLP	LD	A,(IX+5)	;fetch filename char
	INC	IX		;point to next char
	XOR	C		;mash it up a bit
	RLCA
	LD	C,A		;save result
	DJNZ	HASHLP		;do all 11 chars in name
	OR	A		;end up with 0?
	JR	NZ,HASHOK	;nope, hash code OK
	INC	A		;else make it one
;
HASHOK	POP	BC		;A = hash code
	POP	IX
	RET			;back to caller
;
	PAGE
;
;	$PUTHIT - insert HIT byte for current file
;
;	ENT	IX => directory file entry
;
;	EXT	all primary and extended HIT bytes
;		are placed correctly into $HITBUFF
;
PUTHIT	BIT	7,(IX)		;extension?
	RET	NZ		;don't do those (yet)
	CALL	SAVEREG		;save pointers/offsets
;
	LD	A,B		;get posit in sector
	ADD	A,A		;align to 3 top bits
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,C		;add to rel sector
	LD	H,HITBUFF<-8	;page start of HIT
	LD	L,A		;HL => byte/sec relative
	LD	A,(IY+7)	;get dos type
	CP	02		;t1d?
	JR	Z,INSHIT3	;yes, go!
	CP	03		;t3?
	JR	NZ,INSHIT	;nope, go!
;
INSHIT3	LD	L,D		;HL => file relative
;
INSHIT	PUSH	AF		;save TRSDOS DD flags
	CALL	HASH		;compute hashcode
	LD	(HL),A		;insert hashcode
	LD	C,A		;save hashcode
	POP	AF		;restore flags
	CP	03		;trs 3?
	RET	Z		;yes, no extents!
;
;	check for any extended entries
;	insert same hit byte for those also
;
EXTHIT	CALL	GETEXTS		;max # of extents/entry
;
EXTHITL	LD	A,(IX+16H)	;type byte
	INC	A		;terminator?
	RET	Z		;this file done!
	INC	A		;extent?
	JR	Z,EXTHITH	;yes, fetch it!
;
	INC	IX		;bump pointer
	INC	IX		;two bytes each extent
	DJNZ	EXTHITL		;finish locating it
	RET			;corrupt! return
;
EXTHITH	LD	L,(IX+17H)	;get new DEC
	LD	H,HITBUFF<-8	;page of hit buffer
	LD	(HL),C		;put in same hashcode
	LD	A,L		;fetch it back
	CALL	WHATDEC		;compute sector/byte off.
	LD	IX,FILBUFF	;start of records
	ADD	IX,DE		;IX => extension
	JR	EXTHIT		;check for more
;
	PAGE
;
;	$DSKFREE - display free space on all drives
;
DSKFREE	CALL	INITDVO		;activate all drives
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	DE,DSKFREC	;subroutine vector
	LD	BC,GOBACK	;to menu when done
	JP	DRVCOMM		;do all drives
;
DSKFREC	CALL	STAT		;is drive ready?
	RET	NZ		;nope, do next drive
;
	CALL	RDDIR		;read directory
	JP	NZ,NOTDIR	;can't find it!
;
	RST	@08		;move cursor up 2 rows
;
	DEFB	UFEED		;up cursor command
	DEFB	UFEED		;2 rows
	DEFB	ETX		;term
;
	CALL	DIRPART		;name/date/grans/files
	RST	@08		;linefeed between each
;
	DEFB	LF
	DEFB	ETX
;
	RET			;done, next drive
;
	PAGE
;
;	$KILLCAT - kill files by category
;
KILLCAT	CALL	GETDRVS		;get multiple drives
	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	DE,KILCATC	;subroutine vector
	LD	BC,GOBACK	;to menu when done
	JP	DRVCOMM		;do all requested drives
;
KILCATC	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't locate it!
;
	CALL	DIRPART		;name/date/grans/files
	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
BADCAT	RST	@08		;display prompt
;
	DEFB	BOL		;clear current line
	DEFM	'Category? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;fetch from keyboard
	JR	Z,BADCAT	;nil? ask again
;
;	convert user input to upper case for matching
;
	PUSH	HL		;string pointer
	PUSH	BC		;length
;
CCAATT	LD	A,(HL)		;fetch a character
	CALL	UCASE		;make it upper case
	LD	(HL),A		;put it back
	INC	HL		;point to next
	DJNZ	CCAATT		;any more? go if yes
	POP	BC		;unstack
	POP	HL
;
	LD	A,(HL)		;fetch first character
	CP	'/'		;kill by extension?
	JR	Z,KEXT		;kill by extension
	CP	SSPACE		;space here?
	JR	Z,KSYMB		;kill by symbol
	CP	SPACE		;normal space?
	JR	Z,KSYMB		;kill by symbol
;
	LD	A,B		;get length
	CP	9		;up to 8 allowed
	JR	NC,BADCAT	;too many, ask again
;
	LD	DE,5		;offset to name
;
KCATTGO	EXX			;save in alt set
	CALL	ENTRIES		;load E with # entries
	LD	IX,FILBUFF	;start of files
;
KCATLP	BIT	4,(IX)		;active file entry?
	CALL	NZ,KILLCT	;see if class matches
	CALL	IXDIR		;move IX to next entry
	DEC	E		;less this file
	JR	NZ,KCATLP	;finish 'em off
;
	CALL	MAKEGAT		;create the GAT
	CALL	MAKEHIT		;create the HIT
	JP	WRDIR		;write directory back!
;
;	killing by extension
;
KEXT	INC	HL		;look at next byte
	CALL	POSHL		;anything?
	JR	Z,KNEXT		;kill with no extensions
;
	LD	DE,13		;offset to extension
	DEC	B		;less the / character
	LD	A,B		;fetch resulting length
	CP	4		;must be 1-3
	JR	C,KCATTGO	;OK, do it!
	JR	BADCAT		;invalid, ask again
;
KNEXT	LD	HL,SPACES	;3 spaces for extension
	LD	DE,13		;offset to extension
	LD	B,3		;for 3 bytes long
	JR	KCATTGO		;kill with no extensions
;
KSYMB	INC	HL		;bump input pointer
	LD	A,(HL)		;get next byte
	CALL	UCASE		;make it upper
;
	LD	BC,4040H	;B=mask, C=result
	CP	'S'		;system files?
	JR	Z,KSYMBGO	;yes, go!
;
	LD	BC,0808H
	CP	'I'		;invisible files?
	JR	Z,KSYMBGO
;
	LD	BC,0800H
	CP	'V'		;visible files?
	JR	Z,KSYMBGO
;
	LD	BC,0700H
	CP	'P'		;with no passwords
	JR	Z,KSYMBGO
;
	LD	BC,4000H
	CP	'N'		;non-system?
	JP	NZ,BADCAT	;invalid command if not
;
KSYMBGO	LD	DE,0		;offset to mask
	JR	KCATTGO		;do 'em
KILLCT	BIT	7,(IX)		;extended entry?
	RET	NZ		;don't check these
;
	EXX			;data in alt set
	INC	E		;check for symbol type
	DEC	E		;E = 0?
	JR	Z,KILLSYM	;yes, kill by symbol
;
	PUSH	BC		;save mask/test
	PUSH	DE		;save displacement
	PUSH	HL		;save string pointer
	PUSH	IX		;file pointer
;
	ADD	IX,DE		;offset to desired data
	PUSH	IX		;pass to DE
	POP	DE		;DE => file entry
	CALL	COMPARE		;same?
;
	POP	IX		;unstack 'em all
	POP	HL
	POP	DE
	POP	BC
	JR	KICAT		;Z set if to be killed
;
KILLSYM	LD	A,(IX)		;fetch file type byte
	AND	B		;mask desired bits
	CP	C		;should be this to kill
;
KICAT	EXX			;save registers back
	LD	BC,FILBUFF	;start of records
	LD	(KILLW),BC	;save for $KILL
	CALL	Z,KILLIT	;kill the file if flagged
	RET			;done, next file
;
	PAGE
;
;	$FIGTKS - establish diskette track count from GAT
;
;	ENT	GAT table loaded into memory at $GATBUFF
;
;	EXT	DCT track count byte updated
;
FIGTKS	LD	A,(IY+7)	;fetch dos type
	CP	1		;t1s?
	JR	Z,FIGTRS	;trsdos I SD
;
	CP	2		;t1d?
	JR	Z,FIGTRD	;trsdos I DD
;
	CP	3		;trsdos III?
	RET	Z		;trsdos III, can't tell
;
	CP	7		;ldos?
	JR	C,FIGLDOS	;ldos I/III SD
	CP	17		;8"?
	JR	NC,FIGLDOS	;go LDOS type
;
	CP	10		;dosplus?
	JR	C,FIGLDOS	;dosplus I/III
;
	CP	13		;multidos?
	JR	C,FIGMDOS	;yes, go
;
;	leave an opening for any future dos
;	assignments for bit 1 (not currently used)
;
	CP	16		;newdos?
	JR	C,FIGNDOS	;yes, go!
;
	BIT	6,(IY+6)	;single density?
	JR	Z,FIGTRS	;yes, go!
	JR	FIGTRET		;undefined disk(for now)
;
FIGTRD	RET				;done!
;
FIGLDOS	LD	A,(GATBUFF+0CCH)	;ldos byte
	ADD	A,35		;byte is minus 35 trks
	JR	FIGPUT		;update DCT
;
FIGMDOS	LD	A,(GATBUFF+0CCH)	;multidos
	LD	(IY+0),A	;physical tracks
	LD	A,(GATBUFF+0CDH)
	LD	(IY+1),A	;relative tracks
	RET			;done
;
FIGNDOS	BIT	6,(IY+6)	;single density?
	JR	Z,FIGTRS	;yes, go!
	JR	FIGTRET		;continue
;
FIGPUT	LD	(IY+0),A	;save into DCT
	CALL	RELTKS		;compute relative tracks
;
FIGTRET	RET			;done!
;
;	compute physical track count of a diskette
;	by locating the highest non-locked out track
;
FIGTRS	PUSH	HL		;need this
	PUSH	BC		;and this
	LD	B,60H		;96 tracks maximum in GAT
	LD	HL,GATBUFF+0BFH	;last lockout byte
;
FIGTK1	LD	A,(HL)		;fetch lockout byte
	INC	A		;is it FF locked?
	JR	NZ,FIGTK2	;nope, have tracks
	DEC	HL		;move pointer down
	DJNZ	FIGTK1		;go for 96 tracks
	LD	B,(IY+1)	;table corrupt! get curr
;
FIGTK2	LD	A,B		;get resulting tracks
	POP	BC		;done, unstack
	POP	HL
;
	JR	FIGPUT		;insert into DCT
;
	PAGE
;
;	$COMPDIR - compute correct byte to write directry
;
;	ENT	IY => DCT
;
;	EXT	A = FDC sector write command
;
COMPDIR	LD	A,(IY+6)	;get system flag
	RRCA			;move bit 2 => 0
	RRCA
	CPL			;reverse the bits
	AND	1		;save one bit only
	LD	(CDIRMSK),A	;save mask byte
;
	PUSH	BC		;save it
	CALL	FIXSET		;compute IBM bit
	LD	A,0A0H		;start sector byte
	OR	B		;combine bit
	POP	BC		;restore
	OR	0		;set data address mark
CDIRMSK	EQU	$-1
;
;	if we are writing single density on a Mod I
;	that is NOT TRSDOS/NEWDOS, use deleted data
;	address mark for compatability with Mod III
;
;i*
	IF	MODI
	BIT	6,(IY+6)	;double density?
	RET	NZ		;yes, skip it all
	PUSH	BC		;save again
	LD	C,(IY+7)	;get dos type
	DEC	C		;trsdos I?
	POP	BC		;restore
	RET	Z		;yes, return
	OR	2		;select user defined mark
	ENDIF
;i*
	RET			;done, A = write byte
;
	PAGE
;
;	$COMPDAT - compute write byte for data sectors
;
;	ENT	IY => DCT
;
;	EXT	A = FDC sector write byte for data sectrs
;
COMPDAT	LD	A,(IY+6)	;get system flag
	RRCA			;move bit 2 => 0
	RRCA
	AND	1		;low bit only
	LD	(CDATMSK),A	;save mask byte
;
	PUSH	BC		;save it
	CALL	FIXSET		;compute IBM bit
	LD	A,0A0H		;start write byte
	OR	B		;combine with IBM bit
	POP	BC		;restore
	OR	0		;set data address mark
CDATMSK	EQU	$-1
	RET			;done, A = write byte
;
	PAGE
;
;	$CHFILE - change file parameters
;
;
CHFILE	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	ASKFILE		;ask for filespec
;
	RST	@08		;another linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	HL,(CURSOR)	;fetch current cursor
;
	CALL	SHOWIT		;display filename
;
	RST	@08		;another linefeed
;
	DEFB	LF
	DEFB	ETX
;
;	must save current drive # from file evaluator
;
	LD	A,(DRIV)	;get binary drive #
	LD	(TEMP0),A	;save it
NNAME	RST	@08		;prompt for name
;
	DEFB	EOL		;clear line
	DEFM	'Name? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;fetch from keyboard
	JR	Z,NPASS		;nil, don't change!
;
	CALL	MOVFILE		;crack open this name
	CALL	C,BADFILE	;invalid filespec
	JR	C,NNAME		;ask again
;
;	move new name into directory area
;
	PUSH	IX		;IX => file
	POP	DE		;DE => file entry
	LD	A,E		;fetch LSB
	ADD	A,5		;offset to name start
	LD	E,A		;DE => file name
	LD	HL,FILEDCB	;new name is here
	LD	BC,11		;11 chars long
	LDIR			;move in new name
;
NPASS	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DPASSU		;default password NIL
	LD	(IX+12H),L	;access password
	LD	(IX+13H),H	;password '        '
;
;	reset previous drive #
;
	LD	A,(TEMP0)	;get old drive #
	CALL	SETDRV		;set back up for I/O
;
NAPASS	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'Access Password? '
	DEFB	ETX
;
	LD	B,8		;8 char input
	RST	@10		;fetch from keyboard
	JR	Z,NBPASS	;nil, already set in
	CALL	CODE		;code the password
	LD	(IX+12H),L	;put into dir entry
	LD	(IX+13H),H
;
NBPASS	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DPASSU		;default password
	LD	(IX+10H),L	;update password
	LD	(IX+11H),H
;
NCPASS	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'Update Password? '
	DEFB	ETX
;
	LD	B,8		;8 chars to fetch
	RST	@10		;get from keyboard
	JR	Z,NACCESS	;nil, already set
	CALL	CODE		;code the password
	LD	(IX+10H),L	;put into dir entry
	LD	(IX+11H),H
;
NACCESS	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	A,(IX)		;get type byte
	AND	0F8H		;set prot level at 0
	LD	(IX),A		;put it back
;
NBACESS	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'Protection Level? '
	DEFB	ETX
;
	LD	B,2		;2 char input
	RST	@10		;from keyboard
	JR	Z,PUTABC	;done, already set
;
	SUB	'0'		;remove ascii
	JR	C,NBACESS	;invalid, ask again
	CP	8		;must be 0-7
	JR	NC,NBACESS	;invalid, ask again
;
;	3 is not a defined level in most DOS's
;	but we will allow it here in case they
;	implement that setting at a later date
;
	OR	(IX)		;combine with type
	LD	(IX),A		;put it back
;
PUTABC	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
PUTABCC	RST	@08		;display prompt
;
	DEFB	EOL		;clear line
	DEFM	'Attribute? '
	DEFB	ETX
;
	LD	B,1		;one char input
	RST	@10		;get from keyboard
	JR	Z,PUTBBC	;nil, leave it
	CALL	UCASE		;make it upper case
;
	CP	'V'		;visible?
	JR	Z,PVIS
;
	CP	'I'		;invisible?
	JR	Z,PINV
;
	CP	'S'		;system?
	JR	Z,PSYS
;
	JR	PUTABCC		;invalid, ask again
;
PVIS	RES	3,(IX)		;set VISIBLE
	RES	6,(IX)		;set NON SYSTEM
	JR	PUTBBC		;continue
;
PINV	SET	3,(IX)		;set INVISIBLE
	JR	PUTBBC		;continue
;
PSYS	SET	6,(IX)		;set SYSTEM
	SET	3,(IX)		;set INVISIBLE
;
PUTBBC	CALL	MAKEHIT		;reset HIT table
	CALL	WRDIR		;write directory to disk
	JP	GOBACK		;back to menu!
;
	PAGE
;
;	$BCDIR - fetch offset from directory entries
;
;	EXT	BC = 20H or 30H as applies
;
BCDIR	LD	BC,20H		;32 bytes standard
	LD	A,(IY+7)	;get dos type
	CP	03H		;trsdos III?
	RET	NZ		;nope, must be 32
	LD	C,30H		;Mod III is different!
	RET			;BC = file entry length
;
;	$IXDIR - advance IX to next file in directory
;
IXDIR	PUSH	HL		;will use this too
;
	PUSH	IX		;pass IX to HL
	POP	HL
	CALL	HLDIR		;advance it
	PUSH	HL		;pass HL to IX
	POP	IX
;
	POP	HL		;unstack
	RET			;IX => next entry
;
;	$HLDIR - advance HL to next directory record
;
HLDIR	PUSH	BC		;save it
	CALL	BCDIR		;load BC with length
	ADD	HL,BC		;point to next
	POP	BC		;unstack
;
;	because TRSDOS III uses a different entry
;	length than ANYONE else, check to see if
;	we ended up on the last 16 bytes of a sector
;	which can only happen with that dos
;
;	can you believe that they never use the last
;	16 bytes of each directory sector?
;	that means 16 sectors times 16 bytes or
;	256 bytes of directory that is never used!!
;
	LD	A,L		;fetch LSB of pointer
	CP	0F0H		;at last row?
	RET	NZ		;nope, HL is set
	LD	L,0		;else force first record
	INC	H		;of the next sector
	RET			;HL => next record
;
;	$IXDIRB - move IX back one entry
;
IXDIRB	PUSH	BC		;save it
	PUSH	HL		;need this too
;
	PUSH	IX		;pass IX to HL
	POP	HL		;HL => current file
;
;	once again, the all too familiar detect for
;	the 'strange' trsdos III
;
	LD	BC,-20H		;'normal' offset
	LD	A,(IY+7)	;get dos type
	CP	03H		;trsdos III?
	JR	NZ,IXDIRBB	;nope, go!
	LD	BC,-30H		;offset TRSDOS III
;
	LD	A,L		;get LSB of entry
	OR	A		;at first entry in sectr?
	JR	NZ,IXDIRBB	;nope, decrement it
;
	LD	L,0C0H		;offset last entry
	DEC	H		;move back a page
	JR	IXDIRDD		;done, unstack
;
IXDIRBB	ADD	HL,BC		;subtract offset
;
IXDIRDD	PUSH	HL		;pass HL => IX
	POP	IX
;
	POP	HL		;unstack
	POP	BC
	RET			;IX => last entry
;
	PAGE
;
;	$DPASSU - compute nil file password
;	$DPASSV - compute master password 'PASSWORD'
;
;	ENT	IY => DCT
;
;	EXT	HL = desired password
;
DPASSU	PUSH	BC		;save it
	LD	HL,4296H	;password non-trsIII
	LD	BC,5CEFH	;password trsIII
	JR	FIGPSST		;continue
;
DPASSV	PUSH	BC		;save it
	LD	HL,42E0H	;password non-trsIII
	LD	BC,8FD3H	;password trsIII
;
FIGPSST	LD	A,(IY+7)	;get dos type
	CP	2		;t1d?
	JR	C,FIGPST	;nope, go!
	CP	4		;t3?
	JR	NC,FIGPST	;nope, go!
;
;	mod I DD or Mod III are the same
;
	LD	H,B		;pass the word
	LD	L,C		;to HL
;
FIGPST	POP	BC		;unstack
	RET			;HL = password
;
