; sufilef/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/16/83 - kjw
;
	PAGE
;
;	$CREATE - create file
;
CREAT0	RST	@08		;display message
;
	DEFB	LF
	DEFM	'File Exists'
	DEFB	ETX
;
	JP	GOBACK		;abort!
;
;
CREATF	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
CREAFT	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'File to Create? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;fetch from keyboard
	CALL	POSHL		;any input?
	JR	Z,CREAFT	;nope, ask again
;
	CALL	MOVFILE		;valid filespec?
	CALL	C,BADFILE	;display if not
	JR	C,CREAFT	;ask again
;
	CALL	FNDFILE		;does it exist?
	JR	NC,CREAT0	;yes, display it
;
	LD	A,(SCANFLG)	;drive # specified?
	OR	A		;yes?
	JR	NZ,BLDDOIT	;nope, build on drive
;
;	check all drives for space
;
	CALL	INITDVO		;activate all drives
	LD	DE,BLDFIL	;subroutine vector
	LD	BC,BLDRET	;return vector
	JP	DRVCOMM		;check all drives
;
;	no space available for file
;
BLDRET	RST	@08		;display message
;
	DEFB	LF
	DEFM	'No Space Available'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
BLDFIL	CALL	STAT		;drive ready?
	RET	NZ		;nope, check next drive
	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't find it!
;
	CALL	FIGTKS		;compute track count
;
BLDDOIT	CALL	FNDSPOT		;find a nil entry
	PUSH	HL		;pass to IX
	POP	IX		;IX => free slot
	LD	(IXSAVX),HL	;save pointer
;
	PUSH	HL		;save start
	LD	D,H		;pass to DE
	LD	E,L		;DE => record start
	INC	DE		;start +1
	LD	BC,22		;length of partial record
	LD	(HL),0		;load zero
	LDIR			;clear it out
	LD	(HL),-1		;load -1
	LD	BC,9		;length of extents
	LD	A,(IY+7)	;get dos type
	CP	03		;trsdos III?
	JR	NZ,P103C	;nope, continue
	LD	BC,25		;else length
P103C	LDIR			;fill extents
	POP	HL		;HL => start
;
	LD	(HL),10H	;set as active
	LD	A,L		;get LSB
	ADD	A,5		;offset to name
	LD	E,A		;E = sector offset
	LD	D,H		;DE => record
	LD	HL,FILEDCB	;stored filespec
	LD	BC,11		;11 chars long
	LDIR			;move into directory
	LD	HL,PASSWRD	;password storage
	LD	B,8		;8 chars long
	CALL	CODE		;code it
;
PUTPSW	LD	(IX+16),L	;insert password
	LD	(IX+17),H	;into directory entry
	LD	(IX+18),L	;as both update &
	LD	(IX+19),H	;access passwords
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DIRPART		;display name/date/etc
	RST	@08		;another linefeed
;
	DEFB	LF
	DEFB	ETX
;
BVM	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'# Grans to Allocate? '
	DEFB	ETX
;
	LD	B,20		;20 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;position input
	LD	BC,0		;default # grans
	JR	Z,BMN		;go if nil input
	CALL	VALUE		;fetch string value
	JR	C,BVM		;invalid, ask again
BMN	LD	A,C		;get LSB value
	OR	B		;any grans needed?
	PUSH	AF		;save flags
	LD	H,B		;pass to HL for allocate
	LD	L,C		;HL = # needed grans
	PUSH	HL		;save # grans
	CALL	NZ,ALLO0	;allocate if non-zero
	POP	HL		;HL = # grans
	POP	AF		;get flags
	CALL	NZ,WE41		;yes, set end of file
	CALL	MAKEGAT		;create GAT table
	CALL	MAKEHIT		;create HIT table
	CALL	WRDIR		;write back directory
	JP	GOBACK		;back to sub-menu
;
;	set end of file sector
;
WE41	LD	C,(IY+10)	;sectors/gran
	CALL	MULT		;fetch # sectors
;
	LD	IX,(IXSAVX)	;get dir pointer
	LD	(IX+20),L	;insert LSB eof
	LD	(IX+21),H	;insert MSB eof
	RET			;done!
;
	PAGE
;
;	$DALLOC - disk allocation
;
DALLOC	CALL	GETDRVS		;get which drives to do
	LD	DE,ALLOGO	;subroutine vector
	LD	BC,SUBMENU	;vector when done
	JP	DRVCOMM		;do all requested drives
;
ALLOGO	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't find it!
	CALL	FIGTKS		;compute track count
	RST	@08		;clear screen
;
	DEFB	CLSA		;clear entire screen
	DEFB	ETX
;
	LD	C,16		;16 video rows
	LD	IX,GATBUFF	;start of GAT table
	LD	HL,VIDEO	;start of video
;
UOLP	LD	B,6		;6 per video row
;
UILP	PUSH	HL		;save video pointer
	LD	(HL),SPACE	;put blank
	INC	HL		;bump video
;
	PUSH	BC		;save counters
	PUSH	IX		;pass IX to BC
	POP	BC		;C = track #
	LD	A,C		;get track #
	LD	(TEMP7),A	;save track #
	RST	@18		;to decimal ascii
	LD	(HL),C		;ascii to video
	INC	HL
	LD	(HL),B		;LSB to video
	INC	HL		;bump video
	LD	(HL),5EH	;arrow to video
	INC	HL		;bump video
;
CKC0	LD	B,(IX)		;get allocation byte
	LD	C,(IX+60H)	;get lockout byte
	LD	D,(IY+11)	;get # grans / track
	BIT	0,(IY+5)	;double sided?
	JR	Z,CKC00		;nope, continue
	SLA	D		;double it
CKC00	LD	A,(TEMP7)	;get track
	OR	A		;at zero?
	JR	Z,CKC1		;yes, go!
	CP	(IY+1)		;beyond disk?
	LD	A,5FH		;symbol if yes
	JR	NC,CKC3		;go if yes
;
CKC1	BIT	3,(IY+6)	;relative engaged?
	JR	NZ,CKC11	;yes, go!
	RR	C		;gran locked out?
	JR	C,CKC2		;yes, go!
CKC11	RR	B		;gran allocated?
	LD	A,'.'		;available
	JR	NC,CKC3		;go if free
	LD	A,'x'		;allocated
;
CKC3	CP	'x'		;allocated?
	JR	NZ,CKC5		;nope, go!
	LD	A,(TEMP7)	;get current track
	CP	(IY+2)		;on directory?
	LD	A,'x'		;restore Allocated
	JR	NZ,CKC5		;go if not
	LD	A,'D'		;show Directory
;
CKC5	LD	(HL),A		;to video
	CP	(HL)		;lowercase here?
	JR	Z,CKC4		;go if yes
	PUSH	AF		;save char
	SUB	20H		;make upper case
	LD	(HL),A		;put it back
	POP	AF		;restore char
	JR	CKC4		;see if more to do
;
CKC2	LD	A,'L'		;locked out
	RR	B		;align allocation bit
	JR	CKC3		;continue
;
CKC4	INC	HL		;bump video
	CP	5FH		;out of disk range?
	JR	Z,CKC44		;yes, go!
;
	DEC	D		;any more bits this gran?
	JR	NZ,CKC1		;go if more to do
	JR	CKC444		;continue
;
CKC44	DEC	D		;any more bits?
	JR	NZ,CKC3		;yes, set '*'
;
CKC444	POP	BC		;restore counter
	POP	HL		;restore video pointer
	LD	DE,10		;video offset
	ADD	HL,DE		;HL => next video
	INC	IX		;bump GAT pointer
	DJNZ	UILP		;finish this row
;
	INC	HL		;bump video to next row
	INC	HL
	INC	HL
	INC	HL
	DEC	C		;less row counter
	JP	NZ,UOLP		;go if more video
;
	LD	HL,VIDEO+3FDH	;set cursor
	LD	(CURSOR),HL	;save it
	JP	ONEKEY		;wait for a key
;
	PAGE
;
;	$CMPGRNS - compute total grans for current file
;
CMPGRNS	PUSH	HL		;save it
	LD	H,B		;pass count
	LD	L,C		;HL = counter
COMPG0	LD	B,5		;5 extents non trsIII
	LD	A,(IY+7)	;get dos type
	CP	03H		;trsdos III?
	JR	NZ,COMPG1	;nope, go!
	LD	B,13		;else 13 records
;
COMPG1	LD	A,(IX+22)	;get a byte
	INC	A		;FF terminator?
	JR	Z,CMPGBK	;done, go!
	INC	A		;FE extension?
	JR	Z,COMPEXT	;yes, fetch it
;
	LD	A,(IX+23)	;get # grans
	AND	1FH		;low 5 bits only
	CALL	COMPADD		;adjust for TRSDOS III
	LD	C,A		;pass here
	PUSH	BC		;save counter
	LD	B,0		;BC = current grans
	ADD	HL,BC		;HL = total
	POP	BC		;restore count
	INC	IX		;bump to next element
	INC	IX		;2 bytes each
	DJNZ	COMPG1		;finish it off
;
CMPGBK	LD	B,H		;pass to BC
	LD	C,L		;BC = # grans
	POP	HL		;restore
	RET			;done
;
COMPEXT	LD	A,(IX+23)	;get DEC of extension
	CALL	WHATDEC		;compute offset
	LD	HL,(TEMP5)	;start of records
	ADD	HL,DE		;HL => next entry
	PUSH	HL		;pass to IX
	POP	IX		;IX => next file
	JR	COMPG0		;continue
;
;	$DSPSECS - display sectors/grans for current file
;
DSPSECS	PUSH	HL		;save
	PUSH	IX		;save
	LD	BC,0		;init counter
	CALL	CMPGRNS		;compute # granules
	LD	H,B		;pass to HL
	LD	L,C		;HL = # granules
	LD	C,(IY+10)	;# sectors / gran
	CALL	MULT		;multiply it
	POP	IX		;restore
	PUSH	IY		;save DCT
	LD	IY,DSPSECB	;point to text
	CALL	BINASC		;convert to decimal ascii
	POP	IY		;restore
	POP	HL		;restore
	RST	@08		;display
;
DSPSECB	DEFM	'xxxxx Sectors, '
	DEFB	ETX
;
;	$DSPGRNS - display grans for current file
;
DSPGRNS	PUSH	IX		;save pointer
	LD	BC,0		;init counter
	CALL	CMPGRNS		;compute # grans
	POP	IX		;restore it
;
	PUSH	HL		;save
	PUSH	IY		;save
	LD	H,B		;get result
	LD	L,C		;HL = # grans
	LD	IY,PPPQQ	;point to text
	CALL	BINASC		;binary to decimal
	POP	IY		;unstack
	POP	HL		;restored
	RST	@08		;display it
;
PPPQQ	DEFM	'xxxxx Grans'
	DEFB	ETX
;
	RET			;done!
;
	PAGE
;
;	$CHASH - compute hash code entry point
;
CHASH	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
CHASHH	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Filespec to hash? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;any input?
	JR	Z,CHASHH	;nope, ask again
;
	RST	@08		;another linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	MOVFILE		;move into FCB
	CALL	C,BADFILE	;invalid filespec
	JR	C,CHASHH	;ask again
;
	LD	HL,FILEDCB	;point to 'cracked'
	LD	DE,-5		;less 5 for add
	ADD	HL,DE		;HL => name-5
	PUSH	HL		;pass to IX
	POP	IX		;IX => name -5
	CALL	HASH		;compute hash code
	RST	@20		;convert to hex ascii
	LD	(HBYT),BC	;to the message
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Hash Code = '
HBYT	DEFM	'xxH'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
;	$COMPADD - compute # granules in current extent
;
COMPADD	PUSH	AF		;save #
	LD	A,(IY+7)	;get dos type
	CP	2		;t1d?
	JR	Z,CMPADD	;yes, go!
	CP	3		;t3d?
	JR	Z,CMPADD	;yes, go!
	POP	AF		;restore
	INC	A		;adjust
	RET			;done
CMPADD	POP	AF		;restore
	RET			;no adjust
;
	PAGE
;
;	$INSGTC - insert granule/sector count
;
INSGTC	LD	DE,(DIRX)	;get dir offset
	LD	HL,FILBUFF	;start of records
	LD	BC,0		;init counter
	LD	A,(IY+7)	;get dos type
	CP	03H		;trsdos III?
	LD	A,5		;5 extents if not
	JR	NZ,INSGTX	;go if not
	LD	A,13		;else 13 trsdos III
;
INSGTX	LD	(TEMP9),A	;save count
;
INSGTXX	BIT	4,(HL)		;active file?
	CALL	NZ,INSGTY	;count if not
	CALL	HLDIR		;move HL to next entry
	DEC	E		;less this file
	JR	NZ,INSGTXX	;go if more left
;
	LD	A,(IY+10)	;get sectors/gran
	LD	HL,0		;init counter
;
INSGTZ	ADD	HL,BC		;add this gran
	DEC	A		;less gran
	JR	NZ,INSGTZ	;finish it off
	RET			;HL = # sectors
;
INSGTY	PUSH	HL		;save dir pointer
	PUSH	DE		;save dir counter
	LD	DE,22		;offset to extents
	ADD	HL,DE		;HL => extents
	LD	A,(TEMP9)	;get # extents / record
;
INSGTU	EX	AF,AF'		;A' = # EXTENTS
	LD	A,(HL)		;get extent byte
	CP	-1		;terminator?
	JR	Z,INSGTV	;yes, go!
	CP	-2		;extension marker?
	JR	Z,INSGTV	;yes, go!
	INC	HL		;bump pointer
	LD	A,(HL)		;get # grans
	AND	1FH		;low 5 bits only
	CALL	COMPADD		;adjust to actual
	EX	DE,HL		;DE => record
	LD	L,A		;pass to L
	LD	H,0		;HL = # grans
	ADD	HL,BC		;add to total
	LD	B,H		;pass subtotal to BC
	LD	C,L		;BC = total
	EX	DE,HL		;HL => record
	INC	HL		;bump to second byte
	EX	AF,AF'		;get counter back
	DEC	A		;less this element
	JR	NZ,INSGTU	;go if more to do
;
INSGTV	POP	DE		;unstack
	POP	HL		;restore dir pointer
	RET			;done, BC = total
;
