; suzapd/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/16/83 - kjw
;
	PAGE
;
;	$VERSEC - verify disk sectors
;
VERSEC	CALL	GETDAT		;get drive,track,sector
	CALL	GETCNT		;get sector count
	CALL	DSTAT		;drive ready ?
	JP	NZ,SUBMENU	;nope, back to menu
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	INITBD1		;initialize non-stop
	CALL	INTCNT		;zero error counter
;
VERSECL	LD	BC,BUFFER	;I/O buffer
	CALL	MVERIFY		;multiple verify
	LD	A,H		;any more sectors left?
	OR	L
	JR	NZ,VERSECL	;continue in loop if more
;
VERSECQ	CALL	SHOCNT		;display error counter
	RST	@08		;display message
;
	DEFM	'Bad Sectors'
	DEFB	ETX
;
	JP	GOBACK		;wait for enter key
;
	PAGE
;
;	$COMSEC - compare disk sectors
;
COMSEC	RST	@08		;message
;
	DEFB	LF
	DEFM	'Source'
	DEFB	ETX
;
	CALL	GETDAT		;get drive/tk/sec
	CALL	GETCNT		;get sector count
	EXX			;save source here
	LD	A,(DRIV)	;get binary drive
	LD	(SDRIVE),A	;save source drive
	RST	@08		;display
;
	DEFB	LF
	DEFM	'Compare to'
	DEFB	ETX
;
	CALL	GETDAT		;drive track sector
	LD	A,(DRIV)	;get binary drive
	LD	(DDRIVE),A	;save dest drive
	EXX			;count into source HL
	CALL	INITBD1		;initialize non-stop
	CALL	INTCNT		;initialize counter
	CALL	INTACNT		;alternate counter
	CALL	IFSAME		;same diskette?
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
;	outer loop to fetch buffer fulls
;
COMSECL	CALL	SSETUP		;setup for source use
	JP	NZ,SUBMENU	;skip, abort to sub-menu
	LD	BC,BUFFER+100H	;buffer address
;
	PUSH	HL		;save count
	CALL	MREAD		;multiple read
	LD	B,H		;remain count to BC
	LD	C,L		;BC = sectors left
	POP	HL		;original count
;
;	compute how many sectors were read
;
	OR	A		;clear carry flag
	SBC	HL,BC		;how many were read
	PUSH	HL		;save result on stack
	LD	H,B		;put back in HL
	LD	L,C		;HL = remaining sects
	EXX			;save in alt set
	POP	HL		;get count
;
	LD	BC,BUFFER+100H	;start of data
	CALL	DSETUP		;setup for dest drive
	JP	NZ,SUBMENU	;error, abort
	LD	IX,DAMBUFF	;DAM buffer
;
;	inner loop to compare full buffer
;
COMSL	PUSH	HL		;save counter
	PUSH	BC		;save source pointer
	LD	BC,BUFFER	;read buffer
	CALL	SHOVERF		;read it with display
	POP	HL		;source data buffer
	PUSH	DE		;save from compare
	EX	DE,HL		;DE = buffer
	PUSH	DE		;save buffer address
	LD	HL,BUFFER	;point to buffer
	LD	B,0		;256 bytes
	CALL	COMPARE		;compare 'em
	CALL	COMNO		;display result
	POP	BC		;old buffer address
	POP	DE		;track/sector
	CALL	NEXSEC		;bump sector
	POP	HL		;get counter back
;
	JR	C,COMFIN	;end of disk, stop here
	INC	B		;next buffer page
	DEC	HL		;reduce counter
	CALL	PAUSE		;check space bar
	LD	A,H		;any more to do?
	OR	L		;any bits on?
	JR	NZ,COMSL	;yes, go again
;
	EXX			;get source back
	LD	A,H		;any more left?
	OR	L		;any more left
	JR	NZ,COMSECL	;go outer loop
COMFIN	CALL	SHOCNT		;display counter
	RST	@08		;message
;
	DEFB	'Data mismatches'
	DEFB	ETX
;
	CALL	SHOACNT		;display alternate
	RST	@08		;message
;
	DEFM	'DAM mismatches'
	DEFB	ETX
;
	JP	GOBACK		;wait for enter
;
;	check for good compare
;	check both data and address marks
;	display any differences
;
COMNO	JR	Z,BADDAM	;data OK, check marks
;
	PUSH	BC		;save pointer
	LD	A,L		;fetch first mismatch off
	RST	@20		;to hex ascii
	LD	(COMNSTR),BC	;to the string
	POP	BC		;restore it
;
	RST	@08		;display
;
	DEFM	'-DATA-@'
COMNSTR	DEFM	'xxH-'
	DEFB	ETX
;
	CALL	ADDCNT		;bump counter
	OR	-1		;set NZ
;
BADDAM	EX	AF,AF'		;fetch data address mark
	CP	(IX)		;same as source?
	INC	IX		;bump pointer
	JR	Z,DAMOK		;dam is ok, go!
	RST	@08		;display
;
	DEFM	' DAM-'
	DEFB	ETX
;
	CALL	ADDACNT		;bump alternate counter
	JR	ODKM		;resume
;
DAMOK	JR	NZ,ODKM		;display linefeed
	EX	AF,AF'		;get DATA result back
	RET	Z		;all OK, return
ODKM	RST	@08		;else display
;
	DEFB	BACKSP		;backspace last char
	DEFB	SPACE		;print space
	DEFB	LF		;linefeed
	DEFB	ETX		;terminator
;
	JP	PAUSE		;check for pause key
;
	PAGE
;
;	$COPSEC - copy disk sectors
;
COPSEC	RST	@08		;display
;
	DEFB	LF
	DEFM	'Source'
	DEFB	ETX
;
	CALL	GETDAT		;get drive,track,sector
	CALL	GETCNT		;get sector count
	EXX			;save 'em here
;
	LD	A,(DRIV)	;get binary drive
	LD	(SDRIVE),A	;save source drive
	RST	@08		;display
;
	DEFB	LF
	DEFM	'Destination'
	DEFB	ETX
;
	CALL	GETDAT		;get drive track sector
	LD	A,(DRIV)	;get binary drive
	LD	(DDRIVE),A	;save dest drive
	EXX			;back to source data
;
	CALL	INITBD1		;clear nonstop
	CALL	INTCNT		;clear counter
	CALL	IFSAME		;same diskette?
	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
COPSECL	CALL	SSETUP		;setup for source
	JP	NZ,SUBMENU	;abort to menu if bad
	LD	BC,BUFFER	;I/O buffer
;
	PUSH	HL		;save count
	CALL	MREAD		;read as many as possible
	LD	B,H		;save new count in BC
	LD	C,L
	POP	HL		;get original count
;
	OR	A		;clear carry flag
	SBC	HL,BC		;how many were read
	PUSH	HL		;save result
	LD	H,B
	LD	L,C		;get remaining secs to HL
	EXX			;save int alt set
	POP	HL		;count for write
;
	LD	BC,BUFFER	;I/O buffer
	CALL	DSETUP		;setup for dest I/O
	JP	NZ,SUBMENU	;error, abort sub-menu
	CALL	MWRITE		;write 'em back
	EXX			;back to source data
;
	LD	A,H		;any more sectors?
	OR	L
	JR	NZ,COPSECL	;continue if yes
;
;	copy completed
;
	CALL	SHOCNT		;display counter
	RST	@08		;message
;
	DEFM	'Sectors NOT copied'
	DEFB	ETX
;
	JP	GOBACK		;'enter' to continue
;
	PAGE
;
;	$ZERSEC - zero disk sectors
;
ZERSEC	RST	@08		;warning!
;
	DEFB	LF
	DEFM	'Be Careful'
	DEFB	ETX
;
	CALL	GETDAT		;get drive track sector
	CALL	GETCNT		;get sector count
	CALL	INITBD1		;turn off non-stop
	CALL	INTCNT		;initialize counter
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DSTAT		;check status
	JP	NZ,SUBMENU	;nogood, abort sub-menu
;
ZERSECL	LD	BC,BUFFER	;I/O buffer
	CALL	ZBUFF		;zero it out
	CALL	COMPDAT		;fetch DATA write byte
URHA	LD	(WRTYPE),A	;save it
;
	PUSH	HL		;save counter
	RST	@30		;write a sector
	POP	HL		;restore counter
;
	JR	NZ,URHA+3	;retry, same one again
	CALL	NEXSEC		;bump to next sector
	JR	C,ZERFIN	;end of disk
;
	DEC	HL		;reduce count
	LD	A,H		;any more to do?
	OR	L		;any more?
	JR	NZ,ZERSECL	;more, go!
;
ZERFIN	CALL	SHOCNT		;show error count
	RST	@08		;display
;
	DEFM	'Sectors NOT zeroed'
	DEFB	ETX
;
	JP	GOBACK		;'enter' to continue
;
	PAGE
;
;	$DAMARKS - alter data address marks
;
DAMARKS	CALL	GETDAT		;get drive,track,sector
	CALL	GETCNT		;get sector count
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	EXX			;save in alt
;
;	since the Mod I and III differ in the
;	types of address marks they can read/write
;	only prompt for the ones that apply
;
DAMK	RST	@08		;display which one
;i*
	IF	MODI
	DEFB	EOL		;clear this line
	DEFM	'S>td, R>ptc, D>dt, U>df? '
	DEFB	ETX
	ENDIF
;i*
;
;iii/m*
	IF	MODIII.OR.MAX80
	DEFB	EOL
	DEFM	'S>td, R>ptc? '
	DEFB	ETX
	ENDIF
;iii/m*
	LD	B,4		;let 'em type the whole
	RST	@10		;fetch from keyboard
;
	CALL	COMPDAT		;get data write byte
	LD	B,A		;save it here
	JR	Z,HADAM		;use default
;
	LD	A,(HL)		;fetch the character
	CALL	UCASE		;make upper case
;
	CP	'S'		;standard?
	JR	Z,HADAM
;
	INC	B
	CP	'R'		;read protected?
	JR	Z,HADAM
;
;	check for extra mod I types
;
;i*
	IF	MODI
	INC	B
	CP	'D'		;deleted data?
	JR	Z,HADAM
;
	INC	B
	CP	'U'		;user defined?
	JR	Z,HADAM
	ENDIF
;
	JR	DAMK		;error, ask again
;
HADAM	LD	A,B		;get write byte
	EXX			;get everything back
;
	BIT	6,(IY+6)	;double density?
	JR	Z,HYTDN		;nope, resume
	INC	D		;on track 0
	DEC	D
	JR	NZ,HYTRS	;nope, reset bit 1
	BIT	7,(IY+6)	;double track 0
	JR	Z,HYTDN		;single, go!
;
HYTRS	RES	1,A		;only 2 types double den
HYTDN	LD	(DMSV),A	;save address mark type
	CALL	INITBD1		;clear nonstop
	CALL	INTCNT		;clear error counter
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DSTAT		;check status
	JP	NZ,SUBMENU	;no good, exit menu
;
DAMSECL	LD	BC,BUFFER	;I/O buffer
;
	PUSH	DE		;save track sector
	PUSH	HL		;save count
	CALL	MREAD		;multiple read
	LD	B,H
	LD	C,L		;remaining count
	POP	HL		;original
	OR	A		;clear carry flag
	SBC	HL,BC		;how many just read
	POP	DE		;get start track/sector
;
	PUSH	BC		;save how many left
	EXX			;swap for setup
	LD	HL,DAMBUFF	;DAM buffer
	LD	DE,DAMBUFF+1
	LD	BC,0FFH		;1 full sector
	LD	(HL),0		;new DAM
DMSV	EQU	$-1
	LDIR			;fill the table
	EXX			;get originals back
	LD	BC,BUFFER	;use same one
	CALL	MWRITE		;write 'em back
	POP	HL		;get count back
;
	LD	A,H		;any more?
	OR	L
	JR	NZ,DAMSECL	;continue if more
;
	CALL	SHOCNT		;display counter
	RST	@08		;display message
;
	DEFM	'Sectors NOT altered'
	DEFB	ETX
;
	JP	GOBACK		;'enter' to continue
;
	PAGE
;
;	$EXCSEC - exchange disk sectors
;
EXCSEC	RST	@08		;display
;
	DEFB	LF
	DEFM	'Source'
	DEFB	ETX
;
	CALL	GETDAT		;drive, track, sector
	CALL	GETCNT		;sector count
	EXX			;save data here
	LD	A,(DRIV)	;get drive
	LD	(SDRIVE),A	;save source drive
;
	RST	@08		;display
;
	DEFB	LF
	DEFM	'Exchange with'
	DEFB	ETX
;
	CALL	GETDAT		;drive, track, sector
	LD	A,(DRIV)	;get drive
	LD	(DDRIVE),A	;save it
	EXX			;swap back
	CALL	INITBD1		;clear non-stop
	CALL	INTCNT		;clear error counter
	CALL	IFSAME		;same diskette?
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	SSETUP		;setup for source I/O
	JP	NZ,SUBMENU	;skip, back to sub-menu
;
EXCSECL	LD	BC,(MIDMEM)	;middle memory buffer
	LD	(EXCSAV),DE	;save start track/sector
;
	PUSH	HL		;save sector counter
	CALL	MREAD		;multiple read
	LD	B,H		;pass to BC for compare
	LD	C,L		;remaining count to BC
	POP	HL		;restore start counter
;
	OR	A		;clear carry flag
	SBC	HL,BC		;HL = number just read
;
	PUSH	HL		;pass to alternate set
	LD	H,B		;reset HL to correct
	LD	L,C
	EXX			;save source in alt set.
	POP	HL		;length just read
;
	PUSH	HL		;save again
	PUSH	DE		;save start of read
	LD	BC,GATBUFF	;low buffer area
	CALL	DSETUP		;setup for dest I/O
	JP	NZ,SUBMENU	;error, abort!
	CALL	SWAPDAM		;swap DAM save area
	CALL	MREAD		;read these now
	POP	DE		;get back start of read
	POP	HL		;get sector count
;
	LD	BC,(MIDMEM)	;get other data
;
	PUSH	HL		;save counter
	CALL	SWAPDAM		;swap DAM sets
	CALL	MWRITE		;write the other data
	EXX			;swap set back
	CALL	SSETUP		;setup for souce
	JP	NZ,SUBMENU	;error, abort!
	EX	(SP),HL		;save count
	LD	DE,0		;get start sector
EXCSAV	EQU	$-2
	LD	BC,GATBUFF	;where to write from
	CALL	SWAPDAM		;get other set of DAMs
	CALL	MWRITE		;write this back
	POP	HL		;get counter back
;
	LD	A,H		;any more left?
	OR	L
	JR	NZ,EXCSECL	;continue if more
;
	CALL	SHOCNT		;display error counter
	RST	@08		;display
;
	DEFM	'I/O errors on exchange'
	DEFB	ETX
;
	JP	GOBACK		;'enter' to continue
;
;	$SWAPDAM - swap 2 halves of DAM buffer
;
SWAPDAM	CALL	SAVEREG		;save registers
	LD	HL,DAMBUFF	;start of DAM's
	LD	DE,DAMBUFF+80H	;start of 2nd half
	LD	B,80H		;length of each half
;
SWPDAM0	LD	C,(HL)		;fetch one byte
	LD	A,(DE)		;fetch other byte
	LD	(HL),A		;put in first
	LD	A,C		;fetch first
	LD	(DE),A		;put in second
;
	INC	HL		;bump pointers
	INC	DE		;this too
	DJNZ	SWPDAM0		;go for 128
	RET			;unstack and return
;
	PAGE
;
;	$SECDATA - copy sectors data
;
SECDATA	RST	@08		;display
;
	DEFB	LF
	DEFM	'Source'
	DEFB	ETX
;
	CALL	GETDAT		;drive, track, sector
	CALL	GETBYTE		;start byte
	CALL	GETBCNT		;byte count
	EXX			;save here
	LD	A,(DRIV)	;get drive
	LD	(SDRIVE),A	;save source drive
;
	RST	@08		;display
;
	DEFB	LF
	DEFM	'Destination'
	DEFB	ETX
;
	CALL	GETDAT		;drive,track,sector
	CALL	GETBYTE		;start byte
	LD	A,(DRIV)	;get drive
	LD	(DDRIVE),A	;save destination drive
	EXX			;save here
	CALL	INITBD1		;turn off non-stop
	CALL	INTCNT		;zero the counter
	CALL	IFSAME		;same diskette?
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
SECDATL	LD	(SBC01),BC	;save byte count
	LD	(SBC02),BC	;in two places
	LD	BC,BUFFER	;I/O buffer
	ADD	HL,BC		;HL = rel byte
	LD	(SHL01),HL	;save relative byte
	LD	(SHL02),HL	;save twice
;
SECDMOR	CALL	SSETUP		;setup for source I/O
	JP	NZ,SUBMENU	;error, abort to submenu
	LD	BC,BUFFER	;I/O buffer
;
SECLO	RST	@28		;read a sector
	JR	NZ,SECLO	;retry selected, go again
;
	LD	(SBC03),BC	;save buffer position
	LD	BC,0		;get byte count
SBC01	EQU	$-2
	LD	HL,0		;relative byte
SHL01	EQU	$-2
;
SECLO1	DEC	BC		;byte count-1
	LD	A,B
	OR	C		;any more?
	JR	Z,SECDPUT	;have enough source data
	INC	L		;bump source position
	JR	NZ,SECLO1	;finish this sector
	LD	(SHL01),HL	;save pointer
	LD	(SHL02),HL	;save twice
	CALL	NEXSEC		;next sector
	JR	C,SECDPUT	;disk end, go!
;
	LD	BC,0		;get buffer
SBC03	EQU	$-2
	CALL	BUFFEND		;end of memory?
	JR	NZ,SECLO	;do rest of it if not
;
SECDPUT	EXX			;get alt set back
	CALL	DSETUP		;setup for dest activity
	JP	NZ,SUBMENU	;error, abort!
	LD	BC,GATBUFF	;I/O buffer
	LD	(SDE01),HL	;save relative byte
;
PZ013	RST	@28		;read a sector
	JR	NZ,PZ013	;retry, read again
	LD	BC,0		;get byte count
SBC02	EQU	$-2
;
	PUSH	DE		;save track/sector
	LD	DE,0		;get relative byte
SDE01	EQU	$-2
	LD	HL,GATBUFF	;data I/O buffer
	ADD	HL,DE		;point to rel byte
	EX	DE,HL		;DE => rel byte
	LD	HL,0		;get source start byte
SHL02	EQU	$-2
;
SHDMOV	LD	A,(HL)		;get a byte
	LD	(DE),A		;put into dest
	DEC	BC		;reduce byte count
	LD	A,B		;any more?
	OR	C
	JR	Z,SHDWRT	;put it back if yes
;
	INC	E		;bump dest pointer
	JR	Z,SHDWRT	;write back if end
	INC	L		;bump source pointer
	JR	NZ,SHDMOV	;continue if more source
;
	PUSH	BC		;check for topmem
	LD	B,H		;pass HL to BC
	LD	C,L
	CALL	BUFFEND		;end of memory?
	POP	BC		;Z = end of memory
;
	JR	NZ,SHDMOV	;do some more if not
;
SHDWRT	LD	(SBC01),BC	;save new byte count
	LD	(SBC02),BC	;into both places
	LD	(SHL02),HL	;save new source posit
	POP	DE		;get track/sector
;
	LD	BC,GATBUFF	;where data is
PER810	RST	@30		;write a sector
	JR	NZ,PER810	;retry, try again
	CALL	NEXSEC		;point to next sector
	JR	C,SECDFIN	;end of disk, done!
;
	LD	HL,0		;relative byte 0 now
	EXX			;save in alt
	LD	BC,(SBC01)	;any more left?
	LD	A,B		;get it
	OR	C		;any bits on?
	JP	NZ,SECDMOR	;read some more source
;
SECDFIN	CALL	SHOCNT		;display counter
	RST	@08		;display
;
	DEFM	'I/O errors on transfer'
	DEFB	ETX
;
	JP	GOBACK		;'enter' to continue
;
;	checker string to be sure my name stays
;	in the program at least an hour
;	(damn whiz kids!)
;
KIMCHK	DEFB	'K'.XOR.'$'
	DEFB	'i'.XOR.'$'
	DEFB	'm'.XOR.'$'
	DEFB	' '.XOR.'$'
	DEFB	'W'.XOR.'$'
	DEFB	'a'.XOR.'$'
	DEFB	't'.XOR.'$'
	DEFB	't'.XOR.'$'
;
