; subt3 - kjw/bqsd - 02/83
;
; revised 03/15/83 - kjw
;
	TITLE	'<Super-Utility 3.0 Boot III>'
;
	SUBTTL	'<by Kim Watt - (c)(p) Copyright 1983 Breeze/QSD, Inc. - Dallas, TX>'
;
;	This program will locate at Track 0/Sector 1
;	in double density.  It will read in a rather
;	'unusual' manner the 'true' loader which
;	will reside on track 1, at sectors 50H & 70H
;	The sectors will be have Track/Head/Sector
;	numbers all the same
;
;	equivalences
;
NMI	EQU	0E4H		;NMI select latch
FDC	EQU	0F0H		;FDC command/status reg.
TRACK	EQU	0F1H		;FDC track register
SECTOR	EQU	0F2H		;FDC sector register
XFER	EQU	0F3H		;FDC transfer register
SELFDC	EQU	0F4H		;FDC select register
;
DRIVE	EQU	081H		;drive select code
RESTORE	EQU	00BH		;restore command
SEEK	EQU	01BH		;seek command
SREAD	EQU	080H		;read command
AREAD	EQU	0C0H		;read ID marks
CLEAR	EQU	0D0H		;clear FDC
;
	ORG	4300H		;Mod III loader
;
ENTRY	DI
	LD	A,03H		;for dir kill
;
	XOR	A		;load zero
	OUT	(NMI),A		;disable disk NMI's
	LD	SP,STACK	;reset stack
	POP	HL		;get buffer
	CALL	FIG4080		;figure 40/80 track drive
;
;	move head to loader track
;
	CALL	$SEEK		;move head there
;
;	all register data loaded via POP's
;
	LD	B,3		;3 sectors to read
;
READER	POP	HL		;I/O buffer
	POP	DE		;track/sector
	PUSH	BC		;save counter
	CALL	$READ		;read sector
	POP	BC		;restore count
	DJNZ	READER		;go for count
	RET			;go loader!
;
;	actual read routine
;	return/entry point on stack
;
;	ENT	HL => I/O buffer to use
;		DE = track/sector
;
;	EXT	return made via stack
;		first pass a CALL is on stack
;		last pass, stack overflow fetchs
;		the entry point from init table
;
$READ	LD	BC,READ1	;subroutine
	JR	READ		;go common
;
$READA	LD	BC,READA	;address reader
;
READ	LD	(CALL),BC	;pass subroutine
	LD	A,10		;init retry counter
;
READL	PUSH	HL		;save buffer address
	EX	AF,AF'		;save retry count
	CALL	$		;try once
CALL	EQU	$-2
	POP	HL		;restore buffer
	RET	Z		;no error, return
	EX	AF,AF'		;get retry counter
	DEC	A		;less this attempt
	JR	NZ,READL	;go if more left
	RST	0		;re-boot!
;
READ1	CALL	SELECT		;select drive 0
	LD	A,E		;get sector
	OUT	(SECTOR),A	;to FDC sector reg
	LD	A,D		;get track
	OUT	(TRACK),A	;to FDC track reg
;
	LD	BC,RETNMI	;NMI vector
	LD	A,0C0H		;allow NMI
	CALL	SETNMI		;setup NMI
	LD	C,XFER		;xfer port
	LD	A,SREAD		;read command
	CALL	SLOW		;issue and delay
;
RDL1	IN	A,(FDC)		;read FDC status
	AND	2		;byte ready?
	JR	NZ,RDL3		;go if ready
	JR	RDL1		;else wait
;
RDL2	LD	A,DRIVE.OR.40H	;set wait states
	OUT	(SELFDC),A	;select drive
RDL3	IN	A,(C)		;read the byte
	RRD			;move into buffer
;
	LD	A,DRIVE.OR.40H	;set wait
	OUT	(SELFDC),A	;select drive
	IN	A,(C)		;read the byte
	RRD			;to buffer
	DEC	L		;buffer back
	JR	NZ,RDL2		;go till full
	INC	H		;HL => next buffer addr
	JR	RDL2		;continue
;
RETNMI	XOR	A		;load zero
	LD	BC,NMIRET	;non-disk NMI's
	CALL	SETNMI		;reset NMI's
	POP	AF		;reset stack
;
DISKRET	IN	A,(FDC)		;read status
	PUSH	AF		;save error code
	LD	A,CLEAR		;FDC reset command
	OUT	(FDC),A		;issue reset
	POP	AF		;restore error
	OR	A		;check for error
	RET			;return with Z/NZ status
;
SETNMI	LD	(404AH),BC	;pass interrupt vector
	LD	B,C		;pass lsb
	LD	C,0C3H		;JP opcode
	LD	(4049H),BC	;pass JP opcode
	OUT	(NMI),A		;setup NMI vector
	RET			;done!
;
NMIRET	RETN
;
;	read ID marks
;
FIG4080	LD	A,4		;track to seek
	CALL	$SEEK		;seek it
	CALL	$READA		;read ID marks
	LD	B,3		;4 bytes
	LD	A,(HL)		;get a byte
FIGIT	INC	HL		;bump pointer
	OR	(HL)		;merge
	DJNZ	FIGIT		;continue
	LD	(4300H),A	;pass byte
	RET			;done
;
;	seek track
;
$SEEK	PUSH	AF		;save track
	CALL	SELECT		;select drive
	LD	A,RESTORE	;restore to track 0
	CALL	SLOW		;issue command
SEEK1	IN	A,(FDC)		;select drive
	RRCA			;command done?
	JR	C,SEEK1		;wait for it
	POP	AF		;get track
	OUT	(XFER),A	;to FDC
	LD	A,SEEK		;FDC command
	CALL	SLOW		;issue command
SEEK2	IN	A,(FDC)		;select drive
	RRCA			;command done?
	JR	C,SEEK2		;wait if not
	RET			;else go!
;
;	read ID marks
;
READA	CALL	SELECT		;select drive
	LD	A,AREAD		;address read
	CALL	SLOW		;issue command
	JR	READA2		;continue
;
READA1	RRCA			;command done?
	JR	NC,DISKRET	;return!
READA2	IN	A,(FDC)		;read status
	BIT	1,A		;byte ready?
	JR	Z,READA1	;wait if not
	IN	A,(XFER)	;get from FDC
	LD	(HL),A		;to buffer
	INC	HL		;bump pointer
	JR	READA2		;continue
;
;	issue FDC command and delay for valid status
;
SLOW	OUT	(FDC),A		;issue command
	LD	A,13		;delay count
SLOW1	DEC	A		;less counter
	JR	NZ,SLOW1	;finish
	RET			;else OK to continue
;
;	select drive and return with FDC status
;
SELECT	LD	A,DRIVE		;drive select code
	OUT	(SELFDC),A	;select reg FDC
	IN	A,(FDC)		;read status
	RET			;return status
;
;	following is the real stack area
;
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
;	stack area follows, registers popped here
;
STACK	DEFW	4400H		;buffer address
	DEFW	4400H		;buffer address
	DEFW	4040H		;track/sector
	DEFW	4500H		;buffer address
	DEFW	4545H		;track sector
	DEFW	4600H		;buffer
	DEFW	5050H		;track/sect
	DEFW	4400H		;loader entry point!
;
	END	ENTRY
