; suboot1s/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
$DIFS	EQU	4200H-$		;offset to actual load
$SECLS	EQU	00		;lowest sector on track
$SECHS	EQU	09		;highest sector
;
;	boot entry point 4200H
;
BOOT1S	NOP			;single 00H
	CP	0		;3rd byte dir track
;
	LD	HL,37EEH	;FDC select register R/S
	LD	(HL),0A0H	;single den R/S type
	DEC	L		;37ED
	DEC	L		;37EC
	LD	(HL),0D0H	;interrupt out
	LD	(HL),0FEH	;single den percom type
	LD	(HL),0D0H	;clear FDC
;
	CALL	01C9H		;ROM $CLS routine
	LD	DE,0005H	;track 0, sector 5
	LD	L,-1		;set buffer as empty
	EXX			;save in alt set
;
@1SLOOP	CALL	@1SGETB+$DIFS	;fetch a byte
;
;	begin of load block, check which type
;
	DEC	A		;01 header?
	JR	Z,@1SLOAD	;load it!
	DEC	A		;02 header?
	JR	Z,@1SSTRT	;done!
	CP	1EH		;valid remark? (0-1FH)
	JR	NC,@1SSER	;data error!
;
;	remark block, remove and re-loop
;
	CALL	@1SGETB+$DIFS	;fetch a byte
	LD	B,A		;B = block length
;
@1SLOP2	CALL	@1SGETB+$DIFS	;fetch a remark byte
	DJNZ	@1SLOP2		;finish it off
	JR	@1SLOOP		;go next loop
;
;	entry point marker, fetch address and go!
;
@1SSTRT	CALL	@1SGETL+$DIFS	;fetch load address
	JP	(HL)		;go program!
;
;	load block marker, get address and load it!
;
@1SLOAD	CALL	@1SGETL+$DIFS	;get block address
;
@1SLOP3	CALL	@1SGETB+$DIFS	;fetch block length
	LD	(HL),A		;to buffer
	CP	(HL)		;memory there for it?
	JR	NZ,@1SMER	;memory error
	INC	HL		;bump buffer
	DJNZ	@1SLOP3		;finish off the block
	JR	@1SLOOP		;go next block
;
;	fetch 2 byte address from file
;
@1SGETL	CALL	@1SGETB+$DIFS	;fetch length byte
	SUB	2		;adjust to actual
	LD	B,A		;B = length
	CALL	@1SGETB+$DIFS	;fetch LSB address
	LD	L,A		;pass it
	CALL	@1SGETB+$DIFS	;fetch MSB address
	LD	H,A		;pass it
	RET			;HL = address
;
;	error vectors
;
;	memory error (attempt to load non-existing mem)
;
@1SMER	LD	HL,@1SREM+$DIFS	;memory error text
	JR	@1SERR		;go common
;
;	invalid data (file format error)
;
@1SSER	LD	HL,@1SRES+$DIFS	;data error text
	JR	@1SERR		;go common
;
;	disk I/O error
;
@1SDER	LD	HL,@1SRED+$DIFS	;disk error text
;
@1SERR	CALL	@1SDSP+$DIFS	;display message
	LD	HL,@1SRRE+$DIFS	;'error'
	CALL	@1SDSP+$DIFS	;display also
;
;	wait for a key then re-boot
;
	CALL	0040H		;wait for ENTER key
	HALT			;re-boot Mod I
;
@1SDSP	LD	A,(HL)		;get a byte
	OR	A		;high bit on?
	RET	M		;yes, done!
	CALL	0033H		;else display byte
	INC	L		;bump pointer
	JR	@1SDSP		;continue
;
;	fetch byte from file
;
@1SGETB	EXX			;get disk set back
	INC	L		;bump LSB buff pointer
	JR	NZ,@1SHAVB	;go if in buffer
;
;	read another sector
;
	LD	BC,4D00H	;I/O buffer to use
	CALL	@1SRD+$DIFS	;read the sector
	JR	NZ,@1SDER	;disk error!
	LD	A,E		;get new sector
	INC	E		;bump sector
	SUB	$SECHS		;highest sector/track
	JR	NZ,@1SHAVB	;go, not at track end
	LD	E,$SECLS	;lowest sector/track
	INC	D		;bump track
;
;	byte in buffer => by HL
;
@1SHAVB	LD	A,(HL)		;fetch byte
	EXX			;store registers again
	RET			;done, A = byte
;
;	message text for errors
;	high bit set on word is terminator
;
@1SREM	DEFM	'Memory',-1
@1SRES	DEFM	'Data',-1
@1SRED	DEFM	'Disk',-1
@1SRRE	DEFM	' Error',-1
;
;	short delay for FDC to load valid status byte
;
@1SSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	sector read: DE = track/sector, BC = buff address
;
@1SRD	LD	A,5		;allow 5 retries
;
@1SRDL	EX	AF,AF'		;swap retries left
	PUSH	BC		;save load address
	CALL	@1SRD1+$DIFS	;read a sector
	POP	HL		;original load address
	RET	Z		;no error, return
	LD	B,H		;pass buffer back
	LD	C,L		;to BC from original
	EX	AF,AF'		;get counter back
	DEC	A		;less this pass
	JR	NZ,@1SRDL	;go till out of tries
	EX	AF,AF'		;get NZ error back
	RET			;back NZ
;
;	actual sector I/O - single density Mod I
;
@1SRD1	LD	HL,37ECH	;Mod I FDC command reg.
;
	LD	A,1		;select drive 0
	LD	(37E1H),A	;it's on now
	LD	(37EEH),DE	;status/sector registers
	LD	(HL),1BH	;issue seek command
	CALL	@1SSLO+$DIFS	;wait for valid status
;
@1SSEK	BIT	0,(HL)		;command done?
	JR	NZ,@1SSEK	;wait if not
	LD	(HL),88H	;issue read command
	CALL	@1SSLO+$DIFS	;wait for valid status
	PUSH	DE		;save track/sector
	LD	DE,37EFH	;transfer address
	JR	@1SRD3		;continue
;
@1SRD2	RRCA			;command done?
	JR	NC,@1SRD4	;go if done!
;
@1SRD3	LD	A,(HL)		;fetch FDC status
	BIT	1,A		;ready for a byte?
	JR	Z,@1SRD2	;nope, command done?
;
	LD	A,(DE)		;fetch byte from FDC
	LD	(BC),A		;to I/O buffer
	INC	BC		;bump buffer
	JR	@1SRD3		;go next byte
;
@1SRD4	LD	A,(HL)		;read resulting status
	POP	DE		;unstack track/sector
	LD	(HL),0D0H	;force interrupt contlr.
	AND	9FH		;check for any errors
	RET			;Z = OK, NZ = Error
;
BOOT1SL	EQU	$-BOOT1S	;length of module
;
