; sutask/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	SUBTTL	'<SUTASK/ASM - Interrupt Task Processor>'
;
	PAGE
;
;	$TASK	- interrupt processor
;
;	interrupts each 'real time clock' beat
;
;	fetch interrupted Program Counter for trace
;	save all registers to be used
;
TASK	EX	(SP),HL		;get current PC
	LD	(TRACADD),HL	;save for TRACE
	EX	(SP),HL		;put it back
	PUSH	AF		;save registers
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
;	check for valid RTC interrupt
;
;i*
	IF	MODI
	LD	A,(37E0H)	;read int latch I
	BIT	6,A		;FDC making roster?
	JP	NZ,FDCROST	;clear it if yes
	BIT	7,A		;valid interrupt?
	JP	Z,TSKNOT	;nothing if not set
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0E0H)	;read int latch III
	BIT	2,A		;valid interrupt?
	JP	NZ,TSKNOT	;nothing if set
	ENDIF
;iii*
;
;	check for BREAK key
;
	LD	A,(3840H)	;check for break key
	AND	4		;bit 2 set?
	JR	Z,TASKDN	;if no, continue
;
;	display BREAK on video and wait for key release
;
	RST	@08		;display
;
	DEFB	CLSF		;clear video
	DEFM	'Break'		;message
	DEFB	ETX
;
	LD	A,(3880H)	;check for shift key
	OR	A		;set flags
	JR	Z,BRKCK2	;go if not shift
	RST	@08		;new message
;
	DEFB	BOL		;beginning of line
	DEFB	EOL		;clear line
	DEFM	'Shift Break'
	DEFB	ETX		;terminator
;
BRKCK1	CALL	IFBREAK		;wait for key release
	JP	MASTER		;go main menu
;
BRKCK2	CALL	IFBREAK		;wait for release
	JP	SUBMENU		;go sub-menu
;
IFBREAK	LD	A,(3840H)	;read keyboard
	AND	4		;still pressed?
	JR	NZ,IFBREAK	;wait if yes
	RET			;else return
;
TASKDN	LD	A,(387FH)	;check for 'special keys'
	CP	81H		;special?
	JP	NZ,TASKCHK	;nope, go!
	LD	A,(387DH)	;check second special
	CP	81H		;special?
	JP	NZ,TASKCHK	;nope, go!
;
;	'special' key combination pressed!
;
	LD	HL,SERSTRT	;encoded message text
SER87X	LD	A,(HL)		;fetch a char
	XOR	75H		;decode it
	LD	(HL),A		;put it back
	INC	HL		;bump pointer
	JR	NZ,SER87X	;finish it
	RST	@08		;display hidden message
;
	DEFB	CLSF		;clear screen
SERSTRT	DEFB	5FH,5FH,5FH,5FH,5FH,5FH,5FH,5FH
	DEFB	5FH,5FH,5FH,5FH,5FH,5FH,5FH,5FH,78H
	DEFB	5FH,55H,55H,25H,07H,1AH,12H,07H
	DEFB	14H,18H,55H,17H,0CH,55H,55H,5FH,78H
	DEFB	5FH,55H,55H,55H,3EH,1CH,18H,55H
	DEFB	22H,14H,01H,01H,55H,55H,55H,5FH,78H
	DEFB	5FH,55H,5DH,16H,5CH,5DH,05H,5CH
	DEFB	55H,55H,44H,4CH,4DH,47H,55H,5FH,78H
	DEFB	5FH,37H,07H,10H,10H,0FH,10H,5AH
	DEFB	24H,26H,31H,59H,3CH,1BH,16H,5FH,78H
	DEFB	5FH,55H,55H,31H,14H,19H,19H,14H
	DEFB	06H,59H,55H,21H,2DH,55H,55H,5FH,78H
	DEFB	5FH,55H,55H,34H,19H,19H,55H,27H
	DEFB	1CH,12H,1DH,01H,06H,55H,55H,5FH,78H
	DEFB	5FH,55H,55H,55H,27H,10H,06H,10H
	DEFB	07H,03H,10H,11H,55H,55H,55H,5FH,78H
	DEFB	5FH,5FH,5FH,5FH,5FH,5FH,5FH,5FH
	DEFB	5FH,5FH,5FH,5FH,5FH,5FH,5FH,5FH,78H
	DEFB	75H,ETX
;
;	wait for 'special' key release
;	and restore message
;
WTK3	LD	A,(387FH)	;read keyboard
	CP	81H		;pressed?
	JR	Z,WTK3		;wait if yes
;
;	re-encode string for next access
;
	LD	HL,SERSTRT	;start of message
SER085	LD	A,(HL)		;get a char
	OR	A		;check for term
	PUSH	AF		;save flag
	XOR	75H		;restore it
	LD	(HL),A		;put it back
	INC	HL		;bump pointer
	POP	AF		;get flags
	JR	NZ,SER085	;go if more
	JP	SUBMENU		;go last sub-menu
;
TASKCHK	LD	A,(WHERE)	;get current menu display
	OR	A		;at main menu?
	JR	NZ,CHKTASK	;go if not
	LD	A,150		;! + counter
EPCNT	EQU	$-1
	DEC	A		;less one
	LD	(EPCNT),A	;put it back
	JR	NZ,CHKTASK	;go if not time
	LD	A,150		;reset counter
	LD	(EPCNT),A	;put it back
	LD	A,(VIDEO+20+64)	;get ! or +
	XOR	10		;change from one to other
	LD	(VIDEO+20+64),A	;put it back
;
CHKTASK	LD	A,(FLAGA)	;check for "alive"
	BIT	1,A		;on?
	JR	NZ,TASKCH	;nope, don't display it
;
;	check if 'trace' is ON
;
	LD	A,(FLAGB)	;get sys flag
	BIT	0,A		;is it on?
	CALL	NZ,PERTRC	;yes, display it
;
;	change 'alive' in four video corners
;
;i*
	IF	MODI
	LD	A,4		;counter Mod I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,3		;counter Mod III
	ENDIF
;iii*
;
TSKCNTY	EQU	$-1
	DEC	A		;decrement it
	LD	(TSKCNTY),A	;put it back
	JR	NZ,TSKCNTX	;not time yet, continue
;
;i*
	IF	MODI
	LD	A,4		;reset Mod I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,3		;reset Mod III
	ENDIF
;iii*
;
	LD	(TSKCNTY),A	;put it back
;
;	change all # to * in top row of display
;
	LD	HL,VIDEO+42H	;start here
	LD	B,60		;row length less edges
	LD	A,(HL)		;fetch a byte
	CP	'*'		;one way?
	JR	Z,GOFLS		;yes, go!
	CP	'#'		;opposite
	JR	NZ,TSKCNTX	;skip if neither!
;
GOFLS	CP	(HL)		;same?
	JR	NZ,SKPFLSG	;skip if not
	XOR	09H		;change to other
	LD	(HL),A		;to the video
	XOR	09H		;put it back
SKPFLSG	INC	HL		;bump video pointer
	DJNZ	GOFLS		;finish the row
;
TSKCNTX	EQU	$
;
;i*
	IF	MODI
	LD	A,5		;alive counter I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,4		;alive mod III
	ENDIF
;iii*
;
TSKCNTZ	EQU	$-1
	DEC	A		;less one
	LD	(TSKCNTZ),A	;put it back
	JR	NZ,TASKCH	;go if not time
;
;i*
	IF	MODI
	LD	A,5		;reset I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,4		;reset III
	ENDIF
;iii*
;
	LD	(TSKCNTZ),A
;
;	display 'alive' to video
;
	LD	A,0		;get current 'alive'
TSKXX	EQU	$-1
	PUSH	AF		;save current
	LD	HL,ALVTBL	;lookup table
	ADD	A,A		;*2
	LD	B,A		;save double
	ADD	A,A		;*4
	ADD	A,B		;*6 (6 byte table)
	ADD	A,L		;add to LSB
	LD	L,A		;put it back
	JR	NC,TSKXY	;go if not carry
	INC	H		;bump MSB
TSKXY	LD	A,(HL)		;get a byte
	LD	(VIDEO+000H),A	;to top left
	INC	HL		;bump table
	LD	A,(HL)		;get a byte
	LD	(VIDEO+03FH),A	;to top right
	INC	HL		;bump table
	LD	A,(HL)		;get a byte
	LD	(VIDEO+0C0H),A	;to middle left
	INC	HL		;bump table
	LD	A,(HL)		;get byte
	LD	(VIDEO+0FFH),A	;to middle right
	INC	HL		;bump table
	LD	A,(HL)		;get a byte
	LD	(VIDEO+3C0H),A	;to lower left
	INC	HL		;bump table
	LD	A,(HL)		;get a byte
	LD	(VIDEO+3FFH),A	;to lower right
;
	POP	AF		;restore counter
	INC	A		;bump it
	CP	6		;0-5?
	JR	C,TSKXZ		;yes, go!
	XOR	A		;reset to start
TSKXZ	LD	(TSKXX),A	;resave new posit
;
;	check to see if a valid serial number is present
;
TASKCH	LD	A,0		;get counter
SERCNT	EQU	$-1		;once about each 8 secs
	DEC	A		;less one
	LD	(SERCNT),A	;put it back
	JR	NZ,TSKDONE	;skip this time around
;
;	check to make sure my name has not been changed
;
	LD	HL,KIM		;my name in the program
	LD	DE,KIMCHK	;'checker' string
	LD	B,8		;length to check
;
TSKCK1	LD	A,(DE)		;fetch check byte
	XOR	'*'		;adjust to normal
	CP	(HL)		;same?
	JR	NZ,KILLPGM	;nope, kill the program
;
	INC	DE		;bump checker
	INC	HL		;bump string
	DJNZ	TSKCK1		;go for 8
;
;	check valid serial #
;
	LD	HL,SERSAVE	;serial number area
	LD	BC,1E00H	;B=30 counter, C=cksum
;
TKCKY	LD	A,(HL)		;fetch a byte
	NEG			;reverse it
	ADD	A,C		;add to subtotal
	LD	C,A		;put it back
	INC	HL		;bump pointer
	DJNZ	TKCKY		;do whole length
	LD	A,I		;get interrupt register
	CP	C		;match?
	JR	Z,TSKDONE	;OK, continue
;
;	either my name or the serial name is corrupt
;	destroy the program
;
KILLPGM	LD	HL,VIDEO	;start of writable memory
	LD	DE,VIDEO+1	;start + 1
	LD	BC,0FFFFH-VIDEO	;length of ALL RAM
	LD	(HL),0C7H	;RST 00H opcodes
	LDIR			;fill ALL memory
	RST	@00
;
;	check if printer ready to accept spooled char
;
TSKDONE	CALL	SPOOL		;printer spooler
;
;	completed, clear interrupt latch and return
;
TSKNOT	EQU	$
;i*
	IF	MODI
	LD	A,(37E0H)	;clear interrupt latch
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0ECH)	;clear latch III
	ENDIF
;iii*
	POP	HL		;unstack
	POP	DE
	POP	BC
	POP	AF		;restore AF
	EI			;re-enable
	RET			;done, return from int
;i*
	IF	MODI
FDCROST	LD	A,(37ECH)	;clear FDC
	JR	TSKNOT		;clear latch and return
	ENDIF
;i*
PERTRC	LD	HL,0		;get program counter
TRACADD	EQU	$-2
	LD	A,H		;get MSB
	CALL	HEXCV		;convert to HEX ascii
	LD	(VIDEO+122),BC	;put on the video
	LD	A,L		;get LSB
	CALL	HEXCV		;to HEX ascii
	LD	(VIDEO+124),BC	;to the video
	RET			;done!
;
ALVTBL	DEFB	149,170,149,170,149,170	;+0
	DEFB	135,139,180,184,135,139	;+1
	DEFB	139,135,184,180,139,135	;+2
	DEFB	170,149,170,149,170,149	;+3
	DEFB	184,180,139,135,184,180	;+4
	DEFB	180,184,135,139,180,184	;+5
;
