; supurgc/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUPURGC/ASM - Disk Purge Section C>'
;
;	$UNUSED - clear out ununsed dir entries
;
UNUSED	CALL	SAVEREG		;save registers
	CALL	INTCNT		;clear counter
	CALL	ENTRIES		;fetch # dir entries
	LD	IX,FILBUFF	;start of file entries
;
ZUNUSEL	BIT	4,(IX)		;active file?
	CALL	Z,CLRFILE	;clear it out
	CALL	IXDIR		;move IX to next entry
	DEC	E		;less this record
	JR	NZ,ZUNUSEL	;do 'em all
	RET			;done
;
	PAGE
;
;	$RSYST - remove system files
;
RSYST	CALL	GETDRVS		;get multiple drives
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	DE,RSYSTC	;subroutine vector
	LD	BC,GOBACK	;to menu when all done
	JP	DRVCOMM		;do all indicated drives
;
RSYSTC	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't find it!
;
	CALL	DIRPART		;display name/date/etc
	CALL	INTCNT		;clear counter
;
	LD	A,(IY+7)	;get DCT code
	CP	2		;t1d?
	JR	Z,RSYSTRS	;yes, go!
	CP	3		;t3?
	JR	Z,RSYSTRS	;yes, go!
;
RSYSGO	LD	IX,FILBUFF+20H	;don't kill BOOT/SYS
	LD	E,7		;kill 7 this sector
	CALL	RSYSTM		;remove system files
;
	LD	IX,FILBUFF+120H	;don't kill DIR/SYS
	LD	E,7		;kill 7 this sector
	CALL	RSYSTM		;remove system files
;
	CALL	ENTRIES		;load E with # dir entrys
	LD	A,E		;fetch count
	SUB	16		;less 2 sectors done
	LD	E,A		;put it back
	LD	IX,FILBUFF+200H	;next area
	CALL	RSYSTM		;kill next block
	JR	RSYSDON		;done, go!
;
RSYSTM	BIT	4,(IX)		;active file?
	JR	Z,RSYST2	;nope, go
	BIT	6,(IX)		;system file?
	JR	Z,RSYST2	;nope, go
	LD	BC,FILBUFF	;start of records
	LD	(KILLW),BC	;kill needs this
	CALL	KILLIT		;kill this file
	CALL	ADDCNT		;bump counter
;
RSYST2	CALL	IXDIR		;move IX to next entry
	DEC	E		;less counter
	JR	NZ,RSYSTM	;finish it off
	RET			;done
;
RSYSDON	CALL	SHOCNT		;display counter
	RST	@08		;display message
;
	DEFM	'System files killed'
	DEFB	LF
	DEFB	ETX
;
	CALL	MAKEGAT		;repair GAT
	CALL	MAKEHIT		;repair HIT
	JP	WRDIR		;write dir back to disk
;
RSYSTRS	LD	HL,HITBUFF+0E0H	;mod III system files!
	LD	B,16		;how many there are
	CP	3		;mod III?
	JR	Z,RSYSTLP	;yes, mod III, go!
;
	LD	L,0D0H		;mod I DD system files
	LD	B,24		;how many there are
;
RSYSTLP	LD	A,(HL)		;get a byte
	INC	A		;inactive entry?
	JR	Z,RSYSTN	;inactive, check next
;
	LD	(HL),-1		;kill system file
	INC	HL		;two bytes each
	LD	(HL),-1		;kill this part too
	DEC	HL		;put pointer back
	CALL	ADDCNT		;bump counter
;
RSYSTN	INC	HL		;bump pointer to next
	INC	HL
	DJNZ	RSYSTLP		;finish 'em all off
	JR	RSYSDON		;done, display counter
;
	PAGE
;
;	$ENTRIES - fetch total # of directory records
;
;	ENT	none
;
;	EXT	E = total # dir records
;
ENTRIES	LD	A,(DIRSCNT)	;fetch dir sector count
	DEC	A		;less GAT
	DEC	A		;less HIT
	LD	E,A		;save total file sectors
	ADD	A,A		;*2
	ADD	A,A		;*4
	LD	D,A		;save temp
;
	LD	A,(IY+7)	;get dos type
	CP	03H		;trsdos III?
	JR	NZ,ENTRIS	;nope, go!
;
;	we now have TRSDOS Mod III, 5 entries / sector
;
	LD	A,D		;get temp
	ADD	A,E		;*5
	LD	E,A		;E = total
	RET			;done!
;
;	non TRSDOS III, 8 entries / sector
;
ENTRIS	LD	A,D		;get temp
	ADD	A,A		;*8
	LD	E,A		;return it here
	RET			;done!
;
	PAGE
;
;	$RPASSW - remove passwords
;
RPASSW	CALL	GETDRVS		;get multiple drives
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	DE,RPASSWC	;subroutine vector
	LD	BC,GOBACK	;to menu when done
	JP	DRVCOMM		;do all requested drives
;
RPASSWC	CALL	RDDIR		;read in the directory
	JP	NZ,NOTDIR	;error, display & return
;
	CALL	DIRPART		;display name/date/etc
	CALL	ENTRIES		;load E with # entries
	LD	IX,FILBUFF	;start of file entries
;
RPASSL	LD	A,(IX)		;fetch 'flag' byte
	BIT	4,A		;active file?
	JR	Z,RPASS2	;nope, go!
;
	BIT	7,A		;extension?
	JR	NZ,RPASS2	;skip these
;
	AND	0F8H		;no protection level
	LD	(IX),A		;put it back
	CALL	DPASSU		;get blank password
	LD	(IX+10H),L	;insert ACCESS password
	LD	(IX+11H),H
	LD	(IX+12H),L	;insert UPDATE password
	LD	(IX+13H),H
;
RPASS2	CALL	IXDIR		;move IX to next entry
	DEC	E		;less this file
	JR	NZ,RPASSL	;finish 'em off
;
	CALL	DPASSV		;password 'PASSWORD'
	LD	(GATBUFF+0CEH),HL	;master password
	JP	WRDIR		;write directory back!
;
	PAGE
;
;	$ERAFILE - erase all traces of current file
;
;	ENT	IX => current directory record
;
;	EXT	primary and all extended records
;		filled with zeroes
;
ERAFILE	CALL	SAVEREG		;save pointers
	CALL	GETEXTS		;load # extents into B
;
ERAFILG	PUSH	IX		;save start pointer
;
ERAFILH	LD	A,(IX+16H)	;get extent type
	INC	A		;terminator?
	JR	Z,ERAFILI	;go if terminator
	INC	A		;extension?
	JR	Z,ERAFILJ	;yes, get it too!
;
	INC	IX		;bump pointer
	INC	IX		;to next extent
	DJNZ	ERAFILH		;finish all extents
;
ERAFILI	POP	IX		;restore pointer
	JP	CLRFILE		;corrupt! kill it
;
ERAFILJ	LD	A,(IX+17H)	;get extension DEC
;
	POP	IX		;unstack
	PUSH	AF		;save original
	AND	1FH		;get sector offset
	LD	B,A		;pass it here
	POP	AF		;get it back
;
	AND	0E0H		;page offset
	LD	C,A		;BC = offset to extension
	CALL	CLRFILE		;clear current record
	LD	IX,FILBUFF	;start of file entries
	ADD	IX,BC		;IX => extension
	JR	ERAFILG		;next entry
;
	PAGE
;
;	$MAKEGAT - create a GAT table
;
;	ENT	directory loaded starting at $GATBUFF
;
;	EXT	GAT table completely reconstructed
;
MAKEGAT	CALL	FIGTKS		;get track count from GAT
	CALL	OPENGAT		;open all available trks
	CALL	ENTRIES		;# directory records
	LD	IX,FILBUFF	;start of files
;
MAKGATL	BIT	4,(IX)		;active entry?
;
	PUSH	DE		;save counter
	PUSH	IX		;save pointer
	CALL	NZ,ALLOCAT	;allocate this entry
	POP	IX		;restore pointer
	POP	DE		;restore counter
;
	CALL	IXDIR		;move IX to next entry
	DEC	E		;entries -1
	JR	NZ,MAKGATL	;do all files
;
;	check for SOLE and TRS I DD
;	track 0 is unavailable for normal file I/O
;	yet is sometimes not allocated to any files
;	If it is such a disk, force allocate track 0
;
	BIT	5,(IY+6)	;available?
	JR	Z,NOTDOSP	;nope, continue
;
	LD	A,(GATBUFF)	;get BOOT sector byte
	OR	03FH		;lock out low bits
	LD	(GATBUFF),A	;allocate track 0
;
;	check for TRSDOS double density Mod I & III
;	these peculiar diskettes actually have the
;	system files for the diskette located at the
;	end of the HIT table! allocate these too
;
NOTDOSP	LD	A,(IY+7)	;get dos type
	CP	2		;t1d?
	RET	C		;nope, skip
	CP	4		;t3?
	RET	NC		;nope, skip
;
	LD	HL,HITBUFF+0D0H	;start for Mod I DD
	LD	B,24		;length
	CP	3		;mod III?
	JR	NZ,FIX3LLP	;nope, go Mod I
;
	LD	L,0E0H		;start for Mod III DD
	LD	B,16		;length
;
FIX3LLP	LD	A,(HL)		;fetch extent byte
	CP	-1		;nil entry?
	JR	Z,FIX4LLP	;yes, skip it
	LD	IX,STRING	;use for fake entry
	CALL	TSYSFIX		;fix sys files length
	LD	(IX+17H),A	;save offset/grans
	INC	HL		;bump pointer
	LD	A,(HL)		;fetch start track
	LD	(IX+16H),A	;save into fake entry
	DEC	HL		;put pointer back
	LD	(IX+18H),-1	;set in a terminator
;
	PUSH	BC		;save counter
	PUSH	HL		;save system pointer
	CALL	ALLOCAT		;allocate dummy entry
	POP	HL		;restore pointer
	POP	BC		;restore counter
;
FIX4LLP	INC	HL		;bump extent pointer
	INC	HL		;two bytes each
	DJNZ	FIX3LLP		;finish it off
;
;	if you think that was bad, just wait!
;	the directory and boot are not indicated
;	anywhere on the disk!  let's just go ahead
;	and assume their allocations
;
	LD	HL,GATBUFF	;start of GAT
	LD	A,(IY+7)	;get dos type
	CP	3		;t3?
	LD	A,1		;one gran mod III
	JR	Z,FIX5LLP	;yes, have III
	LD	A,3FH		;all grans mod I
FIX5LLP	OR	(HL)		;combine with whats there
	LD	(HL),A		;put it back
	LD	L,(IY+2)	;HL => directory track
	LD	(HL),3FH	;allocate whole track
	RET			;done, GAT built
;
	PAGE
;
;	$ALLOCAT - allocate space assigned to file
;
;	ENT	directory loaded starting at @GATBUFF
;		IX => directory record to allocate
;
;	EXT	all grans assigned to the entry
;		are allocated to the GAT table
;
;	all registers except primes and IY destroyed
;
;	NOTE	only the space assigned to the current
;		entry is allocated, extensions are done
;		on a separate pass
;
ALLOCAT	CALL	GETEXTS		;get # extents / entry
	CALL	TOPGRAN		;fetch mask for top gran
	LD	(ALLOTOP),A	;save mask byte
;
ALLOCLP	LD	A,(IX+16H)	;get extent element
	LD	L,A		;save for track offset
	INC	A		;FF terminator?
	RET	Z		;finished with this one
	INC	A		;FE extender?
	RET	Z		;will do extension later
;
	LD	A,(IX+17H)	;fetch st gran/gran ctr
	PUSH	AF		;save on stack
	CALL	ADJGRNS		;fetch # grans here
	LD	C,A		;C = # contiguous grans
	POP	AF		;fetch start gran
;
;	compute bit mask position of starting granule
;
	RRCA			;align bits 7 6 5
	RRCA			;down to bits 2 1 0
	RRCA
	RRCA
	RRCA
	AND	7		;keep low 3 only
	LD	E,1		;mask for start bit (0)
	JR	Z,FNGRHV	;first gran, go!
;
FINGRLP	SLA	E		;move over gran bit
	DEC	A		;less gran offset counter
	JR	NZ,FINGRLP	;go till mask found
;
FNGRHV	LD	H,GATBUFF<-8	;page of GAT table
;
;	HL => GAT table entry for starting granule
;	E = bit mask for starting granule
;	C = number of contiguous granules
;	B = number of extents remaining this entry
;
RELGRNS	LD	A,(HL)		;get current byte
	OR	E		;allocate that gran
	LD	(HL),A		;put it back
	DEC	C		;gran count -1
	JR	Z,RELGRDN	;done with this entry
	LD	A,0		;fetch top gran mask
ALLOTOP	EQU	$-1
	SLA	E		;move to next gran
	CP	E		;at end of this track?
	JR	NZ,RELGRNS	;release next gran
	INC	L		;look at next track
	LD	E,1		;start with first gran
	JR	RELGRNS		;continue
;
RELGRDN	INC	IX		;point to next extent
	INC	IX		;two bytes each
	DJNZ	ALLOCLP		;finish off this entry
	RET			;corrupt! return now!
;
;	$TOPGRAN - compute bit mask for highest granule
;
;	ENT	IY => DCT
;
;	EXT	A = mask of highest gran for end compare
;
TOPGRAN	BIT	0,(IY+5)	;double sided?
	JR	Z,TOPGSS	;nope, go single side
;
	LD	A,00010000B	;single den, double side
	BIT	6,(IY+6)	;single den?
	RET	Z		;yes, return
	LD	A,01000000B	;6 grans double den
	RET			;done
;
TOPGSS	LD	A,00000100B	;two grans per/track
	BIT	6,(IY+6)	;double density disk?
	RET	Z		;single, 5 sector grans
;
	LD	A,(IY+7)	;get dos type
	LD	A,00001000B	;3 grans/track
	CP	2		;t1d?
	RET	C		;nope!
	CP	4		;t3?
	RET	NC		;nope!
;
	LD	A,01000000B	;trsdos double (I & III)
	RET			;6 grans of 3 sectors
;
;	leave a small area for future dos's
;
	DEFW	0		;8 bytes should do
	DEFW	0
	DEFW	0
	DEFW	0
;
	PAGE
;
;	$ADJGRNS - adjust A for # contiguous grans
;
;	ENT	A = second byte of directory extent pair
;
;	EXT	A = number contiguous grans in extent
;
ADJGRNS	AND	1FH		;low 5 bits only
	PUSH	AF		;save # grans
	LD	A,(IY+7)	;get dos type
	CP	3		;trsdos III?
	JR	Z,ADJGRN3	;yes, go!
;
	POP	AF		;restore
	INC	A		;number is -1
	RET
;
ADJGRN3	POP	AF		;restore
	RET			;A = # grans
;
	PAGE
;
;	$OPENGAT - reset allocation table to nil
;
;	ENT	directory loaded starting at $GATBUFF
;
;	EXT	allocation table is reset to empty
;
;	diskette is physically addressed
;	move a copy of the lockout table onto
;	the allocation to set all tracks as available
;	that are available
;
OPENGAT	BIT	3,(IY+6)	;relative sectoring?
	RET	NZ		;no lockout table!
;
	LD	HL,GATBUFF+60H	;start of lockout table
	LD	DE,GATBUFF	;start of allocation tble
	LD	BC,60H		;length of table (96)
	LDIR			;copy lockout=>allocation
	RET			;table is 'reset'
;
;	We need to allocate the system files in
;	TRSDOS Mod IDD and III.  The entries are logged
;	into the HIT table at offsets D0 and E0
;	respectively.  TRS III uses the number of
;	contiguous grans as the low 5 bits of the first
;	byte of each entry, whereas TRS I uses the
;	number of contiguous SECTORS.  The following
;	subroutine will convert each of the respective
;	bytes into the corresponding # of granules
;
TSYSFIX	PUSH	AF		;save byte
	LD	A,(IY+7)	;get dos type
	CP	03H		;trsdos III?
	JR	NZ,TSYSFX1	;nope, continue
	POP	AF		;restore
	RET			;done, III = OK
;
TSYSFX1	POP	AF		;restore
;
	PUSH	BC		;save
	PUSH	HL		;save
	LD	L,A		;pass to HL
	LD	H,0		;HL = # sectors in file
	AND	0E0H		;save top 3 bits
	LD	B,A		;in B register
	LD	C,(IY+10)	;sectors / gran
	CALL	DIVD		;divide it
	LD	A,C		;any remainder?
	OR	A		;C <> 0?
	JR	NZ,TSYSFX	;go if not
	INC	L		;else bump product by one
TSYSFX	LD	A,L		;fetch result
	OR	B		;merge gran offset
	POP	HL		;unstack
	POP	BC		;A = # grans
	RET			;done!
;
