; supurga/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUPURGA/ASM - Disk Purge Section A>'
;
;	$NAMDATE - display diskette name/date
;
;	ENT	directory GAT table at $GATBUFF
;
;	EXT	name/date displayed to video
;
;	all registers preserved except A
;
NAMDATE	CALL	SAVEREG		;save registers
;
;	move name/date into display string
;
	LD	HL,GATBUFF+0D0H	;start of disk name
	LD	DE,DISPN	;string to put it
	LD	BC,8		;8 chars long
	LDIR			;move in name
	LD	C,8		;8 more for date
	LD	DE,DISPD	;string where it goes
	LDIR			;move it in
;
;	check to see if valid data present in fields
;
	LD	HL,GATBUFF+0D0H	;data start
	LD	B,16		;16 chars name/date
;
DISPXNX	LD	A,(HL)		;fetch a char
	INC	HL		;bump pointer
	CP	' '		;displayable?
	JR	C,NMDTNO	;nope, show error
	CP	0C0H		;outside graphic range?
	JR	NC,NMDTNO	;yep, go!
	DJNZ	DISPXNX		;check all of 'em
;
;	all characters valid, display it
;
	RST	@08		;call display driver
;
	DEFM	'Name = '
DISPN	DEFM	'xxxxxxxx  Date = '
DISPD	DEFM	'xxxxxxxx'
	DEFB	ETX
;
	RET			;unstack & return
;
NMDTNO	RST	@08		;different message
;
	DEFM	'Invalid Name/Date'
	DEFB	ETX
;
	RET
;
	PAGE
;
;	$WHERDIR - locate directory track
;
;	ENT	none
;
;	EXT	DCT directory track updated
;		C = user selected SKIP on boot I/O error
;		Z & NC = OK
;
;	NOTE	this routine is called when an error
;		in reading the directory has occured
;		from $RDDIR (following)
;
;	read boot sector on disk to find the directory
;
WHERDIR	LD	(IY+2),17	;default dir track
	LD	A,(IY+7)	;get dos type
	CP	16		;doubledos?
	RET	Z		;force dir to 17!
;
;	check if relative sectoring engaged
;	if yes, differentiate between multidos and newdos
;	multidos dir byte is on PHYSICAL trk 0 / sec 0
;	newdos dir byte is on RELATIVE trk 0 / sec 0
;
	LD	A,(IY+6)	;get DCT byte
	PUSH	AF		;save on stack
	BIT	3,A		;relative engaged?
	JR	Z,WHERD1	;go if not
	LD	A,(IY+7)	;get dos type
	CP	13		;multidos?
	JR	NC,WHERD1	;go if not
	RES	3,(IY+6)	;turn off relative
WHERD1	LD	D,0		;boot track (0)
	CALL	FIRSTS		;E = first sector on trk
	LD	BC,BUFFER	;read it in here
	RST	@28		;read the sector
	POP	DE		;restore saved byte
	LD	(IY+6),D	;reset DCT
	RET	C		;error, use default
;
	LD	BC,BUFFER+1	;t1d and t3 directory
	LD	A,(IY+7)	;get dos type
	SUB	2		;t1d?
	JR	Z,WHIDIRZ	;yep, got the byte
	DEC	A		;t3?
	JR	Z,WHIDIRZ	;go if yes
	INC	C		;use 3rd byte on disk
;
WHIDIRZ	LD	D,-1		;set FFH mask
	LD	A,(IY+7)	;get dos type
	SUB	7		;check for dos+
	JR	C,WHDIRZ	;go if not
	CP	3		;dos+?
	JR	NC,WHDIRZ	;go if not
	LD	D,7FH		;else set 7 bits
WHDIRZ	LD	A,(BC)		;get dir track
	AND	D		;remove dos+ dd bit
;
	INC	A		;bump for test
	CP	(IY+1)		;compare to rel tracks
	JR	NC,WHIDIRY	;beyond disk! use 17!
	DEC	A		;adjust back
	LD	(IY+2),A	;save directory track
;
WHIDIRY	XOR	A		;set no errors
	RET			;DCT all set, return
;
	PAGE
;
;	$RDDIR - read in a directory from a disk
;
;	ENT	($DRIV) setup for disk activity
;		IY => drives DCT
;
;	EXT	NZ = error occured
;
;		Z = OK, directory loaded
;		directory will start at ($GATBUFF)
;		the number of sectors in the directory
;		will be loaded into ($DIRSCNT)
;
;	NOTE	if a directory cannot be located on
;		the first attempt, the boot sector
;		will be read to establish the directory
;		location and a new attempt to
;		read the directory will be made
;		Only after all of this will this
;		subroutine report any errors
;
RDDIR	CALL	DSTAT		;check disk status
	RET	NZ		;'skip' selected
;
	BIT	4,(IY+5)	;auto detect?
	CALL	NZ,DETECT	;disk detect on?
	JP	NZ,CANNOT	;cannot establish disk
	LD	A,(IY+7)	;get dos type
	OR	A		;known?
	CALL	Z,WHERDIR	;try to determine type
;
	XOR	A		;NOP opcode
	LD	(RDDIR0),A	;allow boot to be read
;
	CALL	DSTAT		;drive ready to go?
	RET	NZ		;nope, return in error
;
RDDIRO	CALL	GETDIR		;load DE with first sect
	LD	(DIRMAX),A	;save for done compare
	XOR	A		;clear sector counter
	LD	(DIRSCNT),A	;initialize it
	LD	IX,DAMBUFF	;storage for DAM's
	LD	BC,GATBUFF	;re-init buffer
;
RDDIRI	RST	@28		;read a sector
	JR	C,RDDIRD	;user 'skip', end reads
	EX	AF,AF'		;get write byte
	LD	(IX),A		;same into $DAMBUFF
	INC	IX		;bump pointer
;
;	due to the wide variety of directory address
;	marking that various DOS's have used, we will
;	allow ANY dam bit to be set on reads to assist
;	in directory detection
;	This will allow a Mod III read protect mark
;	which will normally return as user defined
;	to be interpreted correctly on the Mod I
;
;i*
	IF	MODI
	AND	3		;mod I has 4 types
	JR	Z,RDCKCT	;no bits, continue
	OR	1		;else allow either OK
RDCKCT	EQU	$
	ENDIF
;i*
;
;iii*
	IF	MODIII
	AND	1		;mod III has 2 types
	ENDIF
;iii*
	RLCA			;move over 2 bits
	RLCA			;to align with mask
	XOR	(IY+6)		;compare to DAM mask
	AND	4		;correct address mark?
	JR	Z,RDDIRD	;not the type we want
;
;	sector has been read in successfully and
;	identified to be part of the directory
;
	CALL	NEXSEC		;bump DE to next sector
	LD	A,(DIRSCNT)	;get sector counter
	INC	A		;add one
	LD	(DIRSCNT),A	;put it back
	CP	0		;at end of designated
DIRMAX	EQU	$-1		;number of sects in dir?
	JR	C,RDDIRI	;not at end, get next
	BIT	3,(IY+6)	;relative engaged?
	JR	NZ,RDDIRI	;go if yes, see if extend
;
;	either the correct number of sectors have
;	been loaded in, or a disk I/O or DAM error
;	has occured - check to see if a sufficient
;	number of sectors have been read in from disk
;
RDDIRD	CALL	GETDIR		;get minimum needed
	LD	L,A		;save it
	LD	A,(DIRSCNT)	;get # actually read in
	CP	L		;did we get enough?
	JR	C,RDDIR0	;not enough, go (NZ set)
	XOR	A		;else all OK, return Z
	RET			;back to caller with dir
;
;	not enough directory sectors have been read in
;	to meet the minimum length
;	attempt to read the boot sector to find the
;	directory location
;	the $RDDIR init placed a NOP opcode at this
;	vector to allow the boot to be read
;	After one execution a RET opcode will be
;	placed here so only one attempt at the
;	boot will be made and the program will
;	return to the caller NZ as a result of the
;	last compare operation
;
RDDIR0	NOP			;vectored opcode
	LD	A,0C9H		;RET opcode
	LD	(RDDIR0),A	;disable it for 2nd pass
;
	CALL	WHERDIR		;read boot to find it
	JR	RDDIRO		;try to read it all over
;
	PAGE
;
;	$WRDIR - write directory in memory to disk
;
;	ENT	directory in memory at ($GATBUFF)
;		($DIRSCNT) contains the number of sectors
;
;	EXT	NZ = error
;		Z = OK, directory written back to disk
;
;	since TANDY on the Mod III uses reverse
;	data address marks on the disk and also
;	the Mod III and IDD invert the IBM bit
;	we need to issue the correct sector write
;	byte to reproduce the native systems ID
;
WRDIR	CALL	COMPDIR		;get correct DAM byte
;
;	fill the $DAMBUFF buffer with the correct
;	write type byte that will be used by $MWRITE
;
WRDIRT	LD	HL,DAMBUFF	;data address mark buff
	LD	DE,DAMBUFF+1	;+1
	LD	BC,0FFH		;length -1
	LD	(HL),A		;put in the byte
	LDIR			;put it in whole page
;
	LD	BC,GATBUFF	;start of data
	CALL	GETDIR		;load DE with directory
	LD	A,(DIRSCNT)	;get # of sectors
	LD	L,A		;pass here for multiple
	LD	H,0		;HL = number of sectors
	CALL	DSTAT		;check disk status
	RET	NZ		;error, abort!
	JP	MWRITE		;else write 'em back
;
	PAGE
;
;	$SHOWDIR - display 8 pages of directory
;
;	ENT	directory loaded into $GATBUFF
;		($DIRPAGE) = starting page of names
;		to be displayed
;
;	EXT	directory files listed to video in
;		preparation for full screen editing
;
SHOWDIR	RST	@08		;clear screen
;
	DEFB	CLSA		;cls code
	DEFB	ETX		;terminator
;
	CALL	SAVEREG		;save registers
	LD	A,(DIRPAGE)	;get start page to dsply
	LD	B,A		;give to B
	LD	C,0		;BC = page offset
	LD	IX,FILBUFF	;start of file records
	ADD	IX,BC		;IX => starting record
	LD	HL,VIDEO	;start of video
;
;	we will display 8 full sectors of files on
;	the video, which is normally 64 files
;	TRSDOS III however, only has 5 files/sector
;	resulting in a total of 40 files/8 sectors
;
	LD	B,64		;64 files to display
	LD	A,(IY+7)	;get dos type
	CP	03H		;trs iii?
	JR	NZ,DIRILP	;nope, go!
	LD	B,40		;40 files to display
;
DIRILP	BIT	4,(IX)		;active file?
	CALL	ACTIVE1		;display type marker
	INC	HL		;bump video
	CALL	SHOWIT		;display filename
;
	PUSH	AF		;save result
	LD	DE,12		;offset to name end
	ADD	HL,DE		;HL => end of name +1
	BIT	4,(IX)		;active entry?
	CALL	ACTIVE2		;display type marker
	POP	AF		;restore file display
;
	JR	Z,DDTCON	;data OK, continue
;
;	current file has invalid characters
;	erase name and markers from video
;
	PUSH	HL		;save current video ptr
	LD	E,14		;14 chars to erase
;
DDTXXC	LD	(HL),' '	;put in a space
	DEC	HL		;move back
	DEC	E		;more?
	JR	NZ,DDTXXC	;yes, finish it off
	POP	HL		;restore video pointer
;
DDTCON	INC	HL		;gap between files
	INC	HL
	INC	HL
;
	CALL	IXDIR		;move IX to next entry
	DJNZ	DIRILP		;finish off 64/40 names
	RET			;display page completed
;
;	display either arrows(brackets) or graphics
;	blocks around a filename to denote if it
;	if an active or deleted file
;
ACTIVE1	JR	Z,ACTIV1	;dead file, use block
;i*
	IF	MODI
	LD	(HL),5EH	;right arrow mod I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	(HL),5BH	;left brace mod III
	ENDIF
;iii*
	RET
;
ACTIV1	LD	(HL),85H	;graphic block dead file
	RET			;done
;
ACTIVE2	JR	Z,ACTIV2	;dead file, use graphic
	LD	(HL),5DH	;l arrow MI, r brace MIII
	RET			;done
;
ACTIV2	LD	(HL),8AH	;graphic block
	RET
;
	PAGE
;
;	$SHOWIT - display filename to video
;
;	ENT	HL => video location to display
;		IX => first byte of directory record
;
;	EXT	Z = OK, filename valid and displayed
;		NZ = invalid chars, not displayed
;
SHOWIT	CALL	SAVEREG		;save registers
	LD	(CURSOR),HL	;position cursor
	LD	HL,STRINGF	;string for filename
;
	PUSH	HL		;save start
	LD	B,12		;8 name + 3 ext + /
	LD	A,SPACE		;space
	CALL	FILL		;clear out the string
	POP	HL		;restore string start
;
	LD	B,8		;8 chars name field
	BIT	7,(IX)		;extended entry?
	JR	NZ,SHOWLX1	;yes, display link
;
SHOWL1	LD	A,(IX+5)	;fetch name byte
	CP	SPACE		;nil?
	JR	Z,SHCON		;yes, continue next
	CALL	CKASCI		;valid character
	JR	C,SHBAD		;nope, return error
	LD	(HL),A		;valid, put in string
	INC	HL		;bump string pointer
;
SHCON	INC	IX		;bump filename pointer
	DJNZ	SHOWL1		;finish name field
;
	LD	A,(IX+5)	;any extension?
	CP	SPACE		;space in first posit?
	JR	Z,SHOKOX	;yes, done, display it
;
	LD	(HL),'/'	;put entension marker
	INC	HL		;bump string pointer
	LD	B,3		;3 chars in extension
;
EXTLP	LD	A,(IX+5)	;fetch extension byte
	CP	SPACE		;nil?
	JR	Z,SHOKOX	;yes, display it
	CALL	CKASCI		;valid character?
	JR	C,SHBAD		;nope, return error
	LD	(HL),A		;valid, put in string
	INC	HL		;bump string pointer
	INC	IX		;bump name pointer
	DJNZ	EXTLP		;finish the extension
;
;	filname loaded into string, display it
;
SHOKOX	LD	HL,(CURSOR)	;get cursor
	LD	DE,STRINGF	;point to string
	CALL	CLSON		;display it
	LD	(CURSOR),HL	;re-save cursor
;
	XOR	A		;return OK
	RET			;back to caller
;
STRINGF	DEFM	'xxxxxxxx/xxx'
	DEFB	ETX
;
SHBAD	OR	-1		;return NZ for error
	RET			;unstack and return
;
;	extended entry, display backward link
;
SHOWLX1	LD	A,(IX+1)	;fetch backward link
	RST	@20		;convert to hex ascii
	LD	(SHWTLL),BC	;put into string
	RST	@08		;display it
;
	DEFM	'Back DEC='
SHWTLL	DEFM	'xxH'
	DEFB	ETX
;
	XOR	A		;return ZERO
	RET			;done, back to caller
;
	PAGE
;
;	$DETECT - automatic DOS recognition
;
DETECT	CALL	SAVEREG		;save registers
	LD	DE,0		;read track 0/sector 0
	LD	BC,BUFFER	;to I/O buffer
	CALL	READ		;read it
	JR	Z,DETEC0	;OK, have track 0
	BIT	4,A		;not found error?
	CALL	NZ,FLIPDEN	;alter density if yes
	CALL	READ		;try other density
	JR	Z,DETEC0	;go if found!
;
;	sector 0 not found, check out sector 1
;
	INC	E		;bump to sector 1
	CALL	READ		;read it
	JR	Z,DETEC0	;yes, go!
	BIT	4,A		;not found error?
	CALL	NZ,FLIPDEN	;change density if not
	CALL	READ		;try other density
	RET	NZ		;cannot determine dos!
;
;	track 0 established, set track sizes
;
DETEC0	LD	A,E		;get start sector track 0
	RLCA			;move to bit 1
	AND	2		;bit 1 only
	RES	1,(IY+6)	;reset bit
	OR	(IY+6)		;merge new bit
	LD	(IY+6),A	;save new start sector
	LD	A,9		;highest sector single
	BIT	7,(IY+6)	;single?
	JR	Z,DETEC00	;yes, go!
	LD	A,17		;highest sector double
DETEC00	ADD	A,E		;add to sector offset
	LD	(IY+8),A	;save it
;
;	detect track 1 density/starting sector
;
	LD	DE,0100H	;track 1/sector 0
	LD	BC,BUFFER	;reset buffer
	CALL	READ		;read it
	JR	Z,DETEC1	;OK, go!
	BIT	4,A		;not found?
	CALL	NZ,FLIPDEN	;yes, change density
	CALL	READ		;try other density
	JR	Z,DETEC1	;OK, go!
;
;	sector 0 not found, check sector 1
;
	INC	E		;sector 1
	CALL	READ		;read it
	JR	Z,DETEC1	;OK, go!
	BIT	4,A		;not found?
	CALL	NZ,FLIPDEN	;yes, change density
	CALL	READ		;try again
	RET	NZ		;cannot establish disk!
;
;	track 1 established
;
DETEC1	LD	A,E		;get low sector
	AND	1		;bit 0 only
	RES	0,(IY+6)	;reset low sector disk
	OR	(IY+6)		;merge new sector
	LD	(IY+6),A	;insert into table
;
;	set highest sector
;
	LD	A,9		;high sector single den
	BIT	6,(IY+6)	;single den?
	JR	Z,DETEC11	;yes, go!
	LD	A,17		;high sector double den
DETEC11	ADD	A,E		;add sector offset
	RES	4,(IY+5)	;auto detect off
	LD	(IY+9),A	;save to DCT
;
;	determine which DOS fits the description
;
	LD	A,(IY+6)	;get densities
	AND	0C0H		;figure it out
	JR	Z,DETECS	;single density!
;
	CP	40H		;double/single 0?
	JR	Z,DETECDS	;yes, go!
;
;	double density disk/double track 0
;	must be LDOS I/III DD or TRS III
;
	BIT	0,(IY+6)	;start sector 0?
	LD	HL,$L3		;ldos DD I/III
	JR	Z,DETPUT	;yes, load DCT
	LD	HL,$T3		;trsdos III
	JR	DETPUT		;setup DCT
;
;	double density/single track 0
;	must be SOLE or TRS I DD
;
DETECDS	BIT	0,(IY+6)	;start sector disk?
	LD	HL,$L1D		;sole
	JR	Z,DETPUT	;insert into DCT
	LD	HL,$T1D		;trsdos I DD
	JR	DETPUT
;
;	have single density disk
;	must be LDOS I/III SD or TRS I
;	since we cannot tell them apart at this time
;	assume trsdos single density
;
DETECS	LD	HL,$T		;ldos I/III or trs I
;
;	setup DCT
;
DETPUT	LD	DE,6		;start perishable data
	ADD	IY,DE		;add offset
	PUSH	IY		;pass to DE
	POP	DE		;DE => perishable
	LD	BC,7		;6 bytes long
	LDIR			;pass it
	XOR	A		;all set to go
	RET			;done!
;
;	cannot establish disk type!
;
CANNOT	LD	(IY+7),0	;set as UNKNOWN
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Cannot establish disk type!'
	DEFB	ETX
;
	JP	GOBACK		;'enter' to continue
;
